/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.standard.helpers.SystemSettingsHelper;
import com.gridnine.xtrip.common.model.system.SecurityAccountPolicySettings;
import com.gridnine.xtrip.common.model.system.SecuritySettings;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.asset.LogicalAssetStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.common.SessionsHelper;
import com.gridnine.xtrip.server.db.storage.common.UsersHelper;
import com.gridnine.xtrip.server.db.storage.dbproperties.LogicalDBPropertiesStorage;
import com.gridnine.xtrip.server.db.storage.dictionary.LogicalBulkDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.dictionary.LogicalDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import java.security.GeneralSecurityException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.LoggerFactory;

public class LogicalStorage
implements Disposable {
    private final PhysicalStorage ps;
    private final UsersHelper usersHelper;
    private final SessionsHelper sessionsHelper;
    private final LogicalEntityStorage entityStorage;
    private final LogicalAssetStorage assetStorage;
    private final LogicalDictionaryStorage dictionaryStorage;
    private final LogicalDBPropertiesStorage dbPropertiesStorage;
    private final LogicalBulkDictionaryStorage bulkDictionaryStorage;
    private final Map<String, Integer> loginAttemptsCount = new HashMap<String, Integer>();
    private final ExtendedProperties configuration;

    public static LogicalStorage get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (LogicalStorage)Environment.getPublished(LogicalStorage.class);
    }

    public static void reset() {
    }

    public String getUser() {
        return this.usersHelper.getUser();
    }

    public void setUser(String value) {
        this.usersHelper.setUser(value);
    }

    public String getSessionToken() {
        return this.usersHelper.getSessionToken();
    }

    public void setSessionToken(String value) {
        this.usersHelper.setSessionToken(value);
    }

    public LogicalStorage(String storageUid, ExtendedProperties configuration) {
        if (Environment.isPublished(LogicalStorage.class)) {
            throw new IllegalStateException("instance of LogicalStorage already exists");
        }
        this.configuration = configuration;
        this.ps = LogicalStorageRegistry.get().getStorage(storageUid);
        this.usersHelper = (UsersHelper)Environment.getPublished(UsersHelper.class);
        this.sessionsHelper = new SessionsHelper(this.ps);
        this.entityStorage = new LogicalEntityStorage(this.ps, this.sessionsHelper);
        this.assetStorage = new LogicalAssetStorage(this.ps, this.sessionsHelper);
        this.dictionaryStorage = new LogicalDictionaryStorage(this.ps, this.sessionsHelper);
        this.dbPropertiesStorage = new LogicalDBPropertiesStorage(this.ps);
        this.bulkDictionaryStorage = new LogicalBulkDictionaryStorage(this.ps, this.sessionsHelper);
    }

    public LogicalSession beginUnitOfWork() throws StorageException {
        return this.sessionsHelper.beginUnitOfWork();
    }

    public Map<String, Object> getSessionContext() {
        return this.sessionsHelper.getSessionContext();
    }

    public void endUnitOfWork(LogicalSession session, boolean closeConnection) throws StorageException {
        this.sessionsHelper.endUnitOfWork(session, closeConnection);
    }

    public void cancelUnitOfWork(LogicalSession session) throws StorageException {
        this.sessionsHelper.cancelUnitOfWork(session);
    }

    public LogicalEntityStorage getEntityStorage() {
        return this.entityStorage;
    }

    public LogicalAssetStorage getAssetStorage() {
        return this.assetStorage;
    }

    public LogicalDictionaryStorage getStandardDictionaryStorage() {
        return this.dictionaryStorage;
    }

    public LogicalDBPropertiesStorage getDbPropertiesStorage() {
        return this.dbPropertiesStorage;
    }

    public LogicalBulkDictionaryStorage getBulkDictionaryStorage() {
        return this.bulkDictionaryStorage;
    }

    public void dispose() {
        this.usersHelper.dispose();
        this.sessionsHelper.dispose();
    }

    public void authorizeAsSystem() throws Exception {
        this.authorizeAsSystem((Properties)this.configuration);
    }

    public void authorizeAsSystem(Properties config) throws Exception {
        String login = config.getProperty("storage.system.account");
        char[] password = DesUtil.decode((String)config.getProperty("storage.system.password")).toCharArray();
        this.authorize(login, password, false, true);
    }

    public void authorize(String userName, char[] password) throws Exception {
        this.authorize(userName, password, false);
    }

    public void authorize(String userName, char[] password, boolean skipAclUserCheck) throws Exception {
        this.authorize(userName, UserAccount.digest((char[])password), skipAclUserCheck);
    }

    private void authorize(String userName, char[] password, boolean skipAclUserCheck, boolean withoutPsw) throws Exception {
        this.authorize(userName, UserAccount.digest((char[])password), skipAclUserCheck, withoutPsw);
    }

    public void authorize(String userName, byte[] password) throws Exception {
        this.authorize(userName, password, false);
    }

    public void authorize(String userName, byte[] password, boolean skipAclUserCheck) throws Exception {
        this.authorize(userName, password, skipAclUserCheck, false);
    }

    private void authorize(String userName, byte[] password, boolean skipAclUserCheck, boolean withoutPsw) throws Exception {
        this.usersHelper.setUser(null);
        UserAccount userAccount = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)userName);
        if (Objects.isNull(userAccount)) {
            throw new GeneralSecurityException(String.format("user %s is absent in database", userName));
        }
        if (!userAccount.isActive()) {
            throw new GeneralSecurityException(String.format("user %s is inactive", userName));
        }
        SecurityAccountPolicySettings settings = Optional.ofNullable(SystemSettingsHelper.getSecuritySettings()).map(SecuritySettings::getAccountPolicySettings).orElse(null);
        boolean isSystem = userAccount.getLoginName().equals(AclHelper.system.getId());
        if (userAccount.getTemporarilyBlockDate() != null) {
            if (!isSystem && settings != null && settings.isEnabled() && MiscUtil.getDuration((Date)userAccount.getTemporarilyBlockDate(), (Date)new Date(), (int)12) < (long)settings.getTemporarilyBlockTime()) {
                throw new GeneralSecurityException(String.format("user %s is temporarily blocked", userName));
            }
            userAccount.setTemporarilyBlockDate(null);
            AssetsStorage.get().save((BaseAsset)userAccount);
        }
        if (isSystem) {
            if (!withoutPsw) {
                throw new GeneralSecurityException("Using system account is not allowed");
            }
        } else {
            this.checkPsw(userAccount, password, settings, false);
        }
        this.loginAttemptsCount.remove(userName);
        this.usersHelper.setUser(userAccount.getLoginName());
        if (!skipAclUserCheck) {
            com.gridnine.xtrip.server.security.acl.helper.AclHelper.checkAclUser(userAccount.getLoginName());
        }
        LoggerFactory.getLogger(this.getClass()).debug("authorized: " + userAccount.getLoginName());
    }

    private void checkPsw(UserAccount userAccount, byte[] password, SecurityAccountPolicySettings settings, boolean isSystem) throws Exception {
        if (!userAccount.isPasswordValid(password)) {
            String userName = userAccount.getLoginName();
            if (!isSystem && settings != null && settings.isEnabled() && settings.getMaxLoginAttempts() > 0) {
                int count;
                int n = count = this.loginAttemptsCount.get(userName) != null ? this.loginAttemptsCount.get(userName) + 1 : 1;
                if (count >= settings.getMaxLoginAttempts()) {
                    userAccount.setTemporarilyBlockDate(new Date());
                    AssetsStorage.get().save((BaseAsset)userAccount);
                    this.loginAttemptsCount.remove(userName);
                    LoggerFactory.getLogger(this.getClass()).debug(String.format("user %s is blocked after %d login attempts", userName, settings.getMaxLoginAttempts()));
                } else {
                    this.loginAttemptsCount.put(userName, count);
                }
            }
            throw new GeneralSecurityException(String.format("user %s password is invalid", userName));
        }
    }

    public void authorizeBySsoSalt(String userName, char[] ssoSalt, long ssoSaltLifetimeMs) throws Exception {
        if (TextUtil.isBlank((String)userName) || ssoSalt == null || ssoSalt.length == 0) {
            throw new IllegalStateException("user name or SSO salt is blank");
        }
        byte[] ssoSaltDigest = UserAccount.digest((char[])ssoSalt);
        this.usersHelper.setUser(null);
        UserAccount userAccount = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)userName, true);
        if (userAccount == null) {
            throw new GeneralSecurityException("user " + userName + " is absent in database");
        }
        if (!userAccount.isActive()) {
            throw new GeneralSecurityException("user " + userName + " is inactive");
        }
        if (userAccount.getSsoSaltDigest() == null || !Arrays.equals(userAccount.getSsoSaltDigest(), ssoSaltDigest)) {
            throw new GeneralSecurityException("SSO salt for user " + userName + " is invalid");
        }
        if (userAccount.getSsoSaltDigestLastUpdateDate() == null) {
            throw new IllegalStateException("Null last update date for SSO digest for user " + userName);
        }
        if (userAccount.getSsoSaltDigestLastUpdateDate().toInstant().plusMillis(ssoSaltLifetimeMs).isBefore(Instant.now())) {
            throw new GeneralSecurityException("SSO salt is outdated for user " + userName);
        }
        this.usersHelper.setUser(userAccount.getLoginName());
        LoggerFactory.getLogger(this.getClass()).debug("authorized by SSO digest: " + userAccount.getLoginName());
    }

    public void setupScheme(boolean cleanup) throws Exception {
        this.ps.setupScheme(cleanup);
    }

    public boolean checkHealth() {
        return this.ps.checkHealth();
    }

    public void maintain() throws Exception {
        this.ps.maintain();
    }

    public String getPrimaryStorageUid() {
        return this.ps.getUid();
    }

    private static class Holder {
        public static final LogicalStorage INSTANCE = (LogicalStorage)Environment.getPublished(LogicalStorage.class);

        private Holder() {
        }
    }
}

