/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.model.LogicalEntityOperationContext;
import com.gridnine.xtrip.server.ibus.components.MessageContext;

public class LogicalStorageHelper {
    public static final String ENTITY_STORAGE_ACTION_SOURCE_KEY = "ENTITY_STORAGE_ACTION_SOURCE";

    public static EntityStorageContext getEntityStorageContext() {
        EntityStorageContext ctx = (EntityStorageContext)LogicalStorage.get().getSessionContext().get(IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT.name());
        if (null == ctx) {
            ctx = EntityStorageHelper.createContext(LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getNewCtr());
            LogicalStorage.get().getSessionContext().put(IBusStandardContextKeys.ENTITY_STORAGE_CONTEXT.name(), ctx);
        }
        return ctx;
    }

    public static <E extends BaseEntity> EntityContainer<E> getOldContainerFromLocalContextByEntityUid(String uid, Class<E> entityType) {
        if (!LogicalStorage.get().getEntityStorage().isGlobalOperationContextAvailable()) {
            return null;
        }
        for (LogicalEntityOperationContext ctx : LogicalStorage.get().getEntityStorage().getAllLocalOperationContextEntries().values()) {
            EntityContainer<? extends BaseEntity> newCtr = ctx.getNewCtr();
            if (newCtr == null || !entityType.equals(newCtr.getEntityType()) || !newCtr.getEntity().getUid().equals(uid)) continue;
            return ctx.getOldCtr();
        }
        return null;
    }

    private static <E extends BaseEntity> EntityContainer<E> findExistingContainer(MessageContext ctx, EntityReference<E> ref, Enum<?> ... contextKeys) {
        if (contextKeys == null || contextKeys.length == 0) {
            for (Object value : ctx.getRawData().values()) {
                EntityContainer val;
                if (!(value instanceof EntityContainer) || !(val = (EntityContainer)value).getUid().equals(ref.getUid()) || !val.getEntityType().equals(ref.getType())) continue;
                return val;
            }
            return null;
        }
        for (Enum<?> key : contextKeys) {
            EntityContainer val;
            Object value = ctx.getObject(key);
            if (!(value instanceof EntityContainer) || !(val = (EntityContainer)value).getUid().equals(ref.getUid())) continue;
            return val;
        }
        return null;
    }

    public static <E extends BaseEntity> EntityContainer<E> getFromContextOrLoad(EntityReference<E> ref, Enum<?> ... contextKeys) {
        if (ref == null) {
            return null;
        }
        MessageContext ctx = (MessageContext)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get(IBusStandardContextKeys.MESSAGE_CONTEXT.name());
        if (ctx == null) {
            return EntityStorage.get().resolve(ref);
        }
        EntityContainer<E> existingCtr = LogicalStorageHelper.findExistingContainer(ctx, ref, contextKeys);
        if (existingCtr == null) {
            return EntityStorage.get().resolve(ref);
        }
        return existingCtr;
    }

    public static void updateContextOnSaveOperation(EntityContainer<?> ctr, Enum<?> ... contextKeys) throws Exception {
        MessageContext ctx = (MessageContext)LogicalStorage.get().getEntityStorage().getGlobalOperationContext().getParameters().get(IBusStandardContextKeys.MESSAGE_CONTEXT.name());
        if (ctx == null) {
            return;
        }
        EntityContainer existingCtr = LogicalStorageHelper.findExistingContainer(ctx, ctr.toReference(), contextKeys);
        if (existingCtr == null || existingCtr == ctr) {
            return;
        }
        XCloneModelHelper.copy(ctr, existingCtr);
    }

    public static <E extends Exception> void unitOfWork(LockUtil.RunnableWithException<E> body) throws E {
        LogicalSession ls = LogicalStorage.get().beginUnitOfWork();
        try {
            body.run();
            LogicalStorage.get().endUnitOfWork(ls, true);
        }
        finally {
            LogicalStorage.get().cancelUnitOfWork(ls);
        }
    }
}

