/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.asset;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AssetOperationsHelper {
    private static final Logger log = LoggerFactory.getLogger(AssetOperationsHelper.class);

    static <E extends BaseEntity> void addAssetCallback(SessionCallback callback, final List<AssetStorageOperationCompletedInterceptor> operationCompletedInterceptors, final AssetInterceptorCallback operation, final ValueHolder<Throwable> errorHolder) {
        if (operationCompletedInterceptors.isEmpty()) {
            return;
        }
        callback.addCallback(new Callback(){
            private static final long serialVersionUID = -6420564602788551302L;

            @Override
            public void execute(SessionCallback ss) {
                for (AssetStorageOperationCompletedInterceptor interceptor : operationCompletedInterceptors) {
                    try {
                        operation.execute(interceptor);
                    }
                    catch (Throwable e) {
                        log.error("unable to execute callback", e);
                        errorHolder.setValue((Object)e);
                        return;
                    }
                }
            }
        }, true);
    }

    static <A extends BaseAsset> List<A> toAssets(List<PhysicalAssetData<A>> data) {
        ArrayList<A> result = new ArrayList<A>();
        for (PhysicalAssetData<A> item : data) {
            result.add(item.getAsset());
        }
        return result;
    }

    private AssetOperationsHelper() {
    }

    static interface AssetInterceptorCallback {
        public void execute(AssetStorageOperationCompletedInterceptor var1) throws Throwable;
    }
}

