/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.asset;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.asset.AssetOperationsHelper;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.List;

public class DeleteAssetOperation<A extends BaseAsset>
extends LogicalStorageOperation {
    private final PhysicalAssetData<A> asset;
    private final List<AssetStorageOperationCompletedInterceptor> interceptors;
    private final SessionCallback callback;
    private final ValueHolder<Throwable> errorHolder;

    public DeleteAssetOperation(PhysicalAssetData<A> oldData, List<AssetStorageOperationCompletedInterceptor> intrs, SessionCallback clb, ValueHolder<Throwable> holder) {
        this.asset = oldData;
        this.interceptors = intrs;
        this.callback = clb;
        this.errorHolder = holder;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        ps.getAssetStorage().deleteAsset(this.asset, session);
        AssetOperationsHelper.addAssetCallback(this.callback, this.interceptors, new AssetOperationsHelper.AssetInterceptorCallback(){

            @Override
            public void execute(AssetStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterDelete(DeleteAssetOperation.this.callback, (BaseAsset)DeleteAssetOperation.this.asset.getAsset());
            }
        }, this.errorHolder);
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        ps.getAssetStorage().saveAsset(this.asset, null, session);
        AssetOperationsHelper.addAssetCallback(this.callback, this.interceptors, new AssetOperationsHelper.AssetInterceptorCallback(){

            @Override
            public void execute(AssetStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterSave(DeleteAssetOperation.this.callback, (BaseAsset)DeleteAssetOperation.this.asset.getAsset());
            }
        }, this.errorHolder);
    }

    public String toString() {
        return String.format("%s: asset = %s", MiscUtil.getSimpleClassName(this.getClass()), this.asset == null ? null : this.asset.getAsset());
    }
}

