/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.asset;

import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.model.profiling.ProfilingUtils;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.asset.DeleteAssetOperation;
import com.gridnine.xtrip.server.db.storage.asset.LogicalAssetOperationContext;
import com.gridnine.xtrip.server.db.storage.asset.SaveAssetOperation;
import com.gridnine.xtrip.server.db.storage.asset.SaveAssetsOperation;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.common.SessionsHelper;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationStartedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalAssetStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PhysicalStorage ps;
    private final SessionsHelper sh;
    private static final ThreadLocal<ContextData> context = new ThreadLocal();

    public LogicalAssetStorage(PhysicalStorage physicalStorage, SessionsHelper sessionsHelper) {
        this.ps = physicalStorage;
        this.sh = sessionsHelper;
    }

    public <A extends BaseAsset> SearchResult<A> search(Class<A> cls, SearchQuery query) {
        SearchResult<A> searchResult;
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork();
        try {
            SearchResult<A> result = this.ps.getAssetStorage().searchAssets(cls, query, sd.getSession());
            Metrics.get().value("profiling.storage.asset.dataSize." + MiscUtil.getSimpleClassName(cls), result.getData().size());
            searchResult = result;
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.asset.search." + MiscUtil.getSimpleClassName(cls), timing);
        }
        catch (Throwable e) {
            try {
                this.log.error(String.format("unable to search: cls = %s, query = %s", MiscUtil.getSimpleClassName(cls), query), e);
                throw new StorageException("unable to search", e);
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(sd);
                Metrics.get().timingAndEvent("profiling.storage.asset.search." + MiscUtil.getSimpleClassName(cls), timing);
                ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("search.%s", MiscUtil.getSimpleClassName(cls)));
                String key = "storage.search." + MiscUtil.getSimpleClassName(cls);
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                throw throwable;
            }
        }
        ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("search.%s", MiscUtil.getSimpleClassName(cls)));
        String key = "storage.search." + MiscUtil.getSimpleClassName(cls);
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        return searchResult;
    }

    public <A extends BaseAsset> ProjectionResult search(Class<A> cls, ProjectionQuery query) throws StorageException {
        ProjectionResult projectionResult;
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork();
        try {
            projectionResult = this.ps.getAssetStorage().searchAssets(cls, query, sd.getSession());
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.asset.projection." + MiscUtil.getSimpleClassName(cls), timing);
        }
        catch (Throwable e) {
            try {
                this.log.error(String.format("unable to perform projection search: cls = %s, query = %s", MiscUtil.getSimpleClassName(cls), query), e);
                throw new StorageException("unable to perform projection search", e);
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(sd);
                Metrics.get().timingAndEvent("profiling.storage.asset.projection." + MiscUtil.getSimpleClassName(cls), timing);
                ProfilingUtils.monitorQuery((long)timing, (String)String.format("projection-search.%s", MiscUtil.getSimpleClassName(cls)), (StorageQuery)query);
                String key = "storage.projection-search." + MiscUtil.getSimpleClassName(cls);
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                throw throwable;
            }
        }
        ProfilingUtils.monitorQuery((long)timing, (String)String.format("projection-search.%s", MiscUtil.getSimpleClassName(cls)), (StorageQuery)query);
        String key = "storage.projection-search." + MiscUtil.getSimpleClassName(cls);
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        return projectionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends BaseAsset> void save(Iterable<A> assets, boolean ignoreInterceptors) {
        ArrayList toSave;
        long timing;
        block21: {
            boolean updateGlobalContext;
            timing = System.currentTimeMillis();
            if (DebugUtil.isThreadDebugEnabled()) {
                DebugUtil.logStackTrace();
            }
            LogicalSession sd = this.sh.beginUnitOfWork();
            SessionCallback callback = this.sh.createSessionCallback();
            boolean bl = updateGlobalContext = context.get() == null;
            if (updateGlobalContext) {
                context.set(new ContextData());
            }
            toSave = new ArrayList();
            try {
                this.log.debug("save() BEGIN");
                ArrayList toRestore = new ArrayList();
                for (BaseAsset asset : assets) {
                    if (updateGlobalContext) {
                        LogicalAssetStorage.context.get().globalOperationContext.setNewAsset(asset);
                    }
                    AssetReference ref = new AssetReference(asset);
                    this.getLocalOperationContext(ref).reset();
                    try {
                        PhysicalAssetData<?> loadAsset = this.ps.getAssetStorage().loadAsset(asset.getClass(), asset.getUid(), sd.getSession());
                        if (loadAsset != null) {
                            Object oldAsset2 = loadAsset.getAsset();
                            this.getLocalOperationContext(ref).setOldAsset((BaseAsset)oldAsset2);
                            if (updateGlobalContext) {
                                LogicalAssetStorage.context.get().globalOperationContext.setOldAsset((BaseAsset)oldAsset2);
                            }
                        }
                        PhysicalAssetData<BaseAsset> newAsset = new PhysicalAssetData<BaseAsset>();
                        if (loadAsset != null) {
                            toRestore.add(loadAsset);
                            loadAsset.copy(newAsset);
                        }
                        newAsset.setAsset(asset);
                        toSave.add(newAsset);
                        if (ignoreInterceptors) continue;
                        for (AssetStorageOperationStartedInterceptor interceptor : LogicalStorageRegistry.get().getAssetOperationStartedInterceptors()) {
                            interceptor.beforeSave(callback, asset);
                        }
                    }
                    finally {
                        LogicalAssetStorage.context.get().localOperationContext.remove(ref);
                    }
                }
                ValueHolder errorHolder = new ValueHolder();
                this.sh.registerOperation(new SaveAssetsOperation(toSave, toRestore, this.getOperationCompletedInterceptors(ignoreInterceptors), callback, (ValueHolder<Throwable>)errorHolder));
                this.sh.endUnitOfWork(sd, true);
                if (errorHolder.getValue() != null) {
                    throw (Throwable)errorHolder.getValue();
                }
                this.log.debug("save() END");
                this.sh.cancelUnitOfWork(sd);
                if (updateGlobalContext) {
                    context.remove();
                }
                if (toSave.isEmpty()) break block21;
                Metrics.get().timingAndEvent("profiling.storage.asset.save." + MiscUtil.getSimpleClassName(((PhysicalAssetData)toSave.get(0)).getClass()), timing);
            }
            catch (Throwable e) {
                try {
                    this.log.error(String.format("unable to save assets: cls = %s", toSave.isEmpty() ? null : ((PhysicalAssetData)toSave.get(0)).getClass()), e);
                    throw new StorageException("unable to search", e);
                }
                catch (Throwable throwable) {
                    this.sh.cancelUnitOfWork(sd);
                    if (updateGlobalContext) {
                        context.remove();
                    }
                    if (!toSave.isEmpty()) {
                        Metrics.get().timingAndEvent("profiling.storage.asset.save." + MiscUtil.getSimpleClassName(((PhysicalAssetData)toSave.get(0)).getClass()), timing);
                    }
                    ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("save.%s", toSave.isEmpty() ? null : MiscUtil.getSimpleClassName(((PhysicalAssetData)toSave.get(0)).getClass())));
                    String key = "storage.save." + (toSave.isEmpty() ? null : MiscUtil.getSimpleClassName(((PhysicalAssetData)toSave.get(0)).getClass()));
                    if (Profiler.get().isProfilingEnabled(key)) {
                        Profiler.get().updateTiming(key, timing, null);
                    }
                    throw throwable;
                }
            }
        }
        ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("save.%s", toSave.isEmpty() ? null : MiscUtil.getSimpleClassName(((PhysicalAssetData)toSave.get(0)).getClass())));
        String key = "storage.save." + (toSave.isEmpty() ? null : MiscUtil.getSimpleClassName(((PhysicalAssetData)toSave.get(0)).getClass()));
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        MiscUtil.logTiming((long)timing, (String)"assets saved");
    }

    public <A extends BaseAsset> void save(A asset) {
        this.save(asset, false);
    }

    public <A extends BaseAsset> void save(Iterable<A> assets) {
        this.save((A)assets, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends BaseAsset> void save(A asset, boolean ignoreInterceptors) {
        long timing = System.currentTimeMillis();
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        NamedLock lock = SessionsHelper.lock(LogicalAssetStorage.getLockKey(asset));
        try {
            boolean updateGlobalContext;
            LogicalSession sd = this.sh.beginUnitOfWork();
            SessionCallback callback = this.sh.createSessionCallback();
            boolean bl = updateGlobalContext = context.get() == null;
            if (updateGlobalContext) {
                context.set(new ContextData());
            }
            if (updateGlobalContext) {
                LogicalAssetStorage.context.get().globalOperationContext.setNewAsset(asset);
            }
            AssetReference ref = new AssetReference(asset);
            this.getLocalOperationContext(ref).reset();
            try {
                this.log.debug("save() BEGIN");
                ValueHolder errorHolder = new ValueHolder();
                PhysicalAssetData<?> oldAsset = this.ps.getAssetStorage().loadAsset(asset.getClass(), asset.getUid(), sd.getSession());
                if (oldAsset != null) {
                    Object oldAsset2 = oldAsset.getAsset();
                    this.getLocalOperationContext(ref).setOldAsset((BaseAsset)oldAsset2);
                    if (updateGlobalContext) {
                        LogicalAssetStorage.context.get().globalOperationContext.setOldAsset((BaseAsset)oldAsset2);
                    }
                }
                if (!ignoreInterceptors) {
                    for (AssetStorageOperationStartedInterceptor interceptor : LogicalStorageRegistry.get().getAssetOperationStartedInterceptors()) {
                        interceptor.beforeSave(callback, asset);
                    }
                }
                PhysicalAssetData<A> newAsset = new PhysicalAssetData<A>();
                if (oldAsset != null) {
                    oldAsset.copy(newAsset);
                }
                newAsset.setAsset(asset);
                this.sh.registerOperation(new SaveAssetOperation(newAsset, oldAsset, this.getOperationCompletedInterceptors(ignoreInterceptors), callback, (ValueHolder<Throwable>)errorHolder));
                this.sh.endUnitOfWork(sd, true);
                if (errorHolder.getValue() != null) {
                    throw (Throwable)errorHolder.getValue();
                }
                this.log.debug("save() END");
                LogicalAssetStorage.context.get().localOperationContext.remove(ref);
            }
            catch (Throwable e) {
                try {
                    this.log.error(String.format("unable to save asset: cls = %s uid = %s", asset.getClass(), asset.getUid()), e);
                    throw new StorageException("unable to save", e);
                }
                catch (Throwable throwable) {
                    LogicalAssetStorage.context.get().localOperationContext.remove(ref);
                    if (updateGlobalContext) {
                        context.remove();
                    }
                    this.sh.cancelUnitOfWork(sd);
                    Metrics.get().timingAndEvent("profiling.storage.asset.save." + MiscUtil.getSimpleClassName(asset.getClass()), timing);
                    ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("save.%s", MiscUtil.getSimpleClassName(asset.getClass())));
                    String key = "storage.save." + MiscUtil.getSimpleClassName(asset.getClass());
                    if (Profiler.get().isProfilingEnabled(key)) {
                        Profiler.get().updateTiming(key, timing, null);
                    }
                    throw throwable;
                }
            }
            if (updateGlobalContext) {
                context.remove();
            }
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.asset.save." + MiscUtil.getSimpleClassName(asset.getClass()), timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("save.%s", MiscUtil.getSimpleClassName(asset.getClass())));
            String key = "storage.save." + MiscUtil.getSimpleClassName(asset.getClass());
            if (Profiler.get().isProfilingEnabled(key)) {
                Profiler.get().updateTiming(key, timing, null);
            }
        }
        finally {
            if (this.sh.isSessionOpen()) {
                this.sh.addSessionLock(lock);
            } else {
                SessionsHelper.unlock(lock);
            }
        }
        MiscUtil.logTiming((long)timing, (String)"assets saved");
    }

    public <A extends BaseAsset> A load(Class<A> cls, String uid) throws StorageException {
        A a;
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork();
        try {
            PhysicalAssetData<A> data = this.ps.getAssetStorage().loadAsset(cls, uid, sd.getSession());
            a = data == null ? null : (A)data.getAsset();
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.asset.load." + MiscUtil.getSimpleClassName(cls), timing);
        }
        catch (Throwable e) {
            try {
                this.log.error(String.format("unable to load asset: cls = %s, uid = %s", MiscUtil.getSimpleClassName(cls), uid), e);
                throw new StorageException("unable to search", e);
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(sd);
                Metrics.get().timingAndEvent("profiling.storage.asset.load." + MiscUtil.getSimpleClassName(cls), timing);
                ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("load.%s", MiscUtil.getSimpleClassName(cls)));
                String key = "storage.load." + MiscUtil.getSimpleClassName(cls);
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                throw throwable;
            }
        }
        ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("load.%s", MiscUtil.getSimpleClassName(cls)));
        String key = "storage.load." + MiscUtil.getSimpleClassName(cls);
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        return a;
    }

    public <A extends BaseAsset> void delete(A asset) {
        this.delete(asset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends BaseAsset> void delete(A asset, boolean ignoreInterceptors) {
        if (asset == null) {
            return;
        }
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        long timing = System.currentTimeMillis();
        NamedLock lock = SessionsHelper.lock(LogicalAssetStorage.getLockKey(asset));
        try {
            PhysicalAssetData<?> oldAsset;
            SessionCallback callback;
            AssetReference ref;
            boolean updateGlobalContext;
            LogicalSession sd;
            block23: {
                sd = this.sh.beginUnitOfWork();
                boolean bl = updateGlobalContext = context.get() == null;
                if (updateGlobalContext) {
                    context.set(new ContextData());
                    LogicalAssetStorage.context.get().globalOperationContext.getParameters().put("OPERATION", "DELETE");
                }
                ref = new AssetReference(asset);
                this.getLocalOperationContext(ref).reset();
                callback = this.sh.createSessionCallback();
                this.log.debug("delete() BEGIN asset=" + asset);
                if (!ignoreInterceptors) {
                    for (AssetStorageOperationStartedInterceptor interceptor : LogicalStorageRegistry.get().getAssetOperationStartedInterceptors()) {
                        interceptor.beforeDelete(callback, asset);
                    }
                }
                if ((oldAsset = this.ps.getAssetStorage().loadAsset(asset.getClass(), asset.getUid(), sd.getSession())) != null) break block23;
                this.log.warn("no data found for asset " + asset);
                LogicalAssetStorage.context.get().localOperationContext.remove(ref);
                if (updateGlobalContext) {
                    context.remove();
                }
                this.sh.cancelUnitOfWork(sd);
                Metrics.get().timingAndEvent("profiling.storage.asset.delete." + MiscUtil.getSimpleClassName(asset.getClass()), timing);
                ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("delete.%s", MiscUtil.getSimpleClassName(asset.getClass())));
                String key = "storage.delete." + MiscUtil.getSimpleClassName(asset.getClass());
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                return;
            }
            try {
                ValueHolder errorHolder = new ValueHolder();
                this.sh.registerOperation(new DeleteAssetOperation(oldAsset, this.getOperationCompletedInterceptors(ignoreInterceptors), callback, (ValueHolder<Throwable>)errorHolder));
                this.sh.endUnitOfWork(sd, true);
                if (errorHolder.getValue() != null) {
                    throw (Throwable)errorHolder.getValue();
                }
                this.log.debug("delete() END asset=" + asset);
                LogicalAssetStorage.context.get().localOperationContext.remove(ref);
            }
            catch (Throwable e) {
                try {
                    this.log.error(String.format("unable to delete asset: cls = %s, uid = %s", asset.getClass(), asset.getUid()), e);
                    throw new StorageException("unable to delete asset", e);
                }
                catch (Throwable throwable) {
                    LogicalAssetStorage.context.get().localOperationContext.remove(ref);
                    if (updateGlobalContext) {
                        context.remove();
                    }
                    this.sh.cancelUnitOfWork(sd);
                    Metrics.get().timingAndEvent("profiling.storage.asset.delete." + MiscUtil.getSimpleClassName(asset.getClass()), timing);
                    ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("delete.%s", MiscUtil.getSimpleClassName(asset.getClass())));
                    String key = "storage.delete." + MiscUtil.getSimpleClassName(asset.getClass());
                    if (Profiler.get().isProfilingEnabled(key)) {
                        Profiler.get().updateTiming(key, timing, null);
                    }
                    throw throwable;
                }
            }
            if (updateGlobalContext) {
                context.remove();
            }
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.asset.delete." + MiscUtil.getSimpleClassName(asset.getClass()), timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("delete.%s", MiscUtil.getSimpleClassName(asset.getClass())));
            String key = "storage.delete." + MiscUtil.getSimpleClassName(asset.getClass());
            if (Profiler.get().isProfilingEnabled(key)) {
                Profiler.get().updateTiming(key, timing, null);
            }
        }
        finally {
            if (this.sh.isSessionOpen()) {
                this.sh.addSessionLock(lock);
            } else {
                SessionsHelper.unlock(lock);
            }
        }
        MiscUtil.logTiming((long)timing, (String)("asset deleted " + asset));
    }

    private List<AssetStorageOperationCompletedInterceptor> getOperationCompletedInterceptors(boolean ignoreInterceptors) {
        return ignoreInterceptors ? LogicalStorageRegistry.get().getAssetOperationCompletedInterceptors().stream().filter(AssetStorageOperationCompletedInterceptor::isSystem).collect(Collectors.toList()) : LogicalStorageRegistry.get().getAssetOperationCompletedInterceptors();
    }

    public static <A extends BaseAsset> String getLockKey(A asset) {
        return asset == null ? null : String.format("%s_%s", asset.getClass().getName(), asset.getUid());
    }

    public LogicalAssetOperationContext getLocalOperationContext(AssetReference<?> ref) {
        if (context.get() == null) {
            throw new IllegalStateException("context is available only inside save or delete operation");
        }
        LogicalAssetOperationContext res = LogicalAssetStorage.context.get().localOperationContext.get(ref);
        if (res == null) {
            res = new LogicalAssetOperationContext();
            LogicalAssetStorage.context.get().localOperationContext.put(ref, res);
        }
        return res;
    }

    public LogicalAssetOperationContext getGlobalOperationContext() {
        if (context.get() == null) {
            throw new IllegalStateException("context is available only inside save or delete operation");
        }
        return LogicalAssetStorage.context.get().globalOperationContext;
    }

    static final class ContextData {
        final Map<AssetReference<?>, LogicalAssetOperationContext> localOperationContext = new HashMap();
        final LogicalAssetOperationContext globalOperationContext = new LogicalAssetOperationContext();

        ContextData() {
        }
    }
}

