/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.asset;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.asset.AssetOperationsHelper;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.List;

public class SaveAssetOperation<A extends BaseAsset>
extends LogicalStorageOperation {
    private final PhysicalAssetData<A> oldAsset;
    private final PhysicalAssetData<A> newAsset;
    private final List<AssetStorageOperationCompletedInterceptor> interceptors;
    private final SessionCallback callback;
    private final ValueHolder<Throwable> errorHolder;

    public SaveAssetOperation(PhysicalAssetData<A> newData, PhysicalAssetData<A> oldData, List<AssetStorageOperationCompletedInterceptor> intrs, SessionCallback clb, ValueHolder<Throwable> holder) {
        this.oldAsset = oldData;
        this.newAsset = newData;
        this.interceptors = intrs;
        this.callback = clb;
        this.errorHolder = holder;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        ps.getAssetStorage().saveAsset(this.newAsset, this.oldAsset, session);
        AssetOperationsHelper.addAssetCallback(this.callback, this.interceptors, new AssetOperationsHelper.AssetInterceptorCallback(){

            @Override
            public void execute(AssetStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterSave(SaveAssetOperation.this.callback, (BaseAsset)SaveAssetOperation.this.newAsset.getAsset());
            }
        }, this.errorHolder);
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (this.oldAsset == null) {
            ps.getAssetStorage().deleteAsset(this.newAsset, session);
            AssetOperationsHelper.addAssetCallback(this.callback, this.interceptors, new AssetOperationsHelper.AssetInterceptorCallback(){

                @Override
                public void execute(AssetStorageOperationCompletedInterceptor interceptor) throws Throwable {
                    interceptor.afterDelete(SaveAssetOperation.this.callback, (BaseAsset)SaveAssetOperation.this.newAsset.getAsset());
                }
            }, this.errorHolder);
            return;
        }
        ps.getAssetStorage().saveAsset(this.oldAsset, this.newAsset, session);
        AssetOperationsHelper.addAssetCallback(this.callback, this.interceptors, new AssetOperationsHelper.AssetInterceptorCallback(){

            @Override
            public void execute(AssetStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterSave(SaveAssetOperation.this.callback, (BaseAsset)SaveAssetOperation.this.oldAsset.getAsset());
            }
        }, this.errorHolder);
    }

    public String toString() {
        return String.format("%s: oldAsset = %s newAsset = %s", MiscUtil.getSimpleClassName(this.getClass()), this.oldAsset == null ? null : this.oldAsset.getAsset(), this.newAsset == null ? null : this.newAsset.getAsset());
    }
}

