/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.asset;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.asset.AssetOperationsHelper;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.ArrayList;
import java.util.List;

public class SaveAssetsOperation<A extends BaseAsset>
extends LogicalStorageOperation {
    private final List<PhysicalAssetData<A>> oldAssets;
    private final List<PhysicalAssetData<A>> newAssets;
    private final List<AssetStorageOperationCompletedInterceptor> interceptors;
    private final SessionCallback callback;
    private final ValueHolder<Throwable> errorHolder;

    public SaveAssetsOperation(List<PhysicalAssetData<A>> newData, List<PhysicalAssetData<A>> oldData, List<AssetStorageOperationCompletedInterceptor> intrs, SessionCallback clb, ValueHolder<Throwable> holder) {
        this.oldAssets = oldData;
        this.newAssets = newData;
        this.interceptors = intrs;
        this.callback = clb;
        this.errorHolder = holder;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        for (PhysicalAssetData<A> asset : this.newAssets) {
            ps.getAssetStorage().saveAsset(asset, this.findAsset(this.oldAssets, asset.getAsset().getUid()), session);
        }
        AssetOperationsHelper.addAssetCallback(this.callback, this.interceptors, new AssetOperationsHelper.AssetInterceptorCallback(){

            @Override
            public void execute(AssetStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterSave(SaveAssetsOperation.this.callback, AssetOperationsHelper.toAssets(SaveAssetsOperation.this.newAssets));
            }
        }, this.errorHolder);
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        ArrayList<PhysicalAssetData<A>> toDelete = new ArrayList<PhysicalAssetData<A>>(this.newAssets);
        for (final PhysicalAssetData<Object> item : this.newAssets) {
            PhysicalAssetData<A> oldAsset = this.findAsset(this.oldAssets, item.getAsset().getUid());
            if (oldAsset == null) continue;
            toDelete.remove(oldAsset);
        }
        for (final PhysicalAssetData<Object> item : toDelete) {
            ps.getAssetStorage().deleteAsset(item, session);
            AssetOperationsHelper.addAssetCallback(this.callback, this.interceptors, new AssetOperationsHelper.AssetInterceptorCallback(){

                @Override
                public void execute(AssetStorageOperationCompletedInterceptor interceptor) throws Throwable {
                    interceptor.afterDelete(SaveAssetsOperation.this.callback, (BaseAsset)item.getAsset());
                }
            }, this.errorHolder);
        }
        if (this.oldAssets.isEmpty()) {
            return;
        }
        for (final PhysicalAssetData<Object> item : this.oldAssets) {
            ps.getAssetStorage().saveAsset(item, this.findAsset(this.newAssets, item.getAsset().getUid()), session);
        }
        AssetOperationsHelper.addAssetCallback(this.callback, this.interceptors, new AssetOperationsHelper.AssetInterceptorCallback(){

            @Override
            public void execute(AssetStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterSave(SaveAssetsOperation.this.callback, AssetOperationsHelper.toAssets(SaveAssetsOperation.this.oldAssets));
            }
        }, this.errorHolder);
    }

    private PhysicalAssetData<A> findAsset(List<PhysicalAssetData<A>> data, String uid) {
        for (PhysicalAssetData<A> item : data) {
            if (!item.getAsset().getUid().equals(uid)) continue;
            return item;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(MiscUtil.getSimpleClassName(this.getClass()));
        for (PhysicalAssetData<A> item : this.newAssets) {
            sb.append("\r\n").append(item.getAsset());
        }
        return sb.toString();
    }
}

