/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.common;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.common.BaseCriterion;
import com.gridnine.xtrip.server.db.storage.common.StringValueCriterion;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;

public final class ArrayRestrictions {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String CITEXT_PROPERTY = "postgresql.extension.citext";

    public static Criterion eq(String propertyName, Object value) {
        return Restrictions.eq((String)propertyName, (Object)value);
    }

    public static Criterion empty(String propertyName) {
        return Restrictions.eq((String)propertyName, (Object)EMPTY_STRING_ARRAY);
    }

    public static Criterion nonEmpty(String propertyName) {
        return Restrictions.ne((String)propertyName, (Object)EMPTY_STRING_ARRAY);
    }

    public static Criterion contains(String propertyName, Object value) {
        return new ArrayContainsCriterion(propertyName, value);
    }

    public static Criterion icontains(String propertyName, Object value) {
        return new ArrayIContainsCriterion(propertyName, value);
    }

    public static Criterion ifirst(String propertyName, Object value) {
        return new ArrayIFirstCriterion(propertyName, value);
    }

    public static Criterion ilast(String propertyName, Object value) {
        return new ArrayILastCriterion(propertyName, value);
    }

    public static Criterion query(String propertyName, Object value) {
        return new QueryCriterion(propertyName, value);
    }

    public static Criterion startsWith(String propertyName, Object value) {
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("values other than String not supported");
        }
        String valueStr = (String)value;
        if (TextUtil.isBlank((String)valueStr)) {
            throw new IllegalArgumentException("blank strings not supported");
        }
        StringBuilder queryStr = new StringBuilder(valueStr.length() + 10);
        queryStr.append('\'');
        for (char c : valueStr.toCharArray()) {
            switch (c) {
                case ' ': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '\\': 
                case '|': {
                    queryStr.append('\\');
                }
            }
            queryStr.append(c);
        }
        queryStr.append('\'');
        queryStr.append(":*");
        return new StartsWithCriterion(propertyName, queryStr.toString());
    }

    private static class StartsWithCriterion
    extends StringValueCriterion {
        private static final long serialVersionUID = 5481322503649801161L;

        public StartsWithCriterion(String propertyName, String value) {
            super(propertyName, value);
        }

        @Override
        protected void toSqlString(StringBuilder fragment, String column, Dialect dialect) {
            fragment.append("array_to_tsvector(").append(column).append(")").append("@@").append("cast(").append('?').append(" as tsquery)");
        }
    }

    private static class QueryCriterion
    extends StringValueCriterion {
        private static final long serialVersionUID = 8758676182362667777L;

        public QueryCriterion(String propertyName, Object value) {
            super(propertyName, value);
        }

        @Override
        protected void toSqlString(StringBuilder fragment, String column, Dialect dialect) {
            fragment.append("to_tsvector('simple', cast(array_to_tsvector(").append(column).append(") as text))").append("@@").append("to_tsquery(").append('?').append(")");
        }
    }

    private static class ArrayILastCriterion
    extends StringValueCriterion {
        private static final long serialVersionUID = -144989393775820684L;

        public ArrayILastCriterion(String propertyName, Object value) {
            super(propertyName, value);
        }

        @Override
        protected void toSqlString(StringBuilder fragment, String column, Dialect dialect) {
            if (dialect instanceof HSQLDialect) {
                fragment.append("POSITION_ARRAY(? IN ").append(column).append(") = CARDINALITY(").append(column).append(")");
                return;
            }
            boolean hasCIText = Boolean.parseBoolean((String)dialect.getDefaultProperties().get(ArrayRestrictions.CITEXT_PROPERTY));
            if (hasCIText) {
                fragment.append(column).append("[array_length(").append(column).append(",1)]").append("::citext").append('=').append('?').append("::citext");
            } else {
                fragment.append(dialect.getLowercaseFunction()).append('(').append(column).append("[array_length(").append(column).append(",1)]").append(')').append('=').append('(').append('?').append(')');
            }
        }
    }

    private static class ArrayIFirstCriterion
    extends StringValueCriterion {
        private static final long serialVersionUID = -1090237608380027518L;

        public ArrayIFirstCriterion(String propertyName, Object value) {
            super(propertyName, value);
        }

        @Override
        protected void toSqlString(StringBuilder fragment, String column, Dialect dialect) {
            if (dialect instanceof HSQLDialect) {
                fragment.append("POSITION_ARRAY(? IN ").append(column).append(") = 1");
                return;
            }
            boolean hasCIText = Boolean.parseBoolean((String)dialect.getDefaultProperties().get(ArrayRestrictions.CITEXT_PROPERTY));
            if (hasCIText) {
                fragment.append(column).append("[1]").append("::citext").append('=').append('?').append("::citext");
            } else {
                fragment.append(dialect.getLowercaseFunction()).append('(').append(column).append("[1]").append(')').append('=').append('(').append('?').append(')');
            }
        }
    }

    private static class ArrayIContainsCriterion
    extends BaseCriterion {
        private static final long serialVersionUID = 6320268513580502745L;

        public ArrayIContainsCriterion(String propertyName, Object value) {
            super(propertyName, value);
        }

        @Override
        protected void toSqlString(StringBuilder fragment, String column, Dialect dialect) {
            if (dialect instanceof HSQLDialect) {
                fragment.append("POSITION_ARRAY(? IN ").append(column).append(") > 0");
                return;
            }
            boolean hasCIText = Boolean.parseBoolean((String)dialect.getDefaultProperties().get(ArrayRestrictions.CITEXT_PROPERTY));
            if (hasCIText) {
                fragment.append(column).append("::citext[]").append("&&").append('?').append("::citext[]");
            } else {
                fragment.append("(SELECT array_agg(lower(value)) FROM unnest(").append(column).append(") value)").append("&&").append("(SELECT array_agg(lower(value)) FROM unnest(?) value)");
            }
        }
    }

    private static class ArrayContainsCriterion
    extends BaseCriterion {
        private static final long serialVersionUID = 4894308955264881202L;

        public ArrayContainsCriterion(String propertyName, Object value) {
            super(propertyName, value);
        }

        @Override
        protected void toSqlString(StringBuilder fragment, String column, Dialect dialect) {
            if (dialect instanceof HSQLDialect) {
                fragment.append("EXISTS (SELECT * FROM UNNEST(").append(column).append(") AS a(v) WHERE v IN (UNNEST(?)) )");
                return;
            }
            fragment.append(column).append("&&").append('?');
        }
    }
}

