/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.common;

import com.gridnine.xtrip.server.db.storage.common.StringValueCriterion;
import org.hibernate.criterion.Criterion;
import org.hibernate.dialect.Dialect;

public final class ExRestrictions {
    public static Criterion query(String propertyName, Object value) {
        return new QueryCriterion(propertyName, value);
    }

    public static Criterion startsWith(String propertyName, Object value) {
        return new StartsWithCriterion(propertyName, ExRestrictions.buildPrefixLike((String)value));
    }

    public static Criterion istartsWith(String propertyName, Object value) {
        return new IStartsWithCriterion(propertyName, ExRestrictions.buildPrefixLike((String)value));
    }

    public static Criterion ieq(String propertyName, Object value) {
        return new IEqCriterion(propertyName, (String)value);
    }

    private static String buildPrefixLike(String like) {
        StringBuilder result = new StringBuilder(like.length() + 5);
        for (char c : like.toCharArray()) {
            switch (c) {
                case '%': 
                case '_': {
                    result.append('\\');
                }
            }
            result.append(c);
        }
        result.append('%');
        return result.toString();
    }

    private static class IEqCriterion
    extends StringValueCriterion {
        private static final long serialVersionUID = 1366227267074186612L;

        public IEqCriterion(String propertyName, String value) {
            super(propertyName, value);
        }

        @Override
        protected void toSqlString(StringBuilder fragment, String column, Dialect dialect) {
            fragment.append(dialect.getLowercaseFunction()).append("(").append(column).append(")").append('=').append(dialect.getLowercaseFunction()).append("(").append('?').append(")");
        }
    }

    private static class IStartsWithCriterion
    extends StringValueCriterion {
        private static final long serialVersionUID = 4646509797182357012L;

        public IStartsWithCriterion(String propertyName, String value) {
            super(propertyName, value);
        }

        @Override
        protected void toSqlString(StringBuilder fragment, String column, Dialect dialect) {
            fragment.append(dialect.getLowercaseFunction()).append("(").append(column).append(")").append(" LIKE ").append(dialect.getLowercaseFunction()).append("(").append('?').append(")");
        }
    }

    private static class StartsWithCriterion
    extends StringValueCriterion {
        private static final long serialVersionUID = 2452219999835840033L;

        public StartsWithCriterion(String propertyName, String value) {
            super(propertyName, value);
        }

        @Override
        protected void toSqlString(StringBuilder fragment, String column, Dialect dialect) {
            fragment.append(column).append(" LIKE ").append('?');
        }
    }

    private static class QueryCriterion
    extends StringValueCriterion {
        private static final long serialVersionUID = -6235586669355592813L;

        public QueryCriterion(String propertyName, Object value) {
            super(propertyName, value);
        }

        @Override
        protected void toSqlString(StringBuilder fragment, String column, Dialect dialect) {
            fragment.append("to_tsvector('simple', ").append(column).append(")").append("@@").append("to_tsquery('simple', ").append('?').append(")");
        }
    }
}

