/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.common;

import com.gridnine.xtrip.common.util.TextUtil;

public class FullTextQueryHelper {
    public static QueryBuilder queryBuilder(String term, boolean searchForPrefix) {
        return new QueryBuilder(term, searchForPrefix);
    }

    public static String buildTextQueryTerm(String text, boolean isPrefixSearch) {
        if (text == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(text.length() + 10);
        result.append('\'');
        for (char c : text.toCharArray()) {
            switch (c) {
                case ' ': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '\\': 
                case '|': {
                    result.append('\\');
                }
            }
            result.append(c);
        }
        result.append('\'');
        if (isPrefixSearch) {
            result.append(":*");
        }
        return result.toString();
    }

    public static class QueryBuilder {
        private final StringBuilder query;

        private QueryBuilder(String term, boolean searchForPrefix) {
            this.query = new StringBuilder(QueryBuilder.ensureValid(FullTextQueryHelper.buildTextQueryTerm(term, searchForPrefix)));
        }

        public QueryBuilder and(String term, boolean searchForPrefix) {
            this.query.append('&').append(QueryBuilder.ensureValid(FullTextQueryHelper.buildTextQueryTerm(term, searchForPrefix)));
            return this;
        }

        public QueryBuilder and(QueryBuilder nested) {
            this.query.append('&').append('(').append((CharSequence)QueryBuilder.ensureValid((QueryBuilder)nested).query).append(')');
            return this;
        }

        public QueryBuilder or(String term, boolean searchForPrefix) {
            this.query.append('|').append(QueryBuilder.ensureValid(FullTextQueryHelper.buildTextQueryTerm(term, searchForPrefix)));
            return this;
        }

        public QueryBuilder or(QueryBuilder nested) {
            this.query.append('|').append('(').append((CharSequence)QueryBuilder.ensureValid((QueryBuilder)nested).query).append(')');
            return this;
        }

        private static String ensureValid(String term) {
            if (TextUtil.isBlank((String)term)) {
                throw new NullPointerException("Term must not be empty");
            }
            return term;
        }

        private static QueryBuilder ensureValid(QueryBuilder qb) {
            if (qb.query.length() == 0) {
                throw new NullPointerException("Nested query  builder must not be empty");
            }
            return qb;
        }

        public String toString() {
            return this.query.toString();
        }
    }
}

