/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.common;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.interceptors.HasPriority;
import com.gridnine.xtrip.server.db.DbInterceptor;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationStartedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationStartedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.EntityStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalStorageRegistry
implements Disposable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<EntityInterceptor> entityInterceptors = new ArrayList<EntityInterceptor>();
    final List<EntityStorageOperationCompletedInterceptor> entityOperationCompletedInterceptors = new ArrayList<EntityStorageOperationCompletedInterceptor>();
    private final List<IndexHandler<?, ?>> indexHandlers = new ArrayList();
    private final List<AssetStorageOperationStartedInterceptor> assetOperationStartedInterceptors = new ArrayList<AssetStorageOperationStartedInterceptor>();
    final List<AssetStorageOperationCompletedInterceptor> assetOperationCompletedInterceptors = new ArrayList<AssetStorageOperationCompletedInterceptor>();
    private final List<DictionaryStorageOperationCompletedInterceptor> dictionaryOperationCompletedInterceptors = new ArrayList<DictionaryStorageOperationCompletedInterceptor>();
    private final List<DictionaryStorageOperationStartedInterceptor> dictionaryOperationStartedInterceptors = new ArrayList<DictionaryStorageOperationStartedInterceptor>();
    private final List<DbInterceptor> storageInterceptors = new ArrayList<DbInterceptor>();
    private final Map<String, PhysicalStorage> storages = new HashMap<String, PhysicalStorage>();
    static final Comparator<HasPriority> INTERCEPTORS_COMPARATOR = new Comparator<HasPriority>(){

        @Override
        public int compare(HasPriority o1, HasPriority o2) {
            return Double.compare(o1.getPriority(), o2.getPriority());
        }
    };

    public static LogicalStorageRegistry get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (LogicalStorageRegistry)Environment.getPublished(LogicalStorageRegistry.class);
    }

    public void registerEntityInterceptor(EntityInterceptor interceptor) {
        this.entityInterceptors.add(interceptor);
        Collections.sort(this.entityInterceptors, INTERCEPTORS_COMPARATOR);
        this.log.debug("registered entity interceptor - " + interceptor);
    }

    public void unRegisterEntityInterceptor(Class clazz) {
        Iterator<EntityInterceptor> iterator = this.entityInterceptors.iterator();
        while (iterator.hasNext()) {
            EntityInterceptor interceptor = iterator.next();
            if (!interceptor.getClass().equals(clazz)) continue;
            iterator.remove();
        }
        Collections.sort(this.entityInterceptors, INTERCEPTORS_COMPARATOR);
        this.log.debug("unregistered entity interceptor - " + clazz.getName());
    }

    public void registerIndexHandler(IndexHandler<?, ?> handler) {
        this.indexHandlers.add(handler);
        this.log.debug("registered index handler - " + handler);
    }

    public void unregisterIndexHandler(IndexHandler<?, ?> handler) {
        this.indexHandlers.remove(handler);
        this.log.debug("unregistered index handler - " + handler);
    }

    public void registerEntityOperationCompletedInterceptor(EntityStorageOperationCompletedInterceptor interceptor) {
        this.entityOperationCompletedInterceptors.add(interceptor);
        Collections.sort(this.entityOperationCompletedInterceptors, INTERCEPTORS_COMPARATOR);
        this.log.debug("registered entity operation completed interceptor - " + interceptor);
    }

    public <E extends BaseEntity> Collection<IndexHandler<E, EntityIndex<E>>> getIndexHandlers(Class<E> cls) {
        ArrayList result = new ArrayList();
        for (IndexHandler<?, ?> handler : this.indexHandlers) {
            if (!handler.getEntityType().equals(cls) && (!Modifier.isAbstract(handler.getEntityType().getModifiers()) || !handler.getEntityType().isAssignableFrom(cls))) continue;
            result.add(handler);
        }
        return result;
    }

    public List<EntityStorageOperationCompletedInterceptor> getEntityOperationCompletedInterceptors() {
        return this.entityOperationCompletedInterceptors;
    }

    public List<EntityInterceptor> getEntityInterceptors() {
        return this.entityInterceptors;
    }

    public void registerAssetOperationCompletedInterceptor(AssetStorageOperationCompletedInterceptor interceptor) {
        this.assetOperationCompletedInterceptors.add(interceptor);
        Collections.sort(this.assetOperationCompletedInterceptors, INTERCEPTORS_COMPARATOR);
        this.log.debug("registered asset operation completed interceptor - " + interceptor);
    }

    public void registerAssetOperationStartedInterceptor(AssetStorageOperationStartedInterceptor interceptor) {
        this.assetOperationStartedInterceptors.add(interceptor);
        Collections.sort(this.assetOperationStartedInterceptors, INTERCEPTORS_COMPARATOR);
        this.log.debug("registered asset operation started interceptor - " + interceptor);
    }

    public void registerPhysicalStorage(PhysicalStorage storage) {
        this.storages.put(storage.getUid(), storage);
        this.log.debug("registered storage - " + storage);
    }

    public PhysicalStorage getStorage(String uid) {
        return this.storages.get(uid);
    }

    public Collection<PhysicalStorage> getStorageList() {
        return new ArrayList<PhysicalStorage>(this.storages.values());
    }

    public List<AssetStorageOperationCompletedInterceptor> getAssetOperationCompletedInterceptors() {
        return this.assetOperationCompletedInterceptors;
    }

    public List<AssetStorageOperationStartedInterceptor> getAssetOperationStartedInterceptors() {
        return this.assetOperationStartedInterceptors;
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> IndexHandler<E, I> getIndexHandler(Class<I> cls) {
        for (IndexHandler<?, ?> handler : this.indexHandlers) {
            if (!handler.getIndexClass().equals(cls)) continue;
            return handler;
        }
        throw new IllegalArgumentException("no handler registered for index " + cls.getName());
    }

    public void registerDictionaryOperationCompletedInterceptor(DictionaryStorageOperationCompletedInterceptor interceptor) {
        this.dictionaryOperationCompletedInterceptors.add(interceptor);
        Collections.sort(this.dictionaryOperationCompletedInterceptors, INTERCEPTORS_COMPARATOR);
        this.log.debug("registered dictionary operation completed interceptor - " + interceptor);
    }

    public void registerDictionaryOperationStartedInterceptor(DictionaryStorageOperationStartedInterceptor interceptor) {
        this.dictionaryOperationStartedInterceptors.add(interceptor);
        Collections.sort(this.dictionaryOperationStartedInterceptors, INTERCEPTORS_COMPARATOR);
        this.log.debug("registered dictionary operation started interceptor - " + interceptor);
    }

    public List<DictionaryStorageOperationCompletedInterceptor> getDictionaryOperationCompletedInterceptors() {
        return this.dictionaryOperationCompletedInterceptors;
    }

    public List<DictionaryStorageOperationStartedInterceptor> getDictionaryOperationStartedInterceptors() {
        return this.dictionaryOperationStartedInterceptors;
    }

    public void registerDbInterceptor(DbInterceptor interceptor) {
        this.storageInterceptors.add(interceptor);
        Collections.sort(this.storageInterceptors, new Comparator<DbInterceptor>(){

            @Override
            public int compare(DbInterceptor o1, DbInterceptor o2) {
                return Double.compare(o1.getPriority(), o2.getPriority());
            }
        });
        this.log.debug("registered storage completed interceptor - " + interceptor);
    }

    public Collection<DbInterceptor> getDbInterceptors() {
        return this.storageInterceptors;
    }

    public void dispose() {
        for (PhysicalStorage storage : this.storages.values()) {
            storage.dispose();
        }
    }

    private static class Holder {
        public static final LogicalStorageRegistry INSTANCE = (LogicalStorageRegistry)Environment.getPublished(LogicalStorageRegistry.class);

        private Holder() {
        }
    }
}

