/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.common;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gen.model.ModelCodeGenHelper;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.search.FilterQuery;
import com.gridnine.xtrip.common.search.PredefinedKeyWords;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriteria;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.usage.IndexUsageHandler;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.common.ArrayRestrictions;
import com.gridnine.xtrip.server.db.storage.common.CompatibleRestrictions;
import com.gridnine.xtrip.server.db.storage.common.ExRestrictions;
import com.gridnine.xtrip.server.db.storage.common.FreeTextSearchRestrictionProvider;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.OrderBySqlFormula;
import com.gridnine.xtrip.server.restriction.helper.RestrictionsHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.AliasedProjection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.PropertyProjection;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.LoggerFactory;

public final class SearchQueryHelper {
    public static final String CONTAINER_UID = "containerUid";
    private static final FreeTextSearchRestrictionProvider restrictionProvider;
    private static final Map<Type, Collection<String>> MUST_HAVE;

    public static <T> SearchResult<T> execute(Session session, Class<T> dataCls, Class<?> indexCls, SearchQuery searchQuery, boolean useArray) throws Exception {
        SearchQuery query = searchQuery;
        if (query.getCriteria().getRestrictions().size() > 0) {
            query = (SearchQuery)XCloneHelper.clone((XCloneable)query);
            query.getCriteria().getCriterions().addAll(RestrictionsHelper.getCriterions(query.getCriteria().getRestrictions(), UserData.get().getCurrentUser(), Collections.emptyList()));
        }
        SearchResult result = new SearchResult();
        result.setTimestamp(new Date());
        ResultMode resultMode = query.getResultMode();
        if (ResultMode.COUNT_ONLY == resultMode) {
            result.setTotalCount(SearchQueryHelper.getCount(session, dataCls, indexCls, query, useArray));
        } else {
            result.getData().addAll(SearchQueryHelper.buildCriteria(session, dataCls, query, false, indexCls, useArray).list());
            if (ResultMode.DATA_AND_COUNT == resultMode || null == resultMode) {
                if (query.getOffset() > 0) {
                    result.setTotalCount(SearchQueryHelper.getCount(session, dataCls, indexCls, query, useArray));
                } else if (query.getLimit() <= 0) {
                    result.setTotalCount(result.getData().size());
                } else if (result.getData().size() < query.getLimit()) {
                    result.setTotalCount(result.getData().size());
                } else {
                    result.setTotalCount(SearchQueryHelper.getCount(session, dataCls, indexCls, query, useArray));
                }
            } else if (query.getOffset() == 0 && query.getLimit() <= 0) {
                result.setTotalCount(result.getData().size());
            } else {
                result.setTotalCount(-1);
            }
            if (query.getLimit() > 0 && result.getData().size() > query.getLimit()) {
                result.getData().remove(result.getData().size() - 1);
            }
            for (FilterQuery filter : query.getFilters()) {
                if (!SearchQueryHelper.isAppropriateForFilterring(filter.getProperty(), indexCls.getName())) continue;
                SearchQueryHelper.updateFilter(session, dataCls, indexCls, query, result, filter, useArray);
            }
        }
        return result;
    }

    private static boolean isAppropriateForFilterring(String property, String className) {
        if (!Environment.isPublished(MetaRegistry.class)) {
            return true;
        }
        IndexType it = (IndexType)MetaRegistry.get().getIndexes().get(className);
        if (it == null) {
            return true;
        }
        IndexProperty ip = (IndexProperty)it.getProperties().get(property);
        if (ip != null) {
            return ip.isFilterable();
        }
        IndexCollection ic = (IndexCollection)it.getCollections().get(property);
        if (ic != null) {
            return ic.isFilterable();
        }
        return true;
    }

    public static List<?> execute(Session session, Class<?> dataCls, Class<?> indexCls, ProjectionQuery projectionQuery, boolean useArray) throws Exception {
        ProjectionQuery query = projectionQuery;
        if (!query.getCriteria().getRestrictions().isEmpty()) {
            query = (ProjectionQuery)XCloneHelper.clone((XCloneable)query);
            query.getCriteria().getCriterions().addAll(RestrictionsHelper.getCriterions(query.getCriteria().getRestrictions(), UserData.get().getCurrentUser(), Collections.emptyList()));
        }
        Criteria criteria = session.createCriteria(dataCls);
        SearchQueryHelper.buildCriteria(query.getCriteria(), criteria, SearchQueryHelper.buildFreeTextPatternCriterion((StorageQuery)projectionQuery), true, indexCls, useArray);
        criteria.setProjection(SearchQueryHelper.buildProjections(query.getProjections()));
        return criteria.list();
    }

    private static int getCount(Session ss, Class<?> dataCls, Class<?> indexCls, SearchQuery query, boolean useArray) {
        return (Integer)SearchQueryHelper.buildCriteria(ss, dataCls, query, true, indexCls, useArray).uniqueResult();
    }

    private static <T> void updateFilter(Session ss, Class<T> dataCls, Class<?> indexCls, SearchQuery query, SearchResult<T> result, FilterQuery filter, boolean useArray) throws Exception {
        boolean entityReference = SearchQueryHelper.isEntityReference(indexCls, filter.getProperty());
        boolean nestedEntityReference = SearchQueryHelper.isNestedEntityReference(indexCls, filter.getProperty());
        Criteria criteria = SearchQueryHelper.buildFilterCriteria(ss, dataCls, indexCls, entityReference || nestedEntityReference, query, filter, useArray);
        HashSet<Object> hcoll = new HashSet<Object>();
        ArrayList objects = new ArrayList(criteria.list());
        if (nestedEntityReference) {
            Class cls = null;
            Class nestedCls = null;
            for (Object obj : objects) {
                String[] uids;
                NestedEntityReference ref;
                Object[] arr = (Object[])obj;
                if (arr[0] == null) continue;
                if (cls == null) {
                    String[] types = arr[1].toString().split("[|]{2}");
                    cls = XHelper.getClass((String)types[1]);
                    nestedCls = XHelper.getClass((String)types[0]);
                }
                if (hcoll.contains(ref = new NestedEntityReference(new EntityReference((uids = arr[0].toString().split("[|]{2}"))[1], cls, null), uids[0], nestedCls, arr[2] != null ? arr[2].toString() : null)) || !hcoll.add(ref)) continue;
                EntityStorage.get().actualize(ref, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(false));
            }
        } else if (entityReference) {
            Class type = null;
            for (Object object : objects) {
                EntityReference reference;
                Object[] array = (Object[])object;
                if (array[0] == null) continue;
                if (type == null) {
                    IndexProperty indexProperty;
                    String className = array[1].toString();
                    IndexType indexType = (IndexType)MetaRegistry.get().getIndexes().get(indexCls.getName());
                    if (indexType != null && (indexProperty = (IndexProperty)indexType.getProperties().get(filter.getProperty())) != null) {
                        for (String renamerClassName : ModelCodeGenHelper.getEntityRenamersClassNames((MetaRegistry)MetaRegistry.get(), (String)indexProperty.getType())) {
                            className = MetaRegistry.get().findEntityRenamer(renamerClassName).renameIndexClassNameField(className);
                        }
                    }
                    type = XHelper.getClass((String)className);
                }
                if (!hcoll.add(reference = new EntityReference(array[0].toString(), type, array[2] != null ? array[2].toString() : null))) continue;
                EntityStorage.get().actualize(reference, new EntityStorageActualizeParameters().useRemoteCallIfNecessary(false));
            }
        } else {
            Class<?> dictionaryClass = SearchQueryHelper.getDictionaryClass(indexCls, filter.getProperty());
            Class<?> enumClass = SearchQueryHelper.getEnumClass(indexCls, filter.getProperty());
            if (SearchQueryHelper.isCollection(indexCls, filter.getProperty())) {
                ArrayList<Object> lst2 = new ArrayList<Object>();
                if (enumClass != null) {
                    for (Object item : objects) {
                        if (item == null) continue;
                        if (item instanceof String[]) {
                            Function<String, Object> s2e = c -> Enum.valueOf(enumClass, c);
                            lst2.addAll(Arrays.stream((String[])item).map(s2e).collect(Collectors.toSet()));
                            continue;
                        }
                        for (String code : ((String)item).split("\\|")) {
                            Object enumItem;
                            if (TextUtil.isBlank((String)code) || lst2.contains(enumItem = Enum.valueOf(enumClass, code))) continue;
                            lst2.add(enumItem);
                        }
                    }
                } else {
                    for (Object item : objects) {
                        if (item == null) continue;
                        if (item instanceof String[]) {
                            lst2.addAll(Arrays.stream((String[])item).filter(TextUtil::nonBlank).collect(Collectors.toSet()));
                            continue;
                        }
                        for (String code : ((String)item).split("\\|")) {
                            if (TextUtil.isBlank((String)code) || lst2.contains(code)) continue;
                            lst2.add(code);
                        }
                    }
                }
                objects = lst2;
            }
            if (dictionaryClass != null) {
                for (Object obj : objects) {
                    if (obj == null) continue;
                    hcoll.add(dictionaryClass.getConstructor(String.class).newInstance(obj));
                }
            } else {
                for (Object obj : objects) {
                    Object item;
                    if (obj == null) continue;
                    item = obj;
                    if (obj instanceof Date) {
                        item = MiscUtil.cloneDate((Date)((Date)obj));
                    }
                    hcoll.add(item);
                }
            }
        }
        List list = result.getFilter(filter.getProperty());
        list.addAll(hcoll);
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if ((o1 == null || o1 instanceof Date) && (o2 == null || o2 instanceof Date)) {
                    return -MiscUtil.compare((Date)((Date)o1), (Date)((Date)o2));
                }
                String str1 = o1 == null ? null : o1.toString();
                String str2 = o2 == null ? null : o2.toString();
                return TextUtil.compare((String)str1, (String)str2, (boolean)false, (boolean)true);
            }
        });
    }

    public static boolean isCollection(Class<?> indexCls, String property) {
        if (indexCls == null) {
            return false;
        }
        MetaRegistry metaRegistry = MetaRegistry.get();
        IndexType idxType = (IndexType)metaRegistry.getIndexes().get(indexCls.getName());
        if (idxType == null) {
            return false;
        }
        return idxType.getCollections().containsKey(property);
    }

    private static <T> Criteria buildFilterCriteria(Session ss, Class<T> dataCls, Class<?> indexCls, boolean entityReference, SearchQuery query, FilterQuery filter, boolean useArray) {
        Criteria result = ss.createCriteria(dataCls);
        SearchQueryHelper.buildCriteria(query.getCriteria(), result, SearchQueryHelper.buildFilterCriterion(query, filter, true, indexCls, useArray), false, indexCls, useArray);
        ProjectionList projectionList = Projections.projectionList();
        PropertyProjection projection = Projections.groupProperty((String)filter.getProperty());
        if (entityReference) {
            projectionList.add((org.hibernate.criterion.Projection)projection);
            projectionList.add((org.hibernate.criterion.Projection)Projections.groupProperty((String)(filter.getProperty() + "EntityClassName")));
            projectionList.add((org.hibernate.criterion.Projection)Projections.groupProperty((String)(filter.getProperty() + "ReferenceCaption")));
            projection = projectionList;
        }
        result.setProjection((org.hibernate.criterion.Projection)projection);
        if (filter.getSortOrder() != null) {
            switch (filter.getSortOrder()) {
                case ASC: {
                    result.addOrder(Order.asc((String)(entityReference ? filter.getProperty() + "ReferenceCaption" : filter.getProperty())));
                    break;
                }
                case DESC: {
                    result.addOrder(Order.desc((String)(entityReference ? filter.getProperty() + "ReferenceCaption" : filter.getProperty())));
                }
            }
        }
        return result;
    }

    public static Class<?> getDictionaryClass(Class<?> indexCls, String propertyName) {
        if (indexCls == null) {
            return null;
        }
        MetaRegistry metaRegistry = MetaRegistry.get();
        IndexType idxType = (IndexType)metaRegistry.getIndexes().get(indexCls.getName());
        if (idxType == null) {
            return null;
        }
        IndexProperty idxProp = (IndexProperty)idxType.getProperties().get(propertyName);
        if (idxProp != null) {
            try {
                return metaRegistry.getDictionaries().containsKey(idxProp.getType()) ? XHelper.getClass((String)(idxProp.getType() + "Reference")) : null;
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(SearchQueryHelper.class).error("unable to initialize class " + idxProp.getType(), (Throwable)e);
                return null;
            }
        }
        IndexCollection indexCollection = (IndexCollection)idxType.getCollections().get(propertyName);
        if (indexCollection != null) {
            try {
                return metaRegistry.getDictionaries().containsKey(indexCollection.getElementType()) ? Class.forName(indexCollection.getElementType() + "Reference") : null;
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(SearchQueryHelper.class).error("unable to initialize class " + indexCollection.getElementType(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static Class<?> getEnumClass(Class<?> indexCls, String propertyName) {
        if (indexCls == null) {
            return null;
        }
        MetaRegistry metaRegistry = MetaRegistry.get();
        IndexType idxType = (IndexType)metaRegistry.getIndexes().get(indexCls.getName());
        if (idxType == null) {
            return null;
        }
        IndexProperty idxProp = (IndexProperty)idxType.getProperties().get(propertyName);
        if (idxProp != null) {
            try {
                return metaRegistry.getEnums().containsKey(idxProp.getType()) || metaRegistry.getEnumRefs().containsKey(idxProp.getType()) ? XHelper.getClass((String)idxProp.getType()) : null;
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(SearchQueryHelper.class).error("unable to initialize class " + idxProp.getType(), (Throwable)e);
                return null;
            }
        }
        IndexCollection indexCollection = (IndexCollection)idxType.getCollections().get(propertyName);
        if (indexCollection != null) {
            try {
                return metaRegistry.getEnums().containsKey(indexCollection.getElementType()) || metaRegistry.getEnumRefs().containsKey(indexCollection.getElementType()) ? Class.forName(indexCollection.getElementType()) : null;
            }
            catch (ClassNotFoundException e) {
                LoggerFactory.getLogger(SearchQueryHelper.class).error("unable to initialize class " + indexCollection.getElementType(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static boolean isEntityReference(Class<?> indexCls, String propertyName) {
        return indexCls != null && MetaRegistryHelper.isEntityReference((String)indexCls.getName(), (String)propertyName);
    }

    public static boolean isNestedEntityReference(Class<?> indexCls, String propertyName) {
        if (indexCls == null) {
            return false;
        }
        MetaRegistry metaRegistry = MetaRegistry.get();
        IndexType idxType = (IndexType)metaRegistry.getIndexes().get(indexCls.getName());
        if (idxType == null) {
            return false;
        }
        IndexProperty idxProp = (IndexProperty)idxType.getProperties().get(propertyName);
        return idxProp != null && SearchQueryHelper.isNestedEntityReference(idxProp.getType());
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> void statSortedAndFiltered(Class<I> cls, StorageQuery query) {
        for (String propId : query.getCriteria().getOrders().keySet()) {
            IndexUsageHandler.get().statSorting(cls.getName(), propId);
        }
        for (SearchCriterion criterion : query.getCriteria().getCriterions()) {
            SearchQueryHelper.statFiltered(cls, criterion);
        }
    }

    private static <E extends BaseEntity, I extends EntityIndex<E>> void statFiltered(Class<I> cls, SearchCriterion criterion) {
        if (criterion instanceof SearchCriterion.SimpleCriterion) {
            SearchCriterion.SimpleCriterion sc = (SearchCriterion.SimpleCriterion)criterion;
            IndexUsageHandler.get().statFiltering(cls.getName(), sc.getProperty());
            return;
        }
        if (criterion instanceof SearchCriterion.BetweenCriterion) {
            SearchCriterion.BetweenCriterion sc = (SearchCriterion.BetweenCriterion)criterion;
            IndexUsageHandler.get().statFiltering(cls.getName(), sc.getProperty());
            return;
        }
        if (criterion instanceof SearchCriterion.NotCriterion) {
            SearchCriterion.NotCriterion sc = (SearchCriterion.NotCriterion)criterion;
            SearchQueryHelper.statFiltered(cls, sc.getCriterion());
            return;
        }
        if (criterion instanceof SearchCriterion.JunctionCriterion) {
            SearchCriterion.JunctionCriterion sc = (SearchCriterion.JunctionCriterion)criterion;
            for (SearchCriterion crit : sc.getCriterions()) {
                SearchQueryHelper.statFiltered(cls, crit);
            }
            return;
        }
        if (criterion instanceof SearchCriterion.CheckCriterion) {
            SearchCriterion.CheckCriterion sc = (SearchCriterion.CheckCriterion)criterion;
            IndexUsageHandler.get().statFiltering(cls.getName(), sc.getProperty());
            return;
        }
    }

    private static Type getType(Class<?> dataCls) {
        return BaseIndexData.class.isAssignableFrom(dataCls) ? Type.INDEX : (BaseAssetData.class.isAssignableFrom(dataCls) ? Type.ASSET : Type.OTHER);
    }

    private static boolean isNestedEntityReference(String type) {
        return type.contains("||");
    }

    private static <T> Criteria buildCriteria(Session ss, Class<T> dataCls, SearchQuery query, boolean forCounting, Class<?> indexCls, boolean useArray) {
        Criteria result = ss.createCriteria(dataCls);
        SearchQueryHelper.buildCriteria(query.getCriteria(), result, SearchQueryHelper.buildFilterCriterion(query, null, false, indexCls, useArray), !forCounting, indexCls, useArray);
        if (!forCounting) {
            MetaRegistry metaRegistry;
            IndexType indexType;
            if (query.getOffset() > 0) {
                result.setFirstResult(query.getOffset());
            }
            if (query.getLimit() > 0) {
                result.setMaxResults(query.getLimit() + 1);
            }
            Type type = SearchQueryHelper.getType(dataCls);
            HashSet prefProps = query.getPreferredProperties();
            if (prefProps.size() == 0 && Type.INDEX == type && (indexType = (IndexType)(metaRegistry = MetaRegistry.get()).getIndexes().get(indexCls.getName())) != null) {
                prefProps = new HashSet();
                prefProps.addAll(indexType.getProperties().keySet());
                prefProps.addAll(indexType.getCollections().keySet());
            }
            if (prefProps.size() != 0) {
                Set props = prefProps.stream().map(property -> SearchQueryHelper.toExtendedProperty(indexCls, type, property)).collect(Collectors.toSet());
                Collection<String> mustHave = MUST_HAVE.get((Object)type);
                if (mustHave != null) {
                    props.addAll(mustHave.stream().map(property -> SearchQueryHelper.toExtendedProperty(indexCls, type, property)).collect(Collectors.toSet()));
                }
                switch (type) {
                    case INDEX: {
                        MetaRegistry metaRegistry2 = MetaRegistry.get();
                        IndexType indexType2 = (IndexType)metaRegistry2.getIndexes().get(indexCls.getName());
                        if (indexType2 == null) break;
                        for (String property2 : prefProps) {
                            IndexProperty indexProperty = (IndexProperty)indexType2.getProperties().get(property2);
                            if (indexProperty != null && (metaRegistry2.getEntities().containsKey(indexProperty.getType()) || metaRegistry2.getEntityRefs().containsKey(indexProperty.getType()) || SearchQueryHelper.isNestedEntityReference(indexProperty.getType()))) {
                                props.add(new ExtendedProperty(property2 + "EntityClassName", null));
                                props.add(new ExtendedProperty(property2 + "ReferenceCaption", null));
                                continue;
                            }
                            IndexCollection indexCollection = (IndexCollection)indexType2.getCollections().get(property2);
                            if (indexCollection == null || !metaRegistry2.getEntities().containsKey(indexCollection.getElementType()) && !metaRegistry2.getEntityRefs().containsKey(indexCollection.getElementType()) && !SearchQueryHelper.isNestedEntityReference(indexCollection.getElementType())) continue;
                            props.add(new ExtendedProperty(property2 + "EntityClassName", null));
                            props.add(new ExtendedProperty(property2 + "ReferenceCaption", null));
                        }
                        break;
                    }
                }
                ProjectionList projectionList = Projections.projectionList();
                for (ExtendedProperty property3 : props) {
                    if (TextUtil.isBlank((String)property3.getProjection())) {
                        projectionList.add((org.hibernate.criterion.Projection)new AliasedProjection((org.hibernate.criterion.Projection)Projections.property((String)property3.getProperty()), property3.getProperty()){
                            private static final long serialVersionUID = -2074344692016692586L;

                            public String[] getColumnAliases(String alias, int loc) {
                                return null;
                            }
                        });
                        continue;
                    }
                    projectionList.add(Projections.sqlProjection((String)String.format("%s AS %s", property3.getProjection(), property3.getProperty()), (String[])new String[]{property3.getProperty()}, (org.hibernate.type.Type[])new org.hibernate.type.Type[]{ss.getSessionFactory().getClassMetadata(dataCls).getPropertyType(property3.getProperty())}));
                }
                result = result.setProjection((org.hibernate.criterion.Projection)projectionList).setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(ss, dataCls));
            }
        } else {
            result.setProjection(Projections.rowCount());
        }
        return result;
    }

    private static Criterion buildFilterCriterion(SearchQuery query, FilterQuery filterToUpdate, boolean ignoreFreeText, Class<?> indexCls, boolean useArray) {
        Criterion ftpc;
        Object result = null;
        for (FilterQuery filter : query.getFilters()) {
            Object value = filter.getValue();
            if (value instanceof NestedEntityReference) {
                NestedEntityReference ref = (NestedEntityReference)value;
                value = String.format("%s||%s", ref.getNestedEntityUid(), ref.getUid());
            } else if (value instanceof EntityReference) {
                value = ((EntityReference)value).getUid();
            } else if (value instanceof DictionaryReference) {
                value = ((DictionaryReference)value).getCode();
            }
            if (value == null || filterToUpdate != null && filterToUpdate.equals(filter)) continue;
            Object subCrit = null;
            subCrit = !SearchQueryHelper.isCollection(indexCls, filter.getProperty()) ? Restrictions.eq((String)filter.getProperty(), (Object)value) : (value instanceof Enum ? (useArray ? ArrayRestrictions.contains(filter.getProperty(), new String[]{((Enum)value).name()}) : Restrictions.like((String)filter.getProperty(), (Object)("%|" + ((Enum)value).name() + "|%"))) : (useArray ? ArrayRestrictions.contains(filter.getProperty(), new String[]{value.toString()}) : Restrictions.like((String)filter.getProperty(), (Object)("%|" + value + "|%"))));
            if (result == null) {
                result = subCrit;
                continue;
            }
            result = Restrictions.and((Criterion)result, (Criterion)subCrit);
        }
        if (!ignoreFreeText && (ftpc = SearchQueryHelper.buildFreeTextPatternCriterion((StorageQuery)query)) != null) {
            result = result == null ? ftpc : Restrictions.and((Criterion)result, (Criterion)ftpc);
        }
        return result;
    }

    private static Criterion buildFreeTextPatternCriterion(StorageQuery query) {
        Object result = null;
        if (!TextUtil.isBlank((String)query.getCriteria().getFreeTextPattern())) {
            HashSet<String> words = new HashSet<String>();
            for (String str : query.getCriteria().getFreeTextPattern().split(" ")) {
                if (TextUtil.isBlank((String)str)) continue;
                str = str.trim();
                if (restrictionProvider != null && restrictionProvider.isRestrictedFreeTextSearch() && str.length() < 3 || words.contains(str)) continue;
                words.add(str);
                String pattern = SearchQueryHelper.prepareSqlLikePattern(str);
                result = result == null ? Restrictions.like((String)"aggregatedData", (Object)pattern.toLowerCase()) : Restrictions.and((Criterion)result, (Criterion)Restrictions.like((String)"aggregatedData", (Object)pattern.toLowerCase()));
                if (words.size() > 4) break;
            }
        }
        return result;
    }

    private static void buildCriteria(SearchCriteria sc, Criteria criteria, Criterion filter, boolean applySorting, Class<?> indexCls, boolean useArray) {
        if (!sc.getCriterions().isEmpty()) {
            if (filter != null) {
                Criterion crt = filter;
                for (SearchCriterion criterion : sc.getCriterions()) {
                    crt = Restrictions.and((Criterion)crt, (Criterion)SearchQueryHelper.buildCriterion(criterion, indexCls, useArray));
                }
                criteria.add(crt);
            } else {
                for (SearchCriterion searchCriterion : sc.getCriterions()) {
                    criteria.add(SearchQueryHelper.buildCriterion(searchCriterion, indexCls, useArray));
                }
            }
        } else if (filter != null) {
            criteria.add(filter);
        }
        if (applySorting) {
            for (Map.Entry entry : sc.getOrders().entrySet()) {
                IndexType indexType;
                String prop = SearchQueryHelper.isEntityReference(indexCls, (String)entry.getKey()) || SearchQueryHelper.isNestedEntityReference(indexCls, (String)entry.getKey()) ? (String)entry.getKey() + "ReferenceCaption" : (String)entry.getKey();
                String sqlFormulaForOrderBy = null;
                boolean orderIgnoreCase = false;
                if (sc.getLocales().containsKey(entry.getKey()) && !TextUtil.isBlank((String)((String)sc.getLocales().get(entry.getKey())))) {
                    String localeForOrderBy = (String)sc.getLocales().get(entry.getKey());
                    sqlFormulaForOrderBy = "substring(" + prop + " from '" + localeForOrderBy + "__\\|\\|([0-9A-Za-z\u0410-\u042f\u0430-\u044f -]+)')";
                } else if (indexCls != null && prop != null && (indexType = MetaRegistryHelper.getIndexType((String)indexCls.getName())) != null) {
                    IndexProperty indexProperty = (IndexProperty)indexType.getProperties().get(prop);
                    if (indexProperty != null) {
                        String order = indexProperty.getOrder();
                        if (TextUtil.nonBlank((String)order)) {
                            sqlFormulaForOrderBy = order;
                        }
                        orderIgnoreCase = indexProperty.isOrderIgnoreCase();
                    } else {
                        IndexCollection indexCollection = (IndexCollection)indexType.getCollections().get(prop);
                        if (indexCollection != null) {
                            orderIgnoreCase = indexCollection.isOrderIgnoreCase();
                        }
                    }
                }
                switch ((SortOrder)entry.getValue()) {
                    case ASC: {
                        Order order = !TextUtil.isBlank(sqlFormulaForOrderBy) ? OrderBySqlFormula.sqlFormula(sqlFormulaForOrderBy + " ASC", true) : Order.asc((String)prop);
                        criteria.addOrder(orderIgnoreCase ? order.ignoreCase() : order);
                        break;
                    }
                    case DESC: {
                        Order order = !TextUtil.isBlank(sqlFormulaForOrderBy) ? OrderBySqlFormula.sqlFormula(sqlFormulaForOrderBy + " DESC", false) : Order.desc((String)prop);
                        criteria.addOrder(orderIgnoreCase ? order.ignoreCase() : order);
                        break;
                    }
                }
            }
        }
    }

    public static Criterion buildCriterion(SearchCriterion sc, Class<?> indexCls, boolean useArray) {
        if (sc instanceof SearchCriterion.NotBetweenCriterion) {
            SearchCriterion.NotBetweenCriterion crt = (SearchCriterion.NotBetweenCriterion)sc;
            return Restrictions.not((Criterion)Restrictions.between((String)crt.getProperty(), (Object)crt.getLo(), (Object)crt.getHi()));
        }
        if (sc instanceof SearchCriterion.BetweenCriterion) {
            SearchCriterion.BetweenCriterion crt = (SearchCriterion.BetweenCriterion)sc;
            return Restrictions.between((String)crt.getProperty(), (Object)crt.getLo(), (Object)crt.getHi());
        }
        if (sc instanceof SearchCriterion.CheckCriterion) {
            SearchCriterion.CheckCriterion crt = (SearchCriterion.CheckCriterion)sc;
            switch (crt.getCheck()) {
                case IS_EMPTY: {
                    if (useArray && SearchQueryHelper.isCollection(indexCls, crt.getProperty())) {
                        return Restrictions.disjunction().add(Restrictions.isNull((String)crt.getProperty())).add(ArrayRestrictions.empty(crt.getProperty()));
                    }
                    return Restrictions.disjunction().add((Criterion)Restrictions.eq((String)crt.getProperty(), (Object)"")).add(Restrictions.isNull((String)crt.getProperty()));
                }
                case NOT_EMPTY: {
                    if (useArray && SearchQueryHelper.isCollection(indexCls, crt.getProperty())) {
                        return Restrictions.conjunction().add(ArrayRestrictions.nonEmpty(crt.getProperty())).add(Restrictions.isNotNull((String)crt.getProperty()));
                    }
                    return Restrictions.conjunction().add((Criterion)Restrictions.ne((String)crt.getProperty(), (Object)"")).add(Restrictions.isNotNull((String)crt.getProperty()));
                }
            }
            throw new IllegalStateException("unsupported search criterion check operation " + crt.getCheck());
        }
        if (sc instanceof SearchCriterion.InCriterion) {
            int i;
            SearchCriterion.InCriterion crt = (SearchCriterion.InCriterion)sc;
            Object[] values = crt.getValues();
            String[] values2 = null;
            if (values != null && values.length > 0 && values[0] instanceof EntityReference) {
                values2 = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    values2[i] = ((EntityReference)values[i]).getUid();
                }
            }
            if (values != null && values.length > 0 && values[0] instanceof DictionaryReference) {
                values2 = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    values2[i] = ((DictionaryReference)values[i]).getCode();
                }
            }
            return Restrictions.in((String)crt.getProperty(), (Object[])(values2 == null ? values : values2));
        }
        if (sc instanceof SearchCriterion.NotCriterion) {
            SearchCriterion.NotCriterion crt = (SearchCriterion.NotCriterion)sc;
            return Restrictions.not((Criterion)SearchQueryHelper.buildCriterion(crt.getCriterion(), indexCls, useArray));
        }
        if (sc instanceof SearchCriterion.SimpleCriterion) {
            SearchCriterion.SimpleCriterion crt = (SearchCriterion.SimpleCriterion)sc;
            Object value = crt.getValue();
            boolean isNestedEntityReference = false;
            if (value instanceof NestedEntityReference) {
                NestedEntityReference ref = (NestedEntityReference)value;
                value = SearchQueryHelper.isCollection(indexCls, crt.getProperty()) ? String.format("%s|%s", ref.getNestedEntityUid(), ref.getUid()) : String.format("%s||%s", ref.getNestedEntityUid(), ref.getUid());
                isNestedEntityReference = true;
            } else if (value instanceof EntityReference) {
                value = ((EntityReference)value).getUid();
            } else if (value instanceof DictionaryReference) {
                value = ((DictionaryReference)value).getCode();
            } else if (value instanceof PredefinedKeyWords) {
                return SearchQueryHelper.useKeywordValue((SearchCriterion.SimpleCriterion)sc);
            }
            switch (crt.getOperation()) {
                case EQ: {
                    if (crt.getValue() == null) {
                        return Restrictions.isNull((String)crt.getProperty());
                    }
                    return Restrictions.eq((String)crt.getProperty(), (Object)value);
                }
                case GE: {
                    return Restrictions.ge((String)crt.getProperty(), (Object)value);
                }
                case GT: {
                    return Restrictions.gt((String)crt.getProperty(), (Object)value);
                }
                case ILIKE: {
                    if (useArray && SearchQueryHelper.isCollection(indexCls, crt.getProperty())) {
                        return CompatibleRestrictions.ilike(crt.getProperty(), value);
                    }
                    return Restrictions.ilike((String)crt.getProperty(), (Object)value);
                }
                case QUERY: {
                    if (SearchQueryHelper.isCollection(indexCls, crt.getProperty())) {
                        if (useArray) {
                            return ArrayRestrictions.query(crt.getProperty(), value);
                        }
                        return CompatibleRestrictions.query(crt.getProperty(), value);
                    }
                    return ExRestrictions.query(crt.getProperty(), value);
                }
                case STARTS_WITH: {
                    if (SearchQueryHelper.isCollection(indexCls, crt.getProperty())) {
                        if (useArray) {
                            return ArrayRestrictions.startsWith(crt.getProperty(), value);
                        }
                        return Restrictions.like((String)crt.getProperty(), (Object)("%|" + value + "%|"));
                    }
                    return ExRestrictions.startsWith(crt.getProperty(), value);
                }
                case ISTARTS_WITH: {
                    return ExRestrictions.istartsWith(crt.getProperty(), value);
                }
                case IEQ: {
                    if (crt.getValue() == null) {
                        return Restrictions.isNull((String)crt.getProperty());
                    }
                    return ExRestrictions.ieq(crt.getProperty(), value);
                }
                case LE: {
                    return Restrictions.le((String)crt.getProperty(), (Object)value);
                }
                case LIKE: {
                    return Restrictions.like((String)crt.getProperty(), (Object)value);
                }
                case LT: {
                    return Restrictions.lt((String)crt.getProperty(), (Object)value);
                }
                case NE: {
                    if (crt.getValue() == null) {
                        return Restrictions.isNotNull((String)crt.getProperty());
                    }
                    Disjunction disj = Restrictions.disjunction();
                    disj.add((Criterion)Restrictions.ne((String)crt.getProperty(), (Object)value));
                    disj.add(Restrictions.isNull((String)crt.getProperty()));
                    return disj;
                }
                case CONTAINS: {
                    if (null == value) {
                        value = "";
                    }
                    if (useArray) {
                        return ArrayRestrictions.contains(crt.getProperty(), new String[]{value.toString()});
                    }
                    String str = isNestedEntityReference ? "|" + value + "|" : value.toString();
                    return Restrictions.like((String)crt.getProperty(), (Object)("%|" + str + "|%"));
                }
                case ICONTAINS: {
                    if (null == value) {
                        value = "";
                    }
                    if (useArray) {
                        return ArrayRestrictions.icontains(crt.getProperty(), new String[]{value.toString()});
                    }
                    String str = isNestedEntityReference ? "|" + value + "|" : value.toString();
                    return Restrictions.ilike((String)crt.getProperty(), (Object)("%|" + str + "|%"));
                }
                case BEGINS: {
                    if (null == value) {
                        value = "";
                    }
                    if (useArray) {
                        return ArrayRestrictions.ifirst(crt.getProperty(), value.toString());
                    }
                    String str = isNestedEntityReference ? "|" + value + "|" : value.toString();
                    return Restrictions.ilike((String)crt.getProperty(), (Object)("|" + str + "|%"));
                }
                case ENDS: {
                    if (null == value) {
                        value = "";
                    }
                    if (useArray) {
                        return ArrayRestrictions.ilast(crt.getProperty(), value.toString());
                    }
                    String str = isNestedEntityReference ? "|" + value + "|" : value.toString();
                    return Restrictions.ilike((String)crt.getProperty(), (Object)("%|" + str + "|"));
                }
                case CONTAINS_ONLY: {
                    if (null == value) {
                        value = "";
                    }
                    if (useArray) {
                        return ArrayRestrictions.eq(crt.getProperty(), new String[]{value.toString()});
                    }
                    String str = isNestedEntityReference ? "|" + value + "|" : value.toString();
                    return Restrictions.ilike((String)crt.getProperty(), (Object)("|" + str + "|"));
                }
            }
            throw new IllegalStateException("unsupported search criterion operation " + crt.getOperation());
        }
        if (sc instanceof SearchCriterion.JunctionCriterion) {
            SearchCriterion.JunctionCriterion crt = (SearchCriterion.JunctionCriterion)sc;
            Object result = crt.isDisjunction() ? Restrictions.disjunction() : Restrictions.conjunction();
            for (SearchCriterion subSc : crt.getCriterions()) {
                result.add(SearchQueryHelper.buildCriterion(subSc, indexCls, useArray));
            }
            return result;
        }
        throw new IllegalStateException("unsupported search criterion " + sc);
    }

    private static Criterion useKeywordValue(SearchCriterion.SimpleCriterion sc) {
        PredefinedKeyWords keyword = (PredefinedKeyWords)sc.getValue();
        Date lo = null;
        Date hi = null;
        switch (keyword) {
            case TODAY: {
                Date today = new Date();
                lo = MiscUtil.clearTime((Date)today);
                hi = MiscUtil.setDayEndTime((Date)today);
                break;
            }
            case YESTERDAY: {
                GregorianCalendar cal = new GregorianCalendar();
                cal.add(5, -1);
                lo = MiscUtil.clearTime((Date)cal.getTime());
                hi = MiscUtil.setDayEndTime((Date)cal.getTime());
                break;
            }
            case CURRENT_WEEK_BSP: {
                lo = MiscUtil.getStartDecade((int)3);
                hi = MiscUtil.getEndDecade((int)3);
                break;
            }
            case LAST_WEEK_BSP: {
                lo = MiscUtil.getStartDecade((int)4);
                hi = MiscUtil.getEndDecade((int)4);
                break;
            }
            case CURRENT_DECADE: {
                lo = MiscUtil.getStartDecade((int)1);
                hi = MiscUtil.getEndDecade((int)1);
                break;
            }
            case LAST_DECADE: {
                lo = MiscUtil.getStartDecade((int)2);
                hi = MiscUtil.getEndDecade((int)2);
                break;
            }
            case CURRENT_MONTH: {
                DateInterval interval = MiscUtil.getCurrentMonth();
                lo = interval.getBeginDate();
                hi = interval.getEndDate();
                break;
            }
            case LAST_MONTH: {
                DateInterval interval = MiscUtil.getPreviousMonth();
                lo = interval.getBeginDate();
                hi = interval.getEndDate();
                break;
            }
            case LAST_7_DAYS: {
                DateInterval interval = MiscUtil.getLastDays((int)7);
                lo = interval.getBeginDate();
                hi = interval.getEndDate();
                break;
            }
            case LAST_30_DAYS: {
                DateInterval interval = MiscUtil.getLastDays((int)30);
                lo = interval.getBeginDate();
                hi = interval.getEndDate();
                break;
            }
            case LAST_HALF_YEAR: {
                DateInterval interval = MiscUtil.getLastHalfYear();
                lo = interval.getBeginDate();
                hi = interval.getEndDate();
                break;
            }
            default: {
                throw new IllegalStateException("unsupported keyword search criterion" + keyword);
            }
        }
        if (lo == null || hi == null) {
            throw new IllegalStateException("date interval is not defined");
        }
        switch (sc.getOperation()) {
            case EQ: {
                return Restrictions.between((String)sc.getProperty(), (Object)lo, (Object)hi);
            }
            case GE: {
                return Restrictions.ge((String)sc.getProperty(), (Object)lo);
            }
            case GT: {
                return Restrictions.gt((String)sc.getProperty(), (Object)hi);
            }
            case LE: {
                return Restrictions.le((String)sc.getProperty(), (Object)hi);
            }
            case LT: {
                return Restrictions.lt((String)sc.getProperty(), (Object)lo);
            }
            case NE: {
                Disjunction disj = Restrictions.disjunction();
                disj.add(Restrictions.not((Criterion)Restrictions.between((String)sc.getProperty(), (Object)lo, (Object)hi)));
                disj.add(Restrictions.isNull((String)sc.getProperty()));
                return disj;
            }
        }
        throw new IllegalStateException("unsupported search criterion operation " + sc.getOperation());
    }

    private static org.hibernate.criterion.Projection buildProjections(List<Projection> projections) {
        if (projections.isEmpty()) {
            return null;
        }
        if (projections.size() == 1) {
            return SearchQueryHelper.buildProjection(projections.get(0));
        }
        ProjectionList result = Projections.projectionList();
        for (Projection prj : projections) {
            result.add(SearchQueryHelper.buildProjection(prj));
        }
        return result;
    }

    public static org.hibernate.criterion.Projection buildProjection(Projection projection) {
        if (projection instanceof Projection.RowCountProjection) {
            return Projections.rowCount();
        }
        if (projection instanceof Projection.SimpleProjection) {
            Projection.SimpleProjection prj = (Projection.SimpleProjection)projection;
            String prop = prj.getProperty();
            switch (prj.getOperation()) {
                case AVG: {
                    return Projections.avg((String)prop);
                }
                case COUNT: {
                    return Projections.count((String)prop);
                }
                case MAX: {
                    return Projections.max((String)prop);
                }
                case MIN: {
                    return Projections.min((String)prop);
                }
                case SUM: {
                    return Projections.sum((String)prop);
                }
                case PROPERTY: {
                    return Projections.property((String)prop);
                }
                case GROUP: {
                    return Projections.groupProperty((String)prop);
                }
            }
            throw new IllegalStateException("unsupported projection operation " + prj.getOperation());
        }
        throw new IllegalStateException("unsupported projection " + projection);
    }

    private static String prepareSqlLikePattern(String str) {
        return "%" + str.replaceAll("\\*", "%").replaceAll("\\?", "_") + "%";
    }

    private SearchQueryHelper() {
    }

    private static ExtendedProperty toExtendedProperty(Class<?> indexCls, Type type, String property) {
        MetaRegistry metaRegistry;
        IndexType indexType;
        if (type == Type.INDEX && (indexType = (IndexType)(metaRegistry = MetaRegistry.get()).getIndexes().get(indexCls.getName())) != null) {
            IndexProperty indexProperty = (IndexProperty)indexType.getProperties().get(property);
            if (indexProperty != null) {
                return new ExtendedProperty(property, indexProperty.getProjection());
            }
            IndexCollection indexCollection = (IndexCollection)indexType.getCollections().get(property);
            if (indexCollection != null) {
                return new ExtendedProperty(property, indexCollection.getProjection());
            }
        }
        return new ExtendedProperty(property, null);
    }

    static {
        String className = System.getProperty("free-text-search-restriction-provider.className");
        restrictionProvider = !TextUtil.isBlank((String)className) ? (FreeTextSearchRestrictionProvider)XHelper.getInstance((String)className, (Object[])new Object[0]) : null;
        MUST_HAVE = new HashMap<Type, Collection<String>>();
        MUST_HAVE.put(Type.OTHER, Arrays.asList("uid"));
        MUST_HAVE.put(Type.ASSET, Arrays.asList("uid", "modified"));
        MUST_HAVE.put(Type.INDEX, Arrays.asList("uid", "entityType", CONTAINER_UID, "referenceCaption", "navigationKey", "modified"));
    }

    private static class ExtendedProperty {
        private final String property;
        private final String projection;

        public ExtendedProperty(String property, String projection) {
            this.property = property;
            this.projection = projection;
        }

        public String getProperty() {
            return this.property;
        }

        public String getProjection() {
            return this.projection;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExtendedProperty)) {
                return false;
            }
            ExtendedProperty other = (ExtendedProperty)obj;
            return MiscUtil.equals((Object)this.property, (Object)other.property) && MiscUtil.equals((Object)this.projection, (Object)other.projection);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.projection);
        }
    }

    private static enum Type {
        INDEX,
        ASSET,
        OTHER;

    }

    public static class AliasToBeanResultTransformer
    implements ResultTransformer {
        private static final long serialVersionUID = -3574080869086061762L;
        private final Class<?> resultClass;
        private final Session session;

        public AliasToBeanResultTransformer(Session session, Class<?> resultClass) {
            this.resultClass = resultClass;
            this.session = session;
        }

        public Object transformTuple(Object[] tuple, String[] aliases) {
            Object result;
            ClassMetadata classMetadata = this.session.getSessionFactory().getClassMetadata(this.resultClass);
            EntityMode entityMode = this.session.getEntityMode();
            String idName = classMetadata.getIdentifierPropertyName();
            if (idName != null) {
                Object idValue = null;
                for (int i = 0; i < aliases.length; ++i) {
                    if (!idName.equals(aliases[i])) continue;
                    idValue = tuple[i];
                    break;
                }
                result = classMetadata.instantiate((Serializable)idValue, entityMode);
            } else {
                try {
                    result = this.resultClass.newInstance();
                }
                catch (Exception e) {
                    throw new HibernateException("Could not instantiate " + this.resultClass);
                }
            }
            for (int i = 0; i < aliases.length; ++i) {
                String propertyName = aliases[i];
                if (idName != null && idName.equals(propertyName)) continue;
                classMetadata.setPropertyValue(result, propertyName, tuple[i], entityMode);
            }
            return result;
        }

        public List transformList(List collection) {
            return collection;
        }

        public int hashCode() {
            return this.resultClass.hashCode();
        }
    }
}

