/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.common;

import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.DbInterceptor;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.common.PhysicalStorageCache;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionsHelper {
    private static final Logger log = LoggerFactory.getLogger(SessionsHelper.class);
    private final Logger updateLog = LoggerFactory.getLogger((String)(this.getClass().getName() + ".UPDATE"));
    private static final ThreadLocal<SessionData> sessions = new ThreadLocal();
    final PhysicalStorage ps;
    int commitTryCount;

    public SessionsHelper(PhysicalStorage storage) {
        this.ps = storage;
        String valueStr = System.getProperty("midoffice.commitTryCount", "3");
        try {
            this.commitTryCount = Integer.parseInt(valueStr);
        }
        catch (Exception e) {
            this.commitTryCount = 1;
        }
    }

    public LogicalSession beginUnitOfWork() throws StorageException {
        return this.beginUnitOfWork(Collections.emptyMap());
    }

    public LogicalSession beginUnitOfWork(Map<String, Object> context) throws StorageException {
        PhysicalStorageSession ss;
        log.debug("beginning unit of work");
        SessionData sessionData = sessions.get();
        if (sessionData != null) {
            LogicalSession result = new LogicalSession(sessionData.session.getSession(), false);
            log.debug(String.format("session reused: %s, original session: %s ", result, sessionData.session));
            return result;
        }
        try {
            ss = this.ps.createSession(context);
        }
        catch (Throwable e1) {
            log.error("unable to create session", e1);
            throw new StorageException("unable to create session", e1);
        }
        try {
            ss.begin();
            for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
                item.afterBeginUnitOfWork();
            }
        }
        catch (Throwable e) {
            if (ss.isOpen()) {
                try {
                    ss.close();
                }
                catch (Throwable e1) {
                    log.error("unable to close session", e);
                }
            }
            throw new StorageException("unable to begin transaction", e);
        }
        LogicalSession result = new LogicalSession(ss, true);
        result.setAlive(true);
        sessions.set(new SessionData(result));
        log.debug("own session created: " + result);
        return result;
    }

    public void registerOperation(LogicalStorageOperation operation) throws StorageException {
        SessionData data = sessions.get();
        if (data == null) {
            throw new IllegalStateException("session is not created");
        }
        try {
            log.debug("executing operation " + operation);
            operation.execute(this.ps, SessionsHelper.sessions.get().session.getSession());
        }
        catch (Throwable e) {
            log.error("unable to execute operation " + operation, e);
            throw new StorageException("unable to execute operation " + operation, e);
        }
        data.operations.add(operation);
    }

    public void endUnitOfWork(LogicalSession session, boolean close) throws StorageException {
        log.debug("ending unit of work: " + session);
        if (!session.isOwn()) {
            log.debug("session is not own");
            return;
        }
        if (!session.isAlive()) {
            this.unlockSessionLocks();
            log.error(String.format("session %s is inactive", session));
            throw new IllegalStateException(String.format("session %s is inactive", session));
        }
        for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
            item.beforeCommit();
        }
        SessionData sessionData = sessions.get();
        PhysicalStorageSession ss = session.getSession();
        try {
            this.commit(ss);
            this.markOperationsCommited();
            for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
                item.commitSucceded();
            }
            this.unlockSessionLocks();
        }
        catch (Throwable e) {
            this.updateLog.error("unable to perform commit for session " + session, e);
            log.error("unable to perform commit for session " + session, e);
            try {
                ss.rollback();
                this.commitFailedOperations();
                boolean hasCommitted = false;
                for (LogicalStorageOperation item : SessionsHelper.sessions.get().operations) {
                    if (!item.isCommited()) continue;
                    hasCommitted = true;
                    break;
                }
                if (hasCommitted) {
                    ss = session.getSession();
                    ss.begin();
                    try {
                        this.rollbackOperations();
                        this.markOperationsRolledBack();
                        ss.commit();
                        this.updateLog.debug("rollback completed for session " + session);
                    }
                    catch (Throwable e2) {
                        this.updateLog.error("unable to rollback operations for session " + session, e2);
                        ss.rollback();
                        log.error("unable to rollback operations", e2);
                    }
                }
            }
            catch (Throwable e1) {
                this.updateLog.error("unable to rollback operations for session " + session, e1);
                log.error("unable to rollback operations", e1);
            }
            this.unlockSessionLocks();
            session.setAlive(false);
            sessions.remove();
            if (ss.isOpen()) {
                try {
                    ss.close();
                }
                catch (Throwable e1) {
                    log.error("unable to close session " + session, e1);
                }
            }
            for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
                item.commitFailed();
            }
            throw new StorageException("unable to commit transaction", e);
        }
        if (!close) {
            log.debug("restarting session " + session);
            try {
                this.executeCallbacks(sessionData.callbacks, ss);
                ss.begin();
                log.debug("session restarted");
                for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
                    item.afterBeginUnitOfWork();
                }
                return;
            }
            catch (Throwable e) {
                log.error("unable to restart session " + session, e);
                this.unlockSessionLocks();
                session.setAlive(false);
                sessions.remove();
                if (ss.isOpen()) {
                    try {
                        ss.close();
                    }
                    catch (Throwable e1) {
                        log.error("unable to restart session " + session, e);
                    }
                }
                log.debug("session closed " + session);
                throw new StorageException(e);
            }
        }
        this.executeCallbacks(sessionData.callbacks, ss);
        this.unlockSessionLocks();
        session.setAlive(false);
        sessions.remove();
        if (ss.isOpen()) {
            try {
                ss.close();
                log.debug("session closed " + session);
            }
            catch (Throwable e) {
                log.debug("unable to close session " + session, e);
                throw new StorageException("unable to close session", e);
            }
        }
    }

    private void commit(PhysicalStorageSession ss) throws Throwable {
        if (this.commitTryCount == 1) {
            try {
                ss.commit();
            }
            catch (Throwable t) {
                StringBuilder sb = new StringBuilder();
                sb.append("Operations were not committed:");
                for (LogicalStorageOperation item : SessionsHelper.sessions.get().operations) {
                    sb.append(String.format("\r\n%s", item));
                }
                String message = sb.toString();
                this.updateLog.error(message, t);
                log.error(message);
                throw t;
            }
            return;
        }
        Throwable e = null;
        for (int n = 0; n < this.commitTryCount; ++n) {
            if (n > 0) {
                log.info("trying to recommit, try = " + n);
                this.updateLog.debug("trying to recommit, try = " + n);
                try {
                    ss.rollback();
                    ss.begin();
                    for (LogicalStorageOperation item : SessionsHelper.sessions.get().operations) {
                        item.execute(this.ps, ss);
                    }
                    ss.commit();
                    return;
                }
                catch (Throwable t) {
                    this.updateLog.warn("unable to recommit", t);
                    log.warn("unable to recommit", t);
                    e = t;
                    continue;
                }
            }
            try {
                ss.commit();
                return;
            }
            catch (Throwable t) {
                this.updateLog.warn("unable to perform main commit", t);
                log.warn("unable to perform main commit", t);
                e = t;
            }
        }
        if (e != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Operations were not committed:");
            for (LogicalStorageOperation item : SessionsHelper.sessions.get().operations) {
                sb.append(String.format("\r\n%s", item));
            }
            String message = sb.toString();
            this.updateLog.error(message, e);
            log.error(message);
            throw e;
        }
    }

    private void markOperationsRolledBack() {
        for (LogicalStorageOperation item : SessionsHelper.sessions.get().operations) {
            item.setRolledBack(true);
        }
    }

    private void markOperationsCommited() {
        for (LogicalStorageOperation item : SessionsHelper.sessions.get().operations) {
            item.setCommited(true);
        }
    }

    private void rollbackOperations() throws Throwable {
        ArrayList<LogicalStorageOperation> items = new ArrayList<LogicalStorageOperation>(SessionsHelper.sessions.get().operations);
        for (int n = items.size() - 1; n >= 0; --n) {
            LogicalStorageOperation operation = (LogicalStorageOperation)items.get(n);
            if (!operation.isCommited()) continue;
            if (operation.isRolledBack()) break;
            operation.rollback(this.ps, SessionsHelper.sessions.get().session.getSession());
        }
    }

    private void commitFailedOperations() throws Throwable {
        ArrayList<LogicalStorageOperation> items = new ArrayList<LogicalStorageOperation>(SessionsHelper.sessions.get().operations);
        for (int n = items.size() - 1; n >= 0; --n) {
            LogicalStorageOperation operation = (LogicalStorageOperation)items.get(n);
            operation.commitFailed(this.ps, SessionsHelper.sessions.get().session.getSession());
        }
    }

    private void executeCallbacks(List<Callback> callbacks, PhysicalStorageSession session) {
        if (callbacks.isEmpty()) {
            return;
        }
        log.debug("executing callbacks, current session is " + session);
        ArrayList<Callback> list = new ArrayList<Callback>(callbacks);
        for (Callback callback : list) {
            final SessionData sessionData = sessions.get();
            try {
                session.begin();
                log.debug("session restarted");
                for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
                    item.afterBeginUnitOfWork();
                }
            }
            catch (Exception e) {
                log.error("failed creating unit of work for callback execution " + callback, (Throwable)e);
                sessionData.callbacks.remove(callback);
                continue;
            }
            callback.execute(new SessionCallback(){

                @Override
                public void addCallback(Callback clb, boolean first) {
                    sessionData.callbacks.add(clb);
                }

                @Override
                public void addCallback(Callback clb) {
                    sessionData.callbacks.add(clb);
                }
            });
            log.debug("callback executed " + callback);
            try {
                for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
                    item.beforeCommit();
                }
                session.commit();
                for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
                    item.commitSucceded();
                }
                sessionData.callbacks.remove(callback);
            }
            catch (Exception e) {
                sessionData.callbacks.remove(callback);
                log.error("failed executing and committing callback " + callback, (Throwable)e);
            }
            this.unlockSessionLocks();
        }
        SessionData sessionData = sessions.get();
        if (!sessionData.callbacks.isEmpty()) {
            this.executeCallbacks(sessionData.callbacks, session);
        }
    }

    public void cancelUnitOfWork(LogicalSession ms) {
        log.debug("cancelling unit of work " + ms);
        if (ms == null) {
            return;
        }
        if (!ms.isOwn()) {
            log.debug("session is not own");
            return;
        }
        if (!ms.isAlive()) {
            this.unlockSessionLocks();
            log.debug("session is not active: " + ms);
            return;
        }
        PhysicalStorageSession session = ms.getSession();
        try {
            session.rollback();
            log.debug("session rollbacked");
        }
        catch (Throwable e) {
            this.updateLog.error("failed rolling back transaction", e);
            log.error("failed rolling back transaction", e);
        }
        if (session.isOpen()) {
            try {
                session.close();
                log.debug("session closed " + session);
            }
            catch (Throwable e) {
                log.error("unable to close session " + session, e);
            }
        }
        this.unlockSessionLocks();
        SessionData sessionData = sessions.get();
        sessionData.callbacks.clear();
        sessionData.cache.clear();
        sessions.remove();
        for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
            item.afterCancelUnitOfWork();
        }
    }

    public SessionCallback createSessionCallback() {
        final SessionData sessionData = sessions.get();
        if (sessionData == null) {
            throw new IllegalStateException("session is not started");
        }
        if (!sessionData.session.isAlive()) {
            throw new IllegalStateException("session is not alive");
        }
        return new SessionCallback(){

            @Override
            public void addCallback(Callback callback, boolean first) {
                sessionData.callbacks.addFirst(callback);
            }

            @Override
            public void addCallback(Callback callback) {
                sessionData.callbacks.add(callback);
            }
        };
    }

    public void dispose() {
        SessionData sessionData = sessions.get();
        if (sessionData == null) {
            return;
        }
        if (sessionData.session.getSession().isOpen()) {
            try {
                sessionData.session.getSession().close();
            }
            catch (Throwable e) {
                log.error("unable to close session", e);
            }
        }
    }

    public boolean isSessionOpen() {
        return sessions.get() != null;
    }

    public Map<String, Object> getSessionContext() {
        return SessionsHelper.sessions.get().sessionContext;
    }

    public void addSessionLock(NamedLock lock) {
        if (lock != null) {
            SessionsHelper.sessions.get().locks.add(lock);
        }
    }

    private void unlockSessionLocks() {
        if (sessions.get() == null) {
            return;
        }
        Iterator<NamedLock> lockIterator = SessionsHelper.sessions.get().locks.iterator();
        while (lockIterator.hasNext()) {
            NamedLock lock = lockIterator.next();
            try {
                SessionsHelper.unlock(lock);
            }
            catch (Exception e) {
                log.error("unable to unlock lock", (Throwable)e);
            }
            lockIterator.remove();
        }
    }

    public static void unlock(NamedLock lock) {
        if (lock == null) {
            return;
        }
        try {
            lock.unlock();
        }
        finally {
            try {
                lock.close();
            }
            catch (Exception e) {
                log.error("unable to close lock", (Throwable)e);
            }
        }
    }

    public static NamedLock lock(LogicalSession ls, String key) {
        if (ls != null && !ls.isOwn()) {
            return null;
        }
        return SessionsHelper.lockInternal(key);
    }

    public static NamedLock lock(String key) {
        if (sessions.get() != null && !SessionsHelper.sessions.get().session.isOwn()) {
            return null;
        }
        return SessionsHelper.lockInternal(key);
    }

    private static NamedLock lockInternal(String key) {
        if (TextUtil.isBlank((String)key) || "false".equals(System.getProperty("midoffice.storage.uselock"))) {
            return null;
        }
        NamedLock lock = null;
        try {
            lock = LockUtil.getLockManager().getLock((Object)key, TimeUnit.SECONDS.toMillis(30L));
            lock.lock();
            return lock;
        }
        catch (Exception e) {
            log.error("unable to get lock ", (Throwable)e);
            return lock;
        }
    }

    public static PhysicalStorageCache getCache() {
        return sessions.get() == null ? null : SessionsHelper.sessions.get().cache;
    }

    static class SessionData {
        final LogicalSession session;
        final LinkedList<Callback> callbacks = new LinkedList();
        final ArrayList<LogicalStorageOperation> operations = new ArrayList();
        final PhysicalStorageCache cache = new PhysicalStorageCache();
        final Map<String, Object> sessionContext = new ConcurrentHashMap<String, Object>();
        final List<NamedLock> locks = new ArrayList<NamedLock>();

        SessionData(LogicalSession ls) {
            this.session = ls;
        }
    }
}

