/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.common;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.SearchQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StorageHelper {
    public static <E extends BaseEntity, I extends EntityIndex<E>> List<EntityContainer<E>> getEntityContainers(SearchQuery query, Class<I> cls) {
        EntityStorage entityCache = EntityStorage.get();
        ArrayList<EntityContainer<EntityContainer>> result = new ArrayList<EntityContainer<EntityContainer>>();
        for (EntityIndex index : EntityStorage.get().search(cls, query).getData()) {
            EntityContainer ctr = entityCache.resolve(index.getSource());
            if (ctr == null) continue;
            result.add(ctr);
        }
        return result;
    }

    public static <E extends BaseEntity, I extends EntityIndex<E>> List<EntityReference<E>> getEntityReferences(SearchQuery query, Class<I> cls) {
        ArrayList<EntityReference<EntityReference>> result = new ArrayList<EntityReference<EntityReference>>();
        for (EntityIndex index : EntityStorage.get().search(cls, query).getData()) {
            result.add(index.getSource());
        }
        return result;
    }

    public static <T> T getFirstElement(boolean unique, Collection<T> items) throws Exception {
        if (items.isEmpty()) {
            return null;
        }
        if (unique && items.size() > 1) {
            throw new Exception("more than one entities were found");
        }
        return items.iterator().next();
    }

    private StorageHelper() {
    }
}

