/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.dbproperties;

import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogicalDBPropertiesStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PhysicalStorage ps;

    public LogicalDBPropertiesStorage(PhysicalStorage storage) {
        this.ps = storage;
    }

    public void putValue(String key, String value) {
        try {
            String oldValue = this.ps.getDBPropertiesStorage().getDbProperty(key);
            this.ps.getDBPropertiesStorage().putDbProperty(key, value, oldValue);
        }
        catch (Throwable e) {
            this.log.error("unable to put db properties value", e);
            throw new StorageException("unable to put db properties value", e);
        }
    }

    public String getValue(String key) {
        try {
            return this.ps.getDBPropertiesStorage().getDbProperty(key);
        }
        catch (Throwable e) {
            this.log.error("unable to read db properties value", e);
            throw new StorageException("unable to read db property", e);
        }
    }

    public Map<String, String> getAllKeys() {
        try {
            return this.ps.getDBPropertiesStorage().getAllKeys();
        }
        catch (Throwable e) {
            this.log.error("unable to read db properties values", e);
            throw new StorageException("unable to read db properties", e);
        }
    }
}

