/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.dictionary;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.dictionary.DictionaryOperationsHelper;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.List;

public class DeleteDictionaryOperation<D extends BaseDictionary>
extends LogicalStorageOperation {
    private final PhysicalDictionaryData<D> dictionaryData;
    private final D dictionary;
    private final List<DictionaryStorageOperationCompletedInterceptor> interceptors;
    private final SessionCallback callback;
    private final ValueHolder<Throwable> errorHolder;

    public DeleteDictionaryOperation(PhysicalDictionaryData<D> oldData, D dict, List<DictionaryStorageOperationCompletedInterceptor> intrs, SessionCallback clb, ValueHolder<Throwable> holder) {
        this.dictionaryData = oldData;
        this.interceptors = intrs;
        this.callback = clb;
        this.errorHolder = holder;
        this.dictionary = dict;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        ps.getDictionaryStorage().deleteDictionary(this.dictionaryData, session);
        DictionaryOperationsHelper.addDictionaryCallback(this.callback, this.interceptors, new DictionaryOperationsHelper.DictionaryInterceptorCallback(){

            @Override
            public void execute(DictionaryStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterDelete(DeleteDictionaryOperation.this.callback, DeleteDictionaryOperation.this.dictionary);
            }
        }, this.errorHolder);
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        ps.getDictionaryStorage().saveDictionary(this.dictionaryData, null, session);
        DictionaryOperationsHelper.addDictionaryCallback(this.callback, this.interceptors, new DictionaryOperationsHelper.DictionaryInterceptorCallback(){

            @Override
            public void execute(DictionaryStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterSave(DeleteDictionaryOperation.this.callback, DeleteDictionaryOperation.this.dictionary);
            }
        }, this.errorHolder);
    }
}

