/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.dictionary;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationCompletedInterceptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DictionaryOperationsHelper {
    private static final Logger log = LoggerFactory.getLogger(DictionaryOperationsHelper.class);

    static <E extends BaseEntity> void addDictionaryCallback(SessionCallback callback, final List<DictionaryStorageOperationCompletedInterceptor> operationCompletedInterceptors, final DictionaryInterceptorCallback operation, final ValueHolder<Throwable> errorHolder) {
        if (operationCompletedInterceptors.isEmpty()) {
            return;
        }
        callback.addCallback(new Callback(){
            private static final long serialVersionUID = -6420564602788551302L;

            @Override
            public void execute(SessionCallback ss) {
                for (DictionaryStorageOperationCompletedInterceptor interceptor : operationCompletedInterceptors) {
                    try {
                        operation.execute(interceptor);
                    }
                    catch (Throwable e) {
                        log.error("unable to execute callback", e);
                        errorHolder.setValue((Object)e);
                        return;
                    }
                }
            }
        }, true);
    }

    private DictionaryOperationsHelper() {
    }

    static interface DictionaryInterceptorCallback {
        public void execute(DictionaryStorageOperationCompletedInterceptor var1) throws Throwable;
    }
}

