/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.dictionary;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.model.profiling.ProfilingUtils;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.SessionsHelper;
import com.gridnine.xtrip.server.db.storage.dictionary.UpdateBulkDictionaryOperation;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryDataProvider;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryMetadata;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class LogicalBulkDictionaryStorage {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<Class<?>, DictionaryBatch<?>> cache = new HashMap();
    private final Lock readLock;
    private final Lock writeLock;
    private final BulkDictionaryPhysicalStorage ps;
    private final SessionsHelper sh;

    public LogicalBulkDictionaryStorage(PhysicalStorage physicalStorage, SessionsHelper sessionHelper) {
        this.ps = physicalStorage.getBulkDictionaryStorage();
        this.sh = sessionHelper;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends BaseDictionary> loadAll(Date modifiedSince, Class<? extends BaseDictionary> dictCls, Set<String> ignoredTypes) throws Exception {
        if (this.log.isDebugEnabled()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
            this.log.debug(String.format("loading dictionary: cls = %s, modifiedSince = %s, ignoredTypes = %s", dictCls != null ? dictCls : "null", modifiedSince == null ? null : sdf.format(modifiedSince), ignoredTypes));
        }
        if (dictCls != null && ignoredTypes.contains(dictCls.getName())) {
            this.log.debug(String.format("type %s is in ignored list, returning empty list", dictCls.getName()));
            return Collections.emptyList();
        }
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        long timing = System.currentTimeMillis();
        this.actualizeCache();
        this.readLock.lock();
        try {
            ArrayList result = new ArrayList();
            for (Map.Entry<Class<?>, DictionaryBatch<?>> entry : this.cache.entrySet()) {
                if (ignoredTypes.contains(entry.getKey().getName()) || dictCls != null && !dictCls.equals(entry.getKey()) || modifiedSince != null && modifiedSince.after(entry.getValue().modifiedDate)) continue;
                result.addAll(entry.getValue().dictionaries.values());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("got %s dictionaries", Integer.toString(result.size())));
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
            Metrics.get().timingAndEvent("profiling.storage.dicts.bulkLoad", timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)"bulk-dict-loadAll");
            String key = "storage.bulk-dictionary.loadAll";
            if (Profiler.get().isProfilingEnabled(key)) {
                Profiler.get().updateTiming(key, timing, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualizeCache() throws Exception {
        LogicalSession ls = this.sh.beginUnitOfWork();
        try {
            HashMap actualTimeStamps = new HashMap();
            PhysicalStorageSession session = ls.getSession();
            List<PhysicalBulkDictionaryMetadata<?>> metadata = this.ps.loadMetadata(session);
            for (PhysicalBulkDictionaryMetadata<?> item : metadata) {
                actualTimeStamps.put(item.getDictionaryType(), item.getModified());
            }
            ArrayList toUpdate = new ArrayList();
            this.readLock.lock();
            try {
                for (Map.Entry entry : actualTimeStamps.entrySet()) {
                    if (this.cache.get(entry.getKey()) != null && this.cache.get(entry.getKey()).modifiedDate.equals(entry.getValue())) continue;
                    PhysicalBulkDictionaryData data = this.ps.loadData((Class)entry.getKey(), session);
                    toUpdate.add(data);
                }
            }
            finally {
                this.readLock.unlock();
            }
            if (toUpdate.isEmpty()) {
                return;
            }
            this.writeLock.lock();
            try {
                for (PhysicalBulkDictionaryData physicalBulkDictionaryData : toUpdate) {
                    this.updateCache(physicalBulkDictionaryData);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        finally {
            this.sh.cancelUnitOfWork(ls);
        }
    }

    private <D extends BaseDictionary> void updateCache(PhysicalBulkDictionaryData<D> item) throws Exception {
        Class dictClass = item.getDictionaryType();
        Date modified = item.getModified();
        HashMap<String, BaseDictionary> map = new HashMap<String, BaseDictionary>();
        for (BaseDictionary dict : this.toDictionaryList(item)) {
            dict.setCreated(modified);
            dict.setModified(modified);
            map.put(dict.getCode(), dict);
        }
        this.cache.put(dictClass, new DictionaryBatch(modified, map));
    }

    private <D extends BaseDictionary> List<D> toDictionaryList(PhysicalBulkDictionaryData<D> data) throws Exception {
        byte[] cdata = data.getData();
        if (cdata == null || cdata.length == 0) {
            return Collections.emptyList();
        }
        Class dictClass = data.getDictionaryType();
        ArrayList<BaseDictionary> result = new ArrayList<BaseDictionary>();
        for (Element elm : XmlUtil.getElements((Element)DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(GZIPUtil.gunzip((byte[])cdata)))).getDocumentElement(), (String)"dict")) {
            BaseDictionary item = (BaseDictionary)dictClass.newInstance();
            item.fromXML(elm);
            item.setCreated(item.getModified());
            item.setModified(item.getCreated());
            result.add(item);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <D extends BaseDictionary> D load(Class<D> cls, String code) throws Exception {
        this.actualizeCache();
        this.readLock.lock();
        try {
            DictionaryBatch<?> batch = this.cache.get(cls);
            BaseDictionary baseDictionary = batch == null ? null : (BaseDictionary)batch.dictionaries.get(code);
            return (D)baseDictionary;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> save(D dict, boolean ignoreInterceptors) throws Exception {
        this.log.warn("single item is saved with bulk dictionary data provider");
        this.writeLock.lock();
        try {
            this.actualizeCache();
            Map<String, D> dictionaries = null;
            dictionaries = this.cache.get(dict.getClass()) != null ? this.cache.get(dict.getClass()).dictionaries : new HashMap<String, D>();
            dictionaries.put(dict.getCode(), dict);
            DictionaryDataProvider.DictionaryUpdateResult<Object> dictionaryUpdateResult = this.update(dictionaries.values(), dict.getClass(), ignoreInterceptors);
            return dictionaryUpdateResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> delete(D dict, boolean ignoreInterceptors) throws Exception {
        this.log.warn("single item is deleted with bulk dictionary data provider");
        this.writeLock.lock();
        try {
            this.actualizeCache();
            Map<Object, Object> dictionaries = null;
            dictionaries = this.cache.get(dict.getClass()) != null ? this.cache.get(dict.getClass()).dictionaries : new HashMap();
            dictionaries.remove(dict.getCode());
            DictionaryDataProvider.DictionaryUpdateResult<Object> dictionaryUpdateResult = this.update(dictionaries.values(), dict.getClass(), ignoreInterceptors);
            return dictionaryUpdateResult;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> update(Collection<D> dictionaries, Class<D> cls, boolean ignoreInterceptors) throws Exception {
        this.writeLock.lock();
        try {
            this.cache.remove(cls);
            LogicalSession ls = this.sh.beginUnitOfWork();
            PhysicalStorageSession session = ls.getSession();
            try {
                DictionaryDataProvider.DictionaryUpdateResult result = new DictionaryDataProvider.DictionaryUpdateResult();
                PhysicalBulkDictionaryData oldData = this.ps.loadData(cls, session);
                PhysicalBulkDictionaryData<D> newData = new PhysicalBulkDictionaryData<D>();
                newData.setDictionaryType(cls);
                if (oldData != null) {
                    oldData.copy(newData);
                    result.toEvict.addAll(this.toDictionaryList(oldData));
                }
                newData.setModified(((TimeService)Environment.getPublished(TimeService.class)).currentDate());
                this.fromDictionariesList(dictionaries, newData);
                this.sh.registerOperation(new UpdateBulkDictionaryOperation(newData, oldData));
                this.sh.endUnitOfWork(ls, true);
                result.toPut.addAll(dictionaries);
                DictionaryDataProvider.DictionaryUpdateResult dictionaryUpdateResult = result;
                this.sh.cancelUnitOfWork(ls);
                return dictionaryUpdateResult;
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(ls);
                throw throwable;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private <D extends BaseDictionary> void fromDictionariesList(Collection<D> dictionaries, PhysicalBulkDictionaryData<D> data) throws Exception {
        Document doc = DocumentBuilderHelper.newDocument();
        Element root = doc.createElement("dicts");
        doc.appendChild(root);
        for (BaseDictionary item : dictionaries) {
            item.toXML(XmlUtil.addElement((Element)root, (String)"dict"));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(baos));
        data.setData(GZIPUtil.gzip((byte[])baos.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getResetTypes(Date modifiedSince, Class<? extends BaseDictionary> dictCls, Set<String> ignoredTypes) throws Exception {
        HashSet<String> result = new HashSet<String>();
        this.actualizeCache();
        this.readLock.lock();
        try {
            for (Map.Entry<Class<?>, DictionaryBatch<?>> entry : this.cache.entrySet()) {
                String dictClassName = entry.getKey().getName();
                if (ignoredTypes.contains(entry.getKey().getName()) || dictCls != null && !dictCls.equals(entry.getKey()) || modifiedSince == null || !modifiedSince.before(entry.getValue().modifiedDate)) continue;
                result.add(dictClassName);
            }
            HashSet<String> hashSet = result;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    static final class DictionaryBatch<D extends BaseDictionary> {
        final Date modifiedDate;
        final Map<String, D> dictionaries;

        DictionaryBatch(Date date, Map<String, D> dicts) {
            this.modifiedDate = date;
            this.dictionaries = dicts;
        }
    }
}

