/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.dictionary;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.model.profiling.ProfilingUtils;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.common.SessionsHelper;
import com.gridnine.xtrip.server.db.storage.dictionary.DeleteDictionaryOperation;
import com.gridnine.xtrip.server.db.storage.dictionary.SaveDictionaryOperation;
import com.gridnine.xtrip.server.db.storage.model.DictionaryDataProvider;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationStartedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class LogicalDictionaryStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Logger updateLog = LoggerFactory.getLogger((String)(LogicalDictionaryStorage.class.getName() + ".UPDATE"));
    private final PhysicalStorage ps;
    private final SessionsHelper sh;

    public LogicalDictionaryStorage(PhysicalStorage storage, SessionsHelper sessionHelper) {
        this.ps = storage;
        this.sh = sessionHelper;
    }

    public <D extends BaseDictionary> D load(Class<D> cls, String code) {
        D d;
        PhysicalDictionaryData<D> dictionaryData;
        LogicalSession sd;
        long timing;
        block9: {
            if (DebugUtil.isThreadDebugEnabled()) {
                DebugUtil.logStackTrace();
            }
            timing = System.currentTimeMillis();
            sd = this.sh.beginUnitOfWork();
            dictionaryData = this.ps.getDictionaryStorage().findDictionaryByCode(cls, code, Boolean.FALSE, sd.getSession());
            if (dictionaryData != null) break block9;
            D d2 = null;
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.dicts.load." + MiscUtil.getSimpleClassName(cls), timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("load.%s", MiscUtil.getSimpleClassName(cls)));
            String key = "storage.dictionary.load" + MiscUtil.getSimpleClassName(cls);
            if (Profiler.get().isProfilingEnabled(key)) {
                Profiler.get().updateTiming(key, timing, null);
            }
            return d2;
        }
        try {
            d = this.toDictionary(dictionaryData);
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.dicts.load." + MiscUtil.getSimpleClassName(cls), timing);
        }
        catch (Throwable e) {
            try {
                this.log.error(String.format("unable to load dictionary: cls = %s, code = %s", MiscUtil.getSimpleClassName(cls), code), e);
                throw new StorageException("unable to search", e);
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(sd);
                Metrics.get().timingAndEvent("profiling.storage.dicts.load." + MiscUtil.getSimpleClassName(cls), timing);
                ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("load.%s", MiscUtil.getSimpleClassName(cls)));
                String key = "storage.dictionary.load" + MiscUtil.getSimpleClassName(cls);
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                throw throwable;
            }
        }
        ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("load.%s", MiscUtil.getSimpleClassName(cls)));
        String key = "storage.dictionary.load" + MiscUtil.getSimpleClassName(cls);
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        return d;
    }

    public <D extends BaseDictionary> void save(D dict) {
        this.save(dict, false);
    }

    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> save(D dict, boolean ignoreInterceptors) {
        DictionaryDataProvider.DictionaryUpdateResult dictionaryUpdateResult;
        DictionaryDataProvider.DictionaryUpdateResult result = new DictionaryDataProvider.DictionaryUpdateResult();
        if (dict == null) {
            return result;
        }
        if (updateLog.isDebugEnabled()) {
            updateLog.debug(String.format("saving %s %s, login = %s,  threadName = %s, stacktrace =\n %s", MiscUtil.getSimpleClassName(dict.getClass()), dict.getCode(), UserData.get().getCurrentUser(), Thread.currentThread().getName(), DebugUtil.getStackTrace()));
        }
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        if (TextUtil.isBlank((String)dict.getDataSource())) {
            IncidentsLog.reportStackTrace((String)("no dataSource when saving " + dict.getClass().getName() + " " + dict.toReference().toString()));
        }
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork();
        PhysicalStorageSession session = sd.getSession();
        SessionCallback callback = this.sh.createSessionCallback();
        Class<?> dictClass = dict.getClass();
        try {
            PhysicalDictionaryData<Object> data = this.ps.getDictionaryStorage().findDictionaryByUid(dictClass, dict.getUid(), true, session);
            PhysicalDictionaryData toRestore = null;
            if (data != null) {
                toRestore = new PhysicalDictionaryData();
                data.copy(toRestore);
            }
            for (DictionaryStorageOperationStartedInterceptor interceptor : this.getOperationStartedInterceptor(ignoreInterceptors)) {
                interceptor.beforeSave(callback, dict);
            }
            boolean createNewData = false;
            if (data != null && !data.getCode().equals(dict.getCode())) {
                PhysicalDictionaryData<?> deletedData;
                if (!TextUtil.isBlank((String)dict.getCode()) && (deletedData = this.ps.getDictionaryStorage().findDictionaryByCode(dictClass, dict.getCode(), Boolean.TRUE, session)) != null) {
                    this.sh.registerOperation(new DeleteDictionaryOperation(deletedData, dict, this.getOperationCompletedInterceptor(true), callback, (ValueHolder<Throwable>)new ValueHolder()));
                    this.sh.endUnitOfWork(sd, false);
                }
                data = this.ps.getDictionaryStorage().findDictionaryByUid(dictClass, dict.getUid(), true, session);
                data.setDeleted(true);
                data.setModified(dict.getModified());
                this.sh.registerOperation(new SaveDictionaryOperation<Object>((PhysicalDictionaryData<Object>)data, null, this.toDictionary(data), null, this.getOperationCompletedInterceptor(true), callback, (ValueHolder<Throwable>)new ValueHolder()));
                this.sh.endUnitOfWork(sd, false);
                BaseDictionary toEvict = (BaseDictionary)dictClass.newInstance();
                toEvict.setUid(data.getUid());
                toEvict.setCode(data.getCode());
                toEvict.getTranslations().put(LocaleHelper.EN_LOCALE, data.getCode());
                result.toEvict.add(toEvict);
                dict.setUid(UUIDGenerator.generate((boolean)true).toString());
                createNewData = true;
            }
            boolean currentDataIsActive = false;
            if (!TextUtil.isBlank((String)dict.getCode())) {
                PhysicalDictionaryData<?> deletedData = this.ps.getDictionaryStorage().findDictionaryByCode(dictClass, dict.getCode(), Boolean.TRUE, session);
                if (deletedData != null) {
                    this.sh.registerOperation(new DeleteDictionaryOperation(deletedData, dict, this.getOperationCompletedInterceptor(true), callback, (ValueHolder<Throwable>)new ValueHolder()));
                    this.sh.endUnitOfWork(sd, false);
                    createNewData = true;
                } else {
                    data = this.ps.getDictionaryStorage().findDictionaryByCode(dictClass, dict.getCode(), Boolean.FALSE, session);
                    if (data != null) {
                        currentDataIsActive = true;
                    }
                }
            }
            if (createNewData || data == null) {
                data = new PhysicalDictionaryData();
                data.setUid(dict.getUid());
            }
            if (TextUtil.isBlank((String)dict.getCode())) {
                DictCompositeNumber cn = new DictCompositeNumber();
                do {
                    cn.setNumber(null);
                    SequenceNumberHelper.get().generateInc(cn, dict.getClass().getName(), null);
                } while (this.ps.getDictionaryStorage().findDictionaryByCode(dictClass, TextUtil.buildFullNumber((CompositeNumber)cn), null, session) != null);
                dict.setCode(TextUtil.buildFullNumber((CompositeNumber)cn));
            }
            if (dict.getCreated() == null) {
                dict.setCreated(new Date());
            }
            if (dict.getCreatedBy() == null) {
                dict.setCreatedBy(UserData.get().getCurrentUser());
            }
            dict.setModified(new Date());
            dict.setModifiedBy(UserData.get().getCurrentUser());
            if (currentDataIsActive) {
                this.fromDictionary(dict, data, true);
            } else {
                this.fromDictionary(dict, data, false);
            }
            if (updateLog.isDebugEnabled() && toRestore != null) {
                updateLog.debug(String.format("login = %s, threadName = %s\ndictionary version before saving: \n%s\ndictionary version after saving: \n%s", UserData.get().getCurrentUser(), Thread.currentThread().getName(), new String(toRestore.getData(), StandardCharsets.UTF_8), new String(data.getData(), StandardCharsets.UTF_8)));
            }
            ValueHolder errorHolder = new ValueHolder();
            this.sh.registerOperation(new SaveDictionaryOperation<Object>(data, toRestore, dict, this.toDictionary(toRestore), this.getOperationCompletedInterceptor(ignoreInterceptors), callback, (ValueHolder<Throwable>)errorHolder));
            this.sh.endUnitOfWork(sd, true);
            if (errorHolder.getValue() != null) {
                throw (Throwable)errorHolder.getValue();
            }
            result.toPut.add(dict);
            this.log.debug("save() END dict=" + dict);
            dictionaryUpdateResult = result;
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.dicts.save." + MiscUtil.getSimpleClassName(dict.getClass()), timing);
        }
        catch (Throwable e) {
            try {
                this.log.error(String.format("unable to save dictionary: cls = %s, code = %s", MiscUtil.getSimpleClassName(dict.getClass()), dict.getCode()), e);
                throw new StorageException("unable to search", e);
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(sd);
                Metrics.get().timingAndEvent("profiling.storage.dicts.save." + MiscUtil.getSimpleClassName(dict.getClass()), timing);
                ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("save.%s", MiscUtil.getSimpleClassName(dict.getClass())));
                String key = "storage.dictionary.save" + MiscUtil.getSimpleClassName(dict.getClass());
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                throw throwable;
            }
        }
        ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("save.%s", MiscUtil.getSimpleClassName(dict.getClass())));
        String key = "storage.dictionary.save" + MiscUtil.getSimpleClassName(dict.getClass());
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        return dictionaryUpdateResult;
    }

    public <D extends BaseDictionary> void delete(D dict) throws Exception {
        this.delete(dict, false);
    }

    public <D extends BaseDictionary> DictionaryDataProvider.DictionaryUpdateResult<D> delete(D dict, boolean ignoreInterceptors) throws Exception {
        DictionaryDataProvider.DictionaryUpdateResult dictionaryUpdateResult;
        PhysicalDictionaryData<?> existingDict;
        String code;
        Class<?> dictClass;
        PhysicalStorageSession session;
        SessionCallback callback;
        LogicalSession sd;
        long timing;
        DictionaryDataProvider.DictionaryUpdateResult result;
        block14: {
            result = new DictionaryDataProvider.DictionaryUpdateResult();
            if (dict == null) {
                return result;
            }
            if (updateLog.isDebugEnabled()) {
                updateLog.debug(String.format("deleting %s %s, login = %s,  thread = %s, stacktrace =\n %s", MiscUtil.getSimpleClassName(dict.getClass()), dict.getCode(), UserData.get().getCurrentUser(), Thread.currentThread().getName(), DebugUtil.getStackTrace()));
            }
            if (DebugUtil.isThreadDebugEnabled()) {
                DebugUtil.logStackTrace();
            }
            timing = System.currentTimeMillis();
            sd = this.sh.beginUnitOfWork();
            callback = this.sh.createSessionCallback();
            session = sd.getSession();
            dictClass = dict.getClass();
            code = dict.getCode();
            for (DictionaryStorageOperationStartedInterceptor dictionaryStorageOperationStartedInterceptor : this.getOperationStartedInterceptor(ignoreInterceptors)) {
                dictionaryStorageOperationStartedInterceptor.beforeDelete(callback, dict);
            }
            existingDict = this.ps.getDictionaryStorage().findDictionaryByCode(dictClass, code, Boolean.FALSE, session);
            if (existingDict != null) break block14;
            this.log.warn("no data found for dictionary item " + dict);
            result.toEvict.add(dict);
            DictionaryDataProvider.DictionaryUpdateResult dictionaryUpdateResult2 = result;
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.dicts.delete." + MiscUtil.getSimpleClassName(dict.getClass()), timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("delete.%s", MiscUtil.getSimpleClassName(dict.getClass())));
            String key = "storage.dictionary.delete" + MiscUtil.getSimpleClassName(dict.getClass());
            if (Profiler.get().isProfilingEnabled(key)) {
                Profiler.get().updateTiming(key, timing, null);
            }
            return dictionaryUpdateResult2;
        }
        try {
            PhysicalDictionaryData physicalDictionaryData = new PhysicalDictionaryData();
            existingDict.copy(physicalDictionaryData);
            PhysicalDictionaryData<?> deletedDict = this.ps.getDictionaryStorage().findDictionaryByCode(dictClass, code, Boolean.TRUE, session);
            if (deletedDict != null) {
                this.sh.registerOperation(new DeleteDictionaryOperation(deletedDict, this.toDictionary(deletedDict), this.getOperationCompletedInterceptor(true), callback, (ValueHolder<Throwable>)new ValueHolder()));
                this.sh.endUnitOfWork(sd, false);
                existingDict = this.ps.getDictionaryStorage().findDictionaryByCode(dictClass, code, Boolean.FALSE, session);
            }
            existingDict.setDeleted(true);
            existingDict.setModified(dict.getModified());
            ValueHolder errorHolder = new ValueHolder();
            this.sh.registerOperation(new SaveDictionaryOperation(existingDict, physicalDictionaryData, dict, dict, this.getOperationCompletedInterceptor(ignoreInterceptors), callback, (ValueHolder<Throwable>)errorHolder));
            this.sh.endUnitOfWork(sd, true);
            if (errorHolder.getValue() != null) {
                throw (Throwable)errorHolder.getValue();
            }
            result.toEvict.add(dict);
            this.log.debug("delete() END dict=" + dict);
            dictionaryUpdateResult = result;
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.dicts.delete." + MiscUtil.getSimpleClassName(dict.getClass()), timing);
        }
        catch (Throwable e) {
            try {
                this.log.error(String.format("unable to delete dictionary: cls = %s, code = %s", MiscUtil.getSimpleClassName(dict.getClass()), dict.getCode()), e);
                throw new StorageException("unable to delete dictionary", e);
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(sd);
                Metrics.get().timingAndEvent("profiling.storage.dicts.delete." + MiscUtil.getSimpleClassName(dict.getClass()), timing);
                ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("delete.%s", MiscUtil.getSimpleClassName(dict.getClass())));
                String key = "storage.dictionary.delete" + MiscUtil.getSimpleClassName(dict.getClass());
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                throw throwable;
            }
        }
        ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("delete.%s", MiscUtil.getSimpleClassName(dict.getClass())));
        String key = "storage.dictionary.delete" + MiscUtil.getSimpleClassName(dict.getClass());
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        return dictionaryUpdateResult;
    }

    public Collection<? extends BaseDictionary> loadAll(Date modifiedSince, Class<? extends BaseDictionary> dictCls, Set<String> ignoredTypes) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        if (this.log.isDebugEnabled()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
            this.log.debug(String.format("loading dictionary: cls = %s, modifiedSince = %s, ignoredTypes = %s", dictCls, modifiedSince == null ? null : sdf.format(modifiedSince), ignoredTypes));
        }
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork();
        PhysicalStorageSession session = sd.getSession();
        try {
            HashSet classes = new HashSet();
            for (String item : ignoredTypes) {
                classes.add(XHelper.getClass((String)item));
            }
            List<PhysicalDictionaryData<?>> data = this.ps.getDictionaryStorage().loadAll(modifiedSince, Boolean.FALSE, dictCls, classes, session);
            ArrayList lst = new ArrayList();
            for (PhysicalDictionaryData<?> item : data) {
                lst.add(this.toDictionary(item));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("got %s dictionaries", Integer.toString(lst.size())));
            }
            Metrics.get().value("profiling.storage.dicts.dataSize", lst.size());
            ArrayList<?> arrayList = lst;
            return arrayList;
        }
        catch (Throwable e) {
            this.log.error(String.format("unable to getModifications: modified = %s, ignored types = %s", modifiedSince, ignoredTypes), e);
            throw new StorageException("unable to search", e);
        }
        finally {
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.dicts.load", timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)"dict-loadAll");
            String key = "storage.dictionary.getModifications";
            if (Profiler.get().isProfilingEnabled(key)) {
                Profiler.get().updateTiming(key, timing, null);
            }
        }
    }

    public Collection<? extends DictionaryReference<?>> getDeleted(Date modifiedSince, Class<? extends BaseDictionary> dictCls, Set<String> ignoredTypes) throws Exception {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork();
        PhysicalStorageSession session = sd.getSession();
        try {
            HashSet classes = new HashSet();
            for (String item : ignoredTypes) {
                classes.add(XHelper.getClass((String)item));
            }
            List<PhysicalDictionaryData<?>> data = this.ps.getDictionaryStorage().loadAll(modifiedSince, Boolean.TRUE, dictCls, classes, session);
            ArrayList result = new ArrayList();
            for (PhysicalDictionaryData<?> item : data) {
                Class cls = XHelper.getClass((String)(item.getDictionaryType().getName() + "Reference"));
                result.add(cls.getConstructor(String.class).newInstance(item.getCode()));
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Throwable e) {
            this.log.error(String.format("unable to get deleted items: modified = %s, ignored types = %s", modifiedSince, ignoredTypes), e);
            throw new StorageException("unable to search", e);
        }
        finally {
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.dicts.getDeleted", timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)"dict-getDeleted");
            String key = "storage.dictionary.getDeleted";
            if (Profiler.get().isProfilingEnabled(key)) {
                Profiler.get().updateTiming(key, timing, null);
            }
        }
    }

    private List<DictionaryStorageOperationCompletedInterceptor> getOperationCompletedInterceptor(boolean ignoreInterceptors) {
        return ignoreInterceptors ? LogicalStorageRegistry.get().getDictionaryOperationCompletedInterceptors().stream().filter(DictionaryStorageOperationCompletedInterceptor::isSystem).collect(Collectors.toList()) : LogicalStorageRegistry.get().getDictionaryOperationCompletedInterceptors();
    }

    private List<DictionaryStorageOperationStartedInterceptor> getOperationStartedInterceptor(boolean ignoreInterceptors) {
        return ignoreInterceptors ? Collections.emptyList() : LogicalStorageRegistry.get().getDictionaryOperationStartedInterceptors();
    }

    private <D extends BaseDictionary> D toDictionary(PhysicalDictionaryData<D> data) throws Exception {
        if (data == null) {
            return null;
        }
        BaseDictionary result = (BaseDictionary)data.getDictionaryType().newInstance();
        result.setUid(data.getUid());
        result.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(data.getData()))).getDocumentElement());
        return (D)result;
    }

    private <D extends BaseDictionary> void fromDictionary(D dict, PhysicalDictionaryData<D> data, boolean useCurrentUid) throws Exception {
        if (!useCurrentUid) {
            data.setCode(dict.getUid());
        }
        data.setDictionaryType(dict.getClass());
        data.setCode(dict.getCode());
        data.setCreated(dict.getCreated());
        data.setModified(dict.getModified());
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        XSUtil.serialize(dict, (OutputStream)strm);
        data.setData(strm.toByteArray());
    }

    public void deleteAll(Class<BaseDictionary> cls) {
        if (updateLog.isDebugEnabled()) {
            updateLog.debug(String.format("deleting all of %s, login = %s,  thread = %s, stacktrace =\n %s", MiscUtil.getSimpleClassName(cls), UserData.get().getCurrentUser(), Thread.currentThread().getName(), DebugUtil.getStackTrace()));
        }
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        LogicalSession sd = this.sh.beginUnitOfWork();
        try {
            this.ps.getDictionaryStorage().deleteAll(cls, sd.getSession());
            this.sh.endUnitOfWork(sd, true);
        }
        catch (Throwable e) {
            this.log.error(String.format("unable to delete all dictionaries: cls = %s", MiscUtil.getSimpleClassName(cls)), e);
            throw new StorageException("unable delete all dictionaries", e);
        }
        finally {
            this.sh.cancelUnitOfWork(sd);
        }
    }

    static final class DictCompositeNumber
    implements CompositeNumber {
        private String number;

        DictCompositeNumber() {
        }

        public String getNumber() {
            return this.number;
        }

        public String getNumberPrefix() {
            return "auto";
        }

        public String getNumberSuffix() {
            return null;
        }

        public void setNumber(String value) {
            this.number = value;
        }

        public void setNumberPrefix(String value) {
        }

        public void setNumberSuffix(String value) {
        }
    }
}

