/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.dictionary;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.dictionary.DictionaryOperationsHelper;
import com.gridnine.xtrip.server.db.storage.model.DictionaryStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.List;

public class SaveDictionaryOperation<D extends BaseDictionary>
extends LogicalStorageOperation {
    private final PhysicalDictionaryData<D> oldData;
    private final PhysicalDictionaryData<D> newData;
    private final D oldDict;
    private final D newDict;
    private final List<DictionaryStorageOperationCompletedInterceptor> interceptors;
    private final SessionCallback callback;
    private final ValueHolder<Throwable> errorHolder;

    public SaveDictionaryOperation(PhysicalDictionaryData<D> newDictData, PhysicalDictionaryData<D> oldDictData, D newDictionary, D oldDictionary, List<DictionaryStorageOperationCompletedInterceptor> intrs, SessionCallback clb, ValueHolder<Throwable> holder) {
        this.oldData = oldDictData;
        this.newData = newDictData;
        this.oldDict = oldDictionary;
        this.newDict = newDictionary;
        this.interceptors = intrs;
        this.callback = clb;
        this.errorHolder = holder;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        ps.getDictionaryStorage().saveDictionary(this.newData, this.oldData, session);
        DictionaryOperationsHelper.addDictionaryCallback(this.callback, this.interceptors, new DictionaryOperationsHelper.DictionaryInterceptorCallback(){

            @Override
            public void execute(DictionaryStorageOperationCompletedInterceptor interceptor) throws Throwable {
                if (SaveDictionaryOperation.this.newData != null && SaveDictionaryOperation.this.newData.isDeleted()) {
                    if (SaveDictionaryOperation.this.oldData != null && SaveDictionaryOperation.this.oldData.isDeleted()) {
                        return;
                    }
                    interceptor.afterDelete(SaveDictionaryOperation.this.callback, SaveDictionaryOperation.this.newDict);
                    return;
                }
                interceptor.afterSave(SaveDictionaryOperation.this.callback, SaveDictionaryOperation.this.newDict);
            }
        }, this.errorHolder);
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (this.oldData == null) {
            ps.getDictionaryStorage().deleteDictionary(this.newData, session);
            if (!this.newData.isDeleted()) {
                DictionaryOperationsHelper.addDictionaryCallback(this.callback, this.interceptors, new DictionaryOperationsHelper.DictionaryInterceptorCallback(){

                    @Override
                    public void execute(DictionaryStorageOperationCompletedInterceptor interceptor) throws Throwable {
                        if (SaveDictionaryOperation.this.newData.isDeleted()) {
                            return;
                        }
                        interceptor.afterDelete(SaveDictionaryOperation.this.callback, SaveDictionaryOperation.this.newDict);
                    }
                }, this.errorHolder);
            }
            return;
        }
        ps.getDictionaryStorage().saveDictionary(this.oldData, this.newData, session);
        DictionaryOperationsHelper.addDictionaryCallback(this.callback, this.interceptors, new DictionaryOperationsHelper.DictionaryInterceptorCallback(){

            @Override
            public void execute(DictionaryStorageOperationCompletedInterceptor interceptor) throws Throwable {
                if (SaveDictionaryOperation.this.oldData.isDeleted()) {
                    if (SaveDictionaryOperation.this.newData != null && SaveDictionaryOperation.this.newData.isDeleted()) {
                        return;
                    }
                    interceptor.afterDelete(SaveDictionaryOperation.this.callback, SaveDictionaryOperation.this.oldDict);
                    return;
                }
                interceptor.afterSave(SaveDictionaryOperation.this.callback, SaveDictionaryOperation.this.oldDict);
            }
        }, this.errorHolder);
    }
}

