/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.dictionary;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;

public class UpdateBulkDictionaryOperation<D extends BaseDictionary>
extends LogicalStorageOperation {
    private final PhysicalBulkDictionaryData<D> oldData;
    private final PhysicalBulkDictionaryData<D> newData;

    public UpdateBulkDictionaryOperation(PhysicalBulkDictionaryData<D> newDictData, PhysicalBulkDictionaryData<D> oldDictData) {
        this.oldData = oldDictData;
        this.newData = newDictData;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        ps.getBulkDictionaryStorage().updateData(this.newData, this.oldData, session);
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (this.oldData == null) {
            ps.getBulkDictionaryStorage().deleteData(this.newData, session);
            return;
        }
        ps.getBulkDictionaryStorage().updateData(this.oldData, this.newData, session);
    }
}

