/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.entity.EntityOperationsHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityOperationContextData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeleteEntityContainerOperation<E extends BaseEntity>
extends LogicalStorageOperation {
    private final Logger archiveLog = LoggerFactory.getLogger((String)(LogicalStorageOperation.class.getName() + ".ARCHIVE"));
    private final PhysicalEntityData<E> newData;
    private final PhysicalEntityData<E> oldData;
    private final EntityContainer<E> oldContainer;
    private final List<EntityStorageOperationCompletedInterceptor> operationCompleteInterceptors;
    private final Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIndexes;
    private final SessionCallback callback;
    private final ValueHolder<Throwable> errorHolder;
    private final Collection<Class<?>> indexClasses;
    private final EntityOperationContextData contextData;

    DeleteEntityContainerOperation(PhysicalEntityData<E> newDat, PhysicalEntityData<E> oldDat, EntityContainer<E> oldCtr, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIdx, List<EntityStorageOperationCompletedInterceptor> interceptors, SessionCallback clb, ValueHolder<Throwable> holder, Collection<Class<?>> classes, EntityOperationContextData context) {
        this.newData = newDat;
        this.oldData = oldDat;
        this.oldContainer = oldCtr;
        this.operationCompleteInterceptors = interceptors;
        this.oldIndexes = oldIdx;
        this.callback = clb;
        this.errorHolder = holder;
        this.indexClasses = classes;
        this.contextData = context;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.oldData.getEntityType())) {
            this.archiveLog.debug("delete archive: delete (" + (this.newData == null ? "delete" : "save") + ") uid: " + this.oldData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        EntityOperationsHelper.deleteIndexes(this.indexClasses, this.oldContainer.getUid(), this.oldIndexes, ps, session);
        if (this.newData == null) {
            ps.getEntityStorage().deleteEntity(this.oldData, session);
        } else {
            ps.getEntityStorage().saveEntity(this.newData, this.oldData, session);
        }
        EntityOperationsHelper.addEntityCallback(this.callback, this.operationCompleteInterceptors, new EntityOperationsHelper.EntityInterceptorCallback(){

            @Override
            public void execute(EntityStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterDelete(DeleteEntityContainerOperation.this.callback, DeleteEntityContainerOperation.this.oldContainer, DeleteEntityContainerOperation.this.contextData);
            }
        }, this.errorHolder);
    }

    @Override
    public void commitFailed(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.oldData.getEntityType())) {
            this.archiveLog.debug("delete archive: commit failed uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.oldData.getEntityType())) {
            this.archiveLog.debug("delete archive: rollback (" + (this.newData != null ? "delete&save" : "save") + ") uid: " + this.oldData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        if (this.newData != null) {
            ps.getEntityStorage().deleteEntity(this.newData, session);
        }
        ps.getEntityStorage().saveEntity(this.oldData, this.newData, session);
        EntityOperationsHelper.createIndexes(this.oldContainer.getUid(), this.oldIndexes, ps, session);
        EntityOperationsHelper.addEntityCallback(this.callback, this.operationCompleteInterceptors, new EntityOperationsHelper.EntityInterceptorCallback(){

            @Override
            public void execute(EntityStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterRestore(DeleteEntityContainerOperation.this.callback, DeleteEntityContainerOperation.this.oldContainer, EntityOperationsHelper.toList(DeleteEntityContainerOperation.this.oldIndexes));
            }
        }, this.errorHolder);
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = MiscUtil.getSimpleClassName(this.getClass());
        Class<Object> clazz = this.newData == null ? (this.oldData != null ? this.oldData.getEntityType() : null) : (objectArray[1] = this.newData.getEntityType());
        objectArray[2] = this.newData == null ? (this.oldData != null ? this.oldData.getUid() : null) : this.newData.getUid();
        return String.format("%s: entity = %s, %s", objectArray);
    }
}

