/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.entity.EntityOperationsHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class DeleteIndexesOperation<E extends BaseEntity>
extends LogicalStorageOperation {
    private final Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> toRestore;
    private final Collection<Class<?>> indexClasses;
    private final EntityContainer<E> container;

    DeleteIndexesOperation(EntityContainer<E> ctr, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> restore, Collection<Class<?>> idxs) {
        this.toRestore = restore;
        this.indexClasses = idxs;
        this.container = ctr;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        EntityOperationsHelper.deleteIndexes(this.indexClasses, this.container.getUid(), this.toRestore, ps, session);
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        EntityOperationsHelper.createIndexes(this.container.getUid(), this.toRestore, ps, session);
    }

    public String toString() {
        return String.format("%s: entity = %s", MiscUtil.getSimpleClassName(this.getClass()), this.container == null ? null : this.container.getEntityType());
    }
}

