/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.Callback;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EntityOperationsHelper {
    private static final Logger log = LoggerFactory.getLogger(EntityOperationsHelper.class);

    static boolean isArchivedBookingClass(Class<?> cls) {
        return "com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking".equals(cls.getName());
    }

    static <E extends BaseEntity> void deleteIndexes(Collection<Class<?>> indexClasses, String containerUid, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIndexes, PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        for (Class<?> cls : indexClasses) {
            ps.getEntityStorage().deleteIndexes(cls, containerUid, oldIndexes.get(cls), session);
        }
    }

    static <E extends BaseEntity> void createIndexes(String containerUid, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> indexes, PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        for (Map.Entry<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> entry : indexes.entrySet()) {
            Class<?> cls = entry.getKey();
            Map indexData = entry.getValue();
            ps.getEntityStorage().saveIndexes(cls, indexData, containerUid, session);
            log.debug(String.format("created %s indexes  of type %s created", Integer.toString(indexData.size()), cls));
        }
    }

    static <E extends BaseEntity> void addIndexUpdateCallback(final SessionCallback callback, final List<EntityStorageOperationCompletedInterceptor> operationCompletedInterceptors, final Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> indexes, final EntityContainer<E> container, final ValueHolder<Throwable> errorHolder) {
        if (operationCompletedInterceptors.isEmpty()) {
            return;
        }
        callback.addCallback(new Callback(){
            private static final long serialVersionUID = -1894877681876658547L;

            @Override
            public void execute(SessionCallback ss) {
                for (EntityStorageOperationCompletedInterceptor interceptor : operationCompletedInterceptors) {
                    try {
                        interceptor.afterIndexUpdate(callback, container, EntityOperationsHelper.toList(indexes));
                    }
                    catch (Throwable e) {
                        log.error("unable to execute callback", e);
                        errorHolder.setValue((Object)e);
                        return;
                    }
                }
            }
        }, true);
    }

    static <E extends BaseEntity> List<BaseIndexData<E, EntityIndex<E>>> toList(Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> indexes) {
        return indexes.values().stream().flatMap(m -> m.values().stream()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static <E extends BaseEntity> void addEntityCallback(SessionCallback callback, final EntityCallback operation, final ValueHolder<Throwable> errorHolder) {
        callback.addCallback(new Callback(){
            private static final long serialVersionUID = 3630420807991853377L;

            @Override
            public void execute(SessionCallback ss) {
                try {
                    operation.execute();
                }
                catch (Throwable e) {
                    log.error("unable to execute callback", e);
                    errorHolder.setValue((Object)e);
                    return;
                }
            }
        }, true);
    }

    static <E extends BaseEntity> void addEntityCallback(SessionCallback callback, final List<EntityStorageOperationCompletedInterceptor> operationCompletedInterceptors, final EntityInterceptorCallback operation, final ValueHolder<Throwable> errorHolder) {
        if (operationCompletedInterceptors.isEmpty()) {
            return;
        }
        callback.addCallback(new Callback(){
            private static final long serialVersionUID = 6572628485949787229L;

            @Override
            public void execute(SessionCallback ss) {
                for (EntityStorageOperationCompletedInterceptor interceptor : operationCompletedInterceptors) {
                    try {
                        operation.execute(interceptor);
                    }
                    catch (Throwable e) {
                        log.error("unable to execute callback", e);
                        errorHolder.setValue((Object)e);
                        return;
                    }
                }
            }
        }, true);
    }

    private EntityOperationsHelper() {
    }

    static interface EntityCallback {
        public void execute() throws Throwable;
    }

    static interface EntityInterceptorCallback {
        public void execute(EntityStorageOperationCompletedInterceptor var1) throws Throwable;
    }
}

