/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.entity;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.db.storage.entity.RevisionConflictException;
import com.gridnine.xtrip.common.incidents.IncidentsContext;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.EntityStatus;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.StorageException;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.cache.advanced.GroupsHandlerManager;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModification;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.model.cache.common.ReferenceActualizationResult;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.entity.misc.EntityStorageThreadContext;
import com.gridnine.xtrip.common.model.entity.parameters.BaseEntityStorageParameters;
import com.gridnine.xtrip.common.model.entity.parameters.BaseEntityStorageWriteParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageDeleteParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageIsAvailableParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageRollbackParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.model.profiling.ProfilingUtils;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.StorageQuery;
import com.gridnine.xtrip.common.usage.IndexUsageHandler;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.DiffUtil;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.InvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.PollingConfiguration;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalSession;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.common.PhysicalStorageCache;
import com.gridnine.xtrip.server.db.storage.common.SearchQueryHelper;
import com.gridnine.xtrip.server.db.storage.common.SessionsHelper;
import com.gridnine.xtrip.server.db.storage.entity.DeleteEntityContainerOperation;
import com.gridnine.xtrip.server.db.storage.entity.ReduceVersionsCountOperation;
import com.gridnine.xtrip.server.db.storage.entity.RestoreEntityContainerOperation;
import com.gridnine.xtrip.server.db.storage.entity.RollbackEntityContainerOperation;
import com.gridnine.xtrip.server.db.storage.entity.SaveEntityContainerOperation;
import com.gridnine.xtrip.server.db.storage.entity.UpdateIndexesOperation;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataFormat;
import com.gridnine.xtrip.server.db.storage.model.EntityInterceptor;
import com.gridnine.xtrip.server.db.storage.model.EntityOperationContextData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.db.storage.model.LogicalEntityOperationContext;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityDataModification;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionMetadataData;
import com.gridnine.xtrip.server.metrics.Metrics;
import com.gridnine.xtrip.server.tracker.LongRunningOperationsTracker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class LogicalEntityStorage {
    public static final String ENTITY_INTERCEPTORS = LogicalEntityStorage.class.getName() + "_ENTITY_INTERCEPTORS";
    private static final Logger log = LoggerFactory.getLogger(LogicalEntityStorage.class);
    private static final Logger updateLog = LoggerFactory.getLogger((String)(LogicalEntityStorage.class.getName() + ".UPDATE"));
    private final PhysicalStorage ps;
    private final SessionsHelper sh;
    private static final ThreadLocal<EntityOperationContextData> context = new ThreadLocal();
    private final OnLoadEntityUpdater onLoadUpdater;
    private static final Field revisionField;
    private static final Field dataSourceField;
    private static final Field dataSourceModifiedField;
    private static final Field versionNotesField;
    private static final Field versionNotesModifiedField;

    public LogicalEntityStorage(PhysicalStorage physicalStorage, SessionsHelper sessionsHelper) {
        this.ps = physicalStorage;
        this.sh = sessionsHelper;
        String clsName = System.getProperty("com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage.OnLoadEntityUpdater.className");
        this.onLoadUpdater = clsName != null ? (OnLoadEntityUpdater)XHelper.getInstance((String)clsName, (Object[])new Object[0]) : null;
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> search(Class<I> cls, SearchQuery query) throws StorageException {
        return this.search(cls, query, new EntityStorageSearchParameters());
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> search(Class<I> cls, SearchQuery query, EntityStorageSearchParameters parameters) throws StorageException {
        SearchResult<I> searchResult;
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        if (IndexUsageHandler.get().isStatEnabled()) {
            SearchQueryHelper.statSortedAndFiltered(cls, (StorageQuery)query);
        }
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork(parameters.getContext());
        try {
            SearchResult<I> result = this.ps.getEntityStorage().searchEntity(cls, query, sd.getSession());
            Metrics.get().value("profiling.storage.entity.dataSize." + MiscUtil.getSimpleClassName(cls), result.getData().size());
            searchResult = result;
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.entity.search." + MiscUtil.getSimpleClassName(cls), timing);
        }
        catch (Throwable e) {
            try {
                log.error(String.format("unable to search: cls = %s, query = %s", MiscUtil.getSimpleClassName(cls), query), e);
                throw new StorageException("unable to search", e);
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(sd);
                Metrics.get().timingAndEvent("profiling.storage.entity.search." + MiscUtil.getSimpleClassName(cls), timing);
                ProfilingUtils.monitorQuery((long)timing, (String)String.format("search.%s.%s", MiscUtil.getSimpleClassName(cls), this.getSlaveMasterSuffix((BaseEntityStorageParameters)parameters)), (StorageQuery)query);
                String key = String.format("storage.search.%s.%s", MiscUtil.getSimpleClassName(cls), this.getSlaveMasterSuffix((BaseEntityStorageParameters)parameters));
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                throw throwable;
            }
        }
        ProfilingUtils.monitorQuery((long)timing, (String)String.format("search.%s.%s", MiscUtil.getSimpleClassName(cls), this.getSlaveMasterSuffix((BaseEntityStorageParameters)parameters)), (StorageQuery)query);
        String key = String.format("storage.search.%s.%s", MiscUtil.getSimpleClassName(cls), this.getSlaveMasterSuffix((BaseEntityStorageParameters)parameters));
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        return searchResult;
    }

    private String getSlaveMasterSuffix(BaseEntityStorageParameters parameters) {
        if (Boolean.TRUE.equals(parameters.getContext().get("irrelevance-tolerant-query"))) {
            return "slave";
        }
        return "master";
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult search(Class<I> cls, ProjectionQuery query, EntityStorageSearchParameters parameters) throws StorageException {
        ProjectionResult projectionResult;
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        if (IndexUsageHandler.get().isStatEnabled()) {
            SearchQueryHelper.statSortedAndFiltered(cls, (StorageQuery)query);
        }
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork(parameters.getContext());
        try {
            projectionResult = this.ps.getEntityStorage().searchEntity(cls, query, sd.getSession());
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.entity.projection." + MiscUtil.getSimpleClassName(cls), timing);
        }
        catch (Throwable e) {
            try {
                log.error(String.format("unable to perform projection search: cls = %s, query = %s", MiscUtil.getSimpleClassName(cls), query), e);
                throw new StorageException("unable to perform projection search", e);
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(sd);
                Metrics.get().timingAndEvent("profiling.storage.entity.projection." + MiscUtil.getSimpleClassName(cls), timing);
                ProfilingUtils.monitorQuery((long)timing, (String)String.format("projection-search.%s.%s", MiscUtil.getSimpleClassName(cls), this.getSlaveMasterSuffix((BaseEntityStorageParameters)parameters)), (StorageQuery)query);
                String key = String.format("projection-storage.search.%s.%s", MiscUtil.getSimpleClassName(cls), this.getSlaveMasterSuffix((BaseEntityStorageParameters)parameters));
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                throw throwable;
            }
        }
        ProfilingUtils.monitorQuery((long)timing, (String)String.format("projection-search.%s.%s", MiscUtil.getSimpleClassName(cls), this.getSlaveMasterSuffix((BaseEntityStorageParameters)parameters)), (StorageQuery)query);
        String key = String.format("projection-storage.search.%s.%s", MiscUtil.getSimpleClassName(cls), this.getSlaveMasterSuffix((BaseEntityStorageParameters)parameters));
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        return projectionResult;
    }

    public <E extends BaseEntity> boolean isAvailable(Class<E> cls, String uid, EntityStorageIsAvailableParameters parameters) throws StorageException {
        boolean bl;
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork(parameters.getContext());
        try {
            bl = this.ps.getEntityStorage().isEntityAvailable(cls, uid, sd.getSession());
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.entity.availability." + MiscUtil.getSimpleClassName(cls), timing);
        }
        catch (Throwable e) {
            try {
                log.error(String.format("unable to check entity availability: cls = %s, uid = %s", MiscUtil.getSimpleClassName(cls), uid), e);
                throw new StorageException("unable to check entity availability", e);
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(sd);
                Metrics.get().timingAndEvent("profiling.storage.entity.availability." + MiscUtil.getSimpleClassName(cls), timing);
                ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("isAvailable.%s", MiscUtil.getSimpleClassName(cls)));
                String key = "storage.isAvailable." + MiscUtil.getSimpleClassName(cls);
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                throw throwable;
            }
        }
        ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("isAvailable.%s", MiscUtil.getSimpleClassName(cls)));
        String key = "storage.isAvailable." + MiscUtil.getSimpleClassName(cls);
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        return bl;
    }

    public <E extends BaseEntity> EntityContainer<E> load(EntityReference<E> ref, EntityStorageLoadParameters parameters) throws StorageException {
        return ref == null ? null : this.load(ref.getType(), ref.getUid(), null, parameters);
    }

    public <E extends BaseEntity> EntityContainer<E> load(EntityReference<E> ref, Integer versionNumber) throws StorageException {
        return ref == null ? null : this.load(ref.getType(), ref.getUid(), versionNumber, new EntityStorageLoadParameters());
    }

    public <E extends BaseEntity> EntityContainer<E> load(Class<E> cls, String uid, EntityStorageLoadParameters parameters) throws StorageException {
        return this.load(cls, uid, null, parameters);
    }

    public <E extends BaseEntity> EntityContainer<E> load(Class<E> cls, String uid, Integer versionNumber, EntityStorageLoadParameters parameters) throws StorageException {
        EntityContainer<E> entityContainer;
        PhysicalEntityData<E> data;
        PhysicalStorageSession session;
        LogicalSession sessionData;
        long timing;
        block13: {
            if (DebugUtil.isThreadDebugEnabled()) {
                DebugUtil.logStackTrace();
            }
            if (cls == null || TextUtil.isBlank((String)uid)) {
                return null;
            }
            if (Modifier.isAbstract(cls.getModifiers())) {
                throw new IllegalArgumentException("can't load entity of an abstract class " + cls.getName());
            }
            timing = System.currentTimeMillis();
            sessionData = this.sh.beginUnitOfWork(parameters.getContext());
            session = sessionData.getSession();
            data = this.loadEntity(cls, uid, versionNumber, Boolean.TRUE.equals(parameters.getContext().get(EntityStorage.NO_PHYSICAL_STORAGE_CACHE)), session);
            if (data != null && data.getStatus() != EntityStatus.VOID) break block13;
            EntityContainer<E> entityContainer2 = null;
            this.sh.cancelUnitOfWork(sessionData);
            Metrics.get().timingAndEvent("profiling.storage.entity.load." + MiscUtil.getSimpleClassName(cls), timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("load.%s", MiscUtil.getSimpleClassName(cls)));
            String key = "storage.load." + MiscUtil.getSimpleClassName(cls);
            if (Profiler.get().isProfilingEnabled(key)) {
                Profiler.get().updateTiming(key, timing, null);
            }
            return entityContainer2;
        }
        try {
            EntityContainer<E> result = LogicalEntityStorage.toEntityContainer(data, versionNumber == null ? data.getVersionsCount() - 1 : versionNumber, this.ps, session);
            if (!Objects.isNull(result) && !Objects.isNull(this.onLoadUpdater)) {
                this.onLoadUpdater.update(result);
            }
            if (Objects.isNull(result) && updateLog.isDebugEnabled()) {
                updateLog.debug("container null for " + cls.getName() + ":" + uid + ":" + versionNumber);
            }
            entityContainer = result;
            this.sh.cancelUnitOfWork(sessionData);
            Metrics.get().timingAndEvent("profiling.storage.entity.load." + MiscUtil.getSimpleClassName(cls), timing);
        }
        catch (Throwable e) {
            try {
                log.error(String.format("unable to load entity: cls = %s, uid = %s", MiscUtil.getSimpleClassName(cls), uid), e);
                throw new StorageException("unable to load entity", e);
            }
            catch (Throwable throwable) {
                this.sh.cancelUnitOfWork(sessionData);
                Metrics.get().timingAndEvent("profiling.storage.entity.load." + MiscUtil.getSimpleClassName(cls), timing);
                ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("load.%s", MiscUtil.getSimpleClassName(cls)));
                String key = "storage.load." + MiscUtil.getSimpleClassName(cls);
                if (Profiler.get().isProfilingEnabled(key)) {
                    Profiler.get().updateTiming(key, timing, null);
                }
                throw throwable;
            }
        }
        ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("load.%s", MiscUtil.getSimpleClassName(cls)));
        String key = "storage.load." + MiscUtil.getSimpleClassName(cls);
        if (Profiler.get().isProfilingEnabled(key)) {
            Profiler.get().updateTiming(key, timing, null);
        }
        return entityContainer;
    }

    public <E extends BaseEntity> void save(EntityContainer<E> etc, boolean withCheckPoint) throws Exception {
        this.save(etc, withCheckPoint, new EntityStorageSaveParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <E extends BaseEntity> void reduceVersionsCount(EntityReference<E> ref, int maxVersionsCount) {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        if (maxVersionsCount <= 0) {
            throw new IllegalArgumentException("maxVersionsCount must be greater than 0");
        }
        NamedLock lock = SessionsHelper.lock(LogicalEntityStorage.getLockKey(ref));
        try {
            LogicalSession ms = this.sh.beginUnitOfWork();
            try {
                log.debug("reduceVersionsCount() BEGIN ref=" + ref);
                PhysicalStorageSession session = ms.getSession();
                PhysicalEntityData data = this.loadEntity(ref.getType(), ref.getUid(), null, false, session);
                if (data == null) {
                    log.warn("entity container is absent id db for ref = " + ref);
                    return;
                }
                EntityContainer<E> ctr = LogicalEntityStorage.toEntityContainer(data, data.getVersionsCount() - 1, this.ps, session);
                if (ctr.getVersionsCount() <= maxVersionsCount) {
                    log.debug("versions count is less than maximum value for " + ref);
                    return;
                }
                long timing = System.currentTimeMillis();
                block12: for (int n = data.getVersionsCount() - 1; n >= 0; --n) {
                    for (PhysicalVersionData vd : data.getVersions()) {
                        if (n != vd.getVersionNumber()) continue;
                        continue block12;
                    }
                    LogicalEntityStorage.getVersion(data, n, this.ps, session);
                }
                data.getVersions().sort((o1, o2) -> o2.getVersionNumber() - o1.getVersionNumber());
                PhysicalEntityData newData = new PhysicalEntityData();
                newData.setModifiedBy(UserData.get().getCurrentUser());
                newData.setModified(((TimeService)Environment.getPublished(TimeService.class)).currentDate());
                data.copy(newData);
                newData.getVersions().clear();
                newData.setVersionsCount(maxVersionsCount);
                for (int n = 0; n < maxVersionsCount; ++n) {
                    PhysicalVersionData vd;
                    vd = data.getVersions().get(n);
                    PhysicalVersionData newVd = new PhysicalVersionData();
                    vd.copy(newVd);
                    newVd.setUid(UUID.randomUUID().toString());
                    newVd.setVersionNumber(maxVersionsCount - n - 1);
                    newVd.setModified(newData.getModified());
                    newData.getVersions().add(newVd);
                }
                this.sh.registerOperation(new ReduceVersionsCountOperation(newData, data));
                this.updatePhysicalStorageCache(newData);
                this.sh.endUnitOfWork(ms, true);
                MiscUtil.logTiming((long)timing, (String)("versions count reduced " + ctr));
                return;
            }
            catch (Throwable t) {
                log.error("unable to reduce versions count for " + ref, t);
                throw new StorageException("unable to reduce versions count for " + ref, t);
            }
            finally {
                log.debug("reduceVersionsCount() END ref=" + ref);
                this.sh.cancelUnitOfWork(ms);
            }
        }
        finally {
            if (this.sh.isSessionOpen()) {
                this.sh.addSessionLock(lock);
            } else {
                SessionsHelper.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> void save(EntityContainer<E> etc, boolean withCheckPoint, EntityStorageSaveParameters parameters) {
        InvocationContext ctx;
        if (log.isDebugEnabled()) {
            log.debug("save() BEGIN etc=" + etc);
        }
        if (updateLog.isDebugEnabled()) {
            updateLog.debug("saving " + MiscUtil.getSimpleClassName((Class)etc.getEntityType()) + " " + etc.getUid() + ", login = " + UserData.get().getCurrentUser() + ", checkpoint = " + withCheckPoint + ", version = " + etc.getVersionInfo().getVersionNumber() + ", revision = " + etc.getRevision() + ", thread = " + Thread.currentThread().getName() + ", dataSource = " + etc.getVersionInfo().getDataSource() + ", stacktrace =\n " + DebugUtil.getStackTrace());
        }
        if (!(ctx = InvocationContext.get((String)"EntityContainerSave")).enter(etc)) {
            if (log.isDebugEnabled()) {
                log.debug("save() END, re-entrance detected for " + etc);
            }
            return;
        }
        boolean hasError = false;
        int originalVersionsCount = etc.getVersionsCount();
        int originalVersionNumber = etc.getVersionInfo().getVersionNumber();
        NamedLock lock = SessionsHelper.lock(LogicalEntityStorage.getLockKey(etc));
        String lrtSessionUid = LongRunningOperationsTracker.get().startSession("save-" + etc.getEntityType().getSimpleName());
        try {
            boolean updateGlobalContext;
            LongRunningOperationsTracker.get().startOperation("load-data", lrtSessionUid);
            if (TextUtil.isBlank((String)etc.getVersionInfo().getDataSource()) && context.get() != null && !LogicalEntityStorage.context.get().globalOperationContext.getNewCtr().equals(etc)) {
                etc.getVersionInfo().setDataSource(LogicalEntityStorage.context.get().globalOperationContext.getNewCtr().getVersionInfo().getDataSource());
            }
            if (DebugUtil.isThreadDebugEnabled()) {
                DebugUtil.logStackTrace();
            }
            long timing = System.currentTimeMillis();
            this.updateVersionInfoUid(etc, withCheckPoint);
            this.checkSerialization(etc);
            LogicalSession ms = this.sh.beginUnitOfWork(parameters.getContext());
            PhysicalStorageSession session = ms.getSession();
            EntityReference ref = etc.toReference();
            boolean bl = updateGlobalContext = context.get() == null;
            if (updateGlobalContext) {
                context.set(new EntityOperationContextData());
                LogicalEntityStorage.context.get().globalOperationContext.setCreateNewVersion(withCheckPoint);
                LogicalEntityStorage.context.get().globalOperationContext.setNewCtr(etc);
                LogicalEntityStorage.context.get().globalOperationContext.getParameters().putAll(parameters.getContext());
            }
            this.getLocalOperationContext(ref).reset();
            this.getLocalOperationContext(ref).setCreateNewVersion(withCheckPoint);
            try {
                PhysicalEntityData data = this.loadEntity(etc.getEntityType(), etc.getUid(), null, false, session);
                PhysicalEntityData restoreData = null;
                if (data != null) {
                    restoreData = new PhysicalEntityData();
                    data.copy(restoreData);
                }
                EntityContainer<E> oldCtr = null;
                if (data != null && data.getStatus() != EntityStatus.VOID) {
                    oldCtr = LogicalEntityStorage.toEntityContainer(data, data.getVersionsCount() - 1, this.ps, session);
                    if (!Objects.isNull(this.onLoadUpdater)) {
                        this.onLoadUpdater.update(oldCtr);
                    }
                    this.getLocalOperationContext(ref).setOldCtr(oldCtr);
                    if (updateGlobalContext) {
                        LogicalEntityStorage.context.get().globalOperationContext.setOldCtr(oldCtr);
                    }
                }
                long revision = data != null ? data.getRevision() : (etc.getRevision() != null ? etc.getRevision() : 0L);
                Long etcRevision = etc.getRevision();
                if (Boolean.parseBoolean(System.getProperty("midoffice.revision.check", "true")) && etcRevision != null && revision != etcRevision) {
                    throw new RevisionConflictException(etc.getUid() + ", " + etc.getEntityType().getName() + " (" + etc.getEntity().toString() + ")", revision, etcRevision.longValue());
                }
                this.updateContainer(etc, withCheckPoint);
                this.getLocalOperationContext(ref).setNewCtr(etc);
                SessionCallback sessionCallback = this.sh.createSessionCallback();
                for (EntityInterceptor interceptor : this.getEntityInterceptors((BaseEntityStorageWriteParameters)parameters)) {
                    LongRunningOperationsTracker.get().startOperation("interceptor-" + interceptor.getClass().getSimpleName(), lrtSessionUid);
                    long timing2 = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug("invoking onSave(), interceptor=" + interceptor + ", etc=" + etc);
                    }
                    interceptor.onSave(sessionCallback, etc);
                    Profiler.get().updateTiming("storage.save." + MiscUtil.getSimpleClassName((Class)etc.getEntityType()) + ".interceptor." + MiscUtil.getSimpleClassName(interceptor.getClass()), timing2, null);
                }
                LongRunningOperationsTracker.get().startOperation("after-interceptors", lrtSessionUid);
                if (TextUtil.isBlank((String)etc.getVersionInfo().getDataSource())) {
                    etc.getVersionInfo().setDataSource(EntityStorageThreadContext.getDefaultDataSource());
                }
                if (TextUtil.isBlank((String)etc.getVersionInfo().getDataSource())) {
                    IncidentsLog.reportStackTrace((String)("no dataSource when saving " + etc.getEntityType().getName() + " " + etc.toString()));
                }
                if (data == null) {
                    data = new PhysicalEntityData();
                }
                if (data.getStatus() == EntityStatus.VOID) {
                    if (log.isWarnEnabled()) {
                        log.warn("database contains VOID object of type " + data.getEntityType() + " with uid " + data.getUid() + ", it will be restored");
                    }
                    data.setStatus(EntityStatus.EDIT);
                }
                LogicalEntityStorage.fromEntityContainer(etc, data, this.ps, session, withCheckPoint, restoreData);
                data.setRevision(revision + 1L);
                ValueHolder errorHolder = new ValueHolder();
                LongRunningOperationsTracker.get().startOperation("register-operation", lrtSessionUid);
                this.sh.registerOperation(new SaveEntityContainerOperation<E>(data, restoreData, etc, oldCtr, !parameters.isDontTouchTheIndexes() ? this.getNewIndexes(etc) : null, this.getOldIndexes(oldCtr, session), this.getOperationCompletedInterceptors(parameters.isIgnoreInterceptors()), this.sh.createSessionCallback(), (ValueHolder<Throwable>)errorHolder, withCheckPoint, this.getIndexClasses(etc.getEntityType()), new EntityOperationContextData(LogicalEntityStorage.context.get().globalOperationContext, LogicalEntityStorage.context.get().localOperationContext)));
                this.updatePhysicalStorageCache(data);
                LogicalEntityStorage.setRevision(etc, data.getRevision());
                LongRunningOperationsTracker.get().startOperation("end-unit-of-work", lrtSessionUid);
                this.sh.endUnitOfWork(ms, true);
                if (errorHolder.getValue() != null) {
                    throw (Throwable)errorHolder.getValue();
                }
                if (log.isDebugEnabled()) {
                    log.debug("save() END etc=" + etc);
                }
            }
            catch (StorageException se) {
                if (log.isErrorEnabled()) {
                    log.error("unable to save entity : cls = " + MiscUtil.getSimpleClassName((Class)etc.getEntityType()) + ", uid = " + etc.getUid(), (Throwable)se);
                }
                hasError = true;
                throw se;
            }
            catch (Throwable t) {
                String mes = "unable to save entity : cls = " + MiscUtil.getSimpleClassName((Class)etc.getEntityType()) + ", uid = " + etc.getUid();
                if (log.isErrorEnabled()) {
                    log.error(mes, t);
                }
                hasError = true;
                throw new StorageException(mes, t);
            }
            finally {
                if (hasError) {
                    etc.setVersionsCount(originalVersionsCount);
                    etc.getVersionInfo().setVersionNumber(originalVersionNumber);
                }
                LogicalEntityStorage.context.get().localOperationContext.remove(ref);
                if (updateGlobalContext) {
                    context.remove();
                }
                LongRunningOperationsTracker.get().startOperation("cancel-unit-of-work", lrtSessionUid);
                this.sh.cancelUnitOfWork(ms);
                Metrics.get().timingAndEvent("profiling.storage.entity.save." + MiscUtil.getSimpleClassName((Class)etc.getEntityType()), timing);
                ProfilingUtils.monitorStacktrace((long)timing, (String)("save." + MiscUtil.getSimpleClassName((Class)etc.getEntityType())));
                Profiler.get().updateTiming("storage.save.entity." + MiscUtil.getSimpleClassName((Class)etc.getEntityType()), timing, null);
            }
            MiscUtil.logTiming((long)timing, (String)("entity container saved " + etc));
        }
        finally {
            try {
                if (this.sh.isSessionOpen()) {
                    this.sh.addSessionLock(lock);
                } else {
                    LongRunningOperationsTracker.get().startOperation("unlock", lrtSessionUid);
                    SessionsHelper.unlock(lock);
                }
                ctx.exit();
            }
            finally {
                LongRunningOperationsTracker.get().endSession(lrtSessionUid);
            }
        }
    }

    private List<EntityStorageOperationCompletedInterceptor> getOperationCompletedInterceptors(boolean ignoreInterceptors) {
        if (ignoreInterceptors) {
            return Collections.emptyList();
        }
        return LogicalStorageRegistry.get().getEntityOperationCompletedInterceptors();
    }

    private <E extends BaseEntity, C extends EntityContainer<E>> void updateVersionInfoUid(C etc, boolean withCheckPoint) {
        if (etc.getVersionInfo().getUid() == null || withCheckPoint) {
            etc.getVersionInfo().setUid(UUID.randomUUID().toString());
        }
    }

    private <E extends BaseEntity, C extends EntityContainer<E>> void updateContainer(C etc, boolean withCheckPoint) {
        String user = UserData.get().getCurrentUser();
        if (user == null) {
            throw Xeption.forDeveloper((String)"thread local user is null", (Object[])new Object[0]);
        }
        if (etc.getCreatedBy() == null) {
            etc.setCreatedBy(user);
        }
        if (etc.getStatus() == null) {
            etc.setStatus(EntityStatus.EDIT);
        }
        if (etc.getModified() == null) {
            etc.setModified(new Date());
        }
        etc.setModifiedBy(user);
        etc.getVersionInfo().setModified(new Date());
        etc.getVersionInfo().setModifiedBy(user);
        if (etc.getVersionInfo().getCreated() == null || withCheckPoint) {
            etc.getVersionInfo().setCreated(etc.getVersionInfo().getModified());
        }
        if (etc.getVersionInfo().getCreatedBy() == null || withCheckPoint) {
            etc.getVersionInfo().setCreatedBy(user);
        }
    }

    public <E extends BaseEntity, C extends EntityContainer<E>> void rollback(C etc, int versionNumber) {
        this.rollback(etc, versionNumber, new EntityStorageRollbackParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity, C extends EntityContainer<E>> void rollback(C etc, int versionNumber, EntityStorageRollbackParameters parameters) {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        NamedLock lock = SessionsHelper.lock(LogicalEntityStorage.getLockKey(etc));
        try {
            boolean updateGlobalContext;
            long timing = System.currentTimeMillis();
            LogicalSession ms = this.sh.beginUnitOfWork(parameters.getContext());
            PhysicalStorageSession session = ms.getSession();
            boolean bl = updateGlobalContext = context.get() == null;
            if (updateGlobalContext) {
                context.set(new EntityOperationContextData());
                LogicalEntityStorage.context.get().globalOperationContext.getParameters().putAll(parameters.getContext());
            }
            EntityReference ref = etc.toReference();
            this.getLocalOperationContext(ref).reset();
            try {
                log.debug("rollback() BEGIN etc=" + etc);
                PhysicalEntityData data = this.loadEntity(etc.getEntityType(), etc.getUid(), null, false, session);
                if (data == null) {
                    throw new IllegalArgumentException("entity is absent id DB");
                }
                PhysicalEntityData restoreData = new PhysicalEntityData();
                data.copy(restoreData);
                EntityContainer<E> oldCtr = LogicalEntityStorage.toEntityContainer(data, data.getVersionsCount() - 1, this.ps, session);
                LogicalEntityStorage.toEntityContainer(etc, data, versionNumber, this.ps, session);
                LogicalEntityStorage.rollbackTo(data, restoreData, versionNumber, this.ps, session);
                etc.setVersionsCount(versionNumber + 1);
                Collection<Class<?>> classes = this.getIndexClasses(etc.getEntityType());
                Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIndexes = this.getOldIndexes(oldCtr, session);
                Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> newIndexes = this.getNewIndexes(etc);
                if (updateGlobalContext) {
                    LogicalEntityStorage.context.get().globalOperationContext.setNewCtr(etc);
                    LogicalEntityStorage.context.get().globalOperationContext.setOldCtr(oldCtr);
                }
                this.getLocalOperationContext(ref).setNewCtr(etc);
                this.getLocalOperationContext(ref).setOldCtr(oldCtr);
                ValueHolder errorHolder = new ValueHolder();
                this.sh.registerOperation(new RollbackEntityContainerOperation<E>(data, restoreData, etc, oldCtr, newIndexes, oldIndexes, this.getOperationCompletedInterceptors(parameters.isIgnoreInterceptors()), this.sh.createSessionCallback(), (ValueHolder<Throwable>)errorHolder, classes, new EntityOperationContextData(LogicalEntityStorage.context.get().globalOperationContext, LogicalEntityStorage.context.get().localOperationContext)));
                this.updatePhysicalStorageCache(data);
                this.sh.endUnitOfWork(ms, true);
                if (errorHolder.getValue() != null) {
                    throw (Throwable)errorHolder.getValue();
                }
                log.debug("rollback() END etc=" + etc);
            }
            catch (Throwable e) {
                log.error(String.format("unable to rollback entity %s: cls = %s, uid = %s", etc.getEntity().toString(), etc.getEntityType(), etc.getUid()), e);
                throw new StorageException("unable to rollback entity", e);
            }
            finally {
                LogicalEntityStorage.context.get().localOperationContext.remove(ref);
                if (updateGlobalContext) {
                    context.remove();
                }
                this.sh.cancelUnitOfWork(ms);
            }
            MiscUtil.logTiming((long)timing, (String)("entity container rollback done " + etc));
        }
        finally {
            if (this.sh.isSessionOpen()) {
                this.sh.addSessionLock(lock);
            } else {
                SessionsHelper.unlock(lock);
            }
        }
    }

    @Deprecated
    public <E extends BaseEntity> EntityContainer<E> restore(EntityReference<E> ref) {
        return this.restore(ref, false);
    }

    /*
     * Loose catch block
     */
    @Deprecated
    public <E extends BaseEntity> EntityContainer<E> restore(EntityReference<E> ref, boolean ignoreInterceptors) {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        NamedLock lock = SessionsHelper.lock(LogicalEntityStorage.getLockKey(ref));
        try {
            long timing = System.currentTimeMillis();
            LogicalSession ms = this.sh.beginUnitOfWork();
            PhysicalStorageSession session = ms.getSession();
            try {
                log.debug("restore() BEGIN ref=" + ref);
                PhysicalEntityData data = this.loadEntity(ref.getType(), ref.getUid(), null, false, session);
                if (data == null) {
                    throw new IllegalArgumentException("entity is absent id DB");
                }
                PhysicalEntityData oldData = new PhysicalEntityData();
                data.copy(oldData);
                data.setStatus(EntityStatus.EDIT);
                EntityContainer<E> result = LogicalEntityStorage.toEntityContainer(data, data.getVersionsCount() - 1, this.ps, session);
                ValueHolder errorHolder = new ValueHolder();
                this.sh.registerOperation(new RestoreEntityContainerOperation<E>(data, oldData, result, this.getNewIndexes(result), this.getOperationCompletedInterceptors(ignoreInterceptors), this.sh.createSessionCallback(), (ValueHolder<Throwable>)errorHolder, this.getIndexClasses(ref.getType()), new EntityOperationContextData(LogicalEntityStorage.context.get().globalOperationContext, LogicalEntityStorage.context.get().localOperationContext)));
                this.updatePhysicalStorageCache(data);
                this.sh.endUnitOfWork(ms, true);
                if (errorHolder.getValue() != null) {
                    throw (Throwable)errorHolder.getValue();
                }
                log.debug("restore() END etc=" + ref);
                MiscUtil.logTiming((long)timing, (String)("entity container restore done " + ref));
                EntityContainer<E> entityContainer = result;
                return entityContainer;
            }
            catch (Throwable e) {
                log.error(String.format("unable to restore entity %s: cls = %s, uid = %s", ref.toString(), ref.getType(), ref.getUid()), e);
                throw new StorageException("unable to restore entity", e);
            }
            finally {
                this.sh.cancelUnitOfWork(ms);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (this.sh.isSessionOpen()) {
                this.sh.addSessionLock(lock);
            } else {
                SessionsHelper.unlock(lock);
            }
        }
    }

    public <E extends BaseEntity, C extends EntityContainer<E>> void delete(C etc) {
        this.delete(etc, new EntityStorageDeleteParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity, C extends EntityContainer<E>> void delete(C etc, EntityStorageDeleteParameters parameters) {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        if (etc == null) {
            return;
        }
        if (updateLog.isDebugEnabled()) {
            updateLog.debug(String.format("deleting %s %s, login = %s, thread = %s,stacktrace =\n %s", MiscUtil.getSimpleClassName((Class)etc.getEntityType()), etc.getUid(), UserData.get().getCurrentUser(), Thread.currentThread().getName(), DebugUtil.getStackTrace()));
        }
        log.debug("delete() BEGIN etc=" + etc);
        InvocationContext ctx = InvocationContext.get((String)"EntityContainerDelete");
        if (!ctx.enter(etc)) {
            log.debug("delete() END, re-entrance detected for " + etc);
            return;
        }
        NamedLock lock = SessionsHelper.lock(LogicalEntityStorage.getLockKey(etc));
        try {
            PhysicalEntityData data;
            boolean updateGlobalContext;
            EntityReference ref;
            PhysicalStorageSession session;
            SessionCallback sessionCallback;
            LogicalSession logicalSession;
            long timing;
            block24: {
                timing = System.currentTimeMillis();
                logicalSession = this.sh.beginUnitOfWork(parameters.getContext());
                sessionCallback = this.sh.createSessionCallback();
                session = logicalSession.getSession();
                ref = etc.toReference();
                boolean bl = updateGlobalContext = context.get() == null;
                if (updateGlobalContext) {
                    context.set(new EntityOperationContextData());
                    LogicalEntityStorage.context.get().globalOperationContext.setNewCtr(etc);
                    LogicalEntityStorage.context.get().globalOperationContext.getParameters().putAll(parameters.getContext());
                }
                this.getLocalOperationContext(ref).reset();
                data = this.loadEntity(etc.getEntityType(), etc.getUid(), null, false, session);
                if (data != null) break block24;
                log.warn("no data found for entity container " + etc);
                LogicalEntityStorage.context.get().localOperationContext.remove(ref);
                if (updateGlobalContext) {
                    context.remove();
                }
                this.sh.cancelUnitOfWork(logicalSession);
                Metrics.get().timingAndEvent("profiling.storage.entity.delete." + MiscUtil.getSimpleClassName((Class)etc.getEntityType()), timing);
                ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("delete.%s", MiscUtil.getSimpleClassName((Class)etc.getEntityType())));
                Profiler.get().updateTiming("storage.delete." + MiscUtil.getSimpleClassName((Class)etc.getEntityType()), timing, null);
                return;
            }
            try {
                EntityContainer<E> oldCtr = LogicalEntityStorage.toEntityContainer(data, data.getVersionsCount() - 1, this.ps, session);
                PhysicalEntityData oldData = new PhysicalEntityData();
                data.copy(oldData);
                this.getLocalOperationContext(ref).setNewCtr(etc);
                this.getLocalOperationContext(ref).setOldCtr(oldCtr);
                for (EntityInterceptor interceptor : this.getEntityInterceptors((BaseEntityStorageWriteParameters)parameters)) {
                    log.debug("invoking onDelete(), interceptor=" + interceptor + ", etc=" + etc);
                    interceptor.onDelete(sessionCallback, etc);
                }
                data.setModified(etc.getModified());
                HashSet<Integer> versionsToRetain = new HashSet<Integer>();
                for (int n = oldData.getVersionsCount() - 1; n >= 0; --n) {
                    versionsToRetain.add(n);
                    try {
                        PhysicalVersionData versionData = LogicalEntityStorage.getVersion(oldData, n, this.ps, session);
                        LogicalEntityStorage.updateVersion(oldData, versionData);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        log.error("unable to load version " + n + " of entity container " + etc, (Throwable)e);
                    }
                }
                LogicalEntityStorage.filterAndSortVersions(oldData, versionsToRetain);
                data = null;
                ValueHolder errorHolder = new ValueHolder();
                this.sh.registerOperation(new DeleteEntityContainerOperation<E>(data, oldData, etc, this.getOldIndexes(etc, session), this.getOperationCompletedInterceptors(parameters.isIgnoreInterceptors()), this.sh.createSessionCallback(), (ValueHolder<Throwable>)errorHolder, this.getIndexClasses(etc.getEntityType()), new EntityOperationContextData(LogicalEntityStorage.context.get().globalOperationContext, LogicalEntityStorage.context.get().localOperationContext)));
                this.registerDeletedEntity(etc.getUid());
                this.sh.endUnitOfWork(logicalSession, true);
                if (errorHolder.getValue() != null) {
                    throw (Throwable)errorHolder.getValue();
                }
                log.debug("delete() END etc=" + etc);
                LogicalEntityStorage.context.get().localOperationContext.remove(ref);
            }
            catch (Throwable e) {
                try {
                    log.error(String.format("unable to delete entity %s: cls = %s, uid = %s", etc.getEntity().toString(), etc.getEntityType(), etc.getUid()), e);
                    throw new StorageException("unable to rollback entity", e);
                }
                catch (Throwable throwable) {
                    LogicalEntityStorage.context.get().localOperationContext.remove(ref);
                    if (updateGlobalContext) {
                        context.remove();
                    }
                    this.sh.cancelUnitOfWork(logicalSession);
                    Metrics.get().timingAndEvent("profiling.storage.entity.delete." + MiscUtil.getSimpleClassName((Class)etc.getEntityType()), timing);
                    ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("delete.%s", MiscUtil.getSimpleClassName((Class)etc.getEntityType())));
                    Profiler.get().updateTiming("storage.delete." + MiscUtil.getSimpleClassName((Class)etc.getEntityType()), timing, null);
                    throw throwable;
                }
            }
            if (updateGlobalContext) {
                context.remove();
            }
            this.sh.cancelUnitOfWork(logicalSession);
            Metrics.get().timingAndEvent("profiling.storage.entity.delete." + MiscUtil.getSimpleClassName((Class)etc.getEntityType()), timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("delete.%s", MiscUtil.getSimpleClassName((Class)etc.getEntityType())));
            Profiler.get().updateTiming("storage.delete." + MiscUtil.getSimpleClassName((Class)etc.getEntityType()), timing, null);
            MiscUtil.logTiming((long)timing, (String)("entity container deleted " + etc));
        }
        finally {
            if (this.sh.isSessionOpen()) {
                this.sh.addSessionLock(lock);
            } else {
                SessionsHelper.unlock(lock);
            }
            ctx.exit();
        }
    }

    private void registerDeletedEntity(String uid) {
        if (SessionsHelper.getCache() == null) {
            return;
        }
        SessionsHelper.getCache().put(uid, PhysicalStorageCache.nullObject);
    }

    public <E extends BaseEntity> ReferenceActualizationResult<E> actualizeReference(EntityReference<E> ref, EntityStorageActualizeParameters parameters) throws Exception {
        long timing = System.currentTimeMillis();
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        ReferenceActualizationResult result = new ReferenceActualizationResult();
        result.setTimestamp(new Date());
        EntityContainer<E> ctr = this.load(ref, (EntityStorageLoadParameters)parameters);
        if (ctr != null) {
            result.setReference(ctr.toReference());
        }
        ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("actualize.%s", MiscUtil.getSimpleClassName((Class)ref.getType())));
        return result;
    }

    public <E extends BaseEntity, T extends BaseEntity> ReferenceActualizationResult<T> actualizeNestedReference(NestedEntityReference<E, T> ref, EntityStorageActualizeParameters parameters) throws Exception {
        BaseEntity nestedEntity;
        long timing = System.currentTimeMillis();
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        ReferenceActualizationResult result = new ReferenceActualizationResult();
        result.setTimestamp(new Date());
        EntityContainer<E> ctr = this.load((EntityReference<E>)ref, (EntityStorageLoadParameters)parameters);
        if (ctr != null && (nestedEntity = EntityStorageHelper.findNestedEntity((BaseEntity)ctr.getEntity(), (String)ref.getNestedEntityUid(), (Class)ref.getNestedEntityType(), new HashSet())) != null) {
            result.setReference(new EntityReference());
            result.getReference().setCaption(nestedEntity.toString());
        }
        ProfilingUtils.monitorStacktrace((long)timing, (String)String.format("actualize.%s", MiscUtil.getSimpleClassName((Class)ref.getType())));
        return result;
    }

    public CacheDataModification<EntityReference<?>> getEntityDataModifications(Date timeStamp, Collection<String> classes) {
        return this.getEntityDataModifications(timeStamp, null, classes);
    }

    public CacheDataModification<EntityReference<?>> getEntityDataModifications(Date timeStampFrom, Date timeStampTo, Collection<String> classes) {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        if (timeStampFrom == null) {
            throw Xeption.forDeveloper((String)"timestamp is null", (Object[])new Object[0]);
        }
        Date timeStampCopy = timeStampTo == null ? new Date() : timeStampTo;
        log.debug(String.format("START getEntityDataModifications from %s to %s", timeStampFrom, timeStampCopy));
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork();
        try {
            CacheDataModification result = new CacheDataModification();
            result.setTimeStamp(new Date());
            if (!classes.isEmpty()) {
                ArrayList types = new ArrayList();
                for (String cls : classes) {
                    types.add(XSHelper.getClass((String)cls));
                }
                List<PhysicalEntityDataModification> modifications = this.ps.getEntityStorage().getEntityModifications(types, timeStampFrom, timeStampTo, sd.getSession());
                for (PhysicalEntityDataModification item : modifications) {
                    EntityReference ref = new EntityReference(item.getUid(), item.getEntityType(), null);
                    String[] groups = item.getGroups();
                    if (!PollingConfiguration.isNewPolling() && GroupsHandlerManager.isCachedByGroups(item.getEntityType())) {
                        EntityContainer etc = this.load(ref, new EntityStorageLoadParameters());
                        Collection groups2 = etc != null ? GroupsHandlerManager.getGroups((Object)etc.getEntity()) : null;
                        groups = groups2 != null ? groups2.toArray(new String[0]) : null;
                    }
                    result.getUpdatedReferences().put(new ModificationData((XSerializable)ref, groups), item.getModified());
                }
            }
            MiscUtil.logTiming((long)timing, (String)String.format("END getEntityDataModifications from %s to %s", timeStampFrom, timeStampCopy));
            CacheDataModification cacheDataModification = result;
            return cacheDataModification;
        }
        catch (Throwable e) {
            log.error(String.format("unable to get entity modifications: classes = %s, timestampFrom = %s, timestampTo = %s", classes, timeStampFrom, timeStampCopy), e);
            throw new StorageException("unable to rollback entity", e);
        }
        finally {
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.entity.modifications", timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)"getAECModifications");
            Profiler.get().updateTiming("storage.getAdvancedEntityModifications", timing, null);
        }
    }

    public <E extends BaseEntity> List<VersionInfo> getVersionInfos(EntityReference<E> ref) {
        if (DebugUtil.isThreadDebugEnabled()) {
            DebugUtil.logStackTrace();
        }
        long timing = System.currentTimeMillis();
        LogicalSession sd = this.sh.beginUnitOfWork();
        try {
            log.debug("getVersionInfos() BEGIN ref=" + ref);
            PhysicalEntityData<E> ctr = this.loadEntity(ref.getType(), ref.getUid(), null, false, sd.getSession());
            if (ctr == null) {
                throw new IllegalStateException("entity is absent in db");
            }
            List<PhysicalVersionMetadataData> versionsMetadata = this.ps.getEntityStorage().getVersionsMetadata(ref, sd.getSession());
            ArrayList<VersionInfo> result = new ArrayList<VersionInfo>();
            for (PhysicalVersionMetadataData item : versionsMetadata) {
                VersionInfo info = new VersionInfo(item.getUid());
                LogicalEntityStorage.updateInfo(info, item.getDataSource(), item.getVersionNotes());
                info.setCreated(item.getCreated());
                info.setModified(item.getModified());
                info.setCreatedBy(item.getCreatedBy());
                info.setModifiedBy(item.getModifiedBy());
                info.setVersionNumber(item.getVersionNumber());
                result.add(info);
            }
            result.sort(Comparator.comparingInt(VersionInfo::getVersionNumber));
            log.debug("getVersionInfos() END ref=" + ref);
            MiscUtil.logTiming((long)timing, (String)("version infos received " + ref));
            ArrayList<VersionInfo> arrayList = result;
            return arrayList;
        }
        catch (Throwable e) {
            log.error(String.format("unable to get versions metadata for entity %s: cls = %s, uid = %s", ref, ref.getType(), ref.getUid()), e);
            throw new StorageException("unable to rollback entity", e);
        }
        finally {
            this.sh.cancelUnitOfWork(sd);
            Metrics.get().timingAndEvent("profiling.storage.entity.versions." + MiscUtil.getSimpleClassName((Class)ref.getType()), timing);
            ProfilingUtils.monitorStacktrace((long)timing, (String)"getVersions");
            Profiler.get().updateTiming("storage.getVersionInfos", timing, null);
        }
    }

    private static <E extends BaseEntity> void toEntityContainer(EntityContainer<E> etc, PhysicalEntityData<E> data, int versionNumber, PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        PhysicalVersionData version = LogicalEntityStorage.getVersion(data, versionNumber, ps, session);
        etc.setUid(data.getUid());
        etc.setCreated(data.getCreated());
        etc.setModified(data.getModified());
        etc.setCreatedBy(data.getCreatedBy());
        etc.setModifiedBy(data.getModifiedBy());
        etc.setStatus(data.getStatus());
        etc.setUpdatePolicy(data.getUpdatePolicy());
        LogicalEntityStorage.setRevision(etc, data.getRevision());
        byte[] uncompressedXml = LogicalEntityStorage.getVersionDataAsUncompressedXml(data, versionNumber, -1, null, ps, session);
        IncidentsContext.setContextValue((String)"EntityType", (String)etc.getEntityType().getName());
        IncidentsContext.setContextValue((String)"ContainerUid", (String)etc.getUid());
        try {
            etc.getEntity().fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(uncompressedXml))).getDocumentElement());
        }
        catch (Throwable t) {
            String xmlData = uncompressedXml == null ? null : new String(uncompressedXml, StandardCharsets.UTF_8);
            log.error("unable to deserialize xml:\r\n " + xmlData, t);
            throw new StorageException("unable to deserialize xml: " + xmlData, t);
        }
        finally {
            IncidentsContext.clearContext();
        }
        etc.setVersionsCount(data.getVersionsCount());
        etc.getVersionInfo().setUid(version.getUid());
        etc.getVersionInfo().setCreated(MiscUtil.cloneDate((Date)version.getCreated()));
        etc.getVersionInfo().setModified(MiscUtil.cloneDate((Date)version.getModified()));
        etc.getVersionInfo().setCreatedBy(version.getCreatedBy());
        etc.getVersionInfo().setModifiedBy(version.getModifiedBy());
        etc.getVersionInfo().setVersionNumber(version.getVersionNumber());
        LogicalEntityStorage.updateInfo(etc.getVersionInfo(), version.getDataSource(), version.getVersionNotes());
        etc.getVersionInfo().setDataSize(version.getData().length);
    }

    public static void clearRevision(EntityContainer<?> etc) {
        LogicalEntityStorage.setRevision(etc, null);
    }

    protected static void setRevision(EntityContainer<?> etc, Long revision) {
        try {
            revisionField.set(etc, revision);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void updateInfo(VersionInfo versionInfo, String dataSource, String versionNotes) throws IllegalArgumentException, IllegalAccessException {
        dataSourceField.set(versionInfo, dataSource);
        versionNotesField.set(versionInfo, versionNotes);
    }

    public static boolean isDataSourceModified(VersionInfo versionInfo) throws IllegalArgumentException, IllegalAccessException {
        return dataSourceModifiedField.getBoolean(versionInfo);
    }

    private static boolean isVersionNotesModified(VersionInfo versionInfo) throws IllegalArgumentException, IllegalAccessException {
        return versionNotesModifiedField.getBoolean(versionInfo);
    }

    public static <E extends BaseEntity> EntityContainer<E> toEntityContainer(PhysicalEntityData<E> data, int versionNumber, PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        EntityContainer etc = new EntityContainer(data.getEntityType(), data.getUid());
        LogicalEntityStorage.toEntityContainer(etc, data, versionNumber, ps, session);
        return etc;
    }

    private static <E extends BaseEntity> void fromEntityContainer(EntityContainer<E> ctr, PhysicalEntityData<E> entityData, PhysicalStorage ps, PhysicalStorageSession session, boolean createNewVersion, PhysicalEntityData<E> restoreData) throws Throwable {
        HashSet<Integer> versionsToRetain = new HashSet<Integer>();
        boolean createVersion = createNewVersion || entityData.getVersionsCount() == 0;
        entityData.setUid(ctr.getUid());
        if (entityData.getCreated() == null) {
            entityData.setCreated(ctr.getCreated());
        }
        if (entityData.getCreatedBy() == null) {
            entityData.setCreatedBy(ctr.getCreatedBy());
        }
        entityData.setModified(ctr.getModified());
        entityData.setModifiedBy(ctr.getModifiedBy());
        entityData.setEntityType(ctr.getEntityType());
        entityData.setStatus(ctr.getStatus());
        entityData.setUpdatePolicy(ctr.getUpdatePolicy());
        ByteArrayOutputStream strm = new ByteArrayOutputStream();
        XSUtil.serialize((XSSerializable)ctr.getEntity(), (OutputStream)strm);
        byte[] data = strm.toByteArray();
        if (createVersion) {
            int versionsCount = entityData.getVersionsCount() + 1;
            versionsToRetain.add(versionsCount - 2);
            versionsToRetain.add(versionsCount - 1);
            entityData.setVersionsCount(versionsCount);
            ctr.setVersionsCount(versionsCount);
            PhysicalVersionData versionData = new PhysicalVersionData();
            versionData.setCreated(ctr.getVersionInfo().getCreated());
            versionData.setCreatedBy(ctr.getVersionInfo().getCreatedBy());
            versionData.setData(GZIPUtil.gzip((byte[])data));
            versionData.setDataFormat(DataFormat.XML_GZIPPED);
            versionData.setModified(ctr.getVersionInfo().getModified());
            versionData.setModifiedBy(ctr.getVersionInfo().getModifiedBy());
            versionData.setUid(ctr.getVersionInfo().getUid());
            versionData.setDataSource(LogicalEntityStorage.isDataSourceModified(ctr.getVersionInfo()) ? ctr.getVersionInfo().getDataSource() : null);
            versionData.setVersionNotes(LogicalEntityStorage.isVersionNotesModified(ctr.getVersionInfo()) ? ctr.getVersionInfo().getVersionNotes() : null);
            versionData.setVersionNumber(versionsCount - 1);
            LogicalEntityStorage.updateVersion(entityData, versionData);
            if (versionsCount > 2) {
                PhysicalVersionData prePrevVersionData = LogicalEntityStorage.getVersion(entityData, versionsCount - 3, ps, session);
                LogicalEntityStorage.updateVersion(entityData, prePrevVersionData);
                if (restoreData != null) {
                    PhysicalVersionData restoreVersion = new PhysicalVersionData();
                    prePrevVersionData.copy(restoreVersion);
                    LogicalEntityStorage.updateVersion(restoreData, restoreVersion);
                }
                byte[] vMinus2Data = LogicalEntityStorage.getVersionDataAsUncompressedXml(entityData, versionsCount - 2, -1, null, ps, session);
                prePrevVersionData.setData(GZIPUtil.gzip((byte[])DiffUtil.diff((byte[])vMinus2Data, (byte[])LogicalEntityStorage.getVersionDataAsUncompressedXml(entityData, versionsCount - 3, versionsCount - 2, vMinus2Data, ps, session))));
                prePrevVersionData.setDataFormat(DataFormat.DIFF_GZIPPED);
                versionsToRetain.add(versionsCount - 3);
            }
            LogicalEntityStorage.filterAndSortVersions(entityData, versionsToRetain);
            LogicalEntityStorage.updateVersionInfo(ctr, entityData, versionData);
            return;
        }
        if (ctr.getVersionInfo().getVersionNumber() == ctr.getVersionsCount() - 1) {
            int version2Number;
            PhysicalVersionData version2;
            versionsToRetain.add(ctr.getVersionInfo().getVersionNumber());
            PhysicalVersionData version = LogicalEntityStorage.getVersion(entityData, ctr.getVersionInfo().getVersionNumber(), ps, session);
            if (restoreData != null) {
                PhysicalVersionData restoreVersion = new PhysicalVersionData();
                version.copy(restoreVersion);
                LogicalEntityStorage.updateVersion(restoreData, restoreVersion);
            }
            if (ctr.getVersionInfo().getVersionNumber() > 0 && ((version2 = LogicalEntityStorage.getVersion(entityData, version2Number = ctr.getVersionInfo().getVersionNumber() - 1, ps, session)).getDataFormat() == DataFormat.DIFF || version2.getDataFormat() == DataFormat.DIFF_GZIPPED)) {
                if (restoreData != null) {
                    PhysicalVersionData restoreVersion2 = new PhysicalVersionData();
                    version2.copy(restoreVersion2);
                    LogicalEntityStorage.updateVersion(restoreData, restoreVersion2);
                }
                version2.setData(GZIPUtil.gzip((byte[])DiffUtil.diff((byte[])data, (byte[])LogicalEntityStorage.getVersionDataAsUncompressedXml(entityData, version2Number, -1, null, ps, session))));
                version2.setDataFormat(DataFormat.DIFF_GZIPPED);
                versionsToRetain.add(version2Number);
            }
            version.setCreated(ctr.getVersionInfo().getCreated());
            version.setCreatedBy(ctr.getVersionInfo().getCreatedBy());
            version.setData(GZIPUtil.gzip((byte[])data));
            version.setDataFormat(DataFormat.XML_GZIPPED);
            version.setModified(ctr.getVersionInfo().getModified());
            version.setModifiedBy(ctr.getVersionInfo().getModifiedBy());
            version.setUid(ctr.getVersionInfo().getUid());
            version.setDataSource(LogicalEntityStorage.isDataSourceModified(ctr.getVersionInfo()) ? ctr.getVersionInfo().getDataSource() : null);
            version.setVersionNotes(LogicalEntityStorage.isVersionNotesModified(ctr.getVersionInfo()) ? ctr.getVersionInfo().getVersionNotes() : null);
            LogicalEntityStorage.filterAndSortVersions(entityData, versionsToRetain);
            LogicalEntityStorage.updateVersionInfo(ctr, entityData, version);
            return;
        }
        versionsToRetain.add(ctr.getVersionInfo().getVersionNumber());
        PhysicalVersionData version = LogicalEntityStorage.getVersion(entityData, ctr.getVersionInfo().getVersionNumber(), ps, session);
        if (restoreData != null) {
            PhysicalVersionData restoreVersion = new PhysicalVersionData();
            version.copy(restoreVersion);
            LogicalEntityStorage.updateVersion(restoreData, restoreVersion);
        }
        byte[] vPlus1Data = LogicalEntityStorage.getVersionDataAsUncompressedXml(entityData, ctr.getVersionInfo().getVersionNumber() + 1, -1, null, ps, session);
        if (ctr.getVersionInfo().getVersionNumber() > 0) {
            PhysicalVersionData prevVersionData = LogicalEntityStorage.getVersion(entityData, ctr.getVersionInfo().getVersionNumber() - 1, ps, session);
            if (restoreData != null) {
                PhysicalVersionData restoreVersion = new PhysicalVersionData();
                prevVersionData.copy(restoreVersion);
                LogicalEntityStorage.updateVersion(restoreData, restoreVersion);
            }
            prevVersionData.setData(GZIPUtil.gzip((byte[])DiffUtil.diff((byte[])data, (byte[])LogicalEntityStorage.getVersionDataAsUncompressedXml(entityData, ctr.getVersionInfo().getVersionNumber() - 1, ctr.getVersionInfo().getVersionNumber() + 1, vPlus1Data, ps, session))));
            prevVersionData.setDataFormat(DataFormat.DIFF_GZIPPED);
            versionsToRetain.add(ctr.getVersionInfo().getVersionNumber() - 1);
        }
        if (ctr.getVersionInfo().getVersionNumber() == ctr.getVersionsCount() - 2) {
            version.setData(GZIPUtil.gzip((byte[])data));
            version.setDataFormat(DataFormat.XML_GZIPPED);
        } else {
            version.setData(GZIPUtil.gzip((byte[])DiffUtil.diff((byte[])vPlus1Data, (byte[])data)));
            version.setDataFormat(DataFormat.DIFF_GZIPPED);
        }
        version.setCreatedBy(ctr.getVersionInfo().getCreatedBy());
        version.setModifiedBy(ctr.getVersionInfo().getModifiedBy());
        version.setDataSource(LogicalEntityStorage.isDataSourceModified(ctr.getVersionInfo()) ? ctr.getVersionInfo().getDataSource() : null);
        version.setVersionNotes(LogicalEntityStorage.isVersionNotesModified(ctr.getVersionInfo()) ? ctr.getVersionInfo().getVersionNotes() : null);
        LogicalEntityStorage.updateVersion(entityData, version);
        LogicalEntityStorage.updateVersionInfo(ctr, entityData, version);
    }

    private static <E extends BaseEntity> void updateVersionInfo(EntityContainer<E> ctr, PhysicalEntityData<E> data, PhysicalVersionData versionData) {
        ctr.setCreated(data.getCreated());
        ctr.setModified(data.getModified());
        ctr.getVersionInfo().setUid(versionData.getUid());
        ctr.getVersionInfo().setCreated(versionData.getCreated());
        ctr.getVersionInfo().setModified(versionData.getModified());
        ctr.getVersionInfo().setCreatedBy(versionData.getCreatedBy());
        ctr.getVersionInfo().setModifiedBy(versionData.getModifiedBy());
        ctr.getVersionInfo().setVersionNumber(versionData.getVersionNumber());
        ctr.getVersionInfo().setDataSize(versionData.getData().length);
    }

    private static <E extends BaseEntity> void filterAndSortVersions(PhysicalEntityData<E> data, Set<Integer> versionsToRetain) {
        HashSet<Integer> existingVersions = new HashSet<Integer>();
        Iterator<PhysicalVersionData> it = data.getVersions().iterator();
        while (it.hasNext()) {
            PhysicalVersionData versionData = it.next();
            Integer versionNumber = versionData.getVersionNumber();
            if (existingVersions.contains(versionNumber) || !versionsToRetain.contains(versionNumber)) {
                it.remove();
            }
            existingVersions.add(versionNumber);
        }
        data.getVersions().sort(Comparator.comparingInt(PhysicalVersionMetadataData::getVersionNumber));
    }

    private static <E extends BaseEntity> PhysicalVersionData getVersion(PhysicalEntityData<E> entityData, int versionNumber, PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        Object object;
        if (versionNumber >= entityData.getVersionsCount()) {
            throw new IllegalArgumentException(String.format("entity %s:%s, versionsCount = %s, requested version = %s", MiscUtil.getSimpleClassName(entityData.getEntityType()), entityData.getUid(), entityData.getVersionsCount(), versionNumber));
        }
        for (PhysicalVersionData item : entityData.getVersions()) {
            if (item.getVersionNumber() != versionNumber) continue;
            return item;
        }
        PhysicalVersionData vd = null;
        if (SessionsHelper.getCache() != null && (object = SessionsHelper.getCache().get(entityData.getUid())) != null && object != PhysicalStorageCache.nullObject) {
            PhysicalEntityData cachedEntityData = (PhysicalEntityData)object;
            vd = LogicalEntityStorage.findVersionData(cachedEntityData, versionNumber);
        }
        if (vd == null) {
            vd = ps.getEntityStorage().getVersions(entityData, session, versionNumber).get(0);
        }
        LogicalEntityStorage.updateVersion(entityData, vd);
        return vd;
    }

    public static <E extends BaseEntity> byte[] getVersionDataAsUncompressedXml(PhysicalEntityData<E> data, int version, int anotherVersion, byte[] anotherVersionData, PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        try {
            PhysicalVersionData versionData = LogicalEntityStorage.getVersion(data, version, ps, session);
            if (versionData.getDataFormat() == null) {
                versionData.setDataFormat(DataFormat.XML);
            }
            switch (versionData.getDataFormat()) {
                case XML: {
                    return versionData.getData();
                }
                case XML_GZIPPED: {
                    return GZIPUtil.gunzip((byte[])versionData.getData());
                }
                case DIFF_GZIPPED: 
                case DIFF: {
                    byte[] patch = versionData.getDataFormat() == DataFormat.DIFF_GZIPPED ? GZIPUtil.gunzip((byte[])versionData.getData()) : versionData.getData();
                    return DiffUtil.patch((byte[])(version + 1 == anotherVersion ? anotherVersionData : LogicalEntityStorage.getVersionDataAsUncompressedXml(data, version + 1, anotherVersion, anotherVersionData, ps, session)), (byte[])patch);
                }
            }
            return null;
        }
        catch (Throwable t) {
            IncidentsHelper.addStackTraceElement((Throwable)t, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)"version", (String)Integer.toString(version))});
            throw t;
        }
    }

    private static <E extends BaseEntity> void rollbackTo(PhysicalEntityData<E> entityData, PhysicalEntityData<E> restoreData, int versionNumber, PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        int versionsCount = entityData.getVersionsCount();
        if (versionsCount == 0) {
            throw new IllegalArgumentException("entity data has no content");
        }
        if (versionNumber == 0 && versionsCount == 1) {
            return;
        }
        if (versionNumber < 0 || versionNumber >= versionsCount) {
            throw new IllegalArgumentException("invalid version number " + versionNumber);
        }
        HashSet<Integer> versionsToRetain = new HashSet<Integer>();
        versionsToRetain.add(versionNumber);
        HashSet<Integer> restoreVersions = new HashSet<Integer>();
        PhysicalVersionMetadataData lastVersionData = null;
        for (int n = versionsCount - 1; n >= versionNumber; --n) {
            PhysicalVersionData versionData = LogicalEntityStorage.getVersion(entityData, n, ps, session);
            PhysicalVersionData versionRestoreData = new PhysicalVersionData();
            versionData.copy(versionRestoreData);
            LogicalEntityStorage.updateVersion(entityData, versionData);
            restoreVersions.add(n);
            LogicalEntityStorage.updateVersion(restoreData, versionData);
            lastVersionData = versionData;
        }
        entityData.setVersionsCount(versionNumber + 1);
        byte[] versionDataAsUncompressedXml = LogicalEntityStorage.getVersionDataAsUncompressedXml(entityData, versionNumber, -1, null, ps, session);
        byte[] data = GZIPUtil.gzip((byte[])versionDataAsUncompressedXml);
        lastVersionData.setDataFormat(DataFormat.XML_GZIPPED);
        ((PhysicalVersionData)lastVersionData).setData(data);
        versionsToRetain.add(versionNumber);
        if (versionNumber > 0) {
            PhysicalVersionData prevVersion = LogicalEntityStorage.getVersion(entityData, versionNumber - 1, ps, session);
            PhysicalVersionData prevVersionRestoreData = new PhysicalVersionData();
            prevVersion.copy(prevVersionRestoreData);
            LogicalEntityStorage.updateVersion(restoreData, prevVersionRestoreData);
            prevVersion.setData(GZIPUtil.gzip((byte[])LogicalEntityStorage.getVersionDataAsUncompressedXml(entityData, versionNumber - 1, versionNumber, versionDataAsUncompressedXml, ps, session)));
            prevVersion.setDataFormat(DataFormat.XML_GZIPPED);
            LogicalEntityStorage.updateVersion(entityData, prevVersion);
            versionsToRetain.add(versionNumber - 1);
            restoreVersions.add(versionNumber - 1);
        }
        LogicalEntityStorage.filterAndSortVersions(entityData, versionsToRetain);
        LogicalEntityStorage.filterAndSortVersions(restoreData, restoreVersions);
    }

    private static <E extends BaseEntity> void updateVersion(PhysicalEntityData<E> entityData, PhysicalVersionData versionData) {
        entityData.getVersions().removeIf(physicalVersionData -> physicalVersionData.getVersionNumber() == versionData.getVersionNumber());
        entityData.getVersions().add(versionData);
    }

    Collection<EntityInterceptor> getEntityInterceptors(BaseEntityStorageWriteParameters parameters) {
        Map context;
        if (Environment.isTest() && (context = parameters.getContext()).containsKey(ENTITY_INTERCEPTORS)) {
            return (Collection)context.get(ENTITY_INTERCEPTORS);
        }
        if (parameters.isIgnoreInterceptors()) {
            return LogicalStorageRegistry.get().getEntityInterceptors().stream().filter(EntityInterceptor::isSystem).collect(Collectors.toList());
        }
        return LogicalStorageRegistry.get().getEntityInterceptors();
    }

    public LogicalEntityOperationContext getLocalOperationContext(EntityReference<?> ref) {
        if (context.get() == null) {
            throw new IllegalStateException("context is available only inside save or delete operation");
        }
        LogicalEntityOperationContext res = LogicalEntityStorage.context.get().localOperationContext.get(ref);
        if (res == null) {
            res = new LogicalEntityOperationContext();
            LogicalEntityStorage.context.get().localOperationContext.put(ref, res);
        }
        return res;
    }

    public Map<EntityReference<?>, LogicalEntityOperationContext> getAllLocalOperationContextEntries() {
        if (context.get() == null) {
            throw new IllegalStateException("context is available only inside save or delete operation");
        }
        return LogicalEntityStorage.context.get().localOperationContext;
    }

    public LogicalEntityOperationContext getGlobalOperationContext() {
        if (context.get() == null) {
            throw new IllegalStateException("context is available only inside save or delete operation");
        }
        return LogicalEntityStorage.context.get().globalOperationContext;
    }

    public boolean isGlobalOperationContextAvailable() {
        return context.get() != null;
    }

    public <E extends BaseEntity> void updateIndexes(SessionCallback ss, EntityContainer<E> etc, EntityContainer<E> oldContainer) throws Exception {
        this.updateIndexes(etc, oldContainer, false);
    }

    private <E extends BaseEntity> Collection<Class<?>> getIndexClasses(Class<E> cls) {
        if (cls == null) {
            return Collections.emptyList();
        }
        LinkedHashSet result = new LinkedHashSet();
        for (IndexHandler<E, EntityIndex<E>> handler : LogicalStorageRegistry.get().getIndexHandlers(cls)) {
            result.add(handler.getIndexClass());
        }
        return result;
    }

    private <E extends BaseEntity> Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> getOldIndexes(EntityContainer<E> ctr, PhysicalStorageSession session) throws Throwable {
        if (ctr == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Class indexClass : LogicalStorageRegistry.get().getIndexHandlers(ctr.getEntityType()).stream().map(IndexHandler::getIndexClass).distinct().collect(Collectors.toList())) {
            long timing = System.currentTimeMillis();
            this.update(result, indexClass, this.ps.getEntityStorage().getIndexes(indexClass, ctr.getUid(), session));
            Profiler.get().updateTiming("storage.old-indexes." + MiscUtil.getSimpleClassName((Class)indexClass), timing, null);
        }
        return result;
    }

    private <E extends BaseEntity> Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> getOldIndexes(EntityContainer<E> ctr, PhysicalStorageSession session, Collection<Class<? extends EntityIndex<E>>> indexClasses) throws Throwable {
        if (ctr == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Class indexClass : LogicalStorageRegistry.get().getIndexHandlers(ctr.getEntityType()).stream().map(IndexHandler::getIndexClass).distinct().collect(Collectors.toList())) {
            if (!indexClasses.contains(indexClass)) continue;
            long timing = System.currentTimeMillis();
            this.update(result, indexClass, this.ps.getEntityStorage().getIndexes(indexClass, ctr.getUid(), session));
            Profiler.get().updateTiming("storage.old-indexes." + MiscUtil.getSimpleClassName((Class)indexClass), timing, null);
        }
        return result;
    }

    private void update(Map<Class<?>, Map<EntityPhysicalStorage, List<?>>> map, Class<?> cls, Map<EntityPhysicalStorage, List<?>> lst) {
        Map result = map.computeIfAbsent(cls, k -> new HashMap());
        for (Map.Entry<EntityPhysicalStorage, List<?>> entry : lst.entrySet()) {
            List dest = result.computeIfAbsent(entry.getKey(), k -> new ArrayList());
            dest.addAll(entry.getValue());
        }
    }

    private <E extends BaseEntity> Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> getNewIndexes(EntityContainer<E> ctr) throws Exception {
        if (ctr == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        Date date = ((TimeService)Environment.getPublished(TimeService.class)).currentDate();
        for (IndexHandler<E, EntityIndex<E>> handler : LogicalStorageRegistry.get().getIndexHandlers(ctr.getEntityType())) {
            long timing = System.currentTimeMillis();
            ArrayList idxs = new ArrayList();
            handler.create(ctr, idxs);
            for (BaseIndexData baseIndexData : idxs) {
                baseIndexData.setModified(date);
                baseIndexData.setUid(UUID.randomUUID().toString());
                baseIndexData.setContainerUid(ctr.getUid());
                baseIndexData.setEntityType(ctr.getEntityType().getName());
                String rc = ctr.getEntity().toString();
                baseIndexData.setReferenceCaption(rc != null && rc.length() > 255 ? rc.substring(0, 252) + "..." : rc);
            }
            this.update(result, handler.getIndexClass(), Collections.singletonMap(null, idxs));
            Profiler.get().updateTiming("storage.index-builder." + MiscUtil.getSimpleClassName(handler.getIndexClass()), timing, null);
        }
        return result;
    }

    private <E extends BaseEntity> Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> getNewIndexes(EntityContainer<E> ctr, Collection<Class<? extends EntityIndex<E>>> indexClasses) throws Exception {
        if (ctr == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        Date date = ((TimeService)Environment.getPublished(TimeService.class)).currentDate();
        for (IndexHandler<E, EntityIndex<E>> handler : LogicalStorageRegistry.get().getIndexHandlers(ctr.getEntityType())) {
            Class indexClass = handler.getIndexClass();
            if (!indexClasses.contains(indexClass)) continue;
            long timing = System.currentTimeMillis();
            ArrayList idxs = new ArrayList();
            handler.create(ctr, idxs);
            for (BaseIndexData baseIndexData : idxs) {
                baseIndexData.setModified(date);
                baseIndexData.setUid(UUID.randomUUID().toString());
                baseIndexData.setContainerUid(ctr.getUid());
                baseIndexData.setEntityType(ctr.getEntityType().getName());
                String rc = ctr.getEntity().toString();
                baseIndexData.setReferenceCaption(rc != null && rc.length() > 255 ? rc.substring(0, 252) + "..." : rc);
            }
            this.update(result, indexClass, Collections.singletonMap(null, idxs));
            Profiler.get().updateTiming("storage.index-builder." + MiscUtil.getSimpleClassName(indexClass), timing, null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> void updateIndexes(EntityContainer<E> newContainer, EntityContainer<E> oldContainer, boolean skipInterceptors) {
        boolean updateGlobalContext = false;
        if (context.get() == null) {
            updateGlobalContext = true;
            context.set(new EntityOperationContextData());
            LogicalEntityStorage.context.get().globalOperationContext.setCreateNewVersion(false);
            LogicalEntityStorage.context.get().globalOperationContext.setNewCtr(newContainer);
            LogicalEntityStorage.context.get().globalOperationContext.setOldCtr(oldContainer);
        }
        NamedLock lock = SessionsHelper.lock(LogicalEntityStorage.getLockKey(newContainer));
        try {
            LogicalSession logicalSession = this.sh.beginUnitOfWork();
            try {
                Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> result = this.getNewIndexes(newContainer);
                Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIndexes = this.getOldIndexes(oldContainer, logicalSession.getSession());
                Collection<Class<?>> indexClasses = this.getIndexClasses(newContainer.getEntityType());
                List<EntityStorageOperationCompletedInterceptor> completedInterceptors = this.getOperationCompletedInterceptors(skipInterceptors);
                this.sh.registerOperation(new UpdateIndexesOperation<E>(newContainer, oldContainer, result, oldIndexes, indexClasses, completedInterceptors, this.sh.createSessionCallback(), (ValueHolder<Throwable>)new ValueHolder()));
            }
            catch (Throwable e) {
                log.error(String.format("unable to update indexes for %s", newContainer.getEntity().toString()), e);
                throw new StorageException("unable to update indexes", e);
            }
            finally {
                this.sh.endUnitOfWork(logicalSession, logicalSession.isOwn());
            }
        }
        finally {
            if (this.sh.isSessionOpen()) {
                this.sh.addSessionLock(lock);
            } else {
                SessionsHelper.unlock(lock);
            }
            if (updateGlobalContext) {
                context.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> void updateIndexes(EntityContainer<E> newContainer, EntityContainer<E> oldContainer, Collection<Class<? extends EntityIndex<E>>> indexClasses, boolean skipInterceptors) {
        Collection<Class<?>> allIndexClasses = this.getIndexClasses(newContainer.getEntityType());
        if (indexClasses.stream().noneMatch(allIndexClasses::contains)) {
            return;
        }
        boolean updateGlobalContext = false;
        if (context.get() == null) {
            updateGlobalContext = true;
            context.set(new EntityOperationContextData());
            LogicalEntityStorage.context.get().globalOperationContext.setCreateNewVersion(false);
            LogicalEntityStorage.context.get().globalOperationContext.setNewCtr(newContainer);
            LogicalEntityStorage.context.get().globalOperationContext.setOldCtr(oldContainer);
        }
        NamedLock lock = SessionsHelper.lock(LogicalEntityStorage.getLockKey(newContainer));
        try {
            LogicalSession logicalSession = this.sh.beginUnitOfWork();
            try {
                Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> result = this.getNewIndexes(newContainer, indexClasses);
                Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIndexes = this.getOldIndexes(oldContainer, logicalSession.getSession(), indexClasses);
                List<EntityStorageOperationCompletedInterceptor> completedInterceptors = this.getOperationCompletedInterceptors(skipInterceptors);
                this.sh.registerOperation(new UpdateIndexesOperation<E>(newContainer, oldContainer, result, oldIndexes, indexClasses, completedInterceptors, this.sh.createSessionCallback(), (ValueHolder<Throwable>)new ValueHolder()));
            }
            catch (Throwable e) {
                log.error(String.format("unable to update indexes for %s", newContainer.getEntity().toString()), e);
                throw new StorageException("unable to update indexes", e);
            }
            finally {
                this.sh.endUnitOfWork(logicalSession, logicalSession.isOwn());
            }
        }
        finally {
            if (this.sh.isSessionOpen()) {
                this.sh.addSessionLock(lock);
            } else {
                SessionsHelper.unlock(lock);
            }
            if (updateGlobalContext) {
                context.remove();
            }
        }
    }

    private <E extends BaseEntity, I extends EntityIndex<E>> Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> getOldIndex(EntityContainer<E> ctr, IndexHandler<E, I> handler, PhysicalStorageSession session) throws Throwable {
        if (ctr == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        long timing = System.currentTimeMillis();
        this.update(result, handler.getIndexClass(), this.ps.getEntityStorage().getIndexes(handler.getIndexClass(), ctr.getUid(), session));
        Profiler.get().updateTiming("storage.old-indexes." + MiscUtil.getSimpleClassName(handler.getIndexClass()), timing, null);
        return result;
    }

    private <E extends BaseEntity, I extends EntityIndex<E>> Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, I>>>> getNewIndex(EntityContainer<E> ctr, IndexHandler<E, I> handler) throws Exception {
        if (ctr == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        Date date = ((TimeService)Environment.getPublished(TimeService.class)).currentDate();
        long timing = System.currentTimeMillis();
        ArrayList idxs = new ArrayList();
        handler.create(ctr, idxs);
        for (BaseIndexData baseIndexData : idxs) {
            baseIndexData.setModified(date);
            baseIndexData.setUid(UUID.randomUUID().toString());
            baseIndexData.setContainerUid(ctr.getUid());
            baseIndexData.setEntityType(ctr.getEntityType().getName());
            String rc = ctr.getEntity().toString();
            baseIndexData.setReferenceCaption(rc != null && rc.length() > 255 ? rc.substring(0, 252) + "..." : rc);
        }
        this.update(result, handler.getIndexClass(), Collections.singletonMap(null, idxs));
        Profiler.get().updateTiming("storage.index-builder." + MiscUtil.getSimpleClassName(handler.getIndexClass()), timing, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> void updateIndex(EntityContainer<E> newContainer, EntityContainer<E> oldContainer, IndexHandler<E, EntityIndex<E>> handler, boolean skipInterceptors) {
        boolean updateGlobalContext = false;
        if (context.get() == null) {
            updateGlobalContext = true;
            context.set(new EntityOperationContextData());
            LogicalEntityStorage.context.get().globalOperationContext.setCreateNewVersion(false);
            LogicalEntityStorage.context.get().globalOperationContext.setNewCtr(newContainer);
            LogicalEntityStorage.context.get().globalOperationContext.setOldCtr(oldContainer);
        }
        NamedLock lock = SessionsHelper.lock(LogicalEntityStorage.getLockKey(newContainer));
        try {
            LogicalSession logicalSession = this.sh.beginUnitOfWork();
            try {
                Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> result = this.getNewIndex(newContainer, handler);
                this.sh.registerOperation(new UpdateIndexesOperation<E>(newContainer, oldContainer, result, this.getOldIndex(oldContainer, handler, logicalSession.getSession()), Collections.singleton(handler.getIndexClass()), this.getOperationCompletedInterceptors(skipInterceptors), this.sh.createSessionCallback(), (ValueHolder<Throwable>)new ValueHolder()));
            }
            catch (Throwable e) {
                log.error(String.format("unable to update indexes for %s", newContainer.getEntity().toString()), e);
                throw new StorageException("unable to update indexes", e);
            }
            finally {
                this.sh.endUnitOfWork(logicalSession, logicalSession.isOwn());
            }
        }
        finally {
            if (this.sh.isSessionOpen()) {
                this.sh.addSessionLock(lock);
            } else {
                SessionsHelper.unlock(lock);
            }
            if (updateGlobalContext) {
                context.remove();
            }
        }
    }

    public void maintain() {
        try {
            this.ps.maintain();
        }
        catch (Throwable e) {
            log.error("unable to maintain storage", e);
            throw new StorageException("unable to maintain storage", e);
        }
    }

    public <E extends BaseEntity> List<String> getEntityUids(Class<E> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreVoid, SortOrder sortOrder, Integer limit) throws Exception {
        LogicalSession sd = this.sh.beginUnitOfWork();
        try {
            if (log.isDebugEnabled()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
                log.debug(String.format("getting entity uids: cls = %s, startDate = %s, endDate = %s, useCreateDate = %s, ignoreVoid = %s, sortOrder = %s, limit = %s", cls, startDate == null ? null : sdf.format(startDate), endDate == null ? null : sdf.format(endDate), useCreateDate, ignoreVoid, sortOrder, limit));
            }
            List<String> result = this.ps.getEntityStorage().getEntityUids(cls, startDate, endDate, useCreateDate, ignoreVoid, sortOrder, limit, sd.getSession());
            if (log.isDebugEnabled()) {
                log.debug(String.format("got %s uids: %s", result.size(), result));
            }
            List<String> list = result;
            return list;
        }
        catch (Throwable e) {
            log.error(String.format("unable to get uids: cls = %s", MiscUtil.getSimpleClassName(cls)), e);
            throw new StorageException("unable to get uids", e);
        }
        finally {
            this.sh.cancelUnitOfWork(sd);
        }
    }

    public <E extends BaseEntity> void deleteAllEntities(Class<E> cls) {
        LogicalSession sd = this.sh.beginUnitOfWork();
        try {
            this.ps.getEntityStorage().deleteAllEntities(cls, sd.getSession());
            this.sh.endUnitOfWork(sd, true);
        }
        catch (Throwable e) {
            log.error(String.format("unable to delete all entities: cls = %s", MiscUtil.getSimpleClassName(cls)), e);
            throw new StorageException("unable delete all entities", e);
        }
        finally {
            this.sh.cancelUnitOfWork(sd);
        }
    }

    public <E extends BaseEntity, I extends EntityIndex<E>> void deleteAllIndexes(Class<I> cls) {
        LogicalSession sd = this.sh.beginUnitOfWork();
        try {
            this.ps.getEntityStorage().deleteAllIndexes(cls, sd.getSession());
            this.sh.endUnitOfWork(sd, true);
        }
        catch (Throwable e) {
            log.error(String.format("unable to delete all indexes: cls = %s", MiscUtil.getSimpleClassName(cls)), e);
            throw new StorageException("unable delete all indexes", e);
        }
        finally {
            this.sh.cancelUnitOfWork(sd);
        }
    }

    public static <E extends BaseEntity> String getLockKey(EntityContainer<E> etc) {
        return etc != null ? LockUtil.getLockKey(etc) : null;
    }

    public static <E extends BaseEntity> String getLockKey(EntityReference<E> ref) {
        return ref != null ? LockUtil.getLockKey(ref) : null;
    }

    private void checkSerialization(EntityContainer<?> ctr) {
        try {
            XUtil.fromBytes((byte[])XSUtil.toByteArray(ctr), (XSerializable)new EntityContainer());
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(String.format("entity ctr %s contains invalid symbols", ctr.getEntity()), e);
        }
    }

    private <E extends BaseEntity> void updatePhysicalStorageCache(PhysicalEntityData<E> data) throws Exception {
        if (SessionsHelper.getCache() == null) {
            return;
        }
        Object object = SessionsHelper.getCache().get(data.getUid());
        if (object == PhysicalStorageCache.nullObject || object == null) {
            SessionsHelper.getCache().put(data.getUid(), data);
            return;
        }
        PhysicalEntityData entityData = (PhysicalEntityData)object;
        PhysicalEntityData result = new PhysicalEntityData();
        data.copy(result);
        for (PhysicalVersionData cachedVersion : entityData.getVersions()) {
            PhysicalVersionData updatedVersion = LogicalEntityStorage.findVersionData(result, cachedVersion.getVersionNumber());
            if (updatedVersion != null) continue;
            result.getVersions().add(cachedVersion);
        }
        SessionsHelper.getCache().put(data.getUid(), result);
    }

    private <E extends BaseEntity> PhysicalEntityData<E> loadEntity(Class<E> entityType, String containerUid, Integer versionNumber, boolean noPhysicalStorageCache, PhysicalStorageSession session) throws Exception {
        if (SessionsHelper.getCache() == null) {
            return this.ps.getEntityStorage().loadEntity(entityType, containerUid, versionNumber, session);
        }
        Object object = SessionsHelper.getCache().get(containerUid);
        if (noPhysicalStorageCache || object == null) {
            PhysicalEntityData<E> actualEntity = this.ps.getEntityStorage().loadEntity(entityType, containerUid, versionNumber, session);
            SessionsHelper.getCache().put(containerUid, actualEntity == null ? PhysicalStorageCache.nullObject : actualEntity);
            return actualEntity;
        }
        if (object == PhysicalStorageCache.nullObject) {
            return null;
        }
        PhysicalEntityData cachedEntityData = (PhysicalEntityData)object;
        PhysicalVersionData versionData = LogicalEntityStorage.findVersionData(cachedEntityData, versionNumber);
        if (versionData != null) {
            PhysicalEntityData result = new PhysicalEntityData();
            ArrayList<PhysicalVersionData> versions = new ArrayList<PhysicalVersionData>(cachedEntityData.getVersions());
            cachedEntityData.getVersions().clear();
            cachedEntityData.copy(result);
            result.getVersions().add(versionData);
            cachedEntityData.getVersions().addAll(versions);
            return result;
        }
        PhysicalEntityData<E> actualEntity = this.ps.getEntityStorage().loadEntity(entityType, containerUid, versionNumber, session);
        for (PhysicalVersionData actualVersion : actualEntity.getVersions()) {
            PhysicalVersionData cachedVersion = LogicalEntityStorage.findVersionData(cachedEntityData, actualVersion.getVersionNumber());
            if (cachedVersion != null) continue;
            cachedEntityData.getVersions().add(actualVersion);
        }
        versionData = LogicalEntityStorage.findVersionData(cachedEntityData, versionNumber);
        PhysicalEntityData result = new PhysicalEntityData();
        ArrayList<PhysicalVersionData> versions = new ArrayList<PhysicalVersionData>(cachedEntityData.getVersions());
        cachedEntityData.getVersions().clear();
        cachedEntityData.copy(result);
        result.getVersions().add(versionData);
        cachedEntityData.getVersions().addAll(versions);
        return result;
    }

    private static <E extends BaseEntity> PhysicalVersionData findVersionData(PhysicalEntityData<E> object, Integer versionNumber) {
        for (PhysicalVersionData versionData : object.getVersions()) {
            if (versionNumber == null && versionData.getVersionNumber() == object.getVersionsCount() - 1) {
                return versionData;
            }
            if (versionNumber == null || versionNumber.intValue() != versionData.getVersionNumber()) continue;
            return versionData;
        }
        return null;
    }

    static {
        try {
            revisionField = EntityContainer.class.getDeclaredField("revision");
            revisionField.setAccessible(true);
            dataSourceField = VersionInfo.class.getDeclaredField("dataSource");
            dataSourceField.setAccessible(true);
            dataSourceModifiedField = VersionInfo.class.getDeclaredField("dataSourceModified");
            dataSourceModifiedField.setAccessible(true);
            versionNotesField = VersionInfo.class.getDeclaredField("versionNotes");
            versionNotesField.setAccessible(true);
            versionNotesModifiedField = VersionInfo.class.getDeclaredField("versionNotesModified");
            versionNotesModifiedField.setAccessible(true);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static interface OnLoadEntityUpdater {
        public <E extends BaseEntity> void update(EntityContainer<E> var1);
    }
}

