/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.entity.EntityOperationsHelper;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReduceVersionsCountOperation<E extends BaseEntity>
extends LogicalStorageOperation {
    private final Logger archiveLog = LoggerFactory.getLogger((String)(LogicalStorageOperation.class.getName() + ".ARCHIVE"));
    private final PhysicalEntityData<E> newData;
    private final PhysicalEntityData<E> oldData;

    ReduceVersionsCountOperation(PhysicalEntityData<E> newDat, PhysicalEntityData<E> oldDat) {
        if (newDat == null) {
            throw new IllegalArgumentException("new data is null");
        }
        this.newData = newDat;
        this.oldData = oldDat;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("reduce versions archive: save uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        this.deleteAllVersions(this.oldData, ps, session);
        ps.getEntityStorage().saveEntity(this.newData, this.oldData, session);
    }

    private void deleteAllVersions(PhysicalEntityData<E> data, PhysicalStorage ps, PhysicalStorageSession session) throws Exception {
        for (PhysicalVersionData vd : data.getVersions()) {
            if (vd.getVersionNumber() == data.getVersionsCount() - 1) continue;
            PhysicalEntityData restoreData = new PhysicalEntityData();
            data.copy(restoreData);
            restoreData.getVersions().clear();
            restoreData.getVersions().add(vd);
            ps.getEntityStorage().deleteVersion(data, vd.getVersionNumber(), restoreData, session);
        }
    }

    @Override
    public void commitFailed(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("reduce versions archive: commit failed uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("reduce versions archive: rollback uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        this.deleteAllVersions(this.newData, ps, session);
        ps.getEntityStorage().saveEntity(this.oldData, this.newData, session);
    }

    public String toString() {
        return String.format("%s: uid = %s", MiscUtil.getSimpleClassName(this.getClass()), this.newData.getUid());
    }
}

