/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.entity.EntityOperationsHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityOperationContextData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestoreEntityContainerOperation<E extends BaseEntity>
extends LogicalStorageOperation {
    private final Logger archiveLog = LoggerFactory.getLogger((String)(LogicalStorageOperation.class.getName() + ".ARCHIVE"));
    private final PhysicalEntityData<E> newData;
    private final PhysicalEntityData<E> oldData;
    private final EntityContainer<E> newContainer;
    private final List<EntityStorageOperationCompletedInterceptor> operationCompleteInterceptors;
    private final Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> newIndexes;
    private final SessionCallback callback;
    private final ValueHolder<Throwable> errorHolder;
    private final Collection<Class<?>> indexClasses;
    private final EntityOperationContextData contextData;

    RestoreEntityContainerOperation(PhysicalEntityData<E> newDat, PhysicalEntityData<E> oldDat, EntityContainer<E> newCtr, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> newIdx, List<EntityStorageOperationCompletedInterceptor> interceptors, SessionCallback clb, ValueHolder<Throwable> holder, Collection<Class<?>> classes, EntityOperationContextData context) {
        this.newData = newDat;
        this.oldData = oldDat;
        this.newContainer = newCtr;
        this.operationCompleteInterceptors = interceptors;
        this.newIndexes = newIdx;
        this.callback = clb;
        this.errorHolder = holder;
        this.indexClasses = classes;
        this.contextData = context;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("restore archive: save uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        ps.getEntityStorage().saveEntity(this.newData, this.oldData, session);
        EntityOperationsHelper.createIndexes(this.newContainer.getUid(), this.newIndexes, ps, session);
        EntityOperationsHelper.addEntityCallback(this.callback, this.operationCompleteInterceptors, new EntityOperationsHelper.EntityInterceptorCallback(){

            @Override
            public void execute(EntityStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterRestore(RestoreEntityContainerOperation.this.callback, RestoreEntityContainerOperation.this.newContainer, EntityOperationsHelper.toList(RestoreEntityContainerOperation.this.newIndexes));
            }
        }, this.errorHolder);
    }

    @Override
    public void commitFailed(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("restore archive: commit failed uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.oldData.getEntityType())) {
            this.archiveLog.debug("restore archive: rollback uid: " + this.oldData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        EntityOperationsHelper.deleteIndexes(this.indexClasses, this.newContainer.getUid(), this.newIndexes, ps, session);
        ps.getEntityStorage().saveEntity(this.oldData, this.newData, session);
        EntityOperationsHelper.addEntityCallback(this.callback, this.operationCompleteInterceptors, new EntityOperationsHelper.EntityInterceptorCallback(){

            @Override
            public void execute(EntityStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterDelete(RestoreEntityContainerOperation.this.callback, RestoreEntityContainerOperation.this.newContainer, RestoreEntityContainerOperation.this.contextData);
            }
        }, this.errorHolder);
    }
}

