/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityStatus;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.entity.EntityOperationsHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityOperationContextData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RollbackEntityContainerOperation<E extends BaseEntity>
extends LogicalStorageOperation {
    private final Logger archiveLog = LoggerFactory.getLogger((String)(LogicalStorageOperation.class.getName() + ".ARCHIVE"));
    private final PhysicalEntityData<E> newData;
    private final PhysicalEntityData<E> oldData;
    private final EntityContainer<E> newContainer;
    private final EntityContainer<E> oldContainer;
    private final List<EntityStorageOperationCompletedInterceptor> operationCompleteInterceptors;
    private final Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> newIndexes;
    private final Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIndexes;
    private final SessionCallback callback;
    private final ValueHolder<Throwable> errorHolder;
    private final Collection<Class<?>> indexClasses;
    private final EntityOperationContextData contextData;

    RollbackEntityContainerOperation(PhysicalEntityData<E> newDat, PhysicalEntityData<E> oldDat, EntityContainer<E> newCtr, EntityContainer<E> oldCtr, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> newIdx, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIdx, List<EntityStorageOperationCompletedInterceptor> interceptors, SessionCallback clb, ValueHolder<Throwable> holder, Collection<Class<?>> classes, EntityOperationContextData context) {
        this.newData = newDat;
        this.oldData = oldDat;
        this.newContainer = newCtr;
        this.oldContainer = oldCtr;
        this.operationCompleteInterceptors = interceptors;
        this.newIndexes = newIdx;
        this.oldIndexes = oldIdx;
        this.callback = clb;
        this.errorHolder = holder;
        this.indexClasses = classes;
        this.contextData = context;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("rollback archive: save uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        for (int n = this.oldData.getVersionsCount() - 2; n > this.newData.getVersionsCount() - 1 && n >= 0; --n) {
            PhysicalVersionData restoreVersionData = null;
            for (PhysicalVersionData item : this.oldData.getVersions()) {
                if (item.getVersionNumber() != n) continue;
                restoreVersionData = item;
                break;
            }
            PhysicalEntityData restoreEntityData = new PhysicalEntityData();
            this.oldData.copy(restoreEntityData);
            restoreEntityData.getVersions().clear();
            restoreEntityData.setVersionsCount(n + 1);
            if (restoreVersionData != null) {
                restoreEntityData.getVersions().add(restoreVersionData);
            }
            PhysicalEntityData correctedNewData = new PhysicalEntityData();
            this.newData.copy(correctedNewData);
            correctedNewData.setVersionsCount(n + 1);
            ps.getEntityStorage().deleteVersion(correctedNewData, n, restoreEntityData, session);
        }
        if (this.oldData.getStatus() != EntityStatus.VOID) {
            EntityOperationsHelper.deleteIndexes(this.indexClasses, this.newContainer.getUid(), this.oldIndexes, ps, session);
        }
        ps.getEntityStorage().saveEntity(this.newData, this.oldData, session);
        EntityOperationsHelper.createIndexes(this.newContainer.getUid(), this.newIndexes, ps, session);
        EntityOperationsHelper.addEntityCallback(this.callback, this.operationCompleteInterceptors, new EntityOperationsHelper.EntityInterceptorCallback(){

            @Override
            public void execute(EntityStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterRollback(RollbackEntityContainerOperation.this.callback, RollbackEntityContainerOperation.this.newContainer, EntityOperationsHelper.toList(RollbackEntityContainerOperation.this.newIndexes));
            }
        }, this.errorHolder);
    }

    @Override
    public void commitFailed(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("rollback archive: commit failed uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("rollback archive: rollback uid: " + this.oldData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        EntityOperationsHelper.deleteIndexes(this.indexClasses, this.newContainer.getUid(), this.oldIndexes, ps, session);
        ps.getEntityStorage().saveEntity(this.oldData, this.newData, session);
        if (this.oldData.getStatus() != EntityStatus.VOID) {
            EntityOperationsHelper.createIndexes(this.newContainer.getUid(), this.oldIndexes, ps, session);
            EntityOperationsHelper.addEntityCallback(this.callback, this.operationCompleteInterceptors, new EntityOperationsHelper.EntityInterceptorCallback(){

                @Override
                public void execute(EntityStorageOperationCompletedInterceptor interceptor) throws Throwable {
                    interceptor.afterSave(RollbackEntityContainerOperation.this.callback, RollbackEntityContainerOperation.this.oldContainer, EntityOperationsHelper.toList(RollbackEntityContainerOperation.this.oldIndexes), false, RollbackEntityContainerOperation.this.contextData);
                }
            }, this.errorHolder);
            return;
        }
        EntityOperationsHelper.addEntityCallback(this.callback, this.operationCompleteInterceptors, new EntityOperationsHelper.EntityInterceptorCallback(){

            @Override
            public void execute(EntityStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterDelete(RollbackEntityContainerOperation.this.callback, RollbackEntityContainerOperation.this.newContainer, RollbackEntityContainerOperation.this.contextData);
            }
        }, this.errorHolder);
    }
}

