/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.entity.EntityOperationsHelper;
import com.gridnine.xtrip.server.db.storage.entity.LogicalEntityStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityOperationContextData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SaveEntityContainerOperation<E extends BaseEntity>
extends LogicalStorageOperation {
    private final Logger archiveLog = LoggerFactory.getLogger((String)(LogicalStorageOperation.class.getName() + ".ARCHIVE"));
    protected final PhysicalEntityData<E> newData;
    protected final PhysicalEntityData<E> oldData;
    protected final EntityContainer<E> newContainer;
    private final EntityContainer<E> oldContainer;
    private final List<EntityStorageOperationCompletedInterceptor> operationCompleteInterceptors;
    private final Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> newIndexes;
    private final Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIndexes;
    private final SessionCallback callback;
    private final ValueHolder<Throwable> errorHolder;
    private final Collection<Class<?>> indexClasses;
    private final boolean withCheckPoint;
    private final EntityOperationContextData contextData;

    SaveEntityContainerOperation(PhysicalEntityData<E> newDat, PhysicalEntityData<E> oldDat, EntityContainer<E> newCtr, EntityContainer<E> oldCtr, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> newIdx, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIdx, List<EntityStorageOperationCompletedInterceptor> interceptors, SessionCallback clb, ValueHolder<Throwable> holder, boolean checkPoint, Collection<Class<?>> classes, EntityOperationContextData context) {
        if (newDat == null) {
            throw new IllegalArgumentException("new data is null");
        }
        this.newData = newDat;
        this.oldData = oldDat;
        this.newContainer = newCtr;
        if (newCtr == null) {
            throw new IllegalArgumentException("new container is null");
        }
        this.oldContainer = oldCtr;
        this.operationCompleteInterceptors = interceptors;
        this.newIndexes = newIdx;
        this.oldIndexes = oldIdx;
        this.callback = clb;
        this.errorHolder = holder;
        this.withCheckPoint = checkPoint;
        this.indexClasses = classes;
        this.contextData = context;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("save archive: save uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        ps.getEntityStorage().saveEntity(this.newData, this.oldData, session);
        if (this.newIndexes != null) {
            EntityOperationsHelper.deleteIndexes(this.indexClasses, this.newContainer.getUid(), this.oldIndexes, ps, session);
            EntityOperationsHelper.createIndexes(this.newContainer.getUid(), this.newIndexes, ps, session);
        }
        EntityOperationsHelper.addEntityCallback(this.callback, this.operationCompleteInterceptors, new EntityOperationsHelper.EntityInterceptorCallback(){

            @Override
            public void execute(EntityStorageOperationCompletedInterceptor interceptor) throws Throwable {
                interceptor.afterSave(SaveEntityContainerOperation.this.callback, SaveEntityContainerOperation.this.newContainer, EntityOperationsHelper.toList(SaveEntityContainerOperation.this.newIndexes != null ? SaveEntityContainerOperation.this.newIndexes : SaveEntityContainerOperation.this.oldIndexes), SaveEntityContainerOperation.this.withCheckPoint, SaveEntityContainerOperation.this.contextData);
            }
        }, this.errorHolder);
    }

    @Override
    public void commitFailed(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("save archive: commit failed archive uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        LogicalEntityStorage.setRevision(this.newContainer, this.oldData != null ? this.oldData.getRevision() : 0L);
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        if (EntityOperationsHelper.isArchivedBookingClass(this.newData.getEntityType())) {
            this.archiveLog.debug("save archive: rollback (" + (this.oldData == null ? "delete&save" : "save") + ") archive uid: " + this.newData.getUid() + ", storage: " + MiscUtil.getSimpleClassName(ps.getClass()));
        }
        if (this.newIndexes != null) {
            EntityOperationsHelper.deleteIndexes(this.indexClasses, this.newContainer.getUid(), this.oldIndexes, ps, session);
        }
        if (this.oldData == null) {
            ps.getEntityStorage().deleteEntity(this.newData, session);
            EntityOperationsHelper.addEntityCallback(this.callback, this.operationCompleteInterceptors, new EntityOperationsHelper.EntityInterceptorCallback(){

                @Override
                public void execute(EntityStorageOperationCompletedInterceptor interceptor) throws Throwable {
                    interceptor.afterDelete(SaveEntityContainerOperation.this.callback, SaveEntityContainerOperation.this.newContainer, SaveEntityContainerOperation.this.contextData);
                }
            }, this.errorHolder);
            return;
        }
        ps.getEntityStorage().saveEntity(this.oldData, this.newData, session);
        if (this.newIndexes != null) {
            EntityOperationsHelper.createIndexes(this.newContainer.getUid(), this.oldIndexes, ps, session);
        }
        EntityOperationsHelper.addEntityCallback(this.callback, this.operationCompleteInterceptors, new EntityOperationsHelper.EntityInterceptorCallback(){

            @Override
            public void execute(EntityStorageOperationCompletedInterceptor interceptor) throws Throwable {
                if (SaveEntityContainerOperation.this.oldData.getVersionsCount() != SaveEntityContainerOperation.this.newData.getVersionsCount()) {
                    interceptor.afterRollback(SaveEntityContainerOperation.this.callback, SaveEntityContainerOperation.this.oldContainer, EntityOperationsHelper.toList(SaveEntityContainerOperation.this.oldIndexes));
                    return;
                }
                interceptor.afterSave(SaveEntityContainerOperation.this.callback, SaveEntityContainerOperation.this.oldContainer, EntityOperationsHelper.toList(SaveEntityContainerOperation.this.oldIndexes), false, SaveEntityContainerOperation.this.contextData);
            }
        }, this.errorHolder);
    }

    public String toString() {
        return String.format("%s: entity = %s", MiscUtil.getSimpleClassName(this.getClass()), this.newContainer == null ? null : this.newContainer.getEntityType());
    }
}

