/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.entity;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageOperation;
import com.gridnine.xtrip.server.db.storage.entity.EntityOperationsHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityStorageOperationCompletedInterceptor;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class UpdateIndexesOperation<E extends BaseEntity>
extends LogicalStorageOperation {
    private final Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> newIndexes;
    private final Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIndexes;
    private final Collection<Class<?>> indexClasses;
    private final EntityContainer<E> newContainer;
    private final EntityContainer<E> oldContainer;
    private final List<EntityStorageOperationCompletedInterceptor> operationCompletedInterceptors;
    private final SessionCallback callback;
    private final ValueHolder<Throwable> errorHolder;

    UpdateIndexesOperation(EntityContainer<E> newCtr, EntityContainer<E> oldCtr, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> newIdxs, Map<Class<?>, Map<EntityPhysicalStorage, List<BaseIndexData<E, EntityIndex<E>>>>> oldIdxs, Collection<Class<?>> idxs, List<EntityStorageOperationCompletedInterceptor> intsp, SessionCallback clb, ValueHolder<Throwable> holder) {
        this.newIndexes = newIdxs;
        this.oldIndexes = oldIdxs;
        this.indexClasses = idxs;
        this.newContainer = newCtr;
        this.oldContainer = oldCtr;
        this.operationCompletedInterceptors = intsp;
        this.callback = clb;
        this.errorHolder = holder;
    }

    @Override
    public void execute(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        EntityOperationsHelper.deleteIndexes(this.indexClasses, this.newContainer.getUid(), this.oldIndexes, ps, session);
        EntityOperationsHelper.createIndexes(this.newContainer.getUid(), this.newIndexes, ps, session);
        EntityOperationsHelper.addIndexUpdateCallback(this.callback, this.operationCompletedInterceptors, this.newIndexes, this.newContainer, this.errorHolder);
    }

    @Override
    public void rollback(PhysicalStorage ps, PhysicalStorageSession session) throws Throwable {
        EntityOperationsHelper.deleteIndexes(this.indexClasses, this.newContainer.getUid(), this.newIndexes, ps, session);
        if (this.oldContainer == null) {
            return;
        }
        EntityOperationsHelper.createIndexes(this.newContainer.getUid(), this.oldIndexes, ps, session);
        EntityOperationsHelper.addIndexUpdateCallback(this.callback, this.operationCompletedInterceptors, this.oldIndexes, this.oldContainer, this.errorHolder);
    }

    public String toString() {
        return String.format("%s: entity = %s", MiscUtil.getSimpleClassName(this.getClass()), this.newContainer == null ? null : this.newContainer.getEntityType());
    }
}

