/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.EntityStatus;
import com.gridnine.xtrip.common.search.FilterQuery;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.cache.asset.ModifiedObjectReferenceData;
import com.gridnine.xtrip.server.db.PollingConfiguration;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.common.SearchQueryHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateSessionManager;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.DataFormat;
import com.gridnine.xtrip.server.db.storage.model.EntityData;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.IndexDataArray;
import com.gridnine.xtrip.server.db.storage.model.IndexHandler;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalEntityDataModification;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalVersionMetadataData;
import com.gridnine.xtrip.server.db.storage.model.VersionData;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.hibernate.Criteria;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.SQLGrammarException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayHibernateEntityStorage
implements EntityPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Logger updateLog = LoggerFactory.getLogger((String)(this.getClass().getName() + ".UPDATE"));
    private final boolean cleanupBlobs;
    private final Map<String, Set<String>> indexesWithBlobls = new HashMap<String, Set<String>>();
    private String storageId;
    private final Comparator<PhysicalVersionData> versionsDataComparator = Comparator.comparingInt(PhysicalVersionMetadataData::getVersionNumber);
    private static final Pattern LODE = Pattern.compile("ERROR: large object \\d+ does not exist");
    private final Map<Class<?>, Class<?>> data2Array = new ConcurrentHashMap();

    public void setStorageId(String value) {
        this.storageId = value;
    }

    public ArrayHibernateEntityStorage(boolean cleanupIndexBlobs) {
        this.cleanupBlobs = cleanupIndexBlobs;
        for (IndexType item : MetaRegistry.get().getIndexes().values()) {
            for (IndexProperty property : item.getProperties().values()) {
                if (!"byte[]".equals(property.getType())) continue;
                Set set = this.indexesWithBlobls.computeIfAbsent(property.getId(), k -> new HashSet());
                set.add(property.getId());
            }
        }
    }

    Session getSession(PhysicalStorageSession session) {
        return ((HibernateSessionManager.HibernatePhysicalStorageSession)session).getSession();
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> searchEntity(Class<I> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        IndexHandler indexHandler = LogicalStorageRegistry.get().getIndexHandler(cls);
        SearchResult searchResult = SearchQueryHelper.execute(this.getSession(session), this.getDataClass(indexHandler.getDataClass()), indexHandler.getIndexClass(), query, true);
        SearchResult result = new SearchResult();
        result.setTimestamp(searchResult.getTimestamp());
        result.setTotalCount(searchResult.getTotalCount());
        List data = searchResult.getData();
        for (BaseIndexData indexData : data) {
            result.getData().add(indexData.toIndex(query.getPreferredProperties()));
        }
        for (FilterQuery filter : query.getFilters()) {
            result.getFilter(filter.getProperty()).addAll(searchResult.getFilter(filter.getProperty()));
        }
        return result;
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult searchEntity(Class<I> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        ProjectionResult result = new ProjectionResult();
        for (Projection prj : query.getProjections()) {
            if (prj instanceof Projection.RowCountProjection) {
                result.getAliases().add(((Projection.RowCountProjection)prj).getAlias());
                continue;
            }
            if (!(prj instanceof Projection.SimpleProjection)) continue;
            result.getAliases().add(((Projection.SimpleProjection)prj).getAlias());
        }
        if (result.getAliases().isEmpty()) {
            this.log.warn("no resulting projections defined in query " + query);
            return result;
        }
        IndexHandler indexHandler = LogicalStorageRegistry.get().getIndexHandler(cls);
        List<?> data = SearchQueryHelper.execute(this.getSession(session), this.getDataClass(indexHandler.getDataClass()), cls, query, true);
        if (result.getAliases().size() == 1) {
            String alias = (String)result.getAliases().get(0);
            for (Object obj : data) {
                result.getData().add(Collections.singletonMap(alias, obj));
            }
        } else {
            for (Object obj : data) {
                Object[] arr = (Object[])obj;
                if (arr.length != result.getAliases().size()) {
                    throw new IllegalStateException("illegal size of projection data");
                }
                HashMap map = new HashMap();
                for (int i = 0; i < arr.length; ++i) {
                    map.put(result.getAliases().get(i), arr[i]);
                }
                result.getData().add(map);
            }
        }
        return result;
    }

    @Override
    public <E extends BaseEntity> PhysicalEntityData<E> loadEntity(Class<E> cls, String uid, Integer versionNumber, PhysicalStorageSession session) throws Exception {
        EntityData entityData = this.findData(this.getSession(session), cls, uid);
        if (entityData == null) {
            return null;
        }
        PhysicalEntityData result = new PhysicalEntityData();
        result.setCreated(MiscUtil.cloneDate((Date)entityData.getCreated()));
        result.setCreatedBy(entityData.getCreatedBy());
        result.setEntityType(XHelper.getClass((String)entityData.getEntityType()));
        result.setModified(MiscUtil.cloneDate((Date)entityData.getModified()));
        result.setModifiedBy(entityData.getModifiedBy());
        result.setStatus(entityData.getStatus());
        result.setUid(entityData.getUid());
        result.setUpdatePolicy(entityData.getUpdatePolicy());
        result.setRevision(entityData.getRevision() != null ? entityData.getRevision() : 0L);
        result.setVersionsCount(entityData.getVersionsCount());
        result.getContext().put(entityData.getUid(), entityData);
        if (versionNumber == null || versionNumber == entityData.getVersionsCount() - 1) {
            PhysicalVersionData version = this.fromLastVersion(entityData);
            result.getVersions().add(version);
            return result;
        }
        VersionData versionData = this.findVersion(cls, uid, versionNumber, session);
        PhysicalVersionData version = this.fromVersion(versionData);
        result.getVersions().add(version);
        return result;
    }

    private <E extends BaseEntity> VersionData findVersion(Class<E> cls, String uid, int versionNumber, PhysicalStorageSession session) throws Exception {
        List<PhysicalVersionMetadataData> versionsMetadata = this.getVersionsMetadata(uid, session, true);
        String versionUid = null;
        for (PhysicalVersionMetadataData item : versionsMetadata) {
            if (item.getVersionNumber() != versionNumber) continue;
            versionUid = item.getUid();
            break;
        }
        if (versionUid == null) {
            throw new Exception(this.composeInvalidVersionErrorMessage(cls, uid, versionNumber));
        }
        return (VersionData)this.getSession(session).get(VersionData.class, versionUid);
    }

    private <E extends BaseEntity> String composeInvalidVersionErrorMessage(Class<E> cls, String uid, int versionNumber) {
        String clazz = cls != null ? cls.getName() : "?";
        String id = uid == null ? "?" : uid;
        return String.format("Could not load version. Version number=%d, UID='%s', class='%s'", versionNumber, id, clazz);
    }

    private PhysicalVersionData fromVersion(VersionData versionData) {
        PhysicalVersionData version = new PhysicalVersionData();
        version.setCreated(MiscUtil.cloneDate((Date)versionData.getCreated()));
        version.setCreatedBy(versionData.getCreatedBy());
        version.setData(versionData.getData());
        version.setDataFormat(versionData.getDataFormat());
        if (version.getDataFormat() == null) {
            version.setDataFormat(DataFormat.XML);
        }
        version.setDataSource(versionData.getDataSource());
        version.setModified(MiscUtil.cloneDate((Date)versionData.getModified()));
        version.setModifiedBy(versionData.getModifiedBy());
        version.setUid(versionData.getUid());
        version.setVersionNotes(versionData.getVersionNotes());
        version.setVersionNumber(versionData.getVersionNumber());
        return version;
    }

    private PhysicalVersionData fromLastVersion(EntityData entityData) {
        PhysicalVersionData version = new PhysicalVersionData();
        version.setCreated(MiscUtil.cloneDate((Date)entityData.getLastVersionCreated()));
        version.setCreatedBy(entityData.getLastVersionCreatedBy());
        version.setData(entityData.getLastVersionData());
        version.setDataFormat(entityData.getLastVersionDataFormat());
        if (version.getDataFormat() == null) {
            version.setDataFormat(DataFormat.XML);
        }
        version.setDataSource(entityData.getLastVersionDataSource());
        version.setModified(MiscUtil.cloneDate((Date)entityData.getLastVersionModified()));
        version.setModifiedBy(entityData.getLastVersionModifiedBy());
        version.setUid(entityData.getLastVersionUid());
        version.setVersionNotes(entityData.getLastVersionNotes());
        version.setVersionNumber(entityData.getVersionsCount() - 1);
        return version;
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionData> getVersions(PhysicalEntityData<E> entityData, PhysicalStorageSession session, int ... versionNumbers) throws Exception {
        if (versionNumbers.length == 0) {
            return Collections.emptyList();
        }
        LinkedList<PhysicalVersionData> result = new LinkedList<PhysicalVersionData>();
        EntityData data = (EntityData)entityData.getContext().get(entityData.getUid());
        LinkedList<Integer> versionsList = new LinkedList<Integer>();
        for (int vn : versionNumbers) {
            Integer iv = vn;
            if (versionsList.contains(iv)) continue;
            versionsList.add(iv);
        }
        Collections.sort(versionsList);
        if (versionsList.contains(entityData.getVersionsCount() - 1)) {
            if (data == null) {
                data = this.findData(this.getSession(session), entityData.getEntityType(), entityData.getUid());
                if (data == null) {
                    throw new IllegalStateException(String.format("tried to get version for non-existent entity %s", entityData.getUid()));
                }
            } else {
                data = (EntityData)this.getSession(session).merge((Object)data);
            }
            result.add(this.fromLastVersion(data));
            versionsList.remove((Object)(entityData.getVersionsCount() - 1));
        }
        List<PhysicalVersionMetadataData> metadata = this.getVersionsMetadata(entityData.getUid(), session, true);
        for (PhysicalVersionMetadataData md : metadata) {
            if (!versionsList.contains(md.getVersionNumber())) continue;
            VersionData vd = (VersionData)this.getSession(session).get(VersionData.class, (Serializable)((Object)md.getUid()));
            if (vd == null) {
                throw new IllegalStateException(String.format("unable to load version %s for entity %s with uid %s", Integer.toString(md.getVersionNumber()), MiscUtil.getSimpleClassName(entityData.getEntityType()), entityData.getUid()));
            }
            result.add(this.fromVersion(vd));
            versionsList.remove((Object)md.getVersionNumber());
        }
        if (!versionsList.isEmpty()) {
            throw new IllegalArgumentException(String.format("versions %s for entity %s with uid %s is absent", versionsList, MiscUtil.getSimpleClassName(entityData.getEntityType()), entityData.getUid()));
        }
        result.sort(this.versionsDataComparator);
        return result;
    }

    @Override
    public <E extends BaseEntity> List<PhysicalVersionMetadataData> getVersionsMetadata(EntityReference<E> ref, PhysicalStorageSession session) throws Exception {
        return this.getVersionsMetadata(ref.getUid(), session, false);
    }

    private List<PhysicalVersionMetadataData> getVersionsMetadata(String containerUid, PhysicalStorageSession session, boolean ignoreLastVersion) throws Exception {
        PhysicalVersionMetadataData info;
        Query query;
        String queryStr;
        LinkedList<PhysicalVersionMetadataData> result = new LinkedList<PhysicalVersionMetadataData>();
        int versionsCount = 0;
        if (!ignoreLastVersion) {
            queryStr = "SELECT versionsCount, lastVersionUid, lastVersionNotes, lastVersionDataSource, lastVersionCreated, lastVersionModified, lastVersionCreatedBy,lastVersionModifiedBy FROM " + EntityData.class.getName() + " WHERE uid=:uid";
            query = this.getSession(session).createQuery(queryStr);
            query.setString("uid", containerUid);
            List list = query.list();
            if (!list.isEmpty()) {
                Object[] fields = (Object[])list.get(0);
                versionsCount = (Integer)fields[0];
                String lastVersionUid = (String)fields[1];
                info = new PhysicalVersionMetadataData();
                info.setUid(lastVersionUid);
                info.setVersionNotes((String)fields[2]);
                info.setDataSource((String)fields[3]);
                info.setCreated(MiscUtil.cloneDate((Date)((Date)fields[4])));
                info.setModified(MiscUtil.cloneDate((Date)((Date)fields[5])));
                info.setCreatedBy((String)fields[6]);
                info.setModifiedBy((String)fields[7]);
                info.setVersionNumber(versionsCount - 1);
                result.add(info);
            }
        }
        if (ignoreLastVersion || versionsCount > 1) {
            queryStr = "SELECT vd.uid, vd.versionNotes, vd.dataSource, vd.created, vd.modified, vd.createdBy,vd.modifiedBy, vd.versionNumber FROM " + VersionData.class.getName() + " vd WHERE vd.entitydata_uid=:uid";
            query = this.getSession(session).createQuery(queryStr);
            query.setString("uid", containerUid);
            for (Object obj : query.list()) {
                Object[] fields = (Object[])obj;
                info = new PhysicalVersionMetadataData();
                info.setUid((String)fields[0]);
                info.setVersionNotes((String)fields[1]);
                info.setDataSource((String)fields[2]);
                info.setCreated(MiscUtil.cloneDate((Date)((Date)fields[3])));
                info.setModified(MiscUtil.cloneDate((Date)((Date)fields[4])));
                info.setCreatedBy((String)fields[5]);
                info.setModifiedBy((String)fields[6]);
                info.setVersionNumber((Integer)fields[7]);
                result.add(info);
            }
        }
        return result;
    }

    private <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> List<D> getIndexes(Map<EntityPhysicalStorage, List<D>> data) {
        List<D> indexes = data.get(this);
        if (indexes != null) {
            return indexes;
        }
        indexes = data.get(null);
        if (indexes != null) {
            return indexes;
        }
        return Collections.emptyList();
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void deleteIndexes(Class<I> indexClass, String containerUid, Map<EntityPhysicalStorage, List<D>> restoreData, PhysicalStorageSession session) throws Exception {
        if (this.updateLog.isDebugEnabled()) {
            this.updateLog.debug(String.format("storage %s: deleting indexes of type %s for containerUid = %s", this.storageId, indexClass.getName(), containerUid));
        }
        Session hs = this.getSession(session);
        if (restoreData != null) {
            List<D> indexes = this.getIndexes(restoreData);
            for (BaseIndexData i : indexes) {
                hs.delete(hs.merge(this.fromData(i)));
            }
        }
        Collection<Object> unsavedIndexes = ((HibernateSessionManager.HibernatePhysicalStorageSession)session).getUnsavedIndexes(indexClass, containerUid);
        unsavedIndexes.forEach(arg_0 -> ((Session)hs).delete(arg_0));
        unsavedIndexes.clear();
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> void saveIndexes(Class<I> indexClass, Map<EntityPhysicalStorage, List<D>> data, String containerUid, PhysicalStorageSession session) throws Exception {
        List<D> indexes = this.getIndexes(data);
        for (BaseIndexData idx2 : indexes) {
            Object idx = this.fromData(idx2);
            if (this.cleanupBlobs && this.indexesWithBlobls.containsKey(indexClass.getName())) {
                Set<String> set = this.indexesWithBlobls.get(indexClass.getName());
                for (Field field : idx.getClass().getDeclaredFields()) {
                    if (!set.contains(field.getName())) continue;
                    field.setAccessible(true);
                    field.set(idx, null);
                }
            }
            try {
                this.getSession(session).saveOrUpdate(idx);
            }
            catch (NonUniqueObjectException e) {
                BaseIndexData item = (BaseIndexData)this.getSession(session).merge(idx);
                this.getSession(session).saveOrUpdate((Object)item);
            }
            ((HibernateSessionManager.HibernatePhysicalStorageSession)session).getUnsavedIndexes(indexClass, containerUid).add(idx);
        }
        if (this.updateLog.isDebugEnabled()) {
            this.updateLog.debug(String.format("storage %s: saved %s indexes of type %s for containerUid = %s", this.storageId, Integer.toString(indexes.size()), indexClass.getName(), containerUid));
        }
    }

    @Override
    public <E extends BaseEntity> void saveEntity(PhysicalEntityData<E> etc, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        EntityData entityData = (EntityData)etc.getContext().get(etc.getUid());
        if (entityData == null) {
            if (etc.getVersionsCount() != 1 || restoreData != null) {
                entityData = this.findData(this.getSession(session), etc.getEntityType(), etc.getUid());
            }
            if (entityData == null) {
                entityData = new EntityData();
            }
        } else {
            entityData = (EntityData)this.getSession(session).merge((Object)entityData);
        }
        entityData.setCreatedBy(etc.getCreatedBy());
        entityData.setEntityType(etc.getEntityType().getName());
        entityData.setCreated(etc.getCreated());
        entityData.setModified(etc.getModified());
        entityData.setModifiedBy(etc.getModifiedBy());
        entityData.setStatus(etc.getStatus());
        entityData.setUid(etc.getUid());
        entityData.setUpdatePolicy(etc.getUpdatePolicy());
        entityData.setRevision(etc.getRevision());
        int currentVersionsCount = entityData.getVersionsCount();
        entityData.setVersionsCount(etc.getVersionsCount());
        if (currentVersionsCount > etc.getVersionsCount()) {
            for (PhysicalVersionMetadataData vm : this.getVersionsMetadata(etc.getUid(), session, true)) {
                VersionData vd;
                if (vm.getVersionNumber() < etc.getVersionsCount() - 1 || (vd = (VersionData)this.getSession(session).get(VersionData.class, (Serializable)((Object)vm.getUid()))) == null) continue;
                this.getSession(session).delete((Object)vd);
            }
        }
        LinkedList<VersionData> versionsToSave = new LinkedList<VersionData>();
        for (PhysicalVersionData versionData : etc.getVersions()) {
            if (versionData.getVersionNumber() == etc.getVersionsCount() - 1) {
                entityData.setLastVersionCreated(versionData.getCreated());
                entityData.setLastVersionCreatedBy(versionData.getCreatedBy());
                entityData.setLastVersionData(this.cleanupBlobs ? null : versionData.getData());
                entityData.setLastVersionDataSource(versionData.getDataSource());
                entityData.setLastVersionModified(versionData.getModified());
                entityData.setLastVersionModifiedBy(versionData.getModifiedBy());
                entityData.setLastVersionNotes(versionData.getVersionNotes());
                entityData.setLastVersionUid(versionData.getUid());
                entityData.setLastVersionDataFormat(versionData.getDataFormat());
                continue;
            }
            VersionData vd = (VersionData)this.getSession(session).get(VersionData.class, (Serializable)((Object)versionData.getUid()));
            if (vd == null) {
                vd = new VersionData();
                vd.setUid(versionData.getUid());
                vd.setEntityDataUid(entityData.getUid());
            }
            vd.setVersionNumber(versionData.getVersionNumber());
            vd.setCreated(versionData.getCreated());
            vd.setCreatedBy(versionData.getCreatedBy());
            vd.setData(this.cleanupBlobs ? null : versionData.getData());
            vd.setDataSource(versionData.getDataSource());
            vd.setModified(versionData.getModified());
            vd.setModifiedBy(versionData.getModifiedBy());
            vd.setDataFormat(versionData.getDataFormat());
            vd.setVersionNotes(versionData.getVersionNotes());
            versionsToSave.add(vd);
        }
        this.getSession(session).saveOrUpdate((Object)entityData);
        for (VersionData vd : versionsToSave) {
            this.getSession(session).saveOrUpdate((Object)vd);
        }
        if (this.updateLog.isDebugEnabled()) {
            this.updateLog.debug(String.format("storage %s: entity saved %s: uid = %s, modifiedDate = %s, versions = %s, versionCount = %d, revision = %d", this.storageId, etc.getEntityType(), etc.getUid(), etc.getModified(), this.getVersionNumbers(etc), etc.getVersionsCount(), etc.getRevision()));
        }
    }

    private <E extends BaseEntity> String getVersionNumbers(PhysicalEntityData<E> etc) {
        StringBuilder sb = new StringBuilder();
        for (PhysicalVersionData item : etc.getVersions()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(item.getVersionNumber());
        }
        return sb.toString();
    }

    @Override
    public <E extends BaseEntity> void deleteEntity(PhysicalEntityData<E> data, PhysicalStorageSession session) throws Exception {
        EntityData entityData = (EntityData)data.getContext().get(data.getUid());
        Session ss = this.getSession(session);
        if (this.updateLog.isDebugEnabled()) {
            this.updateLog.debug(String.format("storage %s: deleting entity %s uid = %s, versionCount = %d, revision = %d", this.storageId, data.getEntityType(), data.getUid(), data.getVersionsCount(), data.getRevision()));
        }
        if (entityData == null && (entityData = this.findData(ss, data.getEntityType(), data.getUid())) == null) {
            this.updateLog.debug(String.format("storage %s: entity is absent in db", this.storageId));
            return;
        }
        if (entityData.getVersionsCount() > 1) {
            List<PhysicalVersionMetadataData> versionsMetadata = this.getVersionsMetadata(data.getUid(), session, true);
            for (PhysicalVersionMetadataData item : versionsMetadata) {
                VersionData vd = (VersionData)ss.get(VersionData.class, (Serializable)((Object)item.getUid()));
                if (vd == null) continue;
                ss.delete((Object)vd);
            }
        }
        ss.delete((Object)entityData);
    }

    @Override
    public <E extends BaseEntity> void deleteVersion(PhysicalEntityData<E> data, int versionNumber, PhysicalEntityData<E> restoreData, PhysicalStorageSession session) throws Exception {
        VersionData vd = this.findVersion(data.getEntityType(), data.getUid(), versionNumber, session);
        if (vd != null) {
            if (this.updateLog.isDebugEnabled()) {
                this.updateLog.debug(String.format("storage %s: deleting version %s of entity %s uid = %s, versionCount = %d, revision = %d", this.storageId, Integer.toString(versionNumber), data.getEntityType(), data.getUid(), data.getVersionsCount(), data.getRevision()));
            }
            this.getSession(session).delete((Object)vd);
        }
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>> Map<EntityPhysicalStorage, List<D>> getIndexes(Class<I> indexClass, String containerUid, PhysicalStorageSession session) throws Exception {
        this.log.debug(String.format("getting indexes: cls = %s, ctrUid = %s", indexClass, containerUid));
        ArrayList<BaseIndexData> result = new ArrayList<BaseIndexData>();
        Class dataCls = this.getDataClass(LogicalStorageRegistry.get().getIndexHandler(indexClass).getDataClass());
        for (Object idx : this.getSession(session).createCriteria(dataCls).add((Criterion)Restrictions.eq((String)"containerUid", (Object)containerUid)).list()) {
            result.add((BaseIndexData)this.toData(idx));
        }
        return Collections.singletonMap(this, result);
    }

    @Override
    public List<PhysicalEntityDataModification> getEntityModifications(List<Class<?>> types, Date timeStampFrom, Date timeStampTo, PhysicalStorageSession session) throws Exception {
        LinkedList<PhysicalEntityDataModification> result = new LinkedList<PhysicalEntityDataModification>();
        if (types.isEmpty()) {
            return result;
        }
        if (!PollingConfiguration.isNewPolling()) {
            Criteria crt = this.getSession(session).createCriteria(EntityData.class);
            if (timeStampFrom != null) {
                crt.add((Criterion)Restrictions.gt((String)"modified", (Object)timeStampFrom));
            }
            if (timeStampTo != null) {
                crt.add((Criterion)Restrictions.lt((String)"modified", (Object)timeStampTo));
            }
            Disjunction disjunction = Restrictions.disjunction();
            for (Class<?> clazz : types) {
                disjunction.add((Criterion)Restrictions.eq((String)"entityType", (Object)clazz.getName()));
            }
            crt.add((Criterion)disjunction);
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((org.hibernate.criterion.Projection)Projections.groupProperty((String)"uid"));
            projectionList.add((org.hibernate.criterion.Projection)Projections.groupProperty((String)"entityType"));
            projectionList.add((org.hibernate.criterion.Projection)Projections.groupProperty((String)"modified"));
            crt.setProjection((org.hibernate.criterion.Projection)projectionList);
            for (Object obj : crt.list()) {
                Object[] values = (Object[])obj;
                String uid = (String)values[0];
                String entityType = (String)values[1];
                Date modified = MiscUtil.cloneDate((Date)((Date)values[2]));
                PhysicalEntityDataModification item = new PhysicalEntityDataModification();
                item.setEntityType(XHelper.getClass((String)entityType));
                item.setModified(modified);
                item.setUid(uid);
                result.add(item);
            }
        } else {
            Criteria crt = this.getSession(session).createCriteria(ModifiedObjectReferenceData.class);
            if (timeStampFrom != null) {
                crt.add((Criterion)Restrictions.gt((String)"refModified", (Object)timeStampFrom));
            }
            if (timeStampTo != null) {
                crt.add((Criterion)Restrictions.le((String)"refModified", (Object)timeStampTo));
            }
            Disjunction disjunction = Restrictions.disjunction();
            for (Class<?> clazz : types) {
                disjunction.add((Criterion)Restrictions.eq((String)"refType", (Object)clazz.getName()));
            }
            crt.add((Criterion)disjunction);
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((org.hibernate.criterion.Projection)Projections.groupProperty((String)"refUid"));
            projectionList.add((org.hibernate.criterion.Projection)Projections.groupProperty((String)"refType"));
            projectionList.add((org.hibernate.criterion.Projection)Projections.groupProperty((String)"refModified"));
            projectionList.add((org.hibernate.criterion.Projection)Projections.groupProperty((String)"groups"));
            crt.setProjection((org.hibernate.criterion.Projection)projectionList);
            for (Object obj : crt.list()) {
                Object[] values = (Object[])obj;
                String uid = (String)values[0];
                String entityType = (String)values[1];
                Date modified = MiscUtil.cloneDate((Date)((Date)values[2]));
                Collection<String> groups = ModifiedObjectReferenceData.getGroups((String)values[3]);
                PhysicalEntityDataModification item = new PhysicalEntityDataModification();
                item.setEntityType(XHelper.getClass((String)entityType));
                item.setModified(modified);
                item.setUid(uid);
                item.setGroups(groups != null ? groups.toArray(new String[groups.size()]) : null);
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public <E extends BaseEntity> boolean isEntityAvailable(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        EntityData data = this.findData(this.getSession(session), cls, uid);
        return data != null && data.getStatus() != EntityStatus.VOID;
    }

    @Override
    public <E extends BaseEntity> boolean isEntityExist(Class<E> cls, String uid, PhysicalStorageSession session) throws Exception {
        String queryStr = "SELECT count(*) FROM " + EntityData.class.getName() + " WHERE uid=:uid AND entityType=:entityType";
        Query query = this.getSession(session).createQuery(queryStr);
        query.setString("uid", uid);
        query.setString("entityType", cls.getName());
        List list = query.list();
        return !list.isEmpty() && ((Number)list.get(0)).intValue() > 0;
    }

    private EntityData findData(Session ss, Class<?> containerCls, String uid) {
        EntityData data;
        int count = 3;
        while (true) {
            try {
                data = (EntityData)ss.get(EntityData.class, (Serializable)((Object)uid));
            }
            catch (SQLGrammarException e) {
                SQLException sql = e.getSQLException();
                if (LODE.matcher(sql.getMessage()).matches() && count-- > 0) continue;
                throw e;
            }
            break;
        }
        if (data == null) {
            return null;
        }
        if (!containerCls.getName().equals(data.getEntityType())) {
            this.log.warn(String.format("inconsistent container ID for entity data %s, expected %s, found %s", data.getUid(), containerCls.getName(), data.getEntityType()));
            return null;
        }
        return data;
    }

    @Override
    public <E extends BaseEntity> List<String> getEntityUids(Class<E> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreVoid, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        String dateFieldName;
        Criteria crit = this.getSession(session).createCriteria(EntityData.class.getName()).add((Criterion)Restrictions.eq((String)"entityType", (Object)cls.getName()));
        if (ignoreVoid) {
            crit.add((Criterion)Restrictions.ne((String)"status", (Object)EntityStatus.VOID));
        }
        String string = dateFieldName = useCreateDate ? "created" : "modified";
        if (startDate != null) {
            crit.add((Criterion)Restrictions.ge((String)dateFieldName, (Object)startDate));
        }
        if (endDate != null) {
            crit.add((Criterion)Restrictions.lt((String)dateFieldName, (Object)endDate));
        }
        if (sortOrder == SortOrder.ASC) {
            crit.addOrder(Order.asc((String)dateFieldName));
        } else if (sortOrder == SortOrder.DESC) {
            crit.addOrder(Order.desc((String)dateFieldName));
        }
        if (limit != null) {
            crit.setMaxResults(limit.intValue());
        }
        crit.setProjection((org.hibernate.criterion.Projection)Projections.property((String)"uid"));
        return new LinkedList<String>(crit.list());
    }

    @Override
    public <E extends BaseEntity> void deleteAllEntities(Class<E> cls, PhysicalStorageSession session) throws Exception {
        Session ss = this.getSession(session);
        ss.createQuery(String.format("delete from %s where entitydata_uid in (select uid from %s where entitytype = '%s')", VersionData.class.getName(), EntityData.class.getName(), cls.getName())).executeUpdate();
        ss.createQuery(String.format("delete from %s where entitytype = '%s'", EntityData.class.getName(), cls.getName())).executeUpdate();
    }

    @Override
    public <E extends BaseEntity, I extends EntityIndex<E>> void deleteAllIndexes(Class<I> cls, PhysicalStorageSession session) throws Exception {
        Session ss = this.getSession(session);
        ss.createQuery(String.format("delete from %sData", cls.getName())).executeUpdate();
    }

    private <E extends BaseEntity, I extends EntityIndex<E>> Class<? extends BaseIndexData<E, I>> getDataClass(Class<? extends BaseIndexData<E, I>> dataClass) {
        Class<Object> result = this.data2Array.get(dataClass);
        if (result != null) {
            return result;
        }
        try {
            result = dataClass.getClassLoader().loadClass(dataClass.getName() + "Array");
        }
        catch (ClassNotFoundException e) {
            result = dataClass;
        }
        this.data2Array.put(dataClass, result);
        return result;
    }

    private <E extends BaseEntity, I extends EntityIndex<E>, D extends BaseIndexData<E, I>, A extends BaseIndexData<E, I>> A fromData(D data) throws IllegalAccessException, InstantiationException {
        Class<?> dataClass = data.getClass();
        Class<BaseIndexData<E, I>> arrayClass = this.getDataClass(dataClass);
        if (arrayClass == dataClass) {
            return (A)data;
        }
        IndexDataArray dataArray = (IndexDataArray)((Object)arrayClass.newInstance());
        dataArray.fromData(data);
        return (A)((BaseIndexData)((Object)dataArray));
    }

    private Object toData(Object dataArray) {
        if (!(dataArray instanceof IndexDataArray)) {
            return dataArray;
        }
        return ((IndexDataArray)dataArray).toData();
    }
}

