/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.server.db.storage.hibernate.ArrayHibernateEntityStorage;
import com.gridnine.xtrip.server.db.storage.hibernate.ArrayHibernateSessionManager;
import com.gridnine.xtrip.server.db.storage.hibernate.DBSchemeUpdateHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateAssetStorage;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateBulkDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateDBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageConfiguration;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateSessionManager;
import com.gridnine.xtrip.server.db.storage.hibernate.StructureAlignment;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.EntityPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayHibernatePhysicalStorage
implements PhysicalStorage {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ArrayHibernateSessionManager sm;
    private final HibernateDBPropertiesPhysicalStorage dbProperties;
    private final String uid;
    private final HibernateAssetStorage assetStorage;
    private final HibernateDictionaryStorage dictionaryStorage;
    private final ArrayHibernateEntityStorage entityStorage;
    private final HibernateBulkDictionaryStorage bulkDictionaryStorage;

    public ArrayHibernatePhysicalStorage(HibernatePhysicalStorageConfiguration configuration) throws Exception {
        this.sm = new ArrayHibernateSessionManager(configuration);
        this.dbProperties = new HibernateDBPropertiesPhysicalStorage(this.sm.connectionFactory);
        this.uid = configuration.getUid();
        this.assetStorage = new HibernateAssetStorage(configuration.isCleanupBlobs());
        this.assetStorage.setStorageId(configuration.getUid());
        this.dictionaryStorage = new HibernateDictionaryStorage(configuration.isCleanupBlobs());
        this.entityStorage = new ArrayHibernateEntityStorage(configuration.isCleanupBlobs());
        this.entityStorage.setStorageId(configuration.getUid());
        this.bulkDictionaryStorage = new HibernateBulkDictionaryStorage(configuration.isCleanupBlobs());
    }

    @Override
    public PhysicalStorageSession createSession(Map<String, Object> context) throws Exception {
        return this.sm.createSession();
    }

    @Override
    public void setupScheme(final boolean cleanupMode) throws Exception {
        this.initialize(cleanupMode, new HibernateSessionManager.SetupSchemeCallback(){
            private final List<DBSchemeUpdateHelper.AfterAction> after = new ArrayList<DBSchemeUpdateHelper.AfterAction>();

            @Override
            public void before() throws Exception {
                if (cleanupMode) {
                    ArrayHibernatePhysicalStorage.this.dbProperties.createTable();
                    DBSchemeUpdateHelper.cleanupDbStructure(ArrayHibernatePhysicalStorage.this.createHibernateCallback());
                    return;
                }
                DBSchemeUpdateHelper.HibernateStorageCallback storageCallback = ArrayHibernatePhysicalStorage.this.createHibernateCallback();
                DBSchemeUpdateHelper.updateDbStructure(storageCallback);
                StructureAlignment.align(storageCallback, true, this.after);
            }

            @Override
            public void after() throws Exception {
                if (this.after.isEmpty()) {
                    return;
                }
                DBSchemeUpdateHelper.HibernateStorageCallback2 storageCallback = ArrayHibernatePhysicalStorage.this.createHibernateCallback2();
                this.after.forEach(a -> a.after(storageCallback));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkHealth() {
        try {
            String key = "check-health.".concat(UUID.randomUUID().toString());
            try {
                this.dbProperties.putDbProperty(key, key, (String)null);
                if (!key.equals(this.dbProperties.getDbProperty(key))) {
                    this.logger.error("healthcheck failed - value mismatch");
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.dbProperties.putDbProperty(key, null, (String)null);
            }
        }
        catch (Throwable t) {
            this.logger.error("healthcheck failed", t);
            return false;
        }
    }

    public void initialize(boolean cleanup, HibernateSessionManager.SetupSchemeCallback callback) throws Exception {
        this.sm.setupScheme(cleanup, callback);
    }

    protected DBSchemeUpdateHelper.HibernateStorageCallback createHibernateCallback() {
        return new DBSchemeUpdateHelper.HibernateStorageCallback(){

            @Override
            public String getDbProperty(String key) throws Exception {
                return ArrayHibernatePhysicalStorage.this.dbProperties.getDbProperty(key);
            }

            @Override
            public void updateDbProperty(String key, String value, Connection cnn) throws Exception {
                ArrayHibernatePhysicalStorage.this.dbProperties.putDbProperty(key, value, cnn);
            }

            @Override
            public void updateDbProperty(String key, String value) throws Exception {
                ArrayHibernatePhysicalStorage.this.dbProperties.putDbProperty(key, value, (String)null);
            }

            @Override
            public Connection createConnection() throws Exception {
                return ArrayHibernatePhysicalStorage.this.sm.createConnection();
            }
        };
    }

    protected DBSchemeUpdateHelper.HibernateStorageCallback2 createHibernateCallback2() {
        return this.sm::getSessionFactory;
    }

    @Override
    public void dispose() {
        this.sm.dispose();
    }

    @Override
    public EntityPhysicalStorage getEntityStorage() {
        return this.entityStorage;
    }

    @Override
    public DictionaryPhysicalStorage getDictionaryStorage() {
        return this.dictionaryStorage;
    }

    @Override
    public AssetPhysicalStorage getAssetStorage() {
        return this.assetStorage;
    }

    @Override
    public DBPropertiesPhysicalStorage getDBPropertiesStorage() {
        return this.dbProperties;
    }

    @Override
    public void maintain() throws Exception {
        this.sm.maintain();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public BulkDictionaryPhysicalStorage getBulkDictionaryStorage() {
        return this.bulkDictionaryStorage;
    }
}

