/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.server.update.db.DbUpdateFile;
import com.gridnine.xtrip.server.update.db.DbUpdateHandler;
import com.gridnine.xtrip.server.update.db.StorageUpdateHelper;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DBSchemeUpdateHelper {
    private static final String DB_VERSION_PREFFIX = "db_version";
    private static final Logger log = LoggerFactory.getLogger(DBSchemeUpdateHelper.class);

    public static void cleanupDbStructure(HibernateStorageCallback clb) throws Exception {
        for (URL url : StorageUpdateHelper.getUpdateURLs()) {
            DBSchemeUpdateHelper.cleanupDbStructure(url, clb);
        }
    }

    public static void cleanupDbStructure(URL url, HibernateStorageCallback clb) throws Exception {
        StorageUpdateHelper.UpdateData updateData = StorageUpdateHelper.getUpdateData(url, DB_VERSION_PREFFIX, DBSchemeUpdateHelper.createVersionProvider(clb));
        String key = String.format("%s.%s", DB_VERSION_PREFFIX, updateData.id);
        log.debug("updating DB structure from " + url);
        if (updateData.id == null) {
            throw new IllegalStateException(String.format("update file %s has no id", url));
        }
        if (updateData.lastVersion == null) {
            throw new IllegalStateException(String.format("update file %s has no last version", url));
        }
        clb.updateDbProperty(key, updateData.lastVersion);
        log.info(String.format("db version of %s was set to %s", updateData.id, updateData.lastVersion));
    }

    private static StorageUpdateHelper.VersionProvider createVersionProvider(final HibernateStorageCallback clb) {
        return new StorageUpdateHelper.VersionProvider(){

            @Override
            public String getVersion(String key) throws Exception {
                return clb.getDbProperty(key);
            }
        };
    }

    public static void updateDbStructure(HibernateStorageCallback clb) throws Exception {
        for (URL url : StorageUpdateHelper.getUpdateURLs()) {
            DBSchemeUpdateHelper.updateDbStructure(url, clb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDbStructure(URL url, HibernateStorageCallback clb) throws Exception {
        StorageUpdateHelper.UpdateData updateData = StorageUpdateHelper.getUpdateData(url, DB_VERSION_PREFFIX, DBSchemeUpdateHelper.createVersionProvider(clb));
        log.debug("updating DB structure from " + url);
        if (updateData.id == null) {
            throw new IllegalStateException(String.format("update file %s has no id", url));
        }
        if (updateData.lastVersion == null) {
            throw new IllegalStateException(String.format("update file %s has no last version", url));
        }
        if (updateData.sections.isEmpty()) {
            return;
        }
        HashMap<String, DbUpdateHandler> handlers = new HashMap<String, DbUpdateHandler>();
        for (DbUpdateFile.DbUpdate section : updateData.sections) {
            Connection cnn = clb.createConnection();
            cnn.setAutoCommit(false);
            try {
                for (Element command : section.getCommands()) {
                    String handlerId = command.getAttribute("handlerClass");
                    DbUpdateHandler handler = (DbUpdateHandler)handlers.get(handlerId);
                    if (handler == null) {
                        handler = (DbUpdateHandler)Class.forName(handlerId).newInstance();
                        handlers.put(handlerId, handler);
                    }
                    handler.execute(command, cnn);
                }
                clb.updateDbProperty(String.format("%s.%s", DB_VERSION_PREFFIX, updateData.id), section.getVersion(), cnn);
                cnn.commit();
                log.info(String.format("db version of %s was set to %s", updateData.id, updateData.lastVersion));
            }
            finally {
                if (cnn.isClosed()) continue;
                cnn.close();
            }
        }
        System.out.println(String.format("%s db structure was updated to version \"%s\"", updateData.id, updateData.lastVersion));
    }

    private DBSchemeUpdateHelper() {
    }

    public static interface AfterAction {
        public void after(HibernateStorageCallback2 var1);
    }

    public static interface HibernateStorageCallback2 {
        public SessionFactory getSessionFactory();
    }

    public static interface HibernateStorageCallback {
        public String getDbProperty(String var1) throws Exception;

        public void updateDbProperty(String var1, String var2, Connection var3) throws Exception;

        public void updateDbProperty(String var1, String var2) throws Exception;

        public Connection createConnection() throws Exception;
    }
}

