/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.search.FilterQuery;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.server.db.storage.common.SearchQueryHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateSessionManager;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateAssetStorage
implements AssetPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean cleanupBlobs;
    private final Logger updateLog = LoggerFactory.getLogger((String)(this.getClass().getName() + ".UPDATE"));
    private String storageId;
    private final Map<Class<?>, Set<String>> assetsWithBlobs = new HashMap();

    public void setStorageId(String value) {
        this.storageId = value;
    }

    public HibernateAssetStorage(boolean cleanupIndexBlobs) {
        this.cleanupBlobs = cleanupIndexBlobs;
        for (Map.Entry<Class<?>, Class<?>> item : ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClasses().entrySet()) {
            Class<?> dataClass = item.getValue();
            for (PropertyDescriptor property : PropertyUtils.getPropertyDescriptors(dataClass)) {
                if (!byte[].class.equals(property.getPropertyType())) continue;
                Set<String> set = this.assetsWithBlobs.get(item.getKey());
                if (set == null) {
                    set = new HashSet<String>();
                    this.assetsWithBlobs.put(item.getKey(), set);
                }
                set.add(property.getName());
            }
        }
    }

    @Override
    public <A extends BaseAsset> SearchResult<A> searchAssets(Class<A> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        return HibernatePhysicalStorageHelper.tryRead(() -> {
            SearchResult searchResult = SearchQueryHelper.execute(this.getSession(session), ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(cls), null, query, false);
            SearchResult result = new SearchResult();
            result.setTimestamp(searchResult.getTimestamp());
            result.setTotalCount(searchResult.getTotalCount());
            for (BaseAssetData assetData : searchResult.getData()) {
                if (!this.cleanupBlobs || !this.assetsWithBlobs.containsKey(cls)) {
                    result.getData().add(assetData.toAsset(query.getPreferredProperties()));
                    continue;
                }
                BaseAsset asset = (BaseAsset)cls.newInstance();
                asset.setUid(assetData.getUid());
                result.getData().add(asset);
            }
            for (FilterQuery filter : query.getFilters()) {
                result.getFilter(filter.getProperty()).addAll(searchResult.getFilter(filter.getProperty()));
            }
            return result;
        });
    }

    @Override
    public <A extends BaseAsset> ProjectionResult searchAssets(Class<A> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        return HibernatePhysicalStorageHelper.tryRead(() -> {
            ProjectionResult result = new ProjectionResult();
            for (Projection prj : query.getProjections()) {
                if (prj instanceof Projection.RowCountProjection) {
                    result.getAliases().add(((Projection.RowCountProjection)prj).getAlias());
                    continue;
                }
                if (!(prj instanceof Projection.SimpleProjection)) continue;
                result.getAliases().add(((Projection.SimpleProjection)prj).getAlias());
            }
            if (result.getAliases().isEmpty()) {
                this.log.warn("no resulting projections defined in query " + query);
                return result;
            }
            List<?> data = SearchQueryHelper.execute(this.getSession(session), ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(cls), null, query, false);
            if (result.getAliases().size() == 1) {
                String alias = (String)result.getAliases().get(0);
                for (Object obj : data) {
                    result.getData().add(Collections.singletonMap(alias, obj));
                }
            } else {
                for (Object obj : data) {
                    Object[] arr = (Object[])obj;
                    if (arr.length != result.getAliases().size()) {
                        throw new IllegalStateException("illegal size of projection data");
                    }
                    HashMap map = new HashMap();
                    for (int i = 0; i < arr.length; ++i) {
                        map.put(result.getAliases().get(i), arr[i]);
                    }
                    result.getData().add(map);
                }
            }
            return result;
        });
    }

    Session getSession(PhysicalStorageSession session) {
        return ((HibernateSessionManager.HibernatePhysicalStorageSession)session).getSession();
    }

    @Override
    public <A extends BaseAsset> void saveAsset(PhysicalAssetData<A> asset, PhysicalAssetData<A> restoreData, PhysicalStorageSession session) throws Exception {
        BaseAssetData assetData = this.toAssetData(asset, session);
        try {
            this.getSession(session).saveOrUpdate(assetData);
        }
        catch (NonUniqueObjectException e) {
            assetData = (BaseAssetData)this.getSession(session).merge(assetData);
            this.getSession(session).saveOrUpdate((Object)assetData);
        }
        if (this.updateLog.isDebugEnabled() && asset.getAsset() != null) {
            this.updateLog.debug(String.format("storage %s: saved asset %s uid = %s modified = %s", this.storageId, asset.getAsset().getClass(), asset.getAsset().getUid(), asset.getAsset().getModified()));
        }
    }

    @Override
    public <A extends BaseAsset> void deleteAsset(PhysicalAssetData<A> asset, PhysicalStorageSession session) throws Exception {
        this.getSession(session).delete(this.toAssetData(asset, session));
        if (this.updateLog.isDebugEnabled() && asset.getAsset() != null) {
            this.updateLog.debug(String.format("storage %s: deleted asset %s uid = %s", this.storageId, asset.getAsset().getClass(), asset.getAsset().getUid()));
        }
    }

    @Override
    public <A extends BaseAsset> PhysicalAssetData<A> loadAsset(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        return HibernatePhysicalStorageHelper.tryRead(() -> {
            BaseAssetData data = (BaseAssetData)this.getSession(session).get(((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(cls), (Serializable)((Object)uid));
            if (data == null) {
                return null;
            }
            PhysicalAssetData result = new PhysicalAssetData();
            Object asset = data.toAsset(Collections.emptySet());
            result.setAsset(asset);
            result.getContext().put(data.getUid(), data);
            return result;
        });
    }

    private <A extends BaseAsset> BaseAssetData<A> toAssetData(PhysicalAssetData<A> data, PhysicalStorageSession session) throws Exception {
        Set<String> set;
        for (Object obj : data.getContext().values()) {
            BaseAssetData bad;
            if (!(obj instanceof BaseAssetData) || !(bad = (BaseAssetData)obj).getUid().equals(data.getAsset().getUid())) continue;
            bad.fromAsset(data.getAsset());
            return bad;
        }
        HibernatePhysicalStorageRegistry registry = (HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class);
        Class<BaseAssetData<?>> clazz = registry.getAssetDataClass(data.getAsset().getClass());
        BaseAssetData<?> _data = (BaseAssetData<?>)this.getSession(session).get(clazz, (Serializable)((Object)data.getAsset().getUid()));
        if (_data == null) {
            _data = clazz.newInstance();
        }
        _data.fromAsset(data.getAsset());
        if (this.cleanupBlobs && (set = this.assetsWithBlobs.get(data.getAsset().getClass())) != null) {
            block1: for (String fieldName : set) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.getName().equals(fieldName)) continue;
                    field.setAccessible(true);
                    field.set(_data, null);
                    continue block1;
                }
            }
        }
        return _data;
    }

    @Override
    public <A extends BaseAsset> List<String> getAssetUids(Class<A> cls, Date startDate, Date endDate, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        Class<BaseAssetData<A>> dataClass = ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(cls);
        Criteria crit = this.getSession(session).createCriteria(dataClass.getName());
        String datePropertyName = "modified";
        if (startDate != null) {
            crit.add((Criterion)Restrictions.ge((String)datePropertyName, (Object)startDate));
        }
        if (endDate != null) {
            crit.add((Criterion)Restrictions.lt((String)datePropertyName, (Object)endDate));
        }
        if (sortOrder == SortOrder.ASC) {
            crit.addOrder(Order.asc((String)datePropertyName));
        } else if (sortOrder == SortOrder.DESC) {
            crit.addOrder(Order.desc((String)datePropertyName));
        }
        crit.setProjection((org.hibernate.criterion.Projection)Projections.property((String)"uid"));
        if (limit != null) {
            crit.setMaxResults(limit.intValue());
        }
        return new ArrayList<String>(crit.list());
    }

    @Override
    public <A extends BaseAsset> boolean isAssetExist(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        String queryStr = "SELECT count(*) FROM " + ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(cls).getName() + " WHERE uid=:uid";
        Query query = this.getSession(session).createQuery(queryStr);
        query.setString("uid", uid);
        List list = query.list();
        return !list.isEmpty() && ((Number)list.get(0)).intValue() > 0;
    }
}

