/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateSessionManager;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryMetadata;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;

public class HibernateBulkDictionaryStorage
implements BulkDictionaryPhysicalStorage {
    private final boolean cleanupBlobs;

    Session getSession(PhysicalStorageSession session) {
        return ((HibernateSessionManager.HibernatePhysicalStorageSession)session).getSession();
    }

    public HibernateBulkDictionaryStorage(boolean cleanup) {
        this.cleanupBlobs = cleanup;
    }

    @Override
    public List<PhysicalBulkDictionaryMetadata<?>> loadMetadata(PhysicalStorageSession session) throws Exception {
        ArrayList result = new ArrayList();
        Criteria crt = this.getSession(session).createCriteria(BulkDictionaryData.class);
        crt.setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)"dictClass")).add((Projection)Projections.groupProperty((String)"modified")));
        List objects = crt.list();
        for (Object[] array : objects) {
            PhysicalBulkDictionaryMetadata item = new PhysicalBulkDictionaryMetadata();
            item.setDictionaryType(XHelper.getClass((String)((String)array[0])));
            item.setModified((Date)array[1]);
            result.add(item);
        }
        return result;
    }

    @Override
    public <D extends BaseDictionary> PhysicalBulkDictionaryData<D> loadData(Class<D> key, PhysicalStorageSession session) throws Exception {
        BulkDictionaryData data = (BulkDictionaryData)this.getSession(session).get(BulkDictionaryData.class, (Serializable)((Object)key.getName()));
        if (data == null) {
            return null;
        }
        PhysicalBulkDictionaryData result = new PhysicalBulkDictionaryData();
        result.setDictionaryType(XHelper.getClass((String)data.getDictClass()));
        result.setModified(data.getModified());
        result.setData(data.getData());
        result.getContext().put(key.getName(), data);
        return result;
    }

    @Override
    public <D extends BaseDictionary> void updateData(PhysicalBulkDictionaryData<D> data, PhysicalBulkDictionaryData<D> restoreData, PhysicalStorageSession session) {
        String className = data.getDictionaryType().getName();
        BulkDictionaryData dictData = (BulkDictionaryData)data.getContext().get(className);
        boolean merge = false;
        if (dictData == null) {
            dictData = (BulkDictionaryData)this.getSession(session).get(BulkDictionaryData.class, (Serializable)((Object)className));
        } else {
            merge = true;
        }
        if (dictData == null) {
            dictData = new BulkDictionaryData();
            dictData.setDictClass(className);
            merge = true;
        }
        if (merge) {
            dictData = (BulkDictionaryData)this.getSession(session).merge((Object)dictData);
        }
        dictData.setModified(data.getModified());
        dictData.setData(this.cleanupBlobs ? null : data.getData());
        this.getSession(session).saveOrUpdate((Object)dictData);
    }

    @Override
    public <D extends BaseDictionary> void deleteData(PhysicalBulkDictionaryData<D> data, PhysicalStorageSession session) {
        String className = data.getDictionaryType().getName();
        BulkDictionaryData dictData = (BulkDictionaryData)data.getContext().get(className);
        if (dictData == null) {
            dictData = (BulkDictionaryData)this.getSession(session).get(BulkDictionaryData.class, (Serializable)((Object)data.getDictionaryType().getName()));
        }
        if (dictData == null) {
            return;
        }
        this.getSession(session).delete((Object)dictData);
    }
}

