/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.ConnectionFactory;
import com.gridnine.xtrip.server.db.storage.model.DBPropertiesPhysicalStorage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateDBPropertiesPhysicalStorage
implements DBPropertiesPhysicalStorage {
    private final ConnectionFactory factory;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public HibernateDBPropertiesPhysicalStorage(ConnectionFactory connectionFactory) {
        this.factory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createTable() throws Exception {
        Connection cnn = this.factory.createConnection();
        try (Statement st = cnn.createStatement();){
            st.execute("CREATE TABLE dbproperties (recordkey varchar(255), recordvalue varchar(255), CONSTRAINT dbproperties_recordkey PRIMARY KEY (recordkey))");
            cnn.commit();
        }
        finally {
            if (!cnn.isClosed()) {
                cnn.close();
            }
        }
        this.log.info("dbproperties table created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void putDbProperty(String key, String value, String oldValue) throws Exception {
        Connection cnn = this.factory.createConnection();
        try {
            this.putDbProperty(key, value, cnn);
        }
        finally {
            if (!cnn.isClosed()) {
                cnn.close();
            }
        }
    }

    public void putDbProperty(String key, String value, Connection cnn) throws Exception {
        this.checkParams(key, value);
        boolean deleteEntry = value == null;
        this.updateDbProperties(deleteEntry, key, value, cnn);
        cnn.commit();
    }

    private void updateDbProperties(boolean deleteEntry, String key, String value, Connection cnn) throws Exception {
        int affectedRowsCount;
        this.deleteDbProperty(key, cnn);
        if (!deleteEntry && (affectedRowsCount = this.insertDbProperty(key, value, cnn)) != 1) {
            throw new Exception(String.format("failed inserting entry with key \"%s\" and value \"%s\" (affected rows count = %s)", key, value, affectedRowsCount));
        }
    }

    private int deleteDbProperty(String key, Connection cnn) throws SQLException {
        try (PreparedStatement st = cnn.prepareStatement("DELETE FROM dbproperties WHERE recordkey = ?");){
            st.setString(1, key);
            int n = st.executeUpdate();
            return n;
        }
    }

    private int insertDbProperty(String key, String value, Connection cnn) throws Exception {
        try (PreparedStatement st = cnn.prepareStatement("INSERT INTO dbproperties(recordkey, recordvalue) VALUES (?, ?)");){
            st.setString(1, key);
            st.setString(2, value);
            int n = st.executeUpdate();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getDbProperty(String key) throws Exception {
        if (TextUtil.isBlank((String)key)) {
            return null;
        }
        Connection conn = this.factory.createConnection();
        try (PreparedStatement st = conn.prepareStatement("SELECT recordvalue FROM dbproperties WHERE recordkey = ?");){
            st.setString(1, key);
            ResultSet rs = st.executeQuery();
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        finally {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        return null;
    }

    private void checkParams(String key, String value) {
        if (TextUtil.isBlank((String)key)) {
            throw new IllegalArgumentException("key is null");
        }
        if (key.length() > 255) {
            throw new IllegalArgumentException("key length is greater than 255");
        }
        if (value != null && value.length() > 255) {
            throw new IllegalArgumentException("value length is greater than 255");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getAllKeys() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        Connection conn = this.factory.createConnection();
        try (Statement st = conn.createStatement();){
            ResultSet rs = st.executeQuery("SELECT * FROM dbproperties");
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                properties.put(key, value);
            }
        }
        finally {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        return properties;
    }
}

