/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateSessionManager;
import com.gridnine.xtrip.server.db.storage.model.DictionaryData;
import com.gridnine.xtrip.server.db.storage.model.DictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateDictionaryStorage
implements DictionaryPhysicalStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean cleanupBlobs;

    public HibernateDictionaryStorage(boolean cleanup) {
        this.cleanupBlobs = cleanup;
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByCode(Class<D> cls, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
        return this.findDictionary(cls, null, code, deleted, session);
    }

    public <D extends BaseDictionary> DictionaryData findDictionaryData(Class<D> cls, String uid, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
        Criteria crt = this.getSession(session).createCriteria(DictionaryData.class);
        if (!TextUtil.isBlank((String)code)) {
            crt.add((Criterion)Restrictions.eq((String)"code", (Object)code));
        }
        if (!TextUtil.isBlank((String)uid)) {
            crt.add((Criterion)Restrictions.eq((String)"uid", (Object)uid));
        }
        if (deleted != null) {
            crt.add((Criterion)Restrictions.eq((String)"deleted", (Object)deleted));
        }
        crt.add((Criterion)Restrictions.eq((String)"dictId", (Object)cls.getName()));
        DictionaryData data = (DictionaryData)crt.uniqueResult();
        if (data != null && !cls.getName().equals(data.getDictionaryId())) {
            this.log.warn(String.format("inconsistent ID for dictionary item data %s, expected %s, found %s", data.getUid(), cls.getName(), data.getDictionaryId()));
        }
        return data;
    }

    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionary(Class<D> cls, String uid, String code, Boolean deleted, PhysicalStorageSession session) throws Exception {
        DictionaryData data = this.findDictionaryData(cls, uid, code, deleted, session);
        if (data == null) {
            return null;
        }
        return HibernateDictionaryStorage.toPhysicalDictionaryData(data);
    }

    private static <D extends BaseDictionary> PhysicalDictionaryData<D> toPhysicalDictionaryData(DictionaryData data) {
        Class dictType;
        PhysicalDictionaryData result = new PhysicalDictionaryData();
        result.setUid(data.getUid());
        result.getContext().put(data.getUid(), data);
        result.setCode(data.getCode());
        result.setCreated(MiscUtil.cloneDate((Date)data.getCreated()));
        result.setData(data.getData());
        result.setDeleted(data.isDeleted());
        try {
            dictType = XHelper.getClass((String)data.getDictionaryId());
            if (dictType == null) {
                return null;
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        result.setDictionaryType(dictType);
        result.setModified(MiscUtil.cloneDate((Date)data.getModified()));
        return result;
    }

    @Override
    public <D extends BaseDictionary> PhysicalDictionaryData<D> findDictionaryByUid(Class<D> cls, String uid, boolean ignoreDeleted, PhysicalStorageSession session) throws Exception {
        return this.findDictionary(cls, uid, null, ignoreDeleted ? Boolean.FALSE : null, session);
    }

    @Override
    public <D extends BaseDictionary> void deleteDictionary(PhysicalDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        DictionaryData dictData = (DictionaryData)data.getContext().get(data.getUid());
        dictData = dictData == null ? this.findDictionaryData(data.getDictionaryType(), data.getUid(), null, data.isDeleted(), session) : (DictionaryData)this.getSession(session).merge((Object)dictData);
        if (dictData == null) {
            return;
        }
        this.getSession(session).delete((Object)dictData);
    }

    @Override
    public <D extends BaseDictionary> void saveDictionary(PhysicalDictionaryData<D> data, PhysicalDictionaryData<D> oldData, PhysicalStorageSession session) throws Exception {
        DictionaryData dictData = (DictionaryData)data.getContext().get(data.getUid());
        boolean merge = false;
        if (dictData == null) {
            dictData = this.findDictionaryData(data.getDictionaryType(), data.getUid(), null, data.isDeleted(), session);
        } else {
            merge = true;
        }
        if (dictData == null) {
            dictData = new DictionaryData();
            dictData.setUid(data.getUid());
            merge = true;
        }
        dictData.setDeleted(data.isDeleted());
        dictData.setCode(data.getCode());
        dictData.setDictId(data.getDictionaryType().getName());
        dictData.setCreated(data.getCreated());
        dictData.setModified(data.getModified());
        if (merge) {
            dictData = (DictionaryData)this.getSession(session).merge((Object)dictData);
        }
        dictData.setData(this.cleanupBlobs ? null : data.getData());
        this.getSession(session).saveOrUpdate((Object)dictData);
        data.getContext().put(dictData.getUid(), dictData);
    }

    @Override
    public List<PhysicalDictionaryData<?>> loadAll(Date modifiedSynce, Boolean deleted, Class<?> dictClass, Set<Class<?>> ignoredTypes, PhysicalStorageSession session) throws Exception {
        Criteria crt = this.getSession(session).createCriteria(DictionaryData.class);
        if (deleted != null) {
            crt.add((Criterion)Restrictions.eq((String)"deleted", (Object)deleted));
        }
        if (dictClass != null) {
            crt.add((Criterion)Restrictions.eq((String)"dictId", (Object)dictClass.getName()));
        }
        if (modifiedSynce != null) {
            crt.add((Criterion)Restrictions.ge((String)"modified", (Object)modifiedSynce));
        }
        for (Class<?> type : ignoredTypes) {
            crt.add((Criterion)Restrictions.ne((String)"dictId", (Object)type.getName()));
        }
        ArrayList result = new ArrayList();
        for (DictionaryData data : crt.list()) {
            PhysicalDictionaryData physicalData = HibernateDictionaryStorage.toPhysicalDictionaryData(data);
            if (physicalData == null) continue;
            result.add(physicalData);
        }
        return result;
    }

    Session getSession(PhysicalStorageSession session) {
        return ((HibernateSessionManager.HibernatePhysicalStorageSession)session).getSession();
    }

    @Override
    public <D extends BaseDictionary> List<String> getDictionaryUids(Class<D> cls, Date startDate, Date endDate, boolean useCreateDate, boolean ignoreDeleted, SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        String dateFieldName;
        Criteria crit = this.getSession(session).createCriteria(DictionaryData.class.getName()).add((Criterion)Restrictions.eq((String)"dictId", (Object)cls.getName()));
        if (ignoreDeleted) {
            crit.add((Criterion)Restrictions.ne((String)"deleted", (Object)Boolean.TRUE));
        }
        String string = dateFieldName = useCreateDate ? "created" : "modified";
        if (startDate != null) {
            crit.add((Criterion)Restrictions.ge((String)dateFieldName, (Object)startDate));
        }
        if (endDate != null) {
            crit.add((Criterion)Restrictions.lt((String)dateFieldName, (Object)endDate));
        }
        if (sortOrder == SortOrder.ASC) {
            crit.addOrder(Order.asc((String)dateFieldName));
        } else if (sortOrder == SortOrder.DESC) {
            crit.addOrder(Order.desc((String)dateFieldName));
        }
        if (limit != null) {
            crit.setMaxResults(limit.intValue());
        }
        crit.setProjection((Projection)Projections.property((String)"uid"));
        return new ArrayList<String>(crit.list());
    }

    @Override
    public <D extends BaseDictionary> void deleteAll(Class<D> cls, PhysicalStorageSession session) throws Exception {
        Session ss = this.getSession(session);
        ss.createQuery(String.format("delete from %s where dictid = '%s'", DictionaryData.class.getName(), cls.getName())).executeUpdate();
    }
}

