/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.SimpleConnectionProvider;
import com.gridnine.xtrip.server.db.storage.hibernate.DictionaryData3;
import com.gridnine.xtrip.server.db.storage.hibernate.DictionaryData3PropertyLoader;
import com.gridnine.xtrip.server.db.storage.hibernate.DictionaryDataPropertyLoader;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateDictionaryStorage;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernateSessionManager;
import com.gridnine.xtrip.server.db.storage.hibernate.PropertyLoader;
import com.gridnine.xtrip.server.db.storage.model.DictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalDictionaryData;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.time.StopWatch;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.junit.Ignore;
import org.junit.Test;

public class HibernateDictionaryStorageTest {
    @Test
    @Ignore
    public void dictionaryLoadingPerformance() throws Exception {
        this.dictionaryLoadingPerformanceTestLogic(DictionaryData3.class, new DictionaryData3PropertyLoader());
        this.dictionaryLoadingPerformanceTestLogic(DictionaryData.class, new DictionaryDataPropertyLoader());
        this.dictionaryLoadingPerformanceTestLogicSqlOnly(DictionaryData3.class);
        this.dictionaryLoadingPerformanceTestLogicSqlOnly(DictionaryData.class);
    }

    @Test
    @Ignore
    public void dictionaryLoadingPerformanceUidsOnly() throws Exception {
        this.dictionaryLoadingPerformanceUidsOnlyTestLogic(DictionaryData3.class);
        this.dictionaryLoadingPerformanceUidsOnlyTestLogic(DictionaryData.class);
        this.dictionaryLoadingPerformanceUidsOnlyTestLogic2(DictionaryData3.class);
        this.dictionaryLoadingPerformanceUidsOnlyTestLogic2(DictionaryData.class);
        this.dictionaryLoadingPerformanceUidsOnlySqlOnlyTestLogic(DictionaryData3.class);
        this.dictionaryLoadingPerformanceUidsOnlySqlOnlyTestLogic(DictionaryData.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dictionaryLoadingPerformanceUidsOnlyTestLogic(Class<?> clazz) {
        Configuration cfg = this.createConfiguration();
        try (Session hbSession = null;){
            hbSession = cfg.buildSessionFactory().openSession();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Query query = hbSession.createQuery("select uid from " + clazz.getName());
            List records = query.list();
            this.traverseQueryResults(records);
            stopWatch.stop();
            System.out.println(clazz.getName() + " time (dictionaryLoadingPerformanceUidsOnly): " + stopWatch.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dictionaryLoadingPerformanceUidsOnlySqlOnlyTestLogic(Class<?> clazz) {
        Configuration cfg = this.createConfiguration();
        try (Session hbSession = null;){
            hbSession = cfg.buildSessionFactory().openSession();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            SQLQuery query = hbSession.createSQLQuery("select uid from " + MiscUtil.getSimpleClassName(clazz));
            List records = query.list();
            this.traverseQueryResults(records);
            stopWatch.stop();
            System.out.println(clazz.getName() + " time (dictionaryLoadingPerformanceUidsOnlySqlOnlyTestLogic): " + stopWatch.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dictionaryLoadingPerformanceUidsOnlyTestLogic2(Class<?> clazz) {
        Configuration cfg = this.createConfiguration();
        try (Session hbSession = null;){
            hbSession = cfg.buildSessionFactory().openSession();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            Criteria crit = hbSession.createCriteria(clazz.getName());
            crit.setProjection((Projection)Projections.property((String)"uid"));
            crit.list();
            stopWatch.stop();
            System.out.println(clazz.getName() + " time (dictionaryLoadingPerformanceUidsOnlyTestLogic2): " + stopWatch.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dictionaryLoadingPerformanceTestLogic(Class<?> clazz, PropertyLoader propLoader) {
        Configuration cfg = this.createConfiguration();
        try (Session hbSession = null;){
            hbSession = cfg.buildSessionFactory().openSession();
            HibernateSessionManager.HibernatePhysicalStorageSession session = new HibernateSessionManager.HibernatePhysicalStorageSession((org.hibernate.Session)hbSession);
            HibernateDictionaryStorage testObject = new HibernateDictionaryStorage(false);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.loadAll(clazz, (org.hibernate.Session)hbSession, propLoader);
            stopWatch.stop();
            System.out.println(clazz.getName() + " time: " + stopWatch.getTime());
        }
    }

    public List<PhysicalDictionaryData<?>> loadAll(Class<?> dictClass, org.hibernate.Session hbSession, PropertyLoader propLoader) throws Exception {
        Criteria crt = hbSession.createCriteria(dictClass);
        ArrayList result = new ArrayList();
        List records = crt.list();
        System.out.println("records.size(): " + records.size());
        for (Object data : records) {
            propLoader.loadProperties(data);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dictionaryLoadingPerformanceTestLogicSqlOnly(Class<?> clazz) {
        Configuration cfg = this.createConfiguration();
        try (Session hbSession = null;){
            hbSession = cfg.buildSessionFactory().openSession();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            SQLQuery query = hbSession.createSQLQuery("SELECT * FROM " + MiscUtil.getSimpleClassName(clazz).toLowerCase());
            List records = query.list();
            this.traverseQueryResults(records);
            stopWatch.stop();
            System.out.println(clazz.getName() + " time (dictionaryLoadingPerformanceTestLogicSqlOnly): " + stopWatch.getTime());
        }
    }

    protected void traverseQueryResults(List records) {
        for (int i = 0; i < records.size(); ++i) {
            records.get(i);
        }
    }

    private Configuration createConfiguration() {
        AnnotationConfiguration config = new AnnotationConfiguration();
        Properties hbProps = new Properties();
        hbProps.put("hibernate.connection.url", "jdbc:postgresql://localhost:5432/bof-vip?loginTimeout=10");
        hbProps.put("hibernate.connection.driver_class", "org.postgresql.Driver");
        hbProps.put("hibernate.connection.username", "bof_user");
        hbProps.put("hibernate.connection.password", "xtrip_pswdGN01");
        hbProps.put("hibernate.dialect", "org.hibernate.dialect.PostgreSQLDialect");
        hbProps.put("hibernate.connection.provider_class", SimpleConnectionProvider.class.getName());
        config.addProperties(hbProps);
        config.addAnnotatedClass(DictionaryData.class);
        config.addAnnotatedClass(DictionaryData3.class);
        return config;
    }
}

