/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class HibernatePhysicalStorageConfiguration
implements XSerializable {
    private String uid;
    private String driverClassName;
    private String adapterClassName;
    private String sqlDialectClassName;
    private String encodedPassword;
    private int poolSize = 50;
    private String url;
    private String user;
    private boolean cleanupBlobs;
    private Long statementTimeout;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public void toXML(Element elm) throws Exception {
        elm.setAttribute("uid", this.uid);
        elm.setAttribute("cleanupBlobs", Boolean.toString(this.cleanupBlobs));
        XHelper.writeString((Element)elm, (String)"driver", (String)this.driverClassName);
        XHelper.writeString((Element)elm, (String)"adapter", (String)this.adapterClassName);
        XHelper.writeString((Element)elm, (String)"dialect", (String)this.sqlDialectClassName);
        XHelper.writeString((Element)elm, (String)"url", (String)this.url);
        XHelper.writeString((Element)elm, (String)"user", (String)this.user);
        XHelper.writeString((Element)elm, (String)"password", (String)this.encodedPassword);
        XHelper.writeInt((Element)elm, (String)"poolSize", (int)this.poolSize);
        Element paramsElm = XmlUtil.addElement((Element)elm, (String)"parameters");
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            Element paramElm = XmlUtil.addElement((Element)paramsElm, (String)"item");
            paramElm.setAttribute("key", entry.getKey());
            paramElm.setAttribute("value", entry.getValue());
        }
    }

    public void fromXML(Element elm) throws Exception {
        this.uid = elm.getAttribute("uid");
        this.cleanupBlobs = "true".equals(elm.getAttribute("cleanupBlobs"));
        this.driverClassName = XHelper.readString((Element)elm, (String)"driver");
        this.adapterClassName = XHelper.readString((Element)elm, (String)"adapter");
        this.sqlDialectClassName = XHelper.readString((Element)elm, (String)"dialect");
        this.url = XHelper.readString((Element)elm, (String)"url");
        this.user = XHelper.readString((Element)elm, (String)"user");
        this.encodedPassword = XHelper.readString((Element)elm, (String)"password");
        this.poolSize = XHelper.readInt((Element)elm, (String)"poolSize", (int)this.poolSize);
        this.parameters.clear();
        this.statementTimeout = XHelper.readLong((Element)elm, (String)"statementTimeout");
        for (Element paramElm : XmlUtil.getElements((Element)elm, (String)"parameters/item")) {
            this.parameters.put(paramElm.getAttribute("key"), paramElm.getAttribute("value"));
        }
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String value) {
        this.driverClassName = value;
    }

    public String getAdapterClassName() {
        return this.adapterClassName;
    }

    public void setAdapterClassName(String value) {
        this.adapterClassName = value;
    }

    public String getSqlDialectClassName() {
        return this.sqlDialectClassName;
    }

    public void setSqlDialectClassName(String value) {
        this.sqlDialectClassName = value;
    }

    public String getEncodedPassword() {
        return this.encodedPassword;
    }

    public void setEncodedPassword(String value) {
        this.encodedPassword = value;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int value) {
        this.poolSize = value;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String value) {
        this.url = value;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String value) {
        this.user = value;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String value) {
        this.uid = value;
    }

    public boolean isCleanupBlobs() {
        return this.cleanupBlobs;
    }

    public void setCleanupBlobs(boolean value) {
        this.cleanupBlobs = value;
    }

    public Long getStatementTimeout() {
        return this.statementTimeout;
    }
}

