/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.xml.XHelper;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.hibernate.exception.LockAcquisitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HibernatePhysicalStorageHelper {
    private static int maxReadCount = 3;
    private static long sleepPeriod = 1000L;
    private static Logger log = LoggerFactory.getLogger(HibernatePhysicalStorageHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T tryRead(Callable<T> clb) throws Exception {
        int readCount = 0;
        Throwable ex = null;
        Class psqlExceptionClass = XHelper.getClass((String)"org.postgresql.util.PSQLException");
        while (readCount < maxReadCount) {
            try {
                if (readCount > 0) {
                    Thread.sleep(sleepPeriod);
                }
                T t = clb.call();
                return t;
            }
            catch (Exception e) {
                ex = e;
                if (!HibernatePhysicalStorageHelper.isRetryableException(ex, 0, psqlExceptionClass)) break;
            }
            finally {
                ++readCount;
            }
        }
        StackTraceElement[] stackTrace = ex.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length + 1];
        newStackTrace[0] = new StackTraceElement("<<Context>>", "readCount", Integer.toString(readCount), -1);
        System.arraycopy(stackTrace, 0, newStackTrace, 1, stackTrace.length);
        ex.setStackTrace(newStackTrace);
        throw ex;
    }

    private static boolean isRetryableException(Throwable ex, int depth, Class<?> psqlClass) {
        if (depth > 10 || ex == null) {
            return false;
        }
        if (ex instanceof LockAcquisitionException) {
            return true;
        }
        if (psqlClass.equals(ex.getClass())) {
            return true;
        }
        if (SQLException.class.equals(ex.getClass()) && ex.getMessage() != null && ex.getMessage().contains("Connections could not be acquired")) {
            return true;
        }
        return HibernatePhysicalStorageHelper.isRetryableException(ex.getCause(), depth + 1, psqlClass);
    }

    private HibernatePhysicalStorageHelper() {
    }
}

