/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.server.db.PersistedClasses;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.java.plugin.registry.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernatePhysicalStorageRegistry
implements Disposable {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Set<Class<?>> persistedClasses = new HashSet();
    protected final Map<Class<?>, Class<?>> assetDataClasses = new HashMap();

    public HibernatePhysicalStorageRegistry() {
        this.registerStandardPersistedClasses();
    }

    protected void registerStandardPersistedClasses() {
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"PersistedClassesProviders")) {
            for (Extension.Parameter param : ext.getParameters("class")) {
                try {
                    this.registerPersistedClasses((PersistedClasses)JpfUtil.getClass((Extension.Parameter)param).newInstance());
                }
                catch (Exception e) {
                    this.log.error("failed registering persisted classes for " + param, (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void registerPersistedClasses(PersistedClasses classes) {
        this.persistedClasses.addAll(classes.getClasses());
    }

    public Set<Class<?>> getPersistenClasses() {
        return Collections.unmodifiableSet(this.persistedClasses);
    }

    public Map<Class<?>, Class<?>> getAssetDataClasses() {
        return this.assetDataClasses;
    }

    public void dispose() {
        this.persistedClasses.clear();
        this.assetDataClasses.clear();
    }

    public <A extends BaseAsset> void registerAssetDataClass(Class<A> assetCls, Class<? extends BaseAssetData<A>> dataCls) {
        this.assetDataClasses.put(assetCls, dataCls);
        this.log.debug(String.format("registered data class %s for asset %s", dataCls.getName(), assetCls.getName()));
    }

    public <A extends BaseAsset> Class<? extends BaseAssetData<A>> getAssetDataClass(Class<A> cls) {
        Class<?> result = this.assetDataClasses.get(cls);
        if (result == null) {
            throw new IllegalArgumentException("no data class registered for asset " + cls.getName());
        }
        return result;
    }
}

