/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.ConnectionFactory;
import com.gridnine.xtrip.server.db.ConnectionInfo;
import com.gridnine.xtrip.server.db.DbAdapter;
import com.gridnine.xtrip.server.db.SimpleConnectionProvider;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageConfiguration;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.gen.storage.StorageCodeGen;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.classic.Session;
import org.hibernate.connection.C3P0ConnectionProvider;
import org.hibernate.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateSessionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Driver driver;
    private final DbAdapter adapter;
    private final String sqlDialectClassName;
    private final String password;
    private final int poolSize;
    private final String url;
    private final String user;
    private final String dataSourceName;
    private final Long statementTimeout;
    private SessionFactory factory;
    private final Map<String, String> parameters = new HashMap<String, String>();
    final ConnectionFactory connectionFactory = new ConnectionFactory(){

        @Override
        public Connection createConnection() throws Exception {
            return HibernateSessionManager.this.createConnection();
        }
    };

    public HibernateSessionManager(HibernatePhysicalStorageConfiguration config) throws Exception {
        this.driver = (Driver)Class.forName(config.getDriverClassName()).newInstance();
        this.adapter = (DbAdapter)Class.forName(config.getAdapterClassName()).newInstance();
        this.sqlDialectClassName = config.getSqlDialectClassName();
        this.password = DesUtil.decode((String)config.getEncodedPassword());
        this.poolSize = config.getPoolSize();
        this.url = config.getUrl();
        this.user = config.getUser();
        this.dataSourceName = config.getUid();
        this.statementTimeout = config.getStatementTimeout();
        this.parameters.putAll(config.getParameters());
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Connection createConnection() throws Exception {
        Properties props = new Properties();
        ConnectionInfo info = this.buildInfo();
        props.put("user", info.getUser());
        props.put("password", info.getPassword());
        props.putAll((Map<?, ?>)info.getParameters());
        Connection result = this.driver.connect(info.getUrl(), props);
        if (result == null) {
            throw new SQLException("failed connecting to " + info.getUrl());
        }
        result.setAutoCommit(false);
        return result;
    }

    public void maintain() throws Exception {
        this.adapter.maintain(this.connectionFactory, this.buildInfo());
    }

    private ConnectionInfo buildInfo() {
        ConnectionInfo result = new ConnectionInfo();
        result.setPassword(this.password);
        result.setUrl(this.url);
        result.setUser(this.user);
        result.getParameters().putAll(this.parameters);
        return result;
    }

    public void init(boolean cleanup) {
        Properties hbProps = new Properties();
        if (cleanup) {
            hbProps.put("hibernate.hbm2ddl.auto", "create");
        }
        hbProps.putAll(this.parameters);
        hbProps.put("hibernate.connection.url", this.url);
        hbProps.put("hibernate.connection.driver_class", this.driver.getClass().getName());
        hbProps.put("hibernate.connection.username", this.user);
        hbProps.put("hibernate.connection.password", this.password);
        hbProps.put("hibernate.dialect", this.sqlDialectClassName);
        if (this.poolSize <= 1) {
            hbProps.put("hibernate.connection.provider_class", SimpleConnectionProvider.class.getName());
        } else {
            hbProps.put("hibernate.connection.provider_class", C3P0ConnectionProvider.class.getName());
            hbProps.put("hibernate.c3p0.min_size", "1");
            hbProps.put("hibernate.c3p0.max_size", "" + this.poolSize);
            hbProps.put("hibernate.c3p0.timeout", "1800");
            hbProps.put("hibernate.c3p0.idle_test_period", "3000");
            hbProps.put("hibernate.c3p0.testConnectionOnCheckin", "true");
            hbProps.put("hibernate.c3p0.testConnectionOnCheckout", "true");
            hbProps.put("hibernate.c3p0.preferredTestQuery", "SELECT 1");
            hbProps.put("hibernate.c3p0.dataSourceName", this.dataSourceName);
            hbProps.put("hibernate.c3p0.max_statements", "0");
            if (TextUtil.isBlank((String)System.getProperty("c3p0.maxStatementsPerConnection"))) {
                System.setProperty("c3p0.maxStatementsPerConnection", "50");
            }
        }
        AnnotationConfiguration result = cleanup && !Environment.isTest() && StorageCodeGen.isUseArray() ? new AnnotationConfiguration((SettingsFactory)new HibernateSettingsFactory()) : new AnnotationConfiguration();
        result.addProperties(hbProps);
        for (Class<?> cls : ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getPersistenClasses()) {
            result.addAnnotatedClass(cls);
        }
        this.factory = result.buildSessionFactory();
    }

    public String hibernateSetupSchemeLockName() {
        return "hibernateSetupScheme";
    }

    public void setupScheme(boolean cleanup, SetupSchemeCallback additionalCleanupAction) throws Exception {
        LockUtil.lock((String)this.hibernateSetupSchemeLockName(), () -> {
            Statement ps = null;
            Connection cnn = null;
            try {
                if (cleanup) {
                    this.adapter.cleanup(new ConnectionFactory(){

                        @Override
                        public Connection createConnection() throws Exception {
                            return HibernateSessionManager.this.createConnection();
                        }
                    }, this.buildInfo());
                }
                if (additionalCleanupAction != null) {
                    additionalCleanupAction.before();
                }
                this.init(cleanup);
                if (cleanup) {
                    cnn = this.createConnection();
                    ps = cnn.prepareStatement("alter table versiondata add CONSTRAINT version_data_foreign_key FOREIGN KEY (entitydata_uid)  REFERENCES entitydata (uid) MATCH SIMPLE  ON UPDATE NO ACTION ON DELETE NO ACTION");
                    ps.execute();
                    cnn.commit();
                }
                if (additionalCleanupAction != null) {
                    additionalCleanupAction.after();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
                if (cnn != null) {
                    cnn.close();
                }
            }
        });
    }

    public PhysicalStorageSession createSession() throws Exception {
        return HibernatePhysicalStorageHelper.tryRead(() -> {
            Session hbSession = this.factory.openSession();
            try {
                hbSession.setFlushMode(FlushMode.MANUAL);
                if (this.statementTimeout != null) {
                    hbSession.createSQLQuery("set statement_timeout to " + this.statementTimeout.toString()).executeUpdate();
                }
                return new HibernatePhysicalStorageSession((org.hibernate.Session)hbSession);
            }
            catch (Exception ex) {
                hbSession.close();
                throw ex;
            }
        });
    }

    public SessionFactory getSessionFactory() {
        return this.factory;
    }

    public void dispose() {
        if (this.factory != null) {
            try {
                this.adapter.dispose(this.connectionFactory, this.buildInfo());
            }
            catch (Exception e) {
                this.log.error("unable to dispose DB", (Throwable)e);
            }
            this.factory.close();
        }
    }

    public static class HibernatePhysicalStorageSession
    implements PhysicalStorageSession {
        private final Logger updateLog = LoggerFactory.getLogger((String)(this.getClass().getName() + ".UPDATE"));
        private final org.hibernate.Session session;
        private final Map<IndexKey, Collection<Object>> unsavedIndexes = new HashMap<IndexKey, Collection<Object>>();

        public HibernatePhysicalStorageSession(org.hibernate.Session hbSession) {
            this.session = hbSession;
        }

        @Override
        public void begin() throws Exception {
            Transaction tx = this.session.getTransaction();
            if (tx == null) {
                tx = this.session.beginTransaction();
            }
            if (!tx.isActive()) {
                tx.begin();
            }
            if (tx.wasRolledBack()) {
                tx.begin();
            }
        }

        @Override
        public boolean isOpen() {
            return this.session.isOpen();
        }

        @Override
        public void commit() throws Exception {
            this.session.flush();
            this.clearUnsavedIndexes();
            Transaction tx = this.session.getTransaction();
            if (tx != null && tx.isActive() && !tx.wasRolledBack()) {
                tx.commit();
            }
        }

        @Override
        public void rollback() throws Exception {
            Transaction tx = this.session.getTransaction();
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            this.clearUnsavedIndexes();
            this.session.clear();
        }

        @Override
        public void close() throws Exception {
            this.session.close();
        }

        public org.hibernate.Session getSession() {
            return this.session;
        }

        public Collection<Object> getUnsavedIndexes(Class<?> indexClass, String containerUid) {
            IndexKey key = new IndexKey(indexClass, containerUid);
            return this.unsavedIndexes.computeIfAbsent(key, k -> new ArrayList());
        }

        protected void clearUnsavedIndexes() {
            this.unsavedIndexes.clear();
        }

        protected static class IndexKey {
            private final Class<?> indexClass;
            private final String containerUid;

            public IndexKey(Class<?> indexClass, String containerUid) {
                this.indexClass = indexClass;
                this.containerUid = containerUid;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.containerUid == null ? 0 : this.containerUid.hashCode());
                result = 31 * result + (this.indexClass == null ? 0 : this.indexClass.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                IndexKey other = (IndexKey)obj;
                if (this.containerUid == null ? other.containerUid != null : !this.containerUid.equals(other.containerUid)) {
                    return false;
                }
                return !(this.indexClass == null ? other.indexClass != null : !this.indexClass.equals(other.indexClass));
            }
        }
    }

    public static interface SetupSchemeCallback {
        public void before() throws Exception;

        public void after() throws Exception;
    }

    public static class HibernateSettingsFactory
    extends SettingsFactory {
        public Settings buildSettings(Properties props) {
            Settings settings = super.buildSettings(props);
            try {
                Method method = Dialect.class.getDeclaredMethod("registerColumnType", Integer.TYPE, String.class);
                method.setAccessible(true);
                method.invoke((Object)settings.getDialect(), 2003, "text[]");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                ExceptionUtil.throwException((Throwable)e);
            }
            return settings;
        }
    }
}

