/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.model.ModelCodeGenHelper;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.DBSchemeUpdateHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.EntityData;
import com.gridnine.xtrip.server.db.storage.model.VersionData;
import com.gridnine.xtrip.server.gen.storage.PropertyGenerator;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.io.IOUtils;
import org.hibernate.engine.SessionFactoryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class StructureAlignment {
    protected static final Logger log = LoggerFactory.getLogger(StructureAlignment.class);
    private static final String[] SYSTEM_TABLES = new String[]{"entitydata", "versiondata", "dbproperties", "dictionarydata", "bulkdictionarydata"};
    private static final boolean SPECIAL_ACTION_INDEXES = true;
    private static final boolean SPECIAL_ACTION_DELETE = true;
    private static final String analizeStructureQuery;
    private static final int MAX_TABLE_NAME;

    protected static IndexMethod getIndexMethod(Field field) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(DBSchemeUpdateHelper.HibernateStorageCallback storageCallback, boolean useArray) throws Exception {
        Connection connection = storageCallback.createConnection();
        try {
            StructureInfo currentStructure = StructureAlignment.analizeStructure(connection);
            StructureInfo neededStructure = StructureAlignment.collectStructure(useArray);
            StructureComparison diff = StructureAlignment.compareStructure(currentStructure, neededStructure);
            if (!(diff.getNewTables().isEmpty() && diff.getDropTables().isEmpty() && diff.getModifiedTables().isEmpty() && diff.getDropIndexes().isEmpty() && diff.getNewIndexes().isEmpty() && diff.getDropTriggers().isEmpty() && diff.getNewTriggers().isEmpty())) {
                StructureAlignment.alignStructure(sql -> log.info("ARRAY STRUCTURE MODIFICATION: " + sql), diff);
            } else {
                log.info("ARRAY STRUCTURE MODIFICATION: NO NEEDED MODIFICATION");
            }
        }
        finally {
            if (!connection.isClosed()) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void align(DBSchemeUpdateHelper.HibernateStorageCallback storageCallback, boolean useArray, List<DBSchemeUpdateHelper.AfterAction> afterActions) throws Exception {
        if (!useArray) {
            StructureAlignment.test(storageCallback, true);
        }
        Connection connection = storageCallback.createConnection();
        try {
            StructureInfo currentStructure = StructureAlignment.analizeStructure(connection);
            StructureInfo neededStructure = StructureAlignment.collectStructure(useArray);
            StructureComparison diff = StructureAlignment.compareStructure(currentStructure, neededStructure);
            if (currentStructure.getExtensions().containsKey("citext") && neededStructure.getExtensions().containsKey("citext")) {
                afterActions.add(clb -> ((SessionFactoryImplementor)clb.getSessionFactory()).getDialect().getDefaultProperties().put("postgresql.extension.citext", "true"));
            }
            if (!(diff.getNewTables().isEmpty() && diff.getDropTables().isEmpty() && diff.getModifiedTables().isEmpty() && diff.getDropIndexes().isEmpty() && diff.getNewIndexes().isEmpty() && diff.getDropTriggers().isEmpty() && diff.getNewTriggers().isEmpty())) {
                StructureAlignment.alignStructure(sql -> {
                    log.debug("STRUCTURE MODIFICATION: " + sql);
                    try (Statement statement = connection.createStatement();){
                        statement.execute(sql);
                        connection.commit();
                    }
                }, diff);
            } else {
                log.debug("STRUCTURE MODIFICATION: NO NEEDED MODIFICATION");
            }
        }
        finally {
            if (!connection.isClosed()) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void slave(DBSchemeUpdateHelper.HibernateStorageCallback storageCallback, boolean useArray, List<DBSchemeUpdateHelper.AfterAction> afterActions) throws Exception {
        if (!useArray) {
            return;
        }
        Connection connection = storageCallback.createConnection();
        try {
            for (int i = 0; i < 3; ++i) {
                try {
                    if (!StructureAlignment.getExtensions(connection).stream().anyMatch(e -> e.isInstalled() && "citext".equals(e.getName()))) continue;
                    afterActions.add(clb -> ((SessionFactoryImplementor)clb.getSessionFactory()).getDialect().getDefaultProperties().put("postgresql.extension.citext", "true"));
                    break;
                }
                catch (SQLException e2) {
                    log.warn("a database error has occurred", (Throwable)e2);
                }
            }
        }
        finally {
            if (!connection.isClosed()) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StructureInfo analizeStructure(Connection connection) throws Exception {
        String tableName;
        String tableName2;
        ResultSet resultSet4;
        Statement statement;
        Object tableName3;
        StructureInfo structure = new StructureInfo();
        Statement statement2 = connection.createStatement();
        Iterator<Map.Entry<String, Table>> iterator = null;
        try {
            if (!statement2.execute(analizeStructureQuery)) {
                throw new SQLException("Error while execute statement");
            }
            ResultSet resultSet2 = statement2.getResultSet();
            if (resultSet2 == null) {
                throw new SQLException("Error while get resultSet");
            }
            try {
                while (resultSet2.next()) {
                    tableName3 = resultSet2.getString(1);
                    String fieldName = resultSet2.getString(2);
                    String fieldType = resultSet2.getString(3);
                    String fieldDefaultValue = resultSet2.getString(4);
                    if (resultSet2.wasNull()) {
                        fieldDefaultValue = null;
                    }
                    Integer fieldLength = resultSet2.getInt(5);
                    if (resultSet2.wasNull()) {
                        fieldLength = null;
                    }
                    Integer fieldPrecision = resultSet2.getInt(6);
                    if (resultSet2.wasNull()) {
                        fieldPrecision = null;
                    }
                    Integer fieldScale = resultSet2.getInt(7);
                    if (resultSet2.wasNull()) {
                        fieldScale = null;
                    }
                    boolean fieldIsNull = "YES".equals(resultSet2.getString(8));
                    if (fieldLength != null) {
                        fieldType = fieldType + "(" + fieldLength + ")";
                    } else if (fieldPrecision != null && ("numeric".equals(fieldType.toLowerCase()) || "decimal".equals(fieldType.toLowerCase()))) {
                        fieldType = fieldType + "(" + fieldPrecision;
                        if (fieldScale != null) {
                            fieldType = fieldType + "," + fieldScale;
                        }
                        fieldType = fieldType + ")";
                    }
                    Table table = structure.getTable((String)tableName3);
                    table.addField(new Field(fieldName, fieldType, !fieldIsNull, fieldDefaultValue, false));
                }
            }
            finally {
                resultSet2.close();
            }
        }
        catch (Throwable resultSet2) {
            iterator = resultSet2;
            throw resultSet2;
        }
        finally {
            if (statement2 != null) {
                if (iterator != null) {
                    try {
                        statement2.close();
                    }
                    catch (Throwable resultSet2) {
                        ((Throwable)((Object)iterator)).addSuppressed(resultSet2);
                    }
                } else {
                    statement2.close();
                }
            }
        }
        String databaseVersion = "";
        Statement statement3 = connection.createStatement();
        tableName3 = null;
        try {
            if (!statement3.execute("SHOW server_version")) {
                throw new SQLException("Error while execute statement");
            }
            ResultSet resultSet3 = statement3.getResultSet();
            if (resultSet3 == null) {
                throw new SQLException("Error while get resultSet");
            }
            try {
                if (resultSet3.next()) {
                    databaseVersion = resultSet3.getString(1);
                }
            }
            finally {
                resultSet3.close();
            }
        }
        catch (Throwable resultSet3) {
            tableName3 = resultSet3;
            throw resultSet3;
        }
        finally {
            if (statement3 != null) {
                if (tableName3 != null) {
                    try {
                        statement3.close();
                    }
                    catch (Throwable resultSet3) {
                        ((Throwable)tableName3).addSuppressed(resultSet3);
                    }
                } else {
                    statement3.close();
                }
            }
        }
        Object m = Pattern.compile("^(\\d*\\.\\d*)").matcher(databaseVersion);
        BigDecimal version = new BigDecimal(((Matcher)m).find() ? ((Matcher)m).group(1) : "0");
        log.info("database version: " + version);
        if (version.compareTo(new BigDecimal("10")) >= 0) {
            statement = connection.createStatement();
            m = null;
            try {
                if (!statement.execute("SELECT c.relname FROM pg_partitioned_table AS pt INNER JOIN pg_class AS c ON c.oid = pt.partrelid")) {
                    throw new SQLException("Error while execute statement");
                }
                resultSet4 = statement.getResultSet();
                if (resultSet4 == null) {
                    throw new SQLException("Error while get resultSet");
                }
                try {
                    while (resultSet4.next()) {
                        tableName2 = resultSet4.getString(1);
                        Table table = structure.getTable(tableName2);
                        table.setPartitioned(true);
                    }
                }
                finally {
                    resultSet4.close();
                }
            }
            catch (Throwable resultSet4) {
                m = resultSet4;
                throw resultSet4;
            }
            finally {
                if (statement != null) {
                    if (m != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable resultSet4) {
                            ((Throwable)m).addSuppressed(resultSet4);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        statement = connection.createStatement();
        m = null;
        try {
            if (!statement.execute("SELECT i.indexrelid::regclass, i.indrelid::regclass, i.indisunique, i.indisprimary, a.attname, am.amname FROM pg_index AS i INNER JOIN pg_attribute AS a ON a.attrelid = i.indrelid AND a.attnum = ANY(i.indkey) INNER JOIN pg_class AS ic ON ic.oid = i.indexrelid INNER JOIN pg_class AS tc ON tc.oid = i.indrelid INNER JOIN information_schema.tables AS t ON t.table_schema = 'public' AND t.table_name = tc.relname INNER JOIN pg_am AS am ON am.oid = ic.relam ORDER BY i.indexrelid::regclass, (SELECT position(('|' || a.attnum || '|') in ('|' || array_to_string(i.indkey, '|') || '|')))")) {
                throw new SQLException("Error while execute statement");
            }
            resultSet4 = statement.getResultSet();
            if (resultSet4 == null) {
                throw new SQLException("Error while get resultSet");
            }
            try {
                while (resultSet4.next()) {
                    Constraint constraint;
                    String indexName = resultSet4.getString(1);
                    tableName = resultSet4.getString(2);
                    boolean unique = resultSet4.getBoolean(3);
                    boolean primary = resultSet4.getBoolean(4);
                    String fieldName = resultSet4.getString(5);
                    String indexMethod = resultSet4.getString(6);
                    Table table = structure.getTable(tableName.toLowerCase());
                    Field field = table.getFields().get(fieldName.toLowerCase());
                    if (field == null) {
                        throw new Exception("There error has occurred while analize database structure: Field " + fieldName + " not found in table " + tableName + ".");
                    }
                    if (!primary) {
                        if (!unique) {
                            Index index = structure.getIndex(indexName, tableName, unique, IndexMethod.valueOf(indexMethod.toUpperCase()));
                            index.addField(field);
                            continue;
                        }
                        constraint = table.getConstraint(indexName, ConstraintType.UNIQUE);
                        constraint.addField(field);
                        continue;
                    }
                    constraint = table.getConstraint(indexName, ConstraintType.PRIMARY_KEY);
                    constraint.addField(field);
                }
            }
            finally {
                resultSet4.close();
            }
        }
        catch (Throwable resultSet5) {
            m = resultSet5;
            throw resultSet5;
        }
        finally {
            if (statement != null) {
                if (m != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable resultSet5) {
                        ((Throwable)m).addSuppressed(resultSet5);
                    }
                } else {
                    statement.close();
                }
            }
        }
        statement = connection.createStatement();
        m = null;
        try {
            if (!statement.execute(version.compareTo(new BigDecimal("9")) >= 0 ? "SELECT tgname, tgrelid::regclass, tgfoid::regprocedure FROM pg_trigger WHERE tgisinternal=false" : "SELECT tgname, tgrelid::regclass, tgfoid::regprocedure FROM pg_trigger WHERE tgisconstraint=false")) {
                throw new SQLException("Error while execute statement");
            }
            resultSet4 = statement.getResultSet();
            if (resultSet4 == null) {
                throw new SQLException("Error while get resultSet");
            }
            try {
                while (resultSet4.next()) {
                    Table table;
                    String triggerName = resultSet4.getString(1);
                    tableName = resultSet4.getString(2);
                    String functionName = resultSet4.getString(3);
                    String loTriggerPrefix = "lo_trigger_" + StructureAlignment.prepareLoTableName(tableName) + "_";
                    if (triggerName.toLowerCase().startsWith(loTriggerPrefix)) {
                        table = structure.getTable(tableName.toLowerCase());
                        String fieldName = triggerName.substring(loTriggerPrefix.length());
                        Field field = table.getFields().get(fieldName.toLowerCase());
                        if (field != null) {
                            structure.addTrigger(new LOTrigger(triggerName, table, field));
                            continue;
                        }
                        structure.addTrigger(new UnknownDBTrigger(triggerName, table));
                        continue;
                    }
                    if (!"lo_manage()".equals(functionName) && !triggerName.toLowerCase().startsWith("lo_")) continue;
                    table = structure.getTable(tableName.toLowerCase());
                    structure.addTrigger(new UnknownDBTrigger(triggerName, table));
                }
            }
            finally {
                resultSet4.close();
            }
        }
        catch (Throwable resultSet6) {
            m = resultSet6;
            throw resultSet6;
        }
        finally {
            if (statement != null) {
                if (m != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable resultSet6) {
                        ((Throwable)m).addSuppressed(resultSet6);
                    }
                } else {
                    statement.close();
                }
            }
        }
        if (version.compareTo(new BigDecimal("9.3")) >= 0) {
            statement = connection.createStatement();
            m = null;
            try {
                if (!statement.execute("SELECT table_name FROM information_schema.views WHERE table_schema = 'public'")) {
                    throw new SQLException("Error while execute statement");
                }
                resultSet4 = statement.getResultSet();
                if (resultSet4 == null) {
                    throw new SQLException("Error while get resultSet");
                }
                try {
                    while (resultSet4.next()) {
                        tableName2 = resultSet4.getString(1);
                        structure.removeTable(tableName2);
                        structure.getView(tableName2);
                    }
                }
                finally {
                    resultSet4.close();
                }
            }
            catch (Throwable resultSet7) {
                m = resultSet7;
                throw resultSet7;
            }
            finally {
                if (statement != null) {
                    if (m != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable resultSet7) {
                            ((Throwable)m).addSuppressed(resultSet7);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        for (Extension extension : StructureAlignment.getExtensions(connection)) {
            structure.addExtension(extension);
        }
        for (Map.Entry<String, Table> tableEntry : new ArrayList<Map.Entry<String, Table>>(structure.getTables().entrySet())) {
            tableName3 = tableEntry.getKey();
            if (!StructureAlignment.ignoreTable((String)tableName3)) continue;
            log.debug("STRUCTURE MODIFICATION: ignore table " + (String)tableName3 + " and its constraints");
            structure.removeTable((String)tableName3);
            Table table = tableEntry.getValue();
            for (Index index : table.getIndexes()) {
                log.debug("STRUCTURE MODIFICATION: ignore index " + index.getName());
                structure.removeIndex(index.getName());
            }
            for (Trigger trigger : table.getTriggers()) {
                log.debug("STRUCTURE MODIFICATION: ignore trigger " + trigger.getName());
                structure.removeTrigger(trigger.getName());
            }
        }
        return structure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Extension> getExtensions(Connection connection) throws SQLException {
        ResultSet resultSet;
        boolean hasExtensions = false;
        try (Statement statement = connection.createStatement();){
            if (!statement.execute("SELECT 1 FROM information_schema.tables WHERE table_name = 'pg_available_extensions'")) {
                throw new SQLException("Error while execute statement");
            }
            resultSet = statement.getResultSet();
            if (resultSet == null) {
                throw new SQLException("Error while get resultSet");
            }
            try {
                while (resultSet.next()) {
                    hasExtensions = true;
                }
            }
            finally {
                resultSet.close();
            }
        }
        if (hasExtensions) {
            statement = connection.createStatement();
            var3_3 = null;
            try {
                ArrayList<Extension> arrayList;
                if (!statement.execute("SELECT name, installed_version FROM pg_available_extensions")) {
                    throw new SQLException("Error while execute statement");
                }
                resultSet = statement.getResultSet();
                if (resultSet == null) {
                    throw new SQLException("Error while get resultSet");
                }
                try {
                    ArrayList<Extension> result = new ArrayList<Extension>();
                    while (resultSet.next()) {
                        String extensionName = resultSet.getString(1);
                        resultSet.getString(2);
                        boolean installed = !resultSet.wasNull();
                        result.add(new Extension(extensionName, installed));
                    }
                    arrayList = result;
                }
                catch (Throwable throwable) {
                    try {
                        resultSet.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        var3_3 = throwable2;
                        throw throwable2;
                    }
                }
                resultSet.close();
                return arrayList;
            }
            finally {
                if (statement != null) {
                    if (var3_3 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    private static String prepareLoTableName(String tableName) {
        if (tableName.length() <= MAX_TABLE_NAME) {
            return tableName.toLowerCase();
        }
        CRC32 crc = new CRC32();
        crc.update(tableName.toLowerCase().getBytes());
        String postfix = Long.toHexString(crc.getValue());
        return (tableName.substring(0, MAX_TABLE_NAME - postfix.length()) + postfix).toLowerCase();
    }

    /*
     * Could not resolve type clashes
     */
    public static StructureInfo collectStructure(boolean useArray) throws Exception {
        StringBuilder name;
        StructureInfo structure = new StructureInfo();
        MetaRegistry metaRegistry = MetaRegistry.get();
        for (IndexType indexType : metaRegistry.getIndexes().values()) {
            Object property2;
            String baseName = GenUtil.getSimpleClassName((String)indexType.getId());
            String tableName = baseName + "Data";
            Table table = structure.getTable(tableName);
            Field uidField = table.addField(new Field("uid", StructureAlignment.getMappedType(String.class, -1, -1, -1), true, null, false));
            table.addConstraint(new Constraint(table.getName() + "_pkey", ConstraintType.PRIMARY_KEY, uidField));
            table.addField(new Field("modified", StructureAlignment.getMappedType(Timestamp.class, -1, -1, -1), false, null, false));
            table.addField(new Field("referenceCaption", StructureAlignment.getMappedType(String.class, -1, -1, -1), false, null, false));
            table.addField(new Field("navigationKey", StructureAlignment.getMappedType(String.class, -1, -1, -1), false, null, false));
            Field containerUidField = table.addField(new Field("containerUid", StructureAlignment.getMappedType(String.class, -1, -1, -1), true, null, false));
            structure.addIndex(table, baseName, containerUidField, false);
            Field entityTypeField = table.addField(new Field("entityType", StructureAlignment.getMappedType(String.class, -1, -1, -1), true, null, false));
            structure.addIndex(table, baseName, entityTypeField, false);
            Field aggregatedDataField = table.addField(new Field("aggregatedData", StructureAlignment.getMappedType(Text.class, -1, -1, -1), false, null, false));
            structure.addIndex(table, baseName, aggregatedDataField, false);
            ArrayList<Field> uniqueFields = new ArrayList<Field>();
            for (Object property2 : indexType.getProperties().values()) {
                Field field;
                String fieldType = null;
                if (metaRegistry.getEnums().containsKey(property2.getType())) {
                    fieldType = StructureAlignment.getMappedType(String.class, -1, -1, -1);
                } else if ("text".equals(property2.getType()) || property2.isLocalizable()) {
                    fieldType = StructureAlignment.getMappedType(Text.class, -1, -1, -1);
                } else if (Date.class.getName().equals(property2.getType())) {
                    fieldType = "timestamp without time zone";
                } else if ("byte[]".equals(property2.getType())) {
                    fieldType = StructureAlignment.getMappedType(byte[].class, -1, -1, -1);
                }
                boolean isDictionary = metaRegistry.getDictionaries().containsKey(property2.getType());
                boolean isEntityReference = BaseEntity.class.getName().equals(property2.getType()) || metaRegistry.getEntities().containsKey(property2.getType());
                String id = property2.getId();
                if (isEntityReference || ModelCodeGenHelper.isNestedEntityReferenceType((String)property2.getType())) {
                    fieldType = StructureAlignment.getMappedType(String.class, -1, -1, -1);
                    field = table.addField(new Field(id, fieldType, false, null, false));
                    table.addField(new Field(id + "EntityClassName", StructureAlignment.getMappedType(String.class, -1, -1, -1), false, null, false));
                    table.addField(new Field(id + "ReferenceCaption", StructureAlignment.getMappedType(String.class, -1, -1, -1), false, null, false));
                } else if (isDictionary) {
                    fieldType = StructureAlignment.getMappedType(String.class, -1, -1, -1);
                    field = table.addField(new Field(id, fieldType, false, null, false));
                } else {
                    if (fieldType == null) {
                        String typezzz = PropertyGenerator.getType((IndexProperty)property2, metaRegistry);
                        Class<?> type = StructureAlignment.correctType(typezzz);
                        fieldType = StructureAlignment.getMappedType(type, -1, -1, -1);
                    }
                    field = table.addField(new Field(id, fieldType, false, null, false));
                }
                if (property2.isSearchable()) {
                    structure.addIndex(table, baseName, field, false);
                }
                if (property2.isUnique()) {
                    uniqueFields.add(field);
                }
                if (!"oid".equals(fieldType)) continue;
                structure.addLOTrigger(table, field);
            }
            for (Object property2 : indexType.getCollections().values()) {
                boolean isEntityReference = BaseEntity.class.getName().equals(property2.getElementType()) || metaRegistry.getEntities().containsKey(property2.getElementType());
                boolean isNestedEntityReferenceType = ModelCodeGenHelper.isNestedEntityReferenceType((String)property2.getElementType());
                if (!isEntityReference && !isNestedEntityReferenceType) {
                    Field isDictionary = table.addField(new Field(property2.getId(), StructureAlignment.getMappedType(useArray ? Text[].class : Text.class, -1, -1, -1), false, null, false));
                    continue;
                }
                Field field = table.addField(new Field(property2.getId(), StructureAlignment.getMappedType(useArray ? Text[].class : Text.class, -1, -1, -1), false, null, isNestedEntityReferenceType));
                table.addField(new Field(property2.getId() + "EntityClassName", StructureAlignment.getMappedType(useArray ? Text[].class : Text.class, -1, -1, -1), false, null, isNestedEntityReferenceType));
                table.addField(new Field(property2.getId() + "ReferenceCaption", StructureAlignment.getMappedType(useArray ? Text[].class : Text.class, -1, -1, -1), false, null, false));
            }
            if (uniqueFields.size() <= 0) continue;
            name = new StringBuilder();
            name.append(table.getName()).append("_");
            property2 = uniqueFields.iterator();
            while (property2.hasNext()) {
                Field field = (Field)property2.next();
                name.append("_").append(field.getName());
            }
            name.append("_").append("key");
            table.addConstraint(new Constraint(name.toString(), ConstraintType.UNIQUE, uniqueFields));
        }
        HibernatePhysicalStorageRegistry hpsr = (HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class);
        if (hpsr != null) {
            HashSet data = new HashSet(hpsr.getAssetDataClasses().values());
            data.add(EntityData.class);
            data.add(VersionData.class);
            for (Class assetDataClass : data) {
                TypeInfo typeInfo = StructureAlignment.getTypeInfo(assetDataClass);
                Table table = structure.getTable(typeInfo.getTableName());
                ArrayList<Field> pk = new ArrayList<Field>();
                HashMap<ColumnInfo, Field> cross = new HashMap<ColumnInfo, Field>();
                for (ColumnInfo column : typeInfo.getColumns()) {
                    String fieldType = column.getType();
                    Field field = table.addField(new Field(column.getName(), fieldType, column.isNotNull() || column.isPrimary(), null, false));
                    if (column.isPrimary()) {
                        pk.add(field);
                    }
                    cross.put(column, field);
                    if (!"oid".equals(fieldType)) continue;
                    structure.addLOTrigger(table, field);
                }
                if (pk.size() > 0) {
                    table.addConstraint(new Constraint(table.getName() + "_pkey", ConstraintType.PRIMARY_KEY, pk));
                }
                for (UniqueConstraintInfo constraintInfo : typeInfo.getUniqueConstraints()) {
                    Object columnInfo2;
                    name = new StringBuilder();
                    if (!TextUtil.isBlank((String)constraintInfo.getName())) {
                        name.append(constraintInfo.getName());
                    } else {
                        name.append(table.getName()).append("_");
                        for (Object columnInfo2 : constraintInfo.getColumns()) {
                            name.append("_").append(((ColumnInfo)columnInfo2).getName());
                        }
                        name.append("_").append("key");
                    }
                    Constraint constraint = table.addConstraint(new Constraint(name.toString(), ConstraintType.UNIQUE, new Field[0]));
                    columnInfo2 = constraintInfo.getColumns().iterator();
                    while (columnInfo2.hasNext()) {
                        ColumnInfo columnInfo3 = (ColumnInfo)columnInfo2.next();
                        constraint.addField((Field)cross.get(columnInfo3));
                    }
                }
                for (IndexInfo indexInfo : typeInfo.getIndexes()) {
                    Index index = structure.addIndex(new Index(indexInfo.getName(), table, indexInfo.isUnique(), null));
                    for (Object columnInfo2 : indexInfo.getColumns()) {
                        index.addField((Field)cross.get(columnInfo2));
                    }
                }
            }
        }
        if (structure.getTriggers().values().stream().anyMatch(t -> t instanceof LOTrigger)) {
            structure.addExtension("lo");
        }
        if (useArray) {
            structure.addExtension("citext");
        }
        return structure;
    }

    private static boolean isSystemTable(String tableName) {
        String name = tableName.toLowerCase();
        for (String systemTableName : SYSTEM_TABLES) {
            if (!systemTableName.toLowerCase().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean ignoreTable(String tableName) {
        return tableName.length() < 5 || !tableName.toLowerCase().endsWith("data");
    }

    public static StructureComparison compareStructure(StructureInfo currentStructure, StructureInfo neededStructure) throws Exception {
        Field currentField;
        Table currentTable;
        StructureComparison result = new StructureComparison();
        boolean hasLo = false;
        for (Extension neededExtension : neededStructure.getExtensions().values()) {
            Extension currentExtension = currentStructure.getExtensions().get(neededExtension.getName().toLowerCase());
            if (currentExtension == null) continue;
            if ("lo".equalsIgnoreCase(currentExtension.getName())) {
                hasLo = true;
            }
            if (currentExtension.isInstalled()) continue;
            result.getNewExtensions().add(neededExtension);
        }
        for (Table neededTable : neededStructure.getTables().values()) {
            Object modifiedTable;
            if (StructureAlignment.isSystemTable(neededTable.getName())) continue;
            currentTable = currentStructure.getTables().get(neededTable.getName().toLowerCase());
            if (null == currentTable) {
                View currentView = currentStructure.getViews().get(neededTable.getName().toLowerCase());
                if (currentView != null) continue;
                result.getNewTables().add(neededTable);
                continue;
            }
            for (Field neededField : neededTable.getFields().values()) {
                currentField = currentTable.getFields().get(neededField.getName().toLowerCase());
                if (currentField == null) {
                    modifiedTable = result.getModifiedTable(neededTable.getName());
                    ((ModifiedTable)modifiedTable).addField(neededField.getName(), neededField.getType(), neededField.isNotNull(), neededField.getDefaultValue(), false, true, neededField.isNestedEntityReference());
                    continue;
                }
                if (!"text[]".equals(neededField.getType().toLowerCase()) || currentField.getType().toLowerCase().equals(neededField.getType().toLowerCase())) continue;
                modifiedTable = result.getModifiedTable(neededTable.getName());
                ((ModifiedTable)modifiedTable).addField(neededField.getName(), neededField.getType(), neededField.isNotNull(), neededField.getDefaultValue(), true, true, neededField.isNestedEntityReference());
            }
            for (Field currentField2 : currentTable.getFields().values()) {
                Field neededField = neededTable.getFields().get(currentField2.getName().toLowerCase());
                if (neededField != null) continue;
                modifiedTable = result.getModifiedTable(neededTable.getName());
                ((ModifiedTable)modifiedTable).addField(currentField2.getName(), currentField2.getType(), currentField2.isNotNull(), currentField2.getDefaultValue(), true, false, currentField2.isNestedEntityReference());
            }
            block4: for (Constraint neededConstraint : neededTable.getConstraints().values()) {
                Constraint currentConstraint = currentTable.getConstraints().get(neededConstraint.getName().toLowerCase());
                if (currentConstraint == null) {
                    if (neededConstraint.getType() == ConstraintType.PRIMARY_KEY && currentTable.isPartitioned()) continue;
                    modifiedTable = result.getModifiedTable(neededTable.getName());
                    ((ModifiedTable)modifiedTable).getNewConstraints().add(neededConstraint);
                    continue;
                }
                if (neededConstraint.getFields().size() != currentConstraint.getFields().size()) {
                    modifiedTable = result.getModifiedTable(neededTable.getName());
                    ((ModifiedTable)modifiedTable).getDropConstraints().add(neededConstraint);
                    ((ModifiedTable)modifiedTable).getNewConstraints().add(neededConstraint);
                    continue;
                }
                for (Field neededField : neededConstraint.getFields().values()) {
                    Field currentField3 = currentConstraint.getFields().get(neededField.getName().toLowerCase());
                    if (currentField3 != null) continue;
                    ModifiedTable modifiedTable2 = result.getModifiedTable(neededTable.getName());
                    modifiedTable2.getDropConstraints().add(neededConstraint);
                    modifiedTable2.getNewConstraints().add(neededConstraint);
                    continue block4;
                }
            }
        }
        for (Table currentTable2 : currentStructure.getTables().values()) {
            Table neededTable;
            if (StructureAlignment.isSystemTable(currentTable2.getName()) || (neededTable = neededStructure.getTables().get(currentTable2.getName().toLowerCase())) != null) continue;
            result.getDropTables().add(currentTable2);
        }
        block7: for (Index neededIndex : neededStructure.getIndexes().values()) {
            if (StructureAlignment.isSystemTable(neededIndex.getTable().getName())) continue;
            Index currentIndex = currentStructure.getIndexes().get(neededIndex.getName().toLowerCase());
            if (null == currentIndex) {
                Table currentTable3 = currentStructure.getTables().get(neededIndex.getTable().getName().toLowerCase());
                if (currentTable3 != null) {
                    boolean f = false;
                    for (Field field : neededIndex.getFields().values()) {
                        if (currentTable3.getFields().containsKey(field.getName().toLowerCase())) continue;
                        f = true;
                        break;
                    }
                    if (!f) continue;
                }
                result.getNewIndexes().add(neededIndex);
                continue;
            }
            if (neededIndex.getFields().size() != currentIndex.getFields().size() || MiscUtil.guarded((Object)((Object)neededIndex.getMethod()), (Object)((Object)IndexMethod.BTREE)) != MiscUtil.guarded((Object)((Object)currentIndex.getMethod()), (Object)((Object)IndexMethod.BTREE))) {
                result.getDropIndexes().add(neededIndex);
                result.getNewIndexes().add(neededIndex);
                continue;
            }
            for (Field neededField : neededIndex.getFields().values()) {
                currentField = currentIndex.getFields().get(neededField.getName().toLowerCase());
                if (currentField != null) continue;
                result.getDropIndexes().add(neededIndex);
                result.getNewIndexes().add(neededIndex);
                continue block7;
            }
        }
        for (Index currentIndex : currentStructure.getIndexes().values()) {
            if (StructureAlignment.isSystemTable(currentIndex.getTable().getName())) continue;
            Index neededIndex = neededStructure.getIndexes().get(currentIndex.getName().toLowerCase());
            if (neededStructure.getTables().get(currentIndex.getTable().getName().toLowerCase()) == null || neededIndex != null) continue;
            Table neededTable = neededStructure.getTables().get(currentIndex.getTable().getName().toLowerCase());
            if (neededTable != null) {
                boolean f = false;
                for (Field field : currentIndex.getFields().values()) {
                    if (neededTable.getFields().containsKey(field.getName().toLowerCase())) continue;
                    f = true;
                    break;
                }
                if (!f) continue;
            }
            result.getDropIndexes().add(currentIndex);
        }
        if (!hasLo) {
            log.warn("STRUCTURE MODIFICATION: NO LO EXTENSION AVAILABLE");
        } else {
            for (Trigger neededTrigger : neededStructure.getTriggers().values()) {
                if (StructureAlignment.isSystemTable(neededTrigger.getTable().getName()) && !(currentTable = currentStructure.getTables().get(neededTrigger.getTable().getName().toLowerCase())).getTriggers().isEmpty()) continue;
                Trigger currentTrigger = currentStructure.getTriggers().get(neededTrigger.getName().toLowerCase());
                if (!(currentTrigger == null || neededTrigger.getClass().getName().equals(currentTrigger.getClass().getName()) && neededTrigger.getTable().getName().equalsIgnoreCase(currentTrigger.getTable().getName()))) {
                    result.getDropTriggers().add(currentTrigger);
                    result.getNewTriggers().add(neededTrigger);
                    continue;
                }
                if (neededTrigger instanceof LOTrigger) {
                    if (null == currentTrigger) {
                        result.getNewTriggers().add(neededTrigger);
                        continue;
                    }
                    Field currentField4 = ((LOTrigger)currentTrigger).getField();
                    Field neededField = ((LOTrigger)neededTrigger).getField();
                    if (neededField.getName().equalsIgnoreCase(currentField4.getName())) continue;
                    result.getDropTriggers().add(currentTrigger);
                    result.getNewTriggers().add(neededTrigger);
                    continue;
                }
                throw new Exception("An unexpected error has occurred: unknown trigger " + neededTrigger.getName() + " type " + neededTrigger.getClass().getName());
            }
            for (Trigger currentTrigger : currentStructure.getTriggers().values()) {
                Trigger neededTrigger;
                if (StructureAlignment.isSystemTable(currentTrigger.getTable().getName()) || null != (neededTrigger = neededStructure.getTriggers().get(currentTrigger.getName().toLowerCase()))) continue;
                result.getDropTriggers().add(currentTrigger);
            }
        }
        return result;
    }

    private static String getPGId(String name) {
        return name;
    }

    public static void alignStructure(ModificationExecutor executor, StructureComparison diff) throws Exception {
        Iterator<Constraint> sql;
        for (Extension extension : diff.getNewExtensions()) {
            executor.executeSQL("CREATE EXTENSION IF NOT EXISTS " + extension.getName());
        }
        for (Index index : diff.getDropIndexes()) {
            if (!diff.getNewIndexes().contains(index)) continue;
            executor.executeSQL("DROP INDEX IF EXISTS " + StructureAlignment.getPGId(index.getName()));
        }
        for (Trigger trigger : diff.getDropTriggers()) {
            if (!(trigger instanceof UnknownDBTrigger)) continue;
            executor.executeSQL(String.format("DROP TRIGGER IF EXISTS %s ON %s", trigger.getName(), trigger.getTable().getName()));
        }
        for (Table table : diff.getNewTables()) {
            sql = new StringBuilder();
            ((StringBuilder)((Object)sql)).append("CREATE TABLE").append(" ").append(table.getName()).append("\n");
            ((StringBuilder)((Object)sql)).append("(").append("\n");
            boolean f = true;
            for (Field field : table.getFields().values()) {
                if (f) {
                    f = false;
                } else {
                    ((StringBuilder)((Object)sql)).append(",").append("\n");
                }
                ((StringBuilder)((Object)sql)).append("\t").append(StructureAlignment.getPGId(field.getName())).append(" ").append(field.getType());
                if (field.isNotNull()) {
                    ((StringBuilder)((Object)sql)).append(" ").append("NOT NULL");
                }
                if (field.getDefaultValue() == null) continue;
                ((StringBuilder)((Object)sql)).append("DEFAULT").append(" ").append(field.getDefaultValue());
            }
            for (Constraint constraint : table.getConstraints().values()) {
                if (f) {
                    f = false;
                } else {
                    ((StringBuilder)((Object)sql)).append(",").append("\n");
                }
                ((StringBuilder)((Object)sql)).append("\t").append("CONSTRAINT").append(" ").append(constraint.getName()).append(" ");
                if (constraint.getType() == ConstraintType.PRIMARY_KEY) {
                    ((StringBuilder)((Object)sql)).append("PRIMARY KEY");
                } else {
                    ((StringBuilder)((Object)sql)).append("UNIQUE");
                }
                ((StringBuilder)((Object)sql)).append(" ").append("(");
                boolean f2 = true;
                for (Field field : constraint.getFields().values()) {
                    if (f2) {
                        f2 = false;
                    } else {
                        ((StringBuilder)((Object)sql)).append(",").append(" ");
                    }
                    ((StringBuilder)((Object)sql)).append(StructureAlignment.getPGId(field.getName()));
                }
                ((StringBuilder)((Object)sql)).append(")");
            }
            if (!f) {
                ((StringBuilder)((Object)sql)).append("\n");
            }
            ((StringBuilder)((Object)sql)).append(")").append("\n");
            executor.executeSQL(((StringBuilder)((Object)sql)).toString());
        }
        for (ModifiedTable modifiedTable : diff.getModifiedTables()) {
            for (ModifiedField field : modifiedTable.getFields().values()) {
                StringBuilder sql2;
                if (field.isCreateField() && field.isDropField() && "text[]".equals(field.getType())) {
                    sql2 = new StringBuilder();
                    String tmpName = field.getName() + "_tmp";
                    sql2.append("ALTER TABLE").append(" ").append(modifiedTable.getName()).append(" ");
                    sql2.append("ADD COLUMN");
                    sql2.append(" ");
                    sql2.append(tmpName).append(" ").append(field.getType());
                    if (field.isNotNull()) {
                        sql2.append(" ").append("NOT NULL");
                    }
                    if (field.getDefaultValue() != null) {
                        sql2.append(" ").append("DEFAULT").append(" ").append(field.getDefaultValue());
                    }
                    sql2.append(";").append(" ");
                    sql2.append("UPDATE").append(" ").append(modifiedTable.getName()).append(" ");
                    String delimiter = !field.isNestedEntityReference() ? "|" : "||";
                    String delimiterRegExp = !field.isNestedEntityReference() ? "\\\\|" : "\\\\|\\\\|";
                    sql2.append("SET").append(" ").append(tmpName).append("=").append("string_to_array(").append("substring(").append(field.getName()).append(",E'^").append(delimiterRegExp).append("?(.*?)").append(delimiterRegExp).append("?$'").append(")").append(", '").append(delimiter).append("')");
                    sql2.append(";").append(" ");
                    sql2.append("ALTER TABLE").append(" ").append(modifiedTable.getName()).append(" ").append("DROP COLUMN").append(" ").append(field.getName());
                    sql2.append(";").append(" ");
                    sql2.append("ALTER TABLE").append(" ").append(modifiedTable.getName()).append(" ").append("RENAME COLUMN").append(" ").append(tmpName).append(" ").append("TO").append(" ").append(field.getName());
                    sql2.append(";");
                    executor.executeSQL(sql2.toString());
                    continue;
                }
                if (!field.isDropField() || !field.isCreateField()) {
                    // empty if block
                }
                if (!field.isCreateField()) continue;
                sql2 = new StringBuilder();
                sql2.append("ALTER TABLE").append(" ").append(modifiedTable.getName()).append(" ");
                if (!field.isDropField()) {
                    sql2.append("ADD COLUMN");
                    sql2.append(" ");
                    sql2.append(field.getName()).append(" ").append(field.getType());
                } else {
                    sql2.append("ALTER COLUMN");
                    sql2.append(" ");
                    sql2.append(field.getName()).append(" ").append("TYPE").append(" ").append(field.getType());
                }
                if (field.isNotNull()) {
                    sql2.append(" ").append("NOT NULL");
                }
                if (field.getDefaultValue() != null) {
                    sql2.append(" ").append("DEFAULT").append(" ").append(field.getDefaultValue());
                }
                executor.executeSQL(sql2.toString());
            }
            for (Constraint constraint : modifiedTable.getNewConstraints()) {
                StringBuilder sql2 = new StringBuilder();
                sql2.append("ALTER TABLE").append(" ").append(StructureAlignment.getPGId(modifiedTable.getName())).append(" ");
                sql2.append("ADD CONSTRAINT").append(" ").append(StructureAlignment.getPGId(constraint.getName())).append(" ");
                if (constraint.getType() == ConstraintType.PRIMARY_KEY) {
                    sql2.append("PRIMARY KEY");
                } else {
                    sql2.append("UNIQUE");
                }
                sql2.append(" ").append("(");
                boolean f2 = true;
                for (Field field : constraint.getFields().values()) {
                    if (f2) {
                        f2 = false;
                    } else {
                        sql2.append(",").append(" ");
                    }
                    sql2.append(StructureAlignment.getPGId(field.getName()));
                }
                sql2.append(")");
                executor.executeSQL(sql2.toString());
            }
        }
        for (Index index : diff.getNewIndexes()) {
            sql = new StringBuilder();
            ((StringBuilder)((Object)sql)).append("CREATE").append(" ");
            if (index.isUnique()) {
                ((StringBuilder)((Object)sql)).append("UNIQUE").append(" ");
            }
            ((StringBuilder)((Object)sql)).append("INDEX").append(" ");
            ((StringBuilder)((Object)sql)).append(StructureAlignment.getPGId(index.getName())).append(" ");
            ((StringBuilder)((Object)sql)).append("ON").append(" ");
            ((StringBuilder)((Object)sql)).append(StructureAlignment.getPGId(index.getTable().getName())).append(" ");
            if (index.getMethod() != null) {
                ((StringBuilder)((Object)sql)).append("USING").append(" ").append(index.getMethod().name().toLowerCase()).append(" ");
            }
            ((StringBuilder)((Object)sql)).append("(");
            boolean f = true;
            for (Field field : index.getFields().values()) {
                if (f) {
                    f = false;
                } else {
                    ((StringBuilder)((Object)sql)).append(",").append(" ");
                }
                ((StringBuilder)((Object)sql)).append(StructureAlignment.getPGId(field.getName()));
            }
            ((StringBuilder)((Object)sql)).append(")");
            executor.executeSQL(((StringBuilder)((Object)sql)).toString());
        }
        for (Trigger trigger : diff.getNewTriggers()) {
            executor.executeSQL(trigger.getSQL());
        }
    }

    private static Class<?> correctType(String type) throws ClassNotFoundException {
        if ("boolean".equals(type)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(type)) {
            return Byte.TYPE;
        }
        if ("char".equals(type)) {
            return Character.TYPE;
        }
        if ("short".equals(type)) {
            return Short.TYPE;
        }
        if ("int".equals(type)) {
            return Integer.TYPE;
        }
        if ("long".equals(type)) {
            return Long.TYPE;
        }
        if ("float".equals(type)) {
            return Float.TYPE;
        }
        if ("double".equals(type)) {
            return Double.TYPE;
        }
        if ("String".equals(type)) {
            return String.class;
        }
        if (!type.contains(".")) {
            try {
                return Class.forName("java.lang." + type);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(type);
    }

    private static String getMappedType(Class<?> type, int length, int precision, int scale) throws Exception {
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.equals(type)) {
            return "integer";
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.equals(type)) {
            return "bigint";
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE.equals(type)) {
            return "smallint";
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.equals(type)) {
            return "real";
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.equals(type)) {
            return "double precision";
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return String.format("numeric(%d,%d)", precision > 0 ? precision : 19, precision > 0 && scale >= 0 ? scale : 2);
        }
        if (Character.class.isAssignableFrom(type) || Character.TYPE.equals(type)) {
            return "character(1)";
        }
        if (String.class.isAssignableFrom(type)) {
            return String.format("character varying(%s)", length > 0 ? length : 255);
        }
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.equals(type)) {
            return "smallint";
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.equals(type)) {
            return "boolean";
        }
        if (java.sql.Date.class.isAssignableFrom(type)) {
            return "date";
        }
        if (Time.class.isAssignableFrom(type)) {
            return "time without time zone";
        }
        if (Timestamp.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type)) {
            return "timestamp without time zone";
        }
        if (byte[].class.isAssignableFrom(type)) {
            return "oid";
        }
        if (Text.class.isAssignableFrom(type)) {
            return "text";
        }
        if (Text[].class.isAssignableFrom(type) || String[].class.isAssignableFrom(type)) {
            return "text[]";
        }
        if (Class.class.isAssignableFrom(type) || Locale.class.isAssignableFrom(type) || TimeZone.class.isAssignableFrom(type)) {
            return String.format("character varying(%s)", length > 0 ? length : 255);
        }
        throw new Exception("Unknown type " + type.getName());
    }

    /*
     * WARNING - void declaration
     */
    private static TypeInfo getTypeInfo(Class<?> clazz) throws Exception {
        String tableName;
        TypeInfo superColumns;
        HashMap<String, ColumnInfo> columns = new HashMap<String, ColumnInfo>();
        HashMap<String, UniqueConstraintInfo> uniqueConstraints = new HashMap<String, UniqueConstraintInfo>();
        HashMap<String, IndexInfo> indexes = new HashMap<String, IndexInfo>();
        if (clazz.getSuperclass() != null && (superColumns = StructureAlignment.getTypeInfo(clazz.getSuperclass())) != null) {
            for (ColumnInfo columnInfo : superColumns.getColumns()) {
                columns.put(columnInfo.getName().toLowerCase(), columnInfo);
            }
            for (UniqueConstraintInfo uniqueConstraintInfo : superColumns.getUniqueConstraints()) {
                String name2 = uniqueConstraintInfo.getName().toLowerCase();
                uniqueConstraints.put(name2, uniqueConstraintInfo);
            }
            for (IndexInfo indexInfo : superColumns.getIndexes()) {
                indexes.put(indexInfo.getName().toLowerCase(), indexInfo);
            }
        }
        HashMap<org.hibernate.annotations.Index, IndexInfo> resolveIndexes = new HashMap<org.hibernate.annotations.Index, IndexInfo>();
        Entity entityAnottation = clazz.getAnnotation(Entity.class);
        org.hibernate.annotations.Entity entityAnottation2 = clazz.getAnnotation(org.hibernate.annotations.Entity.class);
        String potentialName = entityAnottation != null ? entityAnottation.name() : null;
        String string = tableName = !TextUtil.isBlank((String)potentialName) ? potentialName : MiscUtil.getSimpleClassName(clazz);
        if (entityAnottation != null || entityAnottation2 != null || clazz.getAnnotation(MappedSuperclass.class) != null) {
            String javax_persistence_prefix = "javax.persistence.";
            String org_hibernate_annotations_prefix = "org.hibernate.annotations.";
            for (java.lang.reflect.Field field : clazz.getDeclaredFields()) {
                Enumerated a;
                String columnName;
                if (field.getAnnotation(Transient.class) != null) continue;
                if (field.getAnnotation(ManyToOne.class) != null) {
                    throw new Exception("Unsupported declaration. ManyToOne annotation present. Class " + clazz.getName() + ", field " + field.getName());
                }
                if (field.getAnnotation(OneToMany.class) != null) continue;
                ColumnInfo columnInfo = null;
                Annotation[] column = field.getAnnotation(Column.class);
                String string2 = columnName = column != null ? column.name() : null;
                if (TextUtil.isBlank((String)columnName)) {
                    columnName = field.getName();
                }
                if ((a = field.getAnnotation(Enumerated.class)) != null) {
                    EnumType enumType = a.value();
                    if (enumType == null) {
                        enumType = EnumType.ORDINAL;
                    }
                    columnInfo = new ColumnInfo(columnName, StructureAlignment.getMappedType(enumType == EnumType.ORDINAL ? Integer.TYPE : String.class, column != null ? column.length() : -1, column != null ? column.precision() : -1, column != null ? column.scale() : -1), column != null && !column.nullable(), field.getAnnotation(Id.class) != null);
                }
                if (columnInfo == null && (a = field.getAnnotation(Temporal.class)) != null) {
                    TemporalType temporalType = ((Temporal)a).value();
                    if (temporalType == null) {
                        temporalType = TemporalType.TIMESTAMP;
                    }
                    Class type = null;
                    switch (temporalType) {
                        case TIMESTAMP: {
                            type = Timestamp.class;
                            break;
                        }
                        case DATE: {
                            type = java.sql.Date.class;
                            break;
                        }
                        case TIME: {
                            type = Time.class;
                            break;
                        }
                        default: {
                            throw new Exception("Unknown temporal type");
                        }
                    }
                    columnInfo = new ColumnInfo(columnName, StructureAlignment.getMappedType(type, column != null ? column.length() : -1, column != null ? column.precision() : -1, column != null ? column.scale() : -1), column != null && !column.nullable(), field.getAnnotation(Id.class) != null);
                }
                if (columnInfo == null && (a = field.getAnnotation(Lob.class)) != null && String.class.isAssignableFrom(field.getType())) {
                    columnInfo = new ColumnInfo(columnName, StructureAlignment.getMappedType(Text.class, column != null ? column.length() : -1, column != null ? column.precision() : -1, column != null ? column.scale() : -1), column != null && !column.nullable(), field.getAnnotation(Id.class) != null);
                }
                if (columnInfo == null) {
                    if ((field.getModifiers() & 0x98) != 0 && Arrays.stream(field.getAnnotations()).noneMatch(aa -> aa.getClass().getName().startsWith("javax.persistence.") || aa.getClass().getName().startsWith("org.hibernate.annotations."))) continue;
                    columnInfo = new ColumnInfo(columnName, StructureAlignment.getMappedType(field.getType(), column != null ? column.length() : -1, column != null ? column.precision() : -1, column != null ? column.scale() : -1), column != null && !column.nullable(), field.getAnnotation(Id.class) != null);
                }
                columns.put(columnInfo.getName().toLowerCase(), columnInfo);
                org.hibernate.annotations.Index index = field.getAnnotation(org.hibernate.annotations.Index.class);
                if (index == null) continue;
                boolean isUnique = false;
                String name2 = index.name().toLowerCase();
                IndexInfo indexInfo = (IndexInfo)indexes.get(name2);
                if (indexInfo != null) {
                    if (indexInfo.isUnique()) {
                        throw new Exception("There index with another settings found. Index " + index.name());
                    }
                } else {
                    indexInfo = new IndexInfo(index.name(), false);
                    indexes.put(name2, indexInfo);
                }
                if (index.columnNames() == null || index.columnNames().length == 0) {
                    indexInfo.getColumns().add(columnInfo);
                    continue;
                }
                resolveIndexes.put(index, indexInfo);
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (((Method)accessibleObject).getAnnotation(Transient.class) != null || ((Method)accessibleObject).getAnnotation(OneToMany.class) != null) continue;
                boolean f = false;
                for (Annotation annotation : accessibleObject.getAnnotations()) {
                    if (annotation.getClass().getName().startsWith("javax.persistence.") || annotation.getClass().getName().startsWith("org.hibernate.annotations.")) {
                        f = true;
                        break;
                    }
                    if (annotation instanceof Proxy) {
                        for (Class<?> inf : annotation.getClass().getInterfaces()) {
                            if (!inf.getName().startsWith("javax.persistence.") && !inf.getName().startsWith("org.hibernate.annotations.")) continue;
                            f = true;
                            break;
                        }
                    }
                    if (f) break;
                }
                if (!f) continue;
                throw new Exception("Unsupported declaration. Annotation on method. Class " + clazz.getName() + ", method " + ((Method)accessibleObject).getName());
            }
            javax.persistence.Table table = clazz.getAnnotation(javax.persistence.Table.class);
            if (table != null && table.uniqueConstraints() != null) {
                void var14_21;
                UniqueConstraint[] uniqueConstraintArray = table.uniqueConstraints();
                int n = uniqueConstraintArray.length;
                boolean bl = false;
                while (var14_21 < n) {
                    UniqueConstraint uniqueConstraint = uniqueConstraintArray[var14_21];
                    UniqueConstraintInfo constraintInfo = new UniqueConstraintInfo(null);
                    for (String columnName : uniqueConstraint.columnNames()) {
                        constraintInfo.getColumns().add((ColumnInfo)columns.get(columnName.toLowerCase()));
                    }
                    ++var14_21;
                }
            }
            for (Map.Entry entry : resolveIndexes.entrySet()) {
                org.hibernate.annotations.Index index = (org.hibernate.annotations.Index)entry.getKey();
                IndexInfo indexInfo = (IndexInfo)entry.getValue();
                for (String columnName : index.columnNames()) {
                    indexInfo.getColumns().add((ColumnInfo)columns.get(columnName.toLowerCase()));
                }
            }
        }
        TypeInfo typeInfo = new TypeInfo(tableName);
        typeInfo.getColumns().addAll(columns.values());
        typeInfo.getUniqueConstraints().addAll(uniqueConstraints.values());
        typeInfo.getIndexes().addAll(indexes.values());
        return typeInfo;
    }

    static {
        try {
            analizeStructureQuery = IOUtils.toString((InputStream)StructureAlignment.class.getResourceAsStream("analizeStructure.sql"));
        }
        catch (Exception ex) {
            throw new RuntimeException("failed reading analizeStructure.sql", ex);
        }
        MAX_TABLE_NAME = 63 - "lo_trigger_".length() - "_".length() - 20;
    }

    private static class ColumnInfo {
        private final String name;
        private final String type;
        private final boolean notNull;
        private final boolean primary;

        public ColumnInfo(String name, String type, boolean notNull, boolean primary) {
            this.name = name;
            this.type = type;
            this.notNull = notNull;
            this.primary = primary;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isNotNull() {
            return this.notNull;
        }

        public boolean isPrimary() {
            return this.primary;
        }
    }

    private static class IndexInfo {
        private final String name;
        private final boolean unique;
        private final List<ColumnInfo> columns = new ArrayList<ColumnInfo>();

        public IndexInfo(String name, boolean unique) {
            this.name = name;
            this.unique = unique;
        }

        public String getName() {
            return this.name;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public List<ColumnInfo> getColumns() {
            return this.columns;
        }
    }

    private static class UniqueConstraintInfo {
        private final String name;
        private final List<ColumnInfo> columns = new ArrayList<ColumnInfo>();

        public UniqueConstraintInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<ColumnInfo> getColumns() {
            return this.columns;
        }
    }

    private static class TypeInfo {
        private final String tableName;
        private final List<ColumnInfo> columns = new ArrayList<ColumnInfo>();
        private final Collection<UniqueConstraintInfo> uniqueConstraints = new ArrayList<UniqueConstraintInfo>();
        private final Collection<IndexInfo> indexes = new ArrayList<IndexInfo>();

        public TypeInfo(String tableName) {
            this.tableName = tableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public List<ColumnInfo> getColumns() {
            return this.columns;
        }

        public Collection<UniqueConstraintInfo> getUniqueConstraints() {
            return this.uniqueConstraints;
        }

        public Collection<IndexInfo> getIndexes() {
            return this.indexes;
        }
    }

    private static class Text {
        private Text() {
        }
    }

    public static interface ModificationExecutor {
        public void executeSQL(String var1) throws Exception;
    }

    public static class StructureComparison {
        private final List<Table> dropTables = new ArrayList<Table>();
        private final List<Table> newTables = new ArrayList<Table>();
        private final Map<String, ModifiedTable> modifiedTables = new HashMap<String, ModifiedTable>();
        private final List<Index> dropIndexes = new ArrayList<Index>();
        private final List<Index> newIndexes = new ArrayList<Index>();
        private final List<Trigger> dropTriggers = new ArrayList<Trigger>();
        private final List<Trigger> newTriggers = new ArrayList<Trigger>();
        private final List<Extension> newExtensions = new ArrayList<Extension>();

        public Collection<Table> getNewTables() {
            return this.newTables;
        }

        public Collection<Table> getDropTables() {
            return this.dropTables;
        }

        public Collection<ModifiedTable> getModifiedTables() {
            return this.modifiedTables.values();
        }

        public List<Index> getDropIndexes() {
            return this.dropIndexes;
        }

        public List<Index> getNewIndexes() {
            return this.newIndexes;
        }

        public List<Trigger> getDropTriggers() {
            return this.dropTriggers;
        }

        public List<Trigger> getNewTriggers() {
            return this.newTriggers;
        }

        public List<Extension> getNewExtensions() {
            return this.newExtensions;
        }

        public ModifiedTable getModifiedTable(String tableName) {
            String tableName2 = tableName.toLowerCase();
            return this.modifiedTables.computeIfAbsent(tableName2, k -> new ModifiedTable(tableName));
        }
    }

    private static class ModifiedField {
        private final String name;
        private final String type;
        private final boolean notNull;
        private final String defaultValue;
        private final boolean dropField;
        private final boolean createField;
        private final boolean nestedEntityReference;

        public ModifiedField(String name, String type, boolean notNull, String defaultValue, boolean dropField, boolean createField, boolean nestedEntityReference) {
            this.name = name;
            this.type = type;
            this.notNull = notNull;
            this.defaultValue = defaultValue;
            this.dropField = dropField;
            this.createField = createField;
            this.nestedEntityReference = nestedEntityReference;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isNotNull() {
            return this.notNull;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isDropField() {
            return this.dropField;
        }

        public boolean isCreateField() {
            return this.createField;
        }

        public boolean isNestedEntityReference() {
            return this.nestedEntityReference;
        }
    }

    private static class ModifiedTable {
        private final String name;
        private final Map<String, ModifiedField> fields = new HashMap<String, ModifiedField>();
        private final List<Constraint> dropConstraints = new ArrayList<Constraint>();
        private final List<Constraint> newConstraints = new ArrayList<Constraint>();

        public ModifiedTable(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, ModifiedField> getFields() {
            return this.fields;
        }

        public List<Constraint> getDropConstraints() {
            return this.dropConstraints;
        }

        public List<Constraint> getNewConstraints() {
            return this.newConstraints;
        }

        public ModifiedField addField(String fieldName, String fieldType, boolean notNull, String defaultValue, boolean dropField, boolean createField, boolean nestedEntityReference) throws Exception {
            String fieldName2 = fieldName.toLowerCase();
            if (this.fields.get(fieldName2) != null) {
                throw new Exception("Error in scheme. Field " + fieldName + " already present in table " + this.getName());
            }
            ModifiedField field = new ModifiedField(fieldName, fieldType, notNull, defaultValue, dropField, createField, nestedEntityReference);
            this.fields.put(fieldName2, field);
            return field;
        }
    }

    public static class StructureInfo
    implements XSerializable {
        private final Map<String, Table> tables = new HashMap<String, Table>();
        private final Map<String, View> views = new HashMap<String, View>();
        private final Map<String, Index> indexes = new HashMap<String, Index>();
        private final Map<String, Trigger> triggers = new HashMap<String, Trigger>();
        private final Map<String, Extension> extensions = new HashMap<String, Extension>();

        public Map<String, Table> getTables() {
            return this.tables;
        }

        public Map<String, View> getViews() {
            return this.views;
        }

        public Map<String, Index> getIndexes() {
            return this.indexes;
        }

        public Map<String, Trigger> getTriggers() {
            return this.triggers;
        }

        public Map<String, Extension> getExtensions() {
            return this.extensions;
        }

        public Table getTable(String tableName) {
            String tableName2 = tableName.toLowerCase();
            Table table = this.tables.computeIfAbsent(tableName2, k -> new Table(tableName));
            return table;
        }

        public void removeTable(String tableName) {
            String tableName2 = tableName.toLowerCase();
            this.tables.remove(tableName2);
        }

        public View getView(String tableName) {
            String tableName2 = tableName.toLowerCase();
            View view = this.views.computeIfAbsent(tableName2, k -> new View(tableName));
            return view;
        }

        public Index getIndex(String indexName, String tableName, boolean unique, IndexMethod method) throws Exception {
            Table table = this.tables.get(tableName.toLowerCase());
            if (table == null) {
                throw new Exception("There error in scheme. Table " + tableName + " for index " + indexName + " not found.");
            }
            String indexName2 = indexName.toLowerCase();
            Index index = this.indexes.get(indexName2);
            if (index == null) {
                index = new Index(indexName, table, unique, method);
                this.indexes.put(indexName2, index);
                index.getTable().getIndexes().add(index);
            } else if (index.getTable() != table) {
                throw new Exception("There error in scheme. Another table " + table.getName() + " found for index " + indexName + " with table " + tableName + ".");
            }
            return index;
        }

        public void removeIndex(String indexName) {
            String indexName2 = indexName.toLowerCase();
            this.indexes.remove(indexName2);
        }

        public Index addIndex(Index index) throws Exception {
            String indexName2 = index.getName().toLowerCase();
            if (this.indexes.get(indexName2) != null) {
                throw new Exception("There error in scheme. Index " + index.getName() + " already present");
            }
            this.indexes.put(indexName2, index);
            if (!index.getTable().getIndexes().contains(index)) {
                index.getTable().getIndexes().add(index);
            }
            return index;
        }

        public Index addIndex(Table table, String prefix, Field field, boolean unique) throws Exception {
            return this.addIndex(table, prefix + "_" + field.getName(), unique, StructureAlignment.getIndexMethod(field), field);
        }

        private Index addIndex(Table table, String indexName, boolean unique, IndexMethod method, Field field) throws Exception {
            String indexName2 = indexName.toLowerCase();
            if (this.indexes.get(indexName2) != null) {
                throw new Exception("Error in scheme. Index " + indexName + " already present");
            }
            Index index = new Index(indexName, table, unique, method);
            index.addField(field);
            this.indexes.put(indexName2, index);
            if (!index.getTable().getIndexes().contains(index)) {
                index.getTable().getIndexes().add(index);
            }
            return index;
        }

        public Trigger addTrigger(Trigger trigger) throws Exception {
            String triggerName2 = trigger.getName().toLowerCase();
            if (this.triggers.get(triggerName2) != null) {
                throw new Exception("There error in scheme. Trigger " + trigger.getName() + " already present");
            }
            this.triggers.put(triggerName2, trigger);
            if (!trigger.getTable().getTriggers().contains(trigger)) {
                trigger.getTable().getTriggers().add(trigger);
            }
            return trigger;
        }

        public LOTrigger addLOTrigger(Table table, Field field) throws Exception {
            LOTrigger trigger = new LOTrigger("lo_trigger_" + StructureAlignment.prepareLoTableName(table.getName()) + "_" + field.getName(), table, field);
            this.addTrigger(trigger);
            return trigger;
        }

        public void removeTrigger(String triggerName) {
            String triggerName2 = triggerName.toLowerCase();
            this.triggers.remove(triggerName2);
        }

        public Extension addExtension(String name) throws Exception {
            return this.addExtension(new Extension(name, true));
        }

        public Extension addExtension(String name, boolean installed) throws Exception {
            return this.addExtension(new Extension(name, installed));
        }

        private Extension addExtension(Extension extension) throws Exception {
            String extensionName2 = extension.getName().toLowerCase();
            if (this.extensions.get(extensionName2) != null) {
                throw new Exception("There error in scheme. Extension " + extension.getName() + " already present");
            }
            this.extensions.put(extensionName2, extension);
            return extension;
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeMap((Element)elm, (String)"tables/table", this.tables);
            XHelper.writeMap((Element)elm, (String)"extensions/extension", this.extensions);
        }

        public void fromXML(Element elm) throws Exception {
            this.tables.clear();
            this.tables.putAll(XHelper.readMap((Element)elm, (String)"tables/table"));
            this.indexes.clear();
            this.triggers.clear();
            for (Table table : this.tables.values()) {
                for (Index index : table.getIndexes()) {
                    this.addIndex(index);
                }
                for (Trigger trigger : table.getTriggers()) {
                    this.addTrigger(trigger);
                }
            }
            this.extensions.clear();
            this.extensions.putAll(XHelper.readMap((Element)elm, (String)"extensions/extension"));
        }
    }

    public static class View
    implements XSerializable {
        private String name;

        public View() {
        }

        public View(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeString((Element)elm, (String)"name", (String)this.name);
        }

        public void fromXML(Element elm) throws Exception {
            this.name = XHelper.readString((Element)elm, (String)"name");
        }
    }

    public static class Table
    implements XSerializable {
        private String name;
        private boolean partitioned;
        private final Map<String, Field> fields = new HashMap<String, Field>();
        private final Collection<Index> indexes = new ArrayList<Index>();
        private final Map<String, Constraint> constraints = new HashMap<String, Constraint>();
        private final Collection<Trigger> triggers = new ArrayList<Trigger>();

        public Table() {
        }

        public Table(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Field> getFields() {
            return this.fields;
        }

        public Map<String, Constraint> getConstraints() {
            return this.constraints;
        }

        public Collection<Index> getIndexes() {
            return this.indexes;
        }

        public Collection<Trigger> getTriggers() {
            return this.triggers;
        }

        public boolean isPartitioned() {
            return this.partitioned;
        }

        public void setPartitioned(boolean partitioned) {
            this.partitioned = partitioned;
        }

        public Field addField(Field field) throws Exception {
            String fieldName = field.getName().toLowerCase();
            if (this.fields.get(fieldName) != null) {
                throw new Exception("Error in scheme. Field " + fieldName + " already present in table " + this.getName());
            }
            this.fields.put(fieldName, field);
            return field;
        }

        public Constraint addConstraint(Constraint constraint) throws Exception {
            String constraintName = constraint.getName().toLowerCase();
            if (this.constraints.get(constraintName) != null) {
                throw new Exception("Error in scheme. Constraint " + constraint.getName() + " already present in table " + this.getName());
            }
            this.constraints.put(constraintName, constraint);
            return constraint;
        }

        public Constraint getConstraint(String constraintName, ConstraintType constraintType) throws Exception {
            String constraintName2 = constraintName.toLowerCase();
            Constraint constraint = this.constraints.get(constraintName2);
            if (constraint == null) {
                constraint = new Constraint(constraintName, constraintType, new Field[0]);
                this.constraints.put(constraintName2, constraint);
            }
            return constraint;
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeString((Element)elm, (String)"name", (String)this.name);
            XHelper.writeBoolean((Element)elm, (String)"partitioned", (boolean)this.partitioned);
            XHelper.writeMap((Element)elm, (String)"fields/field", this.fields);
            XHelper.writeCollection((Element)elm, (String)"indexes", this.indexes);
            XHelper.writeMap((Element)elm, (String)"constraints/constraint", this.constraints);
            XHelper.writeCollection((Element)elm, (String)"triggers", this.triggers);
        }

        public void fromXML(Element elm) throws Exception {
            this.name = XHelper.readString((Element)elm, (String)"name");
            this.partitioned = XHelper.readBoolean((Element)elm, (String)"partitioned");
            this.fields.clear();
            this.fields.putAll(XHelper.readMap((Element)elm, (String)"fields/field"));
            this.indexes.clear();
            this.indexes.addAll(XHelper.readCollection((Element)elm, (String)"indexes"));
            for (Index index : this.indexes) {
                index.setTable(this);
            }
            this.constraints.clear();
            this.constraints.putAll(XHelper.readMap((Element)elm, (String)"constraints/constraint"));
            this.triggers.clear();
            this.triggers.addAll(XHelper.readCollection((Element)elm, (String)"triggers"));
            for (Trigger trigger : this.triggers) {
                trigger.setTable(this);
            }
        }
    }

    public static class Extension
    implements XSerializable {
        private String name;
        private boolean installed;

        public Extension() {
        }

        public Extension(String name, boolean installed) {
            this.name = name;
            this.installed = installed;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInstalled() {
            return this.installed;
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeString((Element)elm, (String)"name", (String)this.name);
            XHelper.writeBoolean((Element)elm, (String)"installed", (boolean)this.installed);
        }

        public void fromXML(Element elm) throws Exception {
            this.name = XHelper.readString((Element)elm, (String)"name");
            this.installed = XHelper.readBoolean((Element)elm, (String)"installed", (boolean)false);
        }
    }

    public static class LOTrigger
    extends Trigger {
        private Field field;

        public LOTrigger() {
        }

        public LOTrigger(String name, Table table, Field field) {
            super(name, table);
            this.field = field;
        }

        public Field getField() {
            return this.field;
        }

        @Override
        public String getSQL() {
            return String.format("CREATE TRIGGER %1$s AFTER DELETE OR UPDATE ON %2$s FOR EACH ROW EXECUTE PROCEDURE lo_manage('%3$s');", this.getName(), this.getTable().getName(), this.getField().getName().toLowerCase());
        }

        @Override
        public void toXML(Element elm) throws Exception {
            super.toXML(elm);
            XHelper.writeObject((Element)elm, (String)"field", (Object)this.field);
        }

        @Override
        public void fromXML(Element elm) throws Exception {
            super.fromXML(elm);
            this.field = (Field)XHelper.readObject((Element)elm, (String)"field");
        }
    }

    public static class UnknownDBTrigger
    extends Trigger {
        public UnknownDBTrigger(String name, Table table) {
            super(name, table);
        }

        @Override
        public String getSQL() throws Exception {
            throw new Exception("An unexpected error has occurred: invalid logic");
        }
    }

    public static abstract class Trigger
    implements XSerializable {
        private String name;
        private Table table;

        public Trigger() {
        }

        public Trigger(String name, Table table) {
            this.name = name;
            this.table = table;
        }

        public String getName() {
            return this.name;
        }

        public Table getTable() {
            return this.table;
        }

        void setTable(Table table) {
            this.table = table;
        }

        public abstract String getSQL() throws Exception;

        public void toXML(Element elm) throws Exception {
            XHelper.writeString((Element)elm, (String)"name", (String)this.name);
        }

        public void fromXML(Element elm) throws Exception {
            this.name = XHelper.readString((Element)elm, (String)"name");
        }
    }

    public static class Constraint
    implements XSerializable {
        private String name;
        private ConstraintType type;
        private final Map<String, Field> fields = new HashMap<String, Field>();

        public Constraint(String name, ConstraintType type, Field ... fields) throws Exception {
            this.name = name;
            this.type = type;
            for (Field field : fields) {
                this.addField(field);
            }
        }

        public Constraint(String name, ConstraintType type, List<Field> fields) throws Exception {
            this.name = name;
            this.type = type;
            for (Field field : fields) {
                this.addField(field);
            }
        }

        public Constraint() {
        }

        public String getName() {
            return this.name;
        }

        public ConstraintType getType() {
            return this.type;
        }

        public Map<String, Field> getFields() {
            return this.fields;
        }

        public Field addField(Field field) throws Exception {
            String fieldName = field.getName().toLowerCase();
            if (this.fields.get(fieldName) != null) {
                throw new Exception("Error in scheme. Field " + fieldName + " already present in constraint " + this.getName());
            }
            this.fields.put(fieldName, field);
            return field;
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeString((Element)elm, (String)"name", (String)this.name);
            XHelper.writeEnum((Element)elm, (String)"type", (Enum)this.type);
            XHelper.writeMap((Element)elm, (String)"fields/field", this.fields);
        }

        public void fromXML(Element elm) throws Exception {
            this.name = XHelper.readString((Element)elm, (String)"name");
            this.type = (ConstraintType)XHelper.readEnum((Element)elm, (String)"type", ConstraintType.class);
            this.fields.clear();
            this.fields.putAll(XHelper.readMap((Element)elm, (String)"fields/field"));
        }
    }

    public static enum ConstraintType {
        PRIMARY_KEY,
        UNIQUE;

    }

    public static class Index
    implements XSerializable {
        private String name;
        private Table table;
        private boolean unique;
        private IndexMethod method;
        private final Map<String, Field> fields = new HashMap<String, Field>();

        public Index() {
        }

        public Index(String name, Table table, boolean unique, IndexMethod method) {
            this.name = name;
            this.table = table;
            this.unique = unique;
            this.method = method;
        }

        public String getName() {
            return this.name;
        }

        public Table getTable() {
            return this.table;
        }

        void setTable(Table table) {
            this.table = table;
        }

        public boolean isUnique() {
            return this.unique;
        }

        public IndexMethod getMethod() {
            return this.method;
        }

        public Map<String, Field> getFields() {
            return this.fields;
        }

        public Field addField(Field field) throws Exception {
            String fieldName2 = field.getName().toLowerCase();
            if (this.fields.get(fieldName2) != null) {
                throw new Exception("There error in scheme. Field " + field.getName() + " already present in index " + this.getName());
            }
            this.fields.put(fieldName2, field);
            return field;
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeString((Element)elm, (String)"name", (String)this.name);
            XHelper.writeBoolean((Element)elm, (String)"unique", (boolean)this.unique);
            XHelper.writeEnum((Element)elm, (String)"method", (Enum)this.method);
            XHelper.writeMap((Element)elm, (String)"fields/field", this.fields);
        }

        public void fromXML(Element elm) throws Exception {
            this.name = XHelper.readString((Element)elm, (String)"name");
            this.unique = XHelper.readBoolean((Element)elm, (String)"unique");
            this.method = (IndexMethod)XHelper.readEnum((Element)elm, (String)"method", IndexMethod.class);
            this.fields.clear();
            this.fields.putAll(XHelper.readMap((Element)elm, (String)"fields/field"));
        }
    }

    private static enum IndexMethod {
        BTREE,
        HASH,
        GIST,
        GIN,
        BRIN;

    }

    public static class Field
    implements XSerializable {
        private String name;
        private String type;
        private boolean notNull;
        private String defaultValue;
        private boolean nestedEntityReference;

        public Field() {
        }

        public Field(String name, String type, boolean notNull, String defaultValue, boolean nestedEntityReference) {
            this.name = name;
            this.type = type;
            this.notNull = notNull;
            this.defaultValue = defaultValue;
            this.nestedEntityReference = nestedEntityReference;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isNotNull() {
            return this.notNull;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isNestedEntityReference() {
            return this.nestedEntityReference;
        }

        public void toXML(Element elm) throws Exception {
            XHelper.writeString((Element)elm, (String)"name", (String)this.name);
            XHelper.writeString((Element)elm, (String)"type", (String)this.type);
            XHelper.writeBoolean((Element)elm, (String)"notNull", (boolean)this.notNull);
            XHelper.writeString((Element)elm, (String)"defaultValue", (String)this.defaultValue);
            if (this.nestedEntityReference) {
                XHelper.writeBoolean((Element)elm, (String)"nestedEntityReference", (boolean)this.nestedEntityReference);
            }
        }

        public void fromXML(Element elm) throws Exception {
            this.name = XHelper.readString((Element)elm, (String)"name");
            this.type = XHelper.readString((Element)elm, (String)"type");
            this.notNull = XHelper.readBoolean((Element)elm, (String)"notNull", (boolean)false);
            this.defaultValue = XHelper.readString((Element)elm, (String)"readValue");
            this.nestedEntityReference = XHelper.readBoolean((Element)elm, (String)"nestedEntityReference", (boolean)false);
        }
    }
}

