/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.hibernate.type;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.Xeption;
import java.io.Serializable;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.slf4j.LoggerFactory;

public class TextArrayType
implements UserType {
    private static final int[] SQL_TYPES = new int[]{2003};

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class returnedClass() {
        return String[].class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet resultSet, String[] names, Object owner) throws HibernateException, SQLException {
        try {
            Array array = resultSet.getArray(names[0]);
            if (resultSet.wasNull()) {
                return null;
            }
            Object result = array.getArray();
            if (null == result) {
                return null;
            }
            if (!String.class.equals(result.getClass().getComponentType())) {
                Object[] objArray = (Object[])result;
                String[] strArray = new String[objArray.length];
                for (int i = 0; i < objArray.length; ++i) {
                    strArray[i] = (String)objArray[i];
                }
                return strArray;
            }
            return result;
        }
        catch (NullPointerException e) {
            LoggerFactory.getLogger(TextArrayType.class).error("", (Throwable)e);
            return null;
        }
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            statement.setNull(index, SQL_TYPES[0]);
        } else {
            String typeName;
            int p;
            Object[] castObject;
            try {
                castObject = (String[])value;
            }
            catch (ClassCastException e) {
                throw Xeption.forDeveloper((String)("invalid text array value " + String.valueOf(value)), (Throwable)e, (Object[])new Object[0]);
            }
            String elementName = Environment.isTest() ? ((p = (typeName = statement.getParameterMetaData().getParameterTypeName(index)).indexOf(" ARRAY")) != -1 ? typeName.substring(0, p) : "text") : "text";
            Array array = statement.getConnection().createArrayOf(elementName, castObject);
            statement.setArray(index, array);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

