/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.model;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public final class DataAggregator {
    private final Set<String> data = new HashSet<String>();
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void reset() {
        this.data.clear();
    }

    public void aggregate(Iterable<?> values) {
        if (Objects.isNull(values)) {
            return;
        }
        for (Object value : values) {
            this.aggregate(value);
        }
    }

    public void aggregate(Date value) {
        if (Objects.isNull(value)) {
            return;
        }
        this.aggregate(this.dateFormat.format(value));
    }

    public void aggregate(Enum<?> value) {
        if (Objects.isNull(value)) {
            return;
        }
        this.aggregate(value.name());
        this.aggregate(value.toString());
    }

    public void aggregate(L10nString value) {
        if (Objects.isNull(value)) {
            return;
        }
        for (Map.Entry entry : value.getValues().entrySet()) {
            this.aggregate(entry.getValue());
        }
    }

    public void aggregate(Object value) {
        if (Objects.isNull(value)) {
            return;
        }
        String valueStr = value.toString();
        if (TextUtil.isBlank((String)valueStr)) {
            return;
        }
        for (String str : valueStr.split("(?m)\\s")) {
            if (TextUtil.isBlank((String)str)) continue;
            this.data.add(str.trim().toLowerCase(Locale.ENGLISH));
        }
    }

    public String toString() {
        if (CollectionUtil.isEmpty(this.data)) {
            return "";
        }
        if (this.data.size() == 1) {
            String head = (String)CollectionUtil.head(this.data);
            return head == null ? "" : head;
        }
        StringJoiner joiner = new StringJoiner(" ");
        for (String string : this.data) {
            joiner.add(string);
        }
        return joiner.toString();
    }
}

