/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.model.sn;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.ValueHolder;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberGenerator;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceNumberHelper {
    private final Logger log = LoggerFactory.getLogger(SequenceNumberHelper.class);

    public static <E extends BaseEntity, T extends BaseEntity, I extends EntityIndex<T>> String generateNumber(Class<E> entityClass, Class<I> indexClass, String numberProperty) throws Exception {
        return SequenceNumberHelper.generateNumber(entityClass.getName(), indexClass, numberProperty, null, null);
    }

    public static <E extends BaseEntity, T extends BaseEntity, I extends EntityIndex<T>> String generateNumber(String designator, Class<I> indexClass, String numberProperty, String prefix, String suffix) throws Exception {
        return SequenceNumberHelper.generateNumber(designator, indexClass, (String n) -> SearchCriterion.eq((String)numberProperty, (Object)n), prefix, suffix);
    }

    public static <E extends BaseEntity, T extends BaseEntity, I extends EntityIndex<T>> String generateNumber(String designator, Class<I> indexClass, Function<String, SearchCriterion> searchCriterionFunction, final String prefix, final String suffix) throws Exception {
        String number;
        SearchQuery query;
        do {
            final ValueHolder holder = new ValueHolder();
            SequenceNumberHelper.get().generateInc(new CompositeNumber(){

                public void setNumberSuffix(String value) {
                }

                public void setNumberPrefix(String value) {
                }

                public void setNumber(String value) {
                    holder.setValue((Object)value);
                }

                public String getNumberSuffix() {
                    return suffix;
                }

                public String getNumberPrefix() {
                    return prefix;
                }

                public String getNumber() {
                    return (String)holder.getValue();
                }
            }, designator, null);
            number = (String)holder.getValue();
            if (prefix != null || suffix != null) {
                number = MiscUtil.guarded((String)prefix) + number + MiscUtil.guarded((String)suffix);
            }
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(searchCriterionFunction.apply(number));
            query.setLimit(1);
            query.setResultMode(ResultMode.COUNT_ONLY);
        } while (EntityStorage.get().search(indexClass, query).getTotalCount() != 0);
        return number;
    }

    public static SequenceNumberHelper get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (SequenceNumberHelper)Environment.getPublished(SequenceNumberHelper.class);
    }

    public void generateMax(Map<CompositeNumber, String> compositeNumbers, String number) throws Exception {
        SequenceNumberGenerator engine = (SequenceNumberGenerator)Environment.getPublished(SequenceNumberGenerator.class);
        this.log.debug(String.format("max generation START: preffered number = %s", number));
        BigInteger maxNumber = BigInteger.ZERO;
        if (!TextUtil.isBlank((String)number)) {
            try {
                maxNumber = new BigInteger(number);
            }
            catch (NumberFormatException e) {
                this.log.error("failed parsing number " + number, (Throwable)e);
            }
            for (Map.Entry<CompositeNumber, String> entry : compositeNumbers.entrySet()) {
                this.log.debug(String.format("setting preffered for: designator = %s, entity = %s, prefix = %s, suffix = %s, number = %s", entry.getValue(), entry.getKey().getClass().getName(), entry.getKey().getNumberPrefix(), entry.getKey().getNumberSuffix(), entry.getKey().getNumber()));
                DecimalFormat decimalFormat = new DecimalFormat(engine.getFormat(entry.getKey(), entry.getValue()));
                if (!TextUtil.isBlank((String)entry.getKey().getNumber())) {
                    try {
                        entry.getKey().setNumber(decimalFormat.format(new BigInteger(entry.getKey().getNumber())));
                        this.log.debug(String.format("entity already has number: %s, format updated", entry.getKey().getNumber()));
                    }
                    catch (NumberFormatException nfe) {
                        this.log.error("invalid number format " + entry.getKey().getNumber(), (Throwable)nfe);
                    }
                    continue;
                }
                String currentNumberString = decimalFormat.format(maxNumber);
                this.log.debug(String.format("preffered number set: %s", currentNumberString));
                entry.getKey().setNumber(currentNumberString);
            }
        } else {
            maxNumber = engine.nextVal(compositeNumbers);
            this.log.debug(String.format("max number: %s", maxNumber));
            for (Map.Entry<CompositeNumber, String> entry : compositeNumbers.entrySet()) {
                this.log.debug(String.format("setting preffered for: designator = %s, entity = %s, prefix = %s, suffix = %s, number = %s", entry.getValue(), entry.getKey().getClass().getName(), entry.getKey().getNumberPrefix(), entry.getKey().getNumberSuffix(), entry.getKey().getNumber()));
                DecimalFormat decimalFormat = new DecimalFormat(engine.getFormat(entry.getKey(), entry.getValue()));
                if (!TextUtil.isBlank((String)entry.getKey().getNumber())) {
                    try {
                        this.log.debug(String.format("entity already has number: %s, format updated", entry.getKey().getNumber()));
                        entry.getKey().setNumber(decimalFormat.format(new BigInteger(entry.getKey().getNumber())));
                    }
                    catch (NumberFormatException nfe) {
                        this.log.error("invalid number format " + entry.getKey().getNumber(), (Throwable)nfe);
                    }
                    continue;
                }
                String currentNumberString = decimalFormat.format(maxNumber);
                this.log.debug(String.format("new number generated: %s", currentNumberString));
                entry.getKey().setNumber(currentNumberString);
            }
        }
    }

    public void generateInc(Map<CompositeNumber, String> compositeNumbers, String number) throws Exception {
        SequenceNumberGenerator engine = (SequenceNumberGenerator)Environment.getPublished(SequenceNumberGenerator.class);
        this.log.debug(String.format("incremented generation START: preffered number = %s", number));
        BigInteger incNumber = BigInteger.ZERO;
        if (!TextUtil.isBlank((String)number)) {
            try {
                incNumber = new BigInteger(number);
            }
            catch (NumberFormatException e) {
                this.log.error("failed parsing number " + number, (Throwable)e);
            }
            for (Map.Entry<CompositeNumber, String> entry : compositeNumbers.entrySet()) {
                this.log.debug(String.format("setting preffered for: designator = %s, entity = %s, prefix = %s, suffix = %s, number = %s", entry.getValue(), entry.getKey().getClass().getName(), entry.getKey().getNumberPrefix(), entry.getKey().getNumberSuffix(), entry.getKey().getNumber()));
                DecimalFormat decimalFormat = new DecimalFormat(engine.getFormat(entry.getKey(), entry.getValue()));
                if (!TextUtil.isBlank((String)entry.getKey().getNumber())) {
                    try {
                        this.log.debug(String.format("entity already has number: %s, format updated", entry.getKey().getNumber()));
                        entry.getKey().setNumber(decimalFormat.format(new BigInteger(entry.getKey().getNumber())));
                    }
                    catch (NumberFormatException nfe) {
                        this.log.error("invalid number format " + entry.getKey().getNumber(), (Throwable)nfe);
                    }
                    continue;
                }
                String currentNumberString = decimalFormat.format(incNumber);
                this.log.debug(String.format("preffered number set: %s", currentNumberString));
                entry.getKey().setNumber(currentNumberString);
            }
        } else {
            for (Map.Entry<CompositeNumber, String> entry : compositeNumbers.entrySet()) {
                this.log.debug(String.format("generation for: designator = %s, entity = %s, prefix = %s, suffix = %s, number = %s", entry.getValue(), entry.getKey().getClass().getName(), entry.getKey().getNumberPrefix(), entry.getKey().getNumberSuffix(), entry.getKey().getNumber()));
                DecimalFormat decimalFormat = new DecimalFormat(engine.getFormat(entry.getKey(), entry.getValue()));
                if (!TextUtil.isBlank((String)entry.getKey().getNumber())) {
                    try {
                        this.log.debug(String.format("entity already has number: %s, format updated", entry.getKey().getNumber()));
                        entry.getKey().setNumber(decimalFormat.format(new BigInteger(entry.getKey().getNumber())));
                    }
                    catch (NumberFormatException nfe) {
                        this.log.error("invalid number format " + entry.getKey().getNumber(), (Throwable)nfe);
                    }
                    continue;
                }
                incNumber = engine.nextVal(entry.getKey(), entry.getValue());
                String currentNumberString = decimalFormat.format(incNumber);
                this.log.debug(String.format("new number generated: %s", currentNumberString));
                entry.getKey().setNumber(currentNumberString);
            }
        }
        this.log.debug(String.format("incremented generation END", new Object[0]));
    }

    public void generateInc(CompositeNumber compositeNumber, String designator, String number) throws Exception {
        HashMap<CompositeNumber, String> numbersMap = new HashMap<CompositeNumber, String>();
        numbersMap.put(compositeNumber, designator);
        this.generateInc(numbersMap, number);
    }

    public String formatNumber(CompositeNumber number, String designator) throws Exception {
        if (!TextUtil.isBlank((String)number.getNumber())) {
            SequenceNumberGenerator engine = (SequenceNumberGenerator)Environment.getPublished(SequenceNumberGenerator.class);
            DecimalFormat decimalFormat = new DecimalFormat(engine.getFormat(number, designator));
            try {
                return decimalFormat.format(new BigInteger(number.getNumber()));
            }
            catch (NumberFormatException e) {
                this.log.error("invalid number format " + number, (Throwable)e);
            }
        }
        return null;
    }

    private static class Holder {
        public static final SequenceNumberHelper INSTANCE = (SequenceNumberHelper)Environment.getPublished(SequenceNumberHelper.class);

        private Holder() {
        }
    }
}

