/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.model.sn;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumbers;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"prefix", "designator", "suffix"})})
public class SequenceNumbersData
extends BaseAssetData<SequenceNumbers> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="SequenceNumbersData_modified")
    private Date modified;
    @Column
    private String prefix;
    @Column(nullable=false)
    private String designator;
    @Column
    private String suffix;
    @Column(nullable=false)
    private String format;
    @Column(nullable=false)
    private String lastNumber;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public void fromAsset(SequenceNumbers asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.prefix = asset.getPrefix();
        this.designator = asset.getDesignator();
        this.suffix = asset.getSuffix();
        this.format = asset.getFormat();
        this.lastNumber = asset.getLastNumber();
    }

    @Override
    public SequenceNumbers toAsset(Set<String> preferredProperties) throws Exception {
        SequenceNumbers result = new SequenceNumbers();
        result.setUid(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("prefix")) {
            result.setPrefix(this.prefix);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("designator")) {
            result.setDesignator(this.designator);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("suffix")) {
            result.setSuffix(this.suffix);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("format")) {
            result.setFormat(this.format);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("lastNumber")) {
            result.setLastNumber(this.lastNumber);
        }
        return result;
    }
}

