/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.model.sn.impl;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberGenerator;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumbers;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.java.plugin.util.ExtendedProperties;

public class StandardSequenceNumberGenerator
implements SequenceNumberGenerator {
    private final AssetStorageManager storage = new AssetStorageManager();

    @Override
    public void setFormat(String format, CompositeNumber compositeNumber, String designator) throws Exception {
        SequenceNumbers asset = this.storage.getAsset(designator, compositeNumber);
        asset.setFormat(format);
        if (TextUtil.nonBlank((String)asset.getLastNumber())) {
            asset.setLastNumber(new DecimalFormat(asset.getFormat()).format(new BigInteger(asset.getLastNumber())));
        }
        this.storage.save(asset);
    }

    @Override
    public synchronized String getFormat(CompositeNumber compositeNumber, String designator) throws Exception {
        SequenceNumbers asset = this.storage.getAsset(designator, compositeNumber);
        return asset.getFormat();
    }

    @Override
    public synchronized BigInteger nextVal(CompositeNumber compositeNumber, String designator) throws Exception {
        SequenceNumbers asset = this.storage.getAsset(designator, compositeNumber);
        String currentNumberString = asset.getLastNumber();
        BigInteger incNumber = BigInteger.ZERO;
        if (!TextUtil.isBlank((String)currentNumberString)) {
            incNumber = new BigInteger(currentNumberString);
        }
        incNumber = incNumber.add(BigInteger.ONE);
        currentNumberString = new DecimalFormat(asset.getFormat()).format(incNumber);
        asset.setLastNumber(currentNumberString);
        this.storage.save(asset);
        return incNumber;
    }

    @Override
    public synchronized BigInteger nextVal(Map<CompositeNumber, String> compositeNumbers) throws Exception {
        String currentNumberString;
        HashSet<SequenceNumbers> assets = new HashSet<SequenceNumbers>();
        for (Map.Entry<CompositeNumber, String> entry : compositeNumbers.entrySet()) {
            assets.add(this.storage.getAsset(entry.getValue(), entry.getKey()));
        }
        BigInteger maxNumber = BigInteger.ZERO;
        for (SequenceNumbers asset : assets) {
            BigInteger currentNumber;
            currentNumberString = asset.getLastNumber();
            if (TextUtil.isBlank((String)currentNumberString) || (currentNumber = new BigInteger(currentNumberString)).compareTo(maxNumber) <= 0) continue;
            maxNumber = currentNumber;
        }
        maxNumber = maxNumber.add(BigInteger.ONE);
        for (SequenceNumbers asset : assets) {
            currentNumberString = new DecimalFormat(asset.getFormat()).format(maxNumber);
            asset.setLastNumber(currentNumberString);
            this.storage.save(asset);
        }
        return maxNumber;
    }

    public void dispose() {
        this.storage.dispose();
    }

    @Override
    public BigInteger getValue(String id) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getValue(String prefix, String designator, String suffix) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, BigInteger> getValues() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assignValue(String id, BigInteger value) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void assignValue(String prefix, String designator, String suffix, BigInteger value) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static final class AssetStorageManager {
        private final ExecutorServiceFacade worker;
        private final ExtendedProperties config = ServerConfiguration.get().getConfiguration();

        AssetStorageManager() throws GeneralSecurityException, IOException {
            this.worker = ((ExecutorServiceFacade)Environment.getPublished(ExecutorServiceFacade.class)).newFixedThreadPool("sequence-number-generator", 1);
        }

        void dispose() {
            this.worker.dispose();
        }

        void authorize() throws Exception {
            if (UserData.get().getCurrentUser() == null) {
                LogicalStorage.get().authorizeAsSystem((Properties)this.config);
            }
        }

        public void save(final SequenceNumbers asset) throws Exception {
            this.worker.submit((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    this.authorize();
                    AssetsStorage.get().save((BaseAsset)asset);
                    return null;
                }
            }).get();
        }

        SequenceNumbers getAsset(final String designator, final CompositeNumber sn) throws Exception {
            return (SequenceNumbers)((Object)this.worker.submit((Callable)new Callable<SequenceNumbers>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public SequenceNumbers call() throws Exception {
                    this.authorize();
                    SearchQuery query = new SearchQuery();
                    if (sn.getNumberPrefix() == null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"prefix", null));
                    } else {
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"prefix", (Object)sn.getNumberPrefix()));
                    }
                    if (sn.getNumberSuffix() == null) {
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"suffix", null));
                    } else {
                        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"suffix", (Object)sn.getNumberSuffix()));
                    }
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"designator", (Object)designator));
                    List data = AssetsStorage.get().search(SequenceNumbers.class, query).getData();
                    if (data.size() == 1) {
                        return (SequenceNumbers)((Object)data.get(0));
                    }
                    SequenceNumbers asset = new SequenceNumbers();
                    asset.setPrefix(sn.getNumberPrefix());
                    asset.setDesignator(designator);
                    asset.setSuffix(sn.getNumberSuffix());
                    File file = new File(Environment.getDataFolder(), "sequence-numbers.properties");
                    if (file.isFile()) {
                        String suffix;
                        Properties config = new Properties();
                        try (FileInputStream strm = new FileInputStream(file);){
                            config.load(strm);
                        }
                        String prefix = sn.getNumberPrefix();
                        if (prefix == null) {
                            prefix = "";
                        }
                        if ((suffix = sn.getNumberSuffix()) == null) {
                            suffix = "";
                        }
                        asset.setFormat(config.getProperty(prefix + "_" + designator + "_" + suffix + ".format"));
                        asset.setLastNumber(config.getProperty(prefix + "_" + designator + "_" + suffix + ".lastNumber"));
                    }
                    if (TextUtil.isBlank((String)asset.getFormat())) {
                        asset.setFormat("0000000");
                    }
                    return asset;
                }
            }).get());
        }
    }
}

