/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.noscheme;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.search.FilterQuery;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.QueryComparisonHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.AssetPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalAssetData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import com.gridnine.xtrip.server.db.storage.noscheme.NoSchemeException;
import com.gridnine.xtrip.server.db.storage.noscheme.NoSchemePhysicalStorageHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.xml.stream.XMLStreamWriter;

public class NoSchemeAssetPhysicalStorage
implements AssetPhysicalStorage {
    private final Map<Class<?>, Map<String, BaseAssetData<?>>> tables = new ConcurrentHashMap();
    private final Lock TABLE_LOCK = new ReentrantLock();
    private static final Map<Class<?>, TypeInfo> typeInfoList = new HashMap();
    private static final Lock TYPE_INFO_LIST_LOCK = new ReentrantLock();
    private static final Pattern METHOD_NAME_PATTERN = Pattern.compile("\\A(?:get|set|is|)(.+)$");

    @Override
    public <A extends BaseAsset> SearchResult<A> searchAssets(Class<A> cls, SearchQuery query, PhysicalStorageSession session) throws Exception {
        final Class<BaseAssetData<A>> dataClass = ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(cls);
        Map<String, BaseAssetData<?>> table = this.tables.get(dataClass);
        ArrayList allData = new ArrayList();
        if (table != null) {
            allData.addAll(table.values());
        }
        SearchResult data = NoSchemePhysicalStorageHelper.search(allData, query, new QueryComparisonHelper.FieldValuesProviderEx<BaseAssetData<A>>(){

            public Class<?> getFieldClass(String property) {
                try {
                    TypeInfo typeInfo = NoSchemeAssetPhysicalStorage.getTypeInfo(dataClass);
                    PropertyInfo propertyinfo = typeInfo.getColumnByPropertyName(property);
                    return propertyinfo.getPropertyType();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public Object getFieldValue(BaseAssetData<A> object, String property) {
                try {
                    TypeInfo typeInfo = NoSchemeAssetPhysicalStorage.getTypeInfo(dataClass);
                    PropertyInfo propertyinfo = typeInfo.getColumnByPropertyName(property);
                    Object value = propertyinfo.getPropertyValue(object);
                    if (Class.class.isInstance(value) && String.class.isAssignableFrom(propertyinfo.getPropertyType())) {
                        return ((Class)value).getName();
                    }
                    return value;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }

            public Object prepareValue(String property, Object value) {
                if (value instanceof NestedEntityReference) {
                    NestedEntityReference ref = (NestedEntityReference)value;
                    return String.format("%s||%s", ref.getNestedEntityUid(), ref.getUid());
                }
                if (value instanceof EntityReference) {
                    return ((EntityReference)value).getUid();
                }
                if (value instanceof DictionaryReference) {
                    return ((DictionaryReference)value).getCode();
                }
                return value;
            }

            public String getSortProperty(String property) {
                return property;
            }
        });
        SearchResult result = new SearchResult();
        result.setTimestamp(data.getTimestamp());
        result.setTotalCount(data.getTotalCount());
        Set preferredProperties = query.getPreferredProperties();
        for (BaseAssetData item : data.getData()) {
            result.getData().add(item.toAsset(preferredProperties));
        }
        for (FilterQuery filter : query.getFilters()) {
            result.getFilter(filter.getProperty()).addAll(data.getFilter(filter.getProperty()));
        }
        return result;
    }

    @Override
    public <A extends BaseAsset> ProjectionResult searchAssets(Class<A> cls, ProjectionQuery query, PhysicalStorageSession session) throws Exception {
        throw new UnsupportedOperationException("projections search is not supported by this (NoSql) storage");
    }

    @Override
    public <A extends BaseAsset> void saveAsset(PhysicalAssetData<A> asset, PhysicalAssetData<A> restoreData, PhysicalStorageSession session) throws Exception {
        this.save(NoSchemeAssetPhysicalStorage.toAssetData(asset));
    }

    @Override
    public <A extends BaseAsset> void deleteAsset(PhysicalAssetData<A> asset, PhysicalStorageSession session) throws Exception {
        this.delete(NoSchemeAssetPhysicalStorage.getAssetDataClass(asset), asset.getAsset().getUid());
    }

    @Override
    public <A extends BaseAsset> PhysicalAssetData<A> loadAsset(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        BaseAssetData<A> data = this.get(((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(cls), uid);
        if (data == null) {
            return null;
        }
        PhysicalAssetData<A> result = new PhysicalAssetData<A>();
        A asset = data.toAsset(Collections.emptySet());
        result.setAsset(asset);
        result.getContext().put(data.getUid(), data);
        return result;
    }

    @Override
    public <A extends BaseAsset> List<String> getAssetUids(Class<A> cls, Date startDate, Date endDate, final SortOrder sortOrder, Integer limit, PhysicalStorageSession session) throws Exception {
        Class<BaseAssetData<A>> dataClass = ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(cls);
        ArrayList<String> result = new ArrayList<String>();
        if (limit != null && limit <= 1) {
            return result;
        }
        Map<String, BaseAssetData<?>> table = this.tables.get(dataClass);
        if (null == table) {
            return result;
        }
        ArrayList<TempRow> tmpList = new ArrayList<TempRow>();
        for (BaseAssetData<?> data : table.values()) {
            Date dateFiledValue;
            if (startDate != null && ((dateFiledValue = data.getModified()) == null || dateFiledValue.getTime() < startDate.getTime()) || endDate != null && ((dateFiledValue = data.getModified()) == null || dateFiledValue.getTime() >= endDate.getTime())) continue;
            if (sortOrder != null) {
                tmpList.add(new TempRow(data.getUid(), data.getModified()));
                if (limit == null || tmpList.size() < limit) continue;
                break;
            }
            result.add(data.getUid());
            if (limit == null || result.size() < limit) continue;
            break;
        }
        if (sortOrder != null) {
            if (tmpList.size() > 1) {
                Collections.sort(tmpList, new Comparator<TempRow>(){

                    @Override
                    public int compare(TempRow o1, TempRow o2) {
                        long time2;
                        if (o1.getDate() == null) {
                            return o2.getDate() == null ? 0 : 1;
                        }
                        if (o2.getDate() == null) {
                            return o1.getDate() == null ? 0 : -1;
                        }
                        long time1 = o1.getDate().getTime();
                        if (time1 == (time2 = o2.getDate().getTime())) {
                            return 0;
                        }
                        switch (sortOrder) {
                            case ASC: {
                                return time1 > time2 ? 1 : -1;
                            }
                            case DESC: {
                                return time1 > time2 ? -1 : 1;
                            }
                        }
                        return 1;
                    }
                });
            }
            for (TempRow row : tmpList) {
                result.add(row.getUid());
            }
        }
        return result;
    }

    public void save(XMLStreamWriter writer) throws Exception {
        writer.writeStartElement("assets");
        for (Map.Entry<Class<?>, Map<String, BaseAssetData<?>>> classes : this.tables.entrySet()) {
            writer.writeStartElement("type");
            writer.writeAttribute("class", classes.getKey().getName());
            for (Map.Entry<String, BaseAssetData<?>> asset : classes.getValue().entrySet()) {
                writer.writeStartElement("asset");
                writer.writeAttribute("key", asset.getKey());
                BaseAssetData<?> data = asset.getValue();
                writer.writeAttribute("class", data != null ? data.getClass().getName() : classes.getKey().getName());
                if (data != null) {
                    TypeInfo typeInfo = NoSchemeAssetPhysicalStorage.getTypeInfo(data.getClass());
                    if (typeInfo != null) {
                        for (PropertyInfo property : typeInfo.getColumns()) {
                            writer.writeStartElement(NoSchemeAssetPhysicalStorage.getXmlTagName(property.getPropertyName()));
                            Object value = property.getPropertyValue(data);
                            if (value != null) {
                                writer.writeCharacters(value.toString());
                            }
                            writer.writeEndElement();
                        }
                    } else {
                        writer.writeStartElement("uid");
                        if (data.getUid() != null) {
                            writer.writeCharacters(data.getUid());
                        }
                        writer.writeEndElement();
                        writer.writeStartElement("modified");
                        if (data.getModified() != null) {
                            writer.writeCharacters(data.getModified().toString());
                        }
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public synchronized void reset() {
        this.tables.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A extends BaseAsset, D extends BaseAssetData<A>> void save(D data) {
        Map<String, BaseAssetData<?>> table = this.tables.get(data.getClass());
        if (table == null) {
            Lock lock = this.TABLE_LOCK;
            lock.lock();
            try {
                table = this.tables.get(data.getClass());
                if (table == null) {
                    table = new ConcurrentHashMap();
                    this.tables.put(data.getClass(), table);
                }
            }
            finally {
                lock.unlock();
            }
        }
        table.put(data.getUid(), data);
    }

    private <A extends BaseAsset, D extends BaseAssetData<A>> void delete(Class<D> clazz, String id) {
        Map<String, BaseAssetData<?>> table = this.tables.get(clazz);
        if (table != null) {
            table.remove(id);
        }
    }

    private <D extends BaseAssetData<?>> D get(Class<D> cls, String id) {
        Map<String, BaseAssetData<?>> table = this.tables.get(cls);
        return (D)(table != null ? table.get(id) : null);
    }

    private static <A extends BaseAsset, D extends BaseAssetData<A>> Class<D> getAssetDataClass(PhysicalAssetData<A> data) {
        return ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(data.getAsset().getClass());
    }

    private static <A extends BaseAsset> BaseAssetData<A> toAssetData(PhysicalAssetData<A> data) throws Exception {
        for (Object obj : data.getContext().values()) {
            BaseAssetData bad;
            if (!(obj instanceof BaseAssetData) || !(bad = (BaseAssetData)obj).getUid().equals(data.getAsset().getUid())) continue;
            bad.fromAsset(data.getAsset());
            return bad;
        }
        BaseAssetData<?> result = ((HibernatePhysicalStorageRegistry)Environment.getPublished(HibernatePhysicalStorageRegistry.class)).getAssetDataClass(data.getAsset().getClass()).newInstance();
        result.fromAsset(data.getAsset());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeInfo getTypeInfo(Class<?> clazz) throws Exception {
        TypeInfo typeInfo;
        Lock lock = TYPE_INFO_LIST_LOCK;
        lock.lock();
        try {
            Collection<PropertyInfo> superColumns;
            typeInfo = typeInfoList.get(clazz);
            if (typeInfo != null) {
                TypeInfo typeInfo2 = typeInfo;
                return typeInfo2;
            }
            ArrayList<PropertyInfo> columns = new ArrayList<PropertyInfo>();
            if (clazz.getSuperclass() != null && (superColumns = NoSchemeAssetPhysicalStorage.getTypeInfo(clazz.getSuperclass()).getColumns()) != null) {
                columns.addAll(superColumns);
            }
            Entity entityAnottation = clazz.getAnnotation(Entity.class);
            org.hibernate.annotations.Entity entityAnottation2 = clazz.getAnnotation(org.hibernate.annotations.Entity.class);
            if (entityAnottation != null || entityAnottation2 != null || clazz.getAnnotation(MappedSuperclass.class) != null) {
                String javax_persistence_prefix = "javax.persistence.";
                String org_hibernate_annotations_prefix = "org.hibernate.annotations.";
                for (Field field : clazz.getDeclaredFields()) {
                    if (field.getAnnotation(Transient.class) != null || field.getAnnotation(OneToMany.class) != null) continue;
                    columns.add(new PropertyInfo(NoSchemeAssetPhysicalStorage.getProperyNameFromField(field), field.getType()));
                }
                for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                    if (((Method)accessibleObject).getAnnotation(Transient.class) != null || ((Method)accessibleObject).getAnnotation(OneToMany.class) != null) continue;
                    boolean f = false;
                    for (Annotation annotation : accessibleObject.getAnnotations()) {
                        if (annotation.getClass().getName().startsWith("javax.persistence.") || annotation.getClass().getName().startsWith("org.hibernate.annotations.")) {
                            f = true;
                            break;
                        }
                        if (annotation instanceof Proxy) {
                            for (Class<?> inf : annotation.getClass().getInterfaces()) {
                                if (!inf.getName().startsWith("javax.persistence.") && !inf.getName().startsWith("org.hibernate.annotations.")) continue;
                                f = true;
                                break;
                            }
                        }
                        if (f) break;
                    }
                    if (!f || ((Method)accessibleObject).getReturnType() == null || !((Method)accessibleObject).getName().startsWith("get") && !((Method)accessibleObject).getName().startsWith("is")) continue;
                    columns.add(new PropertyInfo(NoSchemeAssetPhysicalStorage.getProperyNameFromMethod((Method)accessibleObject), ((Method)accessibleObject).getReturnType()));
                }
            }
            typeInfo = new TypeInfo(clazz, columns);
            typeInfoList.put(clazz, typeInfo);
        }
        finally {
            lock.unlock();
        }
        return typeInfo;
    }

    private static String getProperyNameFromField(Field field) {
        return field.getName();
    }

    private static String getProperyNameFromMethod(Method method) throws NoSchemeException {
        Matcher matcher = METHOD_NAME_PATTERN.matcher(method.getName());
        if (!matcher.matches()) {
            throw new NoSchemeException("Internal exception: can't get correctly property name from method");
        }
        String name = matcher.group(1);
        if (name.length() < 1) {
            throw new NoSchemeException("Internal exception: can't get correctly property name from method (property name is empty)");
        }
        return Character.isUpperCase(name.charAt(0)) ? Character.toLowerCase(name.charAt(0)) + method.getName().substring(1) : name;
    }

    private static String getXmlTagName(String property) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < property.length(); ++i) {
            char c = property.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0 && Character.isLetter(property.charAt(i - 1))) {
                    sb.append('-');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public <A extends BaseAsset> boolean isAssetExist(Class<A> cls, String uid, PhysicalStorageSession session) throws Exception {
        return this.loadAsset(cls, uid, session) != null;
    }

    private static class PropertyInfo {
        private final String propertyName;
        private final Class<?> propertyType;

        public PropertyInfo(String propertyName, Class<?> propertyType) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Class<?> getPropertyType() {
            return this.propertyType;
        }

        public Object getPropertyValue(Object obj) throws NoSchemeException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Class<?> clazz = obj.getClass();
            Field field = PropertyInfo.getDeclaredField(clazz, this.propertyName);
            if (field != null) {
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                return field.get(obj);
            }
            String methodName = PropertyInfo.getGetterMethodName(this.propertyName);
            Method method = PropertyInfo.getDeclaredMethod(clazz, methodName);
            if (method == null) {
                methodName = PropertyInfo.getIsGetterMethodName(this.propertyName);
                method = PropertyInfo.getDeclaredMethod(clazz, methodName);
            }
            if (method != null) {
                if (!Modifier.isPublic(method.getModifiers())) {
                    method.setAccessible(true);
                }
                return method.invoke(obj, new Object[0]);
            }
            throw new NoSchemeException(String.format("Property \"%s\" not found in class %s", this.propertyName, clazz.getName()));
        }

        private static Field getDeclaredField(Class<?> clazz, String fieldName) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return field;
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass == null) {
                return null;
            }
            return PropertyInfo.getDeclaredField(superclass, fieldName);
        }

        private static Method getDeclaredMethod(Class<?> clazz, String methodName) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!methodName.equals(method.getName()) || method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0) continue;
                return method;
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass == null) {
                return null;
            }
            return PropertyInfo.getDeclaredMethod(superclass, methodName);
        }

        private static String getGetterMethodName(String propertyName) {
            return "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        }

        private static String getIsGetterMethodName(String propertyName) {
            return "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        }
    }

    private static class TypeInfo {
        private final Class<?> clazz;
        private final Map<String, PropertyInfo> infoByPropertyName = new HashMap<String, PropertyInfo>();

        public TypeInfo(Class<?> clazz, Collection<PropertyInfo> columns) throws Exception {
            this.clazz = clazz;
            for (PropertyInfo column : columns) {
                this.infoByPropertyName.put(column.getPropertyName(), column);
            }
        }

        public Class<?> getTypeClass() {
            return this.clazz;
        }

        public Collection<PropertyInfo> getColumns() {
            return this.infoByPropertyName.values();
        }

        public PropertyInfo getColumnByPropertyName(String propertyName) throws NoSchemeException {
            PropertyInfo column = this.infoByPropertyName.get(propertyName);
            if (column == null) {
                throw new NoSchemeException(String.format("Property \"%s\" not found in type info %s", propertyName, this.getTypeClass().getName()));
            }
            return column;
        }
    }

    private final class TempRow {
        private final String uid;
        private final Date date;

        public TempRow(String uid, Date date) {
            this.uid = uid;
            this.date = date;
        }

        public String getUid() {
            return this.uid;
        }

        public Date getDate() {
            return this.date;
        }
    }
}

