/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db.storage.noscheme;

import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.BulkDictionaryPhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryData;
import com.gridnine.xtrip.server.db.storage.model.PhysicalBulkDictionaryMetadata;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorageSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class NoSchemeBulkDictionaryPhysicalStorage
implements BulkDictionaryPhysicalStorage {
    private final Map<String, BulkDictionaryData> table = new ConcurrentHashMap<String, BulkDictionaryData>();

    @Override
    public List<PhysicalBulkDictionaryMetadata<?>> loadMetadata(PhysicalStorageSession session) throws Exception {
        ArrayList result = new ArrayList();
        for (BulkDictionaryData data : this.table.values()) {
            PhysicalBulkDictionaryMetadata item = new PhysicalBulkDictionaryMetadata();
            item.setDictionaryType(XHelper.getClass((String)data.getDictClass()));
            item.setModified(data.getModified());
            result.add(item);
        }
        return result;
    }

    @Override
    public <D extends BaseDictionary> PhysicalBulkDictionaryData<D> loadData(Class<D> key, PhysicalStorageSession session) throws Exception {
        BulkDictionaryData data = this.get(key.getName());
        if (data == null) {
            return null;
        }
        PhysicalBulkDictionaryData result = new PhysicalBulkDictionaryData();
        result.setDictionaryType(XHelper.getClass((String)data.getDictClass()));
        result.setModified(data.getModified());
        result.setData(data.getData());
        result.getContext().put(key.getName(), data);
        return result;
    }

    @Override
    public <D extends BaseDictionary> void updateData(PhysicalBulkDictionaryData<D> data, PhysicalBulkDictionaryData<D> restoreData, PhysicalStorageSession session) throws Exception {
        String className = data.getDictionaryType().getName();
        BulkDictionaryData dictData = (BulkDictionaryData)data.getContext().get(className);
        if (dictData == null) {
            dictData = this.get(className);
        }
        if (dictData == null) {
            dictData = new BulkDictionaryData();
            dictData.setDictClass(className);
        }
        dictData.setModified(data.getModified());
        dictData.setData(data.getData());
        this.save(dictData);
    }

    @Override
    public <D extends BaseDictionary> void deleteData(PhysicalBulkDictionaryData<D> data, PhysicalStorageSession session) throws Exception {
        String className = data.getDictionaryType().getName();
        BulkDictionaryData dictData = (BulkDictionaryData)data.getContext().get(className);
        if (dictData == null) {
            dictData = this.get(data.getDictionaryType().getName());
        }
        if (dictData == null) {
            return;
        }
        this.delete(dictData);
    }

    public void save(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("bulk-dictionaries");
        for (Map.Entry<String, BulkDictionaryData> dictionary : this.table.entrySet()) {
            writer.writeStartElement("bulk-dictionary");
            writer.writeAttribute("key", dictionary.getKey());
            BulkDictionaryData data = dictionary.getValue();
            if (data != null) {
                writer.writeStartElement("dict-\u0441lass");
                if (data.getDictClass() != null) {
                    writer.writeCharacters(data.getDictClass());
                }
                writer.writeEndElement();
                writer.writeStartElement("modified");
                if (data.getModified() != null) {
                    writer.writeCharacters(data.getModified().toString());
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public synchronized void reset() {
        this.table.clear();
    }

    private void save(BulkDictionaryData data) {
        this.table.put(data.getDictClass(), data);
    }

    private void delete(BulkDictionaryData data) {
        this.table.remove(data.getDictClass());
    }

    private BulkDictionaryData get(String id) {
        return this.table.get(id);
    }
}

